%FASTER perform an  FAST corner detection from your FAST-ER generated tree
%    [corners, scores] = FASTER(image, threshold) performs the detection on the image
%    and returns the X coordinates in corners(:,1), the Y coordinares in corners(:,2) and
%    optionally, the scores in scores(:). The score is computed using binary search over 
%    all possible thresholds.
%
%    [corners, scores] = FASTER(image, threshold, nonmax) performs the corner
%    detection and nonmaximal suppression if nonmax is not zero. 
%    
%     If you use this in published work, please cite:
%       Faster and better: A machine learning approach to corner detection, E. Rosten, R. Porter and T. Drummond, PAMI (to appear) 2008
%       Machine learning for high-speed corner detection, E. Rosten and T. Drummond, ECCV 2006
%     The Bibtex entries are:
%     
%     @inproceedings{rosten_2006_machine,
%         title       =    "Machine learning for high-speed corner detection",
%         author      =    "Edward Rosten and Tom Drummond",
%         year        =    "2006",
%         month       =    "May",
%         booktitle   =    "European Conference on Computer Vision (to appear)",
%         notes       =    "Poster presentation",
%         url         =    "http://mi.eng.cam.ac.uk/~er258/work/rosten_2006_machine.pdf"
%     }
%
%     @article{rosten_2008_faster,
%         title       =    "Faster and better: A machine learning approach to corner detection",
%         author      =    "Edward Rosten and Reid Porter and Tom Drummond",
%         year        =    "2008",
%         month       =    "October",
%         journal     =    "IEEE Transactions on Pattern Analysis and Machine Intelligence (to appear)",
%         eprint      =    "arXiv:0810.2434 [cs.CV]",
%         url         =    "http://lanl.arXiv.org/pdf/0810.2434"
%     }
function [ corners scores ] = faster(image, threshold, do_nonmax)
	
	corners = zeros(1024, 2);
	num_corners=0;

	for y=5:size(image,1)-5
		
		for x=5:size(image,2)-5
			cb = image(y, x) + threshold;
			c_b = image(y, x) - threshold;
          if image(y+-3,x+-2) > cb 
           if image(y+2,x+3) > cb 
            if image(y+-2,x+-1) > cb 
             if image(y+2,x+-3) > cb 
              if image(y+-2,x+2) > cb 
               if image(y+2,x+-2) > cb 
                if image(y+2,x+2) > cb 
                 if image(y+-4,x+-1) > cb 
                  if image(y+3,x+2) > cb | image(y+3,x+2) < c_b 
                  else
                   if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                   else
                    if image(y+4,x+-1) > cb 
                     if image(y+-3,x+1) > cb 
                     elseif image(y+-3,x+1) < c_b 
                      continue
                     else
                      if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                       continue
                      else
                      end
                     end
                    elseif image(y+4,x+-1) < c_b 
                     if image(y+-2,x+-2) > cb 
                     elseif image(y+-2,x+-2) < c_b 
                      continue
                     else
                      if image(y+-1,x+3) > cb 
                      else
                       continue
                      end
                     end
                    else
                     if image(y+0,x+-3) > cb 
                      if image(y+1,x+-2) > cb 
                      elseif image(y+1,x+-2) < c_b 
                       continue
                      else
                       if image(y+-2,x+0) > cb 
                       elseif image(y+-2,x+0) < c_b 
                        continue
                       else
                        if image(y+-1,x+4) > cb 
                        else
                         continue
                        end
                       end
                      end
                     else
                     end
                    end
                   end
                  end
                 elseif image(y+-4,x+-1) < c_b 
                 else
                  if image(y+-1,x+2) > cb 
                  elseif image(y+-1,x+2) < c_b 
                   continue
                  else
                   if image(y+2,x+0) > cb 
                   elseif image(y+2,x+0) < c_b 
                    continue
                   else
                    if image(y+-1,x+-2) > cb 
                    elseif image(y+-1,x+-2) < c_b 
                     continue
                    else
                     if image(y+-1,x+-3) > cb 
                      if image(y+1,x+2) > cb 
                      elseif image(y+1,x+2) < c_b 
                       continue
                      else
                       if image(y+-2,x+-2) > cb 
                        if image(y+-2,x+0) > cb 
                        elseif image(y+-2,x+0) < c_b 
                         continue
                        else
                         if image(y+1,x+-3) > cb 
                          if image(y+1,x+3) > cb 
                          elseif image(y+1,x+3) < c_b 
                           continue
                          else
                           if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                            continue
                           else
                           end
                          end
                         else
                          continue
                         end
                        end
                       elseif image(y+-2,x+-2) < c_b 
                        continue
                       else
                        if image(y+-4,x+1) > cb 
                        else
                         continue
                        end
                       end
                      end
                     elseif image(y+-1,x+-3) < c_b 
                      continue
                     else
                     end
                    end
                   end
                  end
                 end
                elseif image(y+2,x+2) < c_b 
                else
                 if image(y+-1,x+-2) > cb 
                  if image(y+-1,x+-4) > cb 
                   if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                   else
                    if image(y+3,x+-2) > cb 
                     if image(y+-1,x+2) > cb | image(y+-1,x+2) < c_b 
                     else
                      if image(y+0,x+-3) > cb 
                       if image(y+0,x+-4) > cb 
                       elseif image(y+0,x+-4) < c_b 
                        continue
                       else
                        if image(y+3,x+2) > cb 
                         if image(y+4,x+-1) > cb 
                         else
                          continue
                         end
                        elseif image(y+3,x+2) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+0,x+-3) < c_b 
                       continue
                      else
                       if image(y+0,x+-4) > cb 
                        if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                         continue
                        else
                        end
                       elseif image(y+0,x+-4) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    elseif image(y+3,x+-2) < c_b 
                     continue
                    else
                     if image(y+-1,x+4) > cb 
                     elseif image(y+-1,x+4) < c_b 
                      continue
                     else
                      if image(y+1,x+3) > cb 
                       if image(y+3,x+2) > cb 
                        if image(y+-1,x+2) > cb | image(y+-1,x+2) < c_b 
                         continue
                        else
                        end
                       elseif image(y+3,x+2) < c_b 
                        continue
                       else
                       end
                      elseif image(y+1,x+3) < c_b 
                       continue
                      else
                      end
                     end
                    end
                   end
                  elseif image(y+-1,x+-4) < c_b 
                  else
                   if image(y+-1,x+2) > cb 
                    if image(y+-2,x+-2) > cb 
                     if image(y+-1,x+4) > cb | image(y+-1,x+4) < c_b 
                     else
                      if image(y+1,x+-2) > cb 
                      elseif image(y+1,x+-2) < c_b 
                       continue
                      else
                       if image(y+2,x+-1) > cb 
                       elseif image(y+2,x+-1) < c_b 
                        continue
                       else
                        if image(y+-4,x+0) > cb 
                        elseif image(y+-4,x+0) < c_b 
                         continue
                        else
                         if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+-2,x+-2) < c_b 
                     continue
                    else
                     if image(y+-3,x+0) > cb 
                     else
                      continue
                     end
                    end
                   elseif image(y+-1,x+2) < c_b 
                    continue
                   else
                    if image(y+0,x+-2) > cb 
                     if image(y+2,x+0) > cb | image(y+2,x+0) < c_b 
                     else
                      if image(y+-2,x+-3) > cb 
                       if image(y+-1,x+4) > cb 
                        if image(y+-2,x+3) > cb 
                         if image(y+-2,x+1) > cb 
                         elseif image(y+-2,x+1) < c_b 
                          continue
                         else
                          if image(y+4,x+0) > cb 
                          elseif image(y+4,x+0) < c_b 
                           continue
                          else
                           if image(y+4,x+-1) > cb 
                            if image(y+2,x+-1) > cb 
                             if image(y+3,x+-1) > cb 
                             elseif image(y+3,x+-1) < c_b 
                              continue
                             else
                              if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                               continue
                              else
                              end
                             end
                            elseif image(y+2,x+-1) < c_b 
                             continue
                            else
                             if image(y+-4,x+1) > cb 
                              if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                               continue
                              else
                              end
                             elseif image(y+-4,x+1) < c_b 
                              continue
                             else
                             end
                            end
                           elseif image(y+4,x+-1) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        elseif image(y+-2,x+3) < c_b 
                         continue
                        else
                         if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+-1,x+4) < c_b 
                        continue
                       else
                       end
                      elseif image(y+-2,x+-3) < c_b 
                       continue
                      else
                      end
                     end
                    elseif image(y+0,x+-2) < c_b 
                     continue
                    else
                     if image(y+3,x+2) > cb 
                      if image(y+-2,x+3) > cb 
                      elseif image(y+-2,x+3) < c_b 
                       continue
                      else
                       if image(y+1,x+-2) > cb 
                        if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                         continue
                        else
                        end
                       elseif image(y+1,x+-2) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+3,x+2) < c_b 
                      continue
                     else
                      if image(y+2,x+-1) > cb 
                      elseif image(y+2,x+-1) < c_b 
                       continue
                      else
                       if image(y+4,x+-1) > cb 
                        if image(y+-2,x+-3) > cb 
                         if image(y+-4,x+-1) > cb 
                          if image(y+-2,x+1) > cb 
                           if image(y+-3,x+0) > cb 
                            if image(y+-1,x+-3) > cb 
                            elseif image(y+-1,x+-3) < c_b 
                             continue
                            else
                             if image(y+-1,x+3) > cb 
                             else
                              continue
                             end
                            end
                           else
                            continue
                           end
                          else
                           continue
                          end
                         elseif image(y+-4,x+-1) < c_b 
                          continue
                         else
                         end
                        elseif image(y+-2,x+-3) < c_b 
                         continue
                        else
                        end
                       elseif image(y+4,x+-1) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    end
                   end
                  end
                 elseif image(y+-1,x+-2) < c_b 
                 else
                  if image(y+-1,x+2) > cb 
                   if image(y+-1,x+4) > cb 
                    if image(y+-2,x+1) > cb 
                    elseif image(y+-2,x+1) < c_b 
                     continue
                    else
                     if image(y+-2,x+-2) > cb 
                     elseif image(y+-2,x+-2) < c_b 
                      continue
                     else
                      if image(y+-2,x+-3) > cb 
                       if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                        continue
                       else
                       end
                      elseif image(y+-2,x+-3) < c_b 
                       continue
                      else
                      end
                     end
                    end
                   elseif image(y+-1,x+4) < c_b 
                    continue
                   else
                    if image(y+2,x+-1) > cb 
                    elseif image(y+2,x+-1) < c_b 
                     continue
                    else
                     if image(y+3,x+1) > cb 
                      if image(y+0,x+-3) > cb 
                      elseif image(y+0,x+-3) < c_b 
                       continue
                      else
                       if image(y+-4,x+-1) > cb 
                        if image(y+1,x+-2) > cb 
                        elseif image(y+1,x+-2) < c_b 
                         continue
                        else
                         if image(y+0,x+2) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+-4,x+-1) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+3,x+1) < c_b 
                     else
                      if image(y+-2,x+1) > cb 
                      elseif image(y+-2,x+1) < c_b 
                       continue
                      else
                       if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+-1,x+2) < c_b 
                   continue
                  else
                   if image(y+2,x+0) > cb 
                    if image(y+1,x+-2) > cb 
                     if image(y+-2,x+3) > cb 
                      if image(y+0,x+3) > cb 
                       if image(y+0,x+-4) > cb 
                        if image(y+-1,x+-4) > cb 
                        elseif image(y+-1,x+-4) < c_b 
                         continue
                        else
                         if image(y+-2,x+1) > cb 
                          if image(y+0,x+-3) > cb 
                          else
                           continue
                          end
                         elseif image(y+-2,x+1) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+0,x+-4) < c_b 
                        continue
                       else
                       end
                      elseif image(y+0,x+3) < c_b 
                       continue
                      else
                      end
                     elseif image(y+-2,x+3) < c_b 
                      continue
                     else
                      if image(y+2,x+1) > cb 
                      elseif image(y+2,x+1) < c_b 
                       continue
                      else
                       if image(y+4,x+0) > cb 
                       elseif image(y+4,x+0) < c_b 
                        continue
                       else
                        if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     end
                    elseif image(y+1,x+-2) < c_b 
                     continue
                    else
                    end
                   elseif image(y+2,x+0) < c_b 
                    continue
                   else
                    if image(y+-2,x+0) > cb 
                     if image(y+-2,x+3) > cb 
                      if image(y+3,x+1) > cb 
                       if image(y+-4,x+-1) > cb 
                       elseif image(y+-4,x+-1) < c_b 
                        continue
                       else
                        if image(y+-4,x+1) > cb 
                         if image(y+-4,x+0) > cb 
                         else
                          continue
                         end
                        elseif image(y+-4,x+1) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+3,x+1) < c_b 
                       continue
                      else
                       if image(y+-1,x+-3) > cb 
                       elseif image(y+-1,x+-3) < c_b 
                        continue
                       else
                        if image(y+-2,x+-2) > cb 
                         if image(y+4,x+-1) > cb 
                          if image(y+1,x+3) > cb 
                          elseif image(y+1,x+3) < c_b 
                           continue
                          else
                           if image(y+2,x+-1) > cb 
                           elseif image(y+2,x+-1) < c_b 
                            continue
                           else
                            if image(y+-4,x+-1) > cb 
                             if image(y+3,x+2) > cb 
                             elseif image(y+3,x+2) < c_b 
                              continue
                             else
                              if image(y+4,x+0) > cb 
                              else
                               continue
                              end
                             end
                            else
                             continue
                            end
                           end
                          end
                         elseif image(y+4,x+-1) < c_b 
                          continue
                         else
                         end
                        elseif image(y+-2,x+-2) < c_b 
                         continue
                        else
                         if image(y+0,x+-4) > cb 
                         elseif image(y+0,x+-4) < c_b 
                          continue
                         else
                          if image(y+1,x+-2) > cb 
                           if image(y+2,x+-1) > cb 
                           elseif image(y+2,x+-1) < c_b 
                            continue
                           else
                            if image(y+1,x+2) > cb | image(y+1,x+2) < c_b 
                             continue
                            else
                             if image(y+3,x+-1) > cb 
                              if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                               continue
                              else
                              end
                             elseif image(y+3,x+-1) < c_b 
                              continue
                             else
                             end
                            end
                           end
                          elseif image(y+1,x+-2) < c_b 
                           continue
                          else
                           if image(y+3,x+0) > cb 
                            if image(y+1,x+3) > cb 
                            else
                             continue
                            end
                           elseif image(y+3,x+0) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+-2,x+3) < c_b 
                      continue
                     else
                      if image(y+-4,x+1) > cb 
                       if image(y+-1,x+-4) > cb 
                        if image(y+-4,x+-1) > cb 
                        elseif image(y+-4,x+-1) < c_b 
                         continue
                        else
                         if image(y+-2,x+-2) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+-1,x+-4) < c_b 
                        continue
                       else
                        if image(y+1,x+-2) > cb 
                         if image(y+1,x+-3) > cb 
                          if image(y+0,x+4) > cb 
                          elseif image(y+0,x+4) < c_b 
                           continue
                          else
                           if image(y+0,x+-2) > cb 
                           elseif image(y+0,x+-2) < c_b 
                            continue
                           else
                            if image(y+3,x+1) > cb | image(y+3,x+1) < c_b 
                             continue
                            else
                            end
                           end
                          end
                         else
                          continue
                         end
                        elseif image(y+1,x+-2) < c_b 
                         continue
                        else
                         if image(y+3,x+2) > cb 
                         elseif image(y+3,x+2) < c_b 
                          continue
                         else
                          if image(y+-2,x+-3) > cb 
                           if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-2,x+-3) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       end
                      elseif image(y+-4,x+1) < c_b 
                       continue
                      else
                      end
                     end
                    elseif image(y+-2,x+0) < c_b 
                     continue
                    else
                     if image(y+4,x+1) > cb 
                      if image(y+-4,x+-1) > cb 
                       if image(y+-2,x+-2) > cb 
                       elseif image(y+-2,x+-2) < c_b 
                        continue
                       else
                        if image(y+1,x+-2) > cb | image(y+1,x+-2) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+-4,x+-1) < c_b 
                       continue
                      else
                       if image(y+-3,x+0) > cb 
                       else
                        continue
                       end
                      end
                     elseif image(y+4,x+1) < c_b 
                      continue
                     else
                      if image(y+4,x+-1) > cb 
                       if image(y+2,x+-1) > cb 
                        if image(y+-2,x+-2) > cb 
                        else
                         continue
                        end
                       elseif image(y+2,x+-1) < c_b 
                        continue
                       else
                        if image(y+-2,x+1) > cb 
                         if image(y+-2,x+3) > cb 
                         elseif image(y+-2,x+3) < c_b 
                          continue
                         else
                          if image(y+-1,x+-4) > cb 
                          else
                           continue
                          end
                         end
                        else
                         continue
                        end
                       end
                      elseif image(y+4,x+-1) < c_b 
                       continue
                      else
                       if image(y+3,x+2) > cb 
                        if image(y+-4,x+1) > cb 
                        elseif image(y+-4,x+1) < c_b 
                         continue
                        else
                         if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+3,x+2) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    end
                   end
                  end
                 end
                end
               elseif image(y+2,x+-2) < c_b 
               else
                if image(y+-1,x+2) > cb 
                 if image(y+-1,x+-4) > cb 
                  if image(y+-1,x+-2) > cb 
                   if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                   else
                    if image(y+3,x+1) > cb 
                    elseif image(y+3,x+1) < c_b 
                     if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                      continue
                     else
                     end
                    else
                     if image(y+1,x+3) > cb 
                     elseif image(y+1,x+3) < c_b 
                      continue
                     else
                      if image(y+1,x+-3) > cb 
                      elseif image(y+1,x+-3) < c_b 
                       continue
                      else
                       if image(y+-2,x+0) > cb 
                       elseif image(y+-2,x+0) < c_b 
                        continue
                       else
                        if image(y+-2,x+1) > cb | image(y+-2,x+1) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+-1,x+-2) < c_b 
                  else
                   if image(y+-1,x+4) > cb 
                    if image(y+-4,x+1) > cb 
                    elseif image(y+-4,x+1) < c_b 
                     continue
                    else
                     if image(y+3,x+2) > cb 
                      if image(y+0,x+2) > cb 
                      elseif image(y+0,x+2) < c_b 
                       continue
                      else
                       if image(y+-3,x+2) > cb 
                        if image(y+2,x+1) > cb 
                        elseif image(y+2,x+1) < c_b 
                         continue
                        else
                         if image(y+3,x+-1) > cb 
                         elseif image(y+3,x+-1) < c_b 
                          continue
                         else
                          if image(y+-4,x+0) > cb 
                          else
                           continue
                          end
                         end
                        end
                       elseif image(y+-3,x+2) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+3,x+2) < c_b 
                      continue
                     else
                      if image(y+1,x+2) > cb 
                       if image(y+4,x+0) > cb 
                        if image(y+4,x+-1) > cb 
                        elseif image(y+4,x+-1) < c_b 
                         continue
                        else
                         if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                          continue
                         else
                          if image(y+-4,x+0) > cb 
                           if image(y+-2,x+0) > cb 
                           else
                            continue
                           end
                          elseif image(y+-4,x+0) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+4,x+0) < c_b 
                       else
                        if image(y+-3,x+-1) > cb 
                        elseif image(y+-3,x+-1) < c_b 
                         continue
                        else
                         if image(y+-4,x+-1) > cb 
                         else
                          continue
                         end
                        end
                       end
                      elseif image(y+1,x+2) < c_b 
                       continue
                      else
                      end
                     end
                    end
                   elseif image(y+-1,x+4) < c_b 
                   else
                    if image(y+0,x+2) > cb 
                     if image(y+-2,x+-3) > cb 
                     elseif image(y+-2,x+-3) < c_b 
                      continue
                     else
                      if image(y+1,x+-4) > cb 
                      elseif image(y+1,x+-4) < c_b 
                       continue
                      else
                       if image(y+3,x+1) > cb 
                        if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                         continue
                        else
                        end
                       elseif image(y+3,x+1) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    elseif image(y+0,x+2) < c_b 
                     continue
                    else
                     if image(y+3,x+1) > cb 
                      if image(y+2,x+2) > cb 
                       if image(y+-2,x+0) > cb 
                       elseif image(y+-2,x+0) < c_b 
                        continue
                       else
                        if image(y+3,x+0) > cb 
                        else
                         continue
                        end
                       end
                      elseif image(y+2,x+2) < c_b 
                       continue
                      else
                       if image(y+-1,x+3) > cb | image(y+-1,x+3) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+3,x+1) < c_b 
                      continue
                     else
                      if image(y+1,x+-2) > cb 
                       if image(y+3,x+-2) > cb 
                       else
                        continue
                       end
                      elseif image(y+1,x+-2) < c_b 
                       continue
                      else
                       if image(y+1,x+-4) > cb 
                       elseif image(y+1,x+-4) < c_b 
                        continue
                       else
                        if image(y+3,x+2) > cb | image(y+3,x+2) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     end
                    end
                   end
                  end
                 elseif image(y+-1,x+-4) < c_b 
                  if image(y+-3,x+0) > cb 
                  else
                   continue
                  end
                 else
                  if image(y+-4,x+1) > cb 
                   if image(y+-1,x+4) > cb | image(y+-1,x+4) < c_b 
                   else
                    if image(y+2,x+1) > cb 
                     if image(y+3,x+1) > cb 
                     elseif image(y+3,x+1) < c_b 
                      continue
                     else
                      if image(y+4,x+-1) > cb 
                       if image(y+-2,x+-3) > cb 
                       else
                        continue
                       end
                      elseif image(y+4,x+-1) < c_b 
                       continue
                      else
                      end
                     end
                    elseif image(y+2,x+1) < c_b 
                     continue
                    else
                     if image(y+0,x+4) > cb 
                     elseif image(y+0,x+4) < c_b 
                      continue
                     else
                      if image(y+4,x+-1) > cb 
                       if image(y+1,x+3) > cb 
                        if image(y+-2,x+1) > cb 
                        else
                         continue
                        end
                       elseif image(y+1,x+3) < c_b 
                        continue
                       else
                        if image(y+-2,x+-2) > cb 
                         if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                          continue
                         else
                          if image(y+-1,x+-2) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+-2,x+-2) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+4,x+-1) < c_b 
                      else
                       if image(y+4,x+1) > cb 
                        if image(y+-1,x+-3) > cb 
                        elseif image(y+-1,x+-3) < c_b 
                         continue
                        else
                         if image(y+0,x+-4) > cb 
                         elseif image(y+0,x+-4) < c_b 
                          continue
                         else
                          if image(y+1,x+4) > cb 
                          else
                           continue
                          end
                         end
                        end
                       elseif image(y+4,x+1) < c_b 
                       else
                        if image(y+-3,x+2) > cb 
                        elseif image(y+-3,x+2) < c_b 
                         continue
                        else
                         if image(y+-2,x+0) > cb 
                         else
                          continue
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+-4,x+1) < c_b 
                  else
                   if image(y+3,x+2) > cb 
                    if image(y+-1,x+4) > cb | image(y+-1,x+4) < c_b 
                    else
                     if image(y+1,x+2) > cb 
                     elseif image(y+1,x+2) < c_b 
                      continue
                     else
                      if image(y+3,x+1) > cb 
                      elseif image(y+3,x+1) < c_b 
                       continue
                      else
                       if image(y+1,x+4) > cb 
                       else
                        continue
                       end
                      end
                     end
                    end
                   elseif image(y+3,x+2) < c_b 
                    continue
                   else
                    if image(y+1,x+2) > cb 
                     if image(y+-2,x+1) > cb 
                      if image(y+4,x+1) > cb 
                       if image(y+4,x+-1) > cb 
                       elseif image(y+4,x+-1) < c_b 
                        continue
                       else
                        if image(y+-1,x+-2) > cb | image(y+-1,x+-2) < c_b 
                         continue
                        else
                         if image(y+-3,x+0) > cb 
                         else
                          continue
                         end
                        end
                       end
                      elseif image(y+4,x+1) < c_b 
                       continue
                      else
                       if image(y+-2,x+0) > cb 
                       elseif image(y+-2,x+0) < c_b 
                        continue
                       else
                        if image(y+2,x+2) > cb | image(y+2,x+2) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     elseif image(y+-2,x+1) < c_b 
                      continue
                     else
                      if image(y+-1,x+-2) > cb 
                       if image(y+-4,x+0) > cb 
                       elseif image(y+-4,x+0) < c_b 
                        continue
                       else
                        if image(y+-4,x+-1) > cb 
                         if image(y+-2,x+-3) > cb 
                          if image(y+0,x+-2) > cb 
                          else
                           continue
                          end
                         elseif image(y+-2,x+-3) < c_b 
                          continue
                         else
                         end
                        elseif image(y+-4,x+-1) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+-1,x+-2) < c_b 
                       continue
                      else
                       if image(y+-2,x+-2) > cb 
                        if image(y+0,x+-4) > cb 
                         if image(y+0,x+-3) > cb | image(y+0,x+-3) < c_b 
                          continue
                         else
                          if image(y+4,x+-1) > cb 
                          elseif image(y+4,x+-1) < c_b 
                           continue
                          else
                           if image(y+-2,x+0) > cb 
                            if image(y+-1,x+-3) > cb 
                             if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                              continue
                             else
                             end
                            elseif image(y+-1,x+-3) < c_b 
                             continue
                            else
                            end
                           else
                            continue
                           end
                          end
                         end
                        else
                         continue
                        end
                       elseif image(y+-2,x+-2) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    elseif image(y+1,x+2) < c_b 
                     continue
                    else
                     if image(y+2,x+1) < c_b
                      if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                       continue
                      else
                      end
                     else
                     end
                    end
                   end
                  end
                 end
                elseif image(y+-1,x+2) < c_b 
                else
                 if image(y+-1,x+-2) > cb 
                  if image(y+-1,x+-4) > cb 
                   if image(y+-4,x+-1) > cb 
                   elseif image(y+-4,x+-1) < c_b 
                    continue
                   else
                    if image(y+1,x+-3) > cb 
                    elseif image(y+1,x+-3) < c_b 
                     continue
                    else
                     if image(y+2,x+2) > cb 
                     elseif image(y+2,x+2) < c_b 
                      continue
                     else
                      if image(y+0,x+4) > cb 
                       if image(y+-3,x+1) < c_b
                        continue
                       else
                        if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+0,x+4) < c_b 
                       continue
                      else
                      end
                     end
                    end
                   end
                  elseif image(y+-1,x+-4) < c_b 
                   continue
                  else
                   if image(y+3,x+-1) > cb 
                    if image(y+2,x+1) > cb 
                    elseif image(y+2,x+1) < c_b 
                     continue
                    else
                     if image(y+-4,x+-1) > cb 
                      if image(y+3,x+2) > cb 
                       if image(y+2,x+2) > cb 
                        if image(y+-1,x+3) > cb 
                        elseif image(y+-1,x+3) < c_b 
                         continue
                        else
                         if image(y+0,x+-2) > cb 
                         elseif image(y+0,x+-2) < c_b 
                          continue
                         else
                          if image(y+1,x+2) > cb 
                          else
                           continue
                          end
                         end
                        end
                       elseif image(y+2,x+2) < c_b 
                        continue
                       else
                        if image(y+3,x+1) > cb | image(y+3,x+1) < c_b 
                         continue
                        else
                         if image(y+-1,x+3) > cb 
                         else
                          continue
                         end
                        end
                       end
                      elseif image(y+3,x+2) < c_b 
                       continue
                      else
                      end
                     elseif image(y+-4,x+-1) < c_b 
                      continue
                     else
                     end
                    end
                   elseif image(y+3,x+-1) < c_b 
                   else
                    if image(y+1,x+3) > cb 
                     if image(y+1,x+2) > cb 
                      if image(y+2,x+2) > cb 
                      elseif image(y+2,x+2) < c_b 
                       continue
                      else
                       if image(y+-4,x+1) > cb 
                        if image(y+3,x+2) > cb 
                        else
                         continue
                        end
                       elseif image(y+-4,x+1) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+1,x+2) < c_b 
                      continue
                     else
                     end
                    elseif image(y+1,x+3) < c_b 
                     continue
                    else
                     if image(y+3,x+-2) > cb 
                      if image(y+0,x+4) > cb 
                      elseif image(y+0,x+4) < c_b 
                       continue
                      else
                       if image(y+0,x+-2) > cb 
                       elseif image(y+0,x+-2) < c_b 
                        continue
                       else
                        if image(y+0,x+-4) > cb 
                        else
                         continue
                        end
                       end
                      end
                     elseif image(y+3,x+-2) < c_b 
                      continue
                     else
                     end
                    end
                   end
                  end
                 elseif image(y+-1,x+-2) < c_b 
                 else
                  if image(y+2,x+1) > cb 
                   if image(y+4,x+1) > cb 
                   elseif image(y+4,x+1) < c_b 
                    continue
                   else
                    if image(y+3,x+2) > cb 
                     if image(y+-2,x+1) > cb 
                      if image(y+1,x+2) > cb 
                       if image(y+3,x+-1) > cb 
                        if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                         continue
                        else
                         if image(y+-2,x+-3) > cb 
                         elseif image(y+-2,x+-3) < c_b 
                          continue
                         else
                          if image(y+-2,x+-2) > cb 
                           if image(y+-1,x+-4) > cb 
                           else
                            continue
                           end
                          elseif image(y+-2,x+-2) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+3,x+-1) < c_b 
                        continue
                       else
                       end
                      elseif image(y+1,x+2) < c_b 
                       continue
                      else
                      end
                     elseif image(y+-2,x+1) < c_b 
                      continue
                     else
                      if image(y+3,x+-2) > cb 
                       if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                        continue
                       else
                       end
                      elseif image(y+3,x+-2) < c_b 
                       continue
                      else
                      end
                     end
                    elseif image(y+3,x+2) < c_b 
                     continue
                    else
                    end
                   end
                  elseif image(y+2,x+1) < c_b 
                   if image(y+0,x+-4) > cb 
                   else
                    continue
                   end
                  else
                   if image(y+3,x+-2) > cb 
                    if image(y+3,x+2) > cb 
                     if image(y+2,x+2) > cb 
                      if image(y+-2,x+1) > cb 
                       if image(y+-3,x+0) > cb 
                        if image(y+3,x+0) > cb 
                        elseif image(y+3,x+0) < c_b 
                         continue
                        else
                         if image(y+1,x+-3) > cb 
                         elseif image(y+1,x+-3) < c_b 
                          continue
                         else
                          if image(y+3,x+-1) > cb 
                           if image(y+-2,x+-3) > cb 
                           elseif image(y+-2,x+-3) < c_b 
                            continue
                           else
                            if image(y+-1,x+4) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+3,x+-1) < c_b 
                           continue
                          else
                           if image(y+-4,x+1) > cb 
                           elseif image(y+-4,x+1) < c_b 
                            continue
                           else
                            if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                             continue
                            else
                            end
                           end
                          end
                         end
                        end
                       elseif image(y+-3,x+0) < c_b 
                        continue
                       else
                        if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+-2,x+1) < c_b 
                       continue
                      else
                       if image(y+-2,x+-3) > cb 
                        if image(y+3,x+-1) > cb 
                         if image(y+-2,x+0) > cb 
                          if image(y+1,x+2) > cb 
                          elseif image(y+1,x+2) < c_b 
                           continue
                          else
                           if image(y+2,x+-1) > cb 
                           else
                            continue
                           end
                          end
                         else
                          continue
                         end
                        elseif image(y+3,x+-1) < c_b 
                         continue
                        else
                         if image(y+0,x+3) > cb 
                          if image(y+1,x+-3) > cb 
                          elseif image(y+1,x+-3) < c_b 
                           continue
                          else
                           if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+0,x+3) < c_b 
                          continue
                         else
                          if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+-2,x+-3) < c_b 
                        continue
                       else
                        if image(y+4,x+0) > cb 
                        else
                         continue
                        end
                       end
                      end
                     elseif image(y+2,x+2) < c_b 
                      continue
                     else
                      if image(y+3,x+-1) > cb 
                       if image(y+2,x+-1) > cb 
                       elseif image(y+2,x+-1) < c_b 
                        continue
                       else
                        if image(y+-2,x+-2) > cb 
                         if image(y+3,x+1) > cb 
                          if image(y+1,x+-2) > cb 
                          else
                           continue
                          end
                         elseif image(y+3,x+1) < c_b 
                          continue
                         else
                          if image(y+-1,x+3) > cb 
                           if image(y+-2,x+1) > cb 
                           else
                            continue
                           end
                          elseif image(y+-1,x+3) < c_b 
                           continue
                          else
                           if image(y+4,x+-1) > cb | image(y+4,x+-1) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        elseif image(y+-2,x+-2) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+3,x+-1) < c_b 
                       continue
                      else
                       if image(y+1,x+-3) > cb 
                       elseif image(y+1,x+-3) < c_b 
                        continue
                       else
                        if image(y+-1,x+4) > cb 
                         if image(y+0,x+-4) > cb 
                          if image(y+0,x+3) > cb 
                           if image(y+3,x+1) > cb | image(y+3,x+1) < c_b 
                            continue
                           else
                           end
                          else
                           continue
                          end
                         elseif image(y+0,x+-4) < c_b 
                          continue
                         else
                         end
                        else
                         continue
                        end
                       end
                      end
                     end
                    elseif image(y+3,x+2) < c_b 
                     continue
                    else
                     if image(y+4,x+1) > cb 
                     elseif image(y+4,x+1) < c_b 
                      continue
                     else
                      if image(y+4,x+-1) > cb 
                       if image(y+1,x+3) > cb 
                        if image(y+-2,x+0) > cb 
                        else
                         continue
                        end
                       elseif image(y+1,x+3) < c_b 
                        continue
                       else
                        if image(y+-1,x+4) > cb 
                         if image(y+1,x+-2) > cb 
                         else
                          continue
                         end
                        elseif image(y+-1,x+4) < c_b 
                         continue
                        else
                         if image(y+-2,x+-3) > cb 
                          if image(y+-4,x+1) > cb 
                           if image(y+1,x+4) > cb 
                           else
                            continue
                           end
                          elseif image(y+-4,x+1) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        end
                       end
                      elseif image(y+4,x+-1) < c_b 
                       continue
                      else
                       if image(y+1,x+2) > cb 
                        if image(y+-1,x+3) > cb 
                        else
                         continue
                        end
                       elseif image(y+1,x+2) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    end
                   elseif image(y+3,x+-2) < c_b 
                    continue
                   else
                    if image(y+3,x+2) > cb 
                     if image(y+1,x+-3) > cb 
                      if image(y+3,x+-1) > cb 
                       if image(y+-2,x+1) > cb 
                       else
                        continue
                       end
                      elseif image(y+3,x+-1) < c_b 
                       continue
                      else
                      end
                     elseif image(y+1,x+-3) < c_b 
                      continue
                     else
                      if image(y+4,x+1) > cb 
                       if image(y+-1,x+4) > cb 
                        if image(y+-1,x+-4) > cb 
                         if image(y+-2,x+1) > cb 
                          if image(y+4,x+-1) > cb 
                          elseif image(y+4,x+-1) < c_b 
                           continue
                          else
                           if image(y+1,x+2) > cb 
                           else
                            continue
                           end
                          end
                         else
                          continue
                         end
                        elseif image(y+-1,x+-4) < c_b 
                         continue
                        else
                        end
                       elseif image(y+-1,x+4) < c_b 
                        continue
                       else
                        if image(y+4,x+-1) > cb 
                         if image(y+-4,x+0) > cb 
                         else
                          continue
                         end
                        elseif image(y+4,x+-1) < c_b 
                         continue
                        else
                         if image(y+1,x+2) > cb 
                         elseif image(y+1,x+2) < c_b 
                          continue
                         else
                          if image(y+2,x+-1) > cb 
                          else
                           continue
                          end
                         end
                        end
                       end
                      elseif image(y+4,x+1) < c_b 
                       continue
                      else
                       if image(y+-2,x+1) > cb 
                       elseif image(y+-2,x+1) < c_b 
                        continue
                       else
                        if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     end
                    elseif image(y+3,x+2) < c_b 
                     continue
                    else
                     if image(y+4,x+-1) > cb 
                      if image(y+-2,x+1) > cb 
                      else
                       continue
                      end
                     elseif image(y+4,x+-1) < c_b 
                      if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                       continue
                      else
                      end
                     else
                     end
                    end
                   end
                  end
                 end
                end
               end
              elseif image(y+-2,x+2) < c_b 
               if image(y+-1,x+-2) > cb 
               elseif image(y+-1,x+-2) < c_b 
                continue
               else
                if image(y+2,x+1) > cb 
                elseif image(y+2,x+1) < c_b 
                 if image(y+-2,x+-2) > cb 
                 else
                  continue
                 end
                else
                 if image(y+4,x+-1) > cb 
                  if image(y+4,x+1) > cb 
                   if image(y+-3,x+0) > cb 
                   else
                    continue
                   end
                  elseif image(y+4,x+1) < c_b 
                   if image(y+-2,x+-2) > cb 
                    if image(y+-4,x+1) > cb 
                    else
                     continue
                    end
                   else
                    continue
                   end
                  else
                   if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                   else
                    if image(y+-4,x+1) > cb 
                     if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                      continue
                     else
                     end
                    elseif image(y+-4,x+1) < c_b 
                     continue
                    else
                     if image(y+3,x+1) > cb | image(y+3,x+1) < c_b 
                      continue
                     else
                      if image(y+-4,x+0) > cb 
                      elseif image(y+-4,x+0) < c_b 
                       continue
                      else
                       if image(y+-1,x+3) < c_b
                       else
                        continue
                       end
                      end
                     end
                    end
                   end
                  end
                 elseif image(y+4,x+-1) < c_b 
                 else
                  if image(y+2,x+-2) > cb 
                   if image(y+3,x+2) < c_b
                    continue
                   else
                   end
                  elseif image(y+2,x+-2) < c_b 
                   continue
                  else
                   if image(y+1,x+-3) > cb 
                   elseif image(y+1,x+-3) < c_b 
                    continue
                   else
                    if image(y+-2,x+0) > cb 
                    else
                     continue
                    end
                   end
                  end
                 end
                end
               end
              else
               if image(y+4,x+-1) > cb 
                if image(y+3,x+2) > cb 
                 if image(y+2,x+-2) > cb 
                  if image(y+-4,x+-1) > cb 
                   if image(y+2,x+2) > cb 
                   elseif image(y+2,x+2) < c_b 
                    continue
                   else
                    if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                    else
                     if image(y+-4,x+1) > cb 
                      if image(y+1,x+-2) > cb 
                       if image(y+2,x+0) > cb 
                        if image(y+-1,x+-2) > cb 
                        elseif image(y+-1,x+-2) < c_b 
                         continue
                        else
                         if image(y+-3,x+1) > cb 
                          if image(y+-3,x+2) > cb 
                          elseif image(y+-3,x+2) < c_b 
                           continue
                          else
                           if image(y+1,x+-4) > cb 
                            if image(y+2,x+1) > cb 
                            elseif image(y+2,x+1) < c_b 
                             continue
                            else
                             if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                              continue
                             else
                             end
                            end
                           elseif image(y+1,x+-4) < c_b 
                            continue
                           else
                            if image(y+0,x+4) > cb 
                            else
                             continue
                            end
                           end
                          end
                         elseif image(y+-3,x+1) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+2,x+0) < c_b 
                       else
                        if image(y+-3,x+1) > cb 
                         if image(y+1,x+4) > cb 
                         elseif image(y+1,x+4) < c_b 
                          continue
                         else
                          if image(y+-1,x+-2) > cb 
                           if image(y+-1,x+3) < c_b
                            if image(y+-3,x+2) > cb 
                            else
                             continue
                            end
                           else
                           end
                          elseif image(y+-1,x+-2) < c_b 
                           continue
                          else
                           if image(y+-3,x+2) > cb 
                            if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                             continue
                            else
                            end
                           else
                            continue
                           end
                          end
                         end
                        elseif image(y+-3,x+1) < c_b 
                         continue
                        else
                         if image(y+-2,x+0) > cb 
                          if image(y+1,x+3) > cb 
                          elseif image(y+1,x+3) < c_b 
                           continue
                          else
                           if image(y+-1,x+4) > cb 
                           else
                            continue
                           end
                          end
                         elseif image(y+-2,x+0) < c_b 
                          continue
                         else
                          if image(y+-3,x+2) > cb 
                           if image(y+0,x+-2) > cb 
                           elseif image(y+0,x+-2) < c_b 
                            continue
                           else
                            if image(y+-1,x+4) > cb 
                             if image(y+4,x+1) > cb 
                              if image(y+1,x+4) > cb 
                              elseif image(y+1,x+4) < c_b 
                               continue
                              else
                               if image(y+-1,x+3) > cb 
                               else
                                continue
                               end
                              end
                             else
                              continue
                             end
                            else
                             continue
                            end
                           end
                          elseif image(y+-3,x+2) < c_b 
                           continue
                          else
                           if image(y+2,x+-1) > cb 
                           elseif image(y+2,x+-1) < c_b 
                            continue
                           else
                            if image(y+0,x+-3) > cb 
                            elseif image(y+0,x+-3) < c_b 
                             continue
                            else
                             if image(y+-2,x+-3) > cb 
                              if image(y+-1,x+4) > cb 
                              else
                               continue
                              end
                             elseif image(y+-2,x+-3) < c_b 
                              continue
                             else
                             end
                            end
                           end
                          end
                         end
                        end
                       end
                      elseif image(y+1,x+-2) < c_b 
                       continue
                      else
                      end
                     elseif image(y+-4,x+1) < c_b 
                      if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                       continue
                      else
                      end
                     else
                      if image(y+1,x+3) > cb 
                      elseif image(y+1,x+3) < c_b 
                       continue
                      else
                       if image(y+2,x+1) > cb 
                        if image(y+-2,x+-3) > cb 
                        elseif image(y+-2,x+-3) < c_b 
                         continue
                        else
                         if image(y+1,x+-3) > cb 
                         elseif image(y+1,x+-3) < c_b 
                          continue
                         else
                          if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+2,x+1) < c_b 
                        continue
                       else
                        if image(y+1,x+-2) > cb 
                         if image(y+-1,x+-2) > cb 
                          if image(y+2,x+0) > cb 
                          elseif image(y+2,x+0) < c_b 
                           continue
                          else
                           if image(y+-1,x+4) > cb 
                            if image(y+0,x+-2) > cb 
                            elseif image(y+0,x+-2) < c_b 
                             continue
                            else
                             if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                              continue
                             else
                             end
                            end
                           elseif image(y+-1,x+4) < c_b 
                            continue
                           else
                            if image(y+-2,x+0) > cb 
                            elseif image(y+-2,x+0) < c_b 
                             continue
                            else
                             if image(y+-2,x+3) > cb 
                             else
                              continue
                             end
                            end
                           end
                          end
                         elseif image(y+-1,x+-2) < c_b 
                          continue
                         else
                          if image(y+-2,x+3) > cb 
                          elseif image(y+-2,x+3) < c_b 
                           continue
                          else
                           if image(y+-2,x+1) > cb 
                           else
                            continue
                           end
                          end
                         end
                        elseif image(y+1,x+-2) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+-4,x+-1) < c_b 
                   continue
                  else
                   if image(y+2,x+0) > cb 
                    if image(y+2,x+2) > cb 
                     if image(y+2,x+-1) > cb 
                      if image(y+-2,x+3) < c_b
                       if image(y+2,x+1) > cb 
                       else
                        continue
                       end
                      else
                      end
                     elseif image(y+2,x+-1) < c_b 
                      continue
                     else
                      if image(y+-1,x+-2) > cb 
                      elseif image(y+-1,x+-2) < c_b 
                       continue
                      else
                       if image(y+-1,x+-4) > cb 
                        if image(y+-2,x+0) > cb 
                        else
                         continue
                        end
                       elseif image(y+-1,x+-4) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    elseif image(y+2,x+2) < c_b 
                     continue
                    else
                     if image(y+-1,x+-2) > cb 
                     elseif image(y+-1,x+-2) < c_b 
                      continue
                     else
                      if image(y+0,x+-4) > cb 
                       if image(y+-2,x+0) > cb 
                       elseif image(y+-2,x+0) < c_b 
                        continue
                       else
                        if image(y+-2,x+3) > cb 
                        else
                         continue
                        end
                       end
                      elseif image(y+0,x+-4) < c_b 
                       continue
                      else
                      end
                     end
                    end
                   elseif image(y+2,x+0) < c_b 
                    continue
                   else
                    if image(y+1,x+2) > cb | image(y+1,x+2) < c_b 
                    else
                     if image(y+-1,x+4) > cb 
                      if image(y+2,x+-1) > cb 
                       if image(y+1,x+4) > cb 
                       elseif image(y+1,x+4) < c_b 
                        continue
                       else
                        if image(y+-2,x+3) > cb 
                        elseif image(y+-2,x+3) < c_b 
                         continue
                        else
                         if image(y+-1,x+-4) > cb 
                          if image(y+-3,x+-1) > cb 
                           if image(y+1,x+3) > cb | image(y+1,x+3) < c_b 
                            continue
                           else
                           end
                          else
                           continue
                          end
                         elseif image(y+-1,x+-4) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      elseif image(y+2,x+-1) < c_b 
                       continue
                      else
                       if image(y+-1,x+-4) > cb 
                        if image(y+-1,x+3) > cb 
                         if image(y+2,x+2) > cb 
                          if image(y+0,x+3) < c_b
                           continue
                          else
                           if image(y+-1,x+-2) > cb | image(y+-1,x+-2) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+2,x+2) < c_b 
                          continue
                         else
                          if image(y+-2,x+3) > cb 
                           if image(y+1,x+3) > cb | image(y+1,x+3) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-2,x+3) < c_b 
                           continue
                          else
                           if image(y+-3,x+-1) > cb 
                           else
                            continue
                           end
                          end
                         end
                        elseif image(y+-1,x+3) < c_b 
                         continue
                        else
                         if image(y+1,x+-2) > cb 
                         elseif image(y+1,x+-2) < c_b 
                          continue
                         else
                          if image(y+-2,x+3) > cb 
                           if image(y+-1,x+-3) > cb 
                           else
                            continue
                           end
                          else
                           continue
                          end
                         end
                        end
                       elseif image(y+-1,x+-4) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+-1,x+4) < c_b 
                      if image(y+-2,x+0) > cb 
                      else
                       continue
                      end
                     else
                      if image(y+-3,x+0) > cb 
                       if image(y+-1,x+-2) > cb 
                        if image(y+-3,x+2) < c_b
                         continue
                        else
                        end
                       elseif image(y+-1,x+-2) < c_b 
                        continue
                       else
                        if image(y+-1,x+-4) > cb 
                         if image(y+-2,x+1) > cb 
                         elseif image(y+-2,x+1) < c_b 
                          continue
                         else
                          if image(y+0,x+-2) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+-1,x+-4) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+-3,x+0) < c_b 
                       continue
                      else
                       if image(y+2,x+1) > cb 
                        if image(y+0,x+-2) > cb 
                        elseif image(y+0,x+-2) < c_b 
                         continue
                        else
                         if image(y+-1,x+-4) > cb 
                          if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                          else
                           if image(y+-2,x+1) > cb 
                           else
                            continue
                           end
                          end
                         elseif image(y+-1,x+-4) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+2,x+1) < c_b 
                        continue
                       else
                        if image(y+-1,x+-4) > cb 
                         if image(y+-2,x+3) > cb 
                          if image(y+2,x+-1) > cb 
                          elseif image(y+2,x+-1) < c_b 
                           continue
                          else
                           if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                            continue
                           else
                            if image(y+-2,x+0) > cb 
                            elseif image(y+-2,x+0) < c_b 
                             continue
                            else
                             if image(y+-4,x+0) < c_b
                             else
                              continue
                             end
                            end
                           end
                          end
                         elseif image(y+-2,x+3) < c_b 
                          if image(y+-2,x+0) > cb 
                          else
                           continue
                          end
                         else
                          if image(y+-3,x+2) > cb 
                          elseif image(y+-3,x+2) < c_b 
                           continue
                          else
                           if image(y+-1,x+2) > cb | image(y+-1,x+2) < c_b 
                           else
                            if image(y+-4,x+0) > cb 
                             if image(y+-1,x+-2) > cb 
                             else
                              continue
                             end
                            elseif image(y+-4,x+0) < c_b 
                             continue
                            else
                             if image(y+-2,x+1) > cb 
                             elseif image(y+-2,x+1) < c_b 
                              continue
                             else
                              if image(y+-2,x+0) > cb 
                               if image(y+2,x+-1) > cb 
                                if image(y+2,x+2) > cb 
                                 if image(y+0,x+3) > cb 
                                 else
                                  continue
                                 end
                                elseif image(y+2,x+2) < c_b 
                                 continue
                                else
                                end
                               else
                                continue
                               end
                              elseif image(y+-2,x+0) < c_b 
                               continue
                              else
                               if image(y+-3,x+1) > cb 
                               elseif image(y+-3,x+1) < c_b 
                                continue
                               else
                                if image(y+0,x+4) > cb 
                                 if image(y+1,x+4) > cb | image(y+1,x+4) < c_b 
                                  continue
                                 else
                                 end
                                else
                                 continue
                                end
                               end
                              end
                             end
                            end
                           end
                          end
                         end
                        elseif image(y+-1,x+-4) < c_b 
                         continue
                        else
                         if image(y+1,x+-2) > cb 
                          if image(y+2,x+2) > cb 
                          elseif image(y+2,x+2) < c_b 
                           continue
                          else
                           if image(y+0,x+3) > cb 
                           elseif image(y+0,x+3) < c_b 
                            continue
                           else
                            if image(y+0,x+-4) > cb 
                             if image(y+3,x+1) > cb 
                             else
                              continue
                             end
                            else
                             continue
                            end
                           end
                          end
                         elseif image(y+1,x+-2) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  end
                 elseif image(y+2,x+-2) < c_b 
                  continue
                 else
                  if image(y+3,x+-1) > cb 
                   if image(y+2,x+1) > cb 
                    if image(y+1,x+-2) > cb 
                     if image(y+1,x+-3) > cb 
                      if image(y+-3,x+-1) > cb 
                      elseif image(y+-3,x+-1) < c_b 
                       continue
                      else
                       if image(y+2,x+0) > cb 
                       else
                        continue
                       end
                      end
                     elseif image(y+1,x+-3) < c_b 
                      continue
                     else
                      if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                       continue
                      else
                      end
                     end
                    elseif image(y+1,x+-2) < c_b 
                     continue
                    else
                     if image(y+-2,x+1) > cb 
                      if image(y+-4,x+-1) > cb 
                       if image(y+-1,x+-2) > cb 
                       elseif image(y+-1,x+-2) < c_b 
                        continue
                       else
                        if image(y+1,x+-4) > cb 
                         if image(y+4,x+0) > cb 
                          if image(y+1,x+-3) > cb 
                           if image(y+-1,x+4) > cb 
                           elseif image(y+-1,x+4) < c_b 
                            continue
                           else
                            if image(y+-2,x+-3) > cb 
                             if image(y+0,x+4) > cb 
                              if image(y+2,x+-1) > cb 
                              elseif image(y+2,x+-1) < c_b 
                               continue
                              else
                               if image(y+-4,x+1) > cb 
                                if image(y+1,x+2) > cb | image(y+1,x+2) < c_b 
                                 continue
                                else
                                end
                               elseif image(y+-4,x+1) < c_b 
                                continue
                               else
                               end
                              end
                             elseif image(y+0,x+4) < c_b 
                              continue
                             else
                             end
                            else
                             continue
                            end
                           end
                          elseif image(y+1,x+-3) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        elseif image(y+1,x+-4) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+-4,x+-1) < c_b 
                       continue
                      else
                       if image(y+-3,x+2) > cb 
                       elseif image(y+-3,x+2) < c_b 
                        continue
                       else
                        if image(y+1,x+-4) > cb 
                         if image(y+-1,x+-2) > cb 
                          if image(y+-4,x+1) > cb 
                          elseif image(y+-4,x+1) < c_b 
                           continue
                          else
                           if image(y+-1,x+3) > cb | image(y+-1,x+3) < c_b 
                            continue
                           else
                           end
                          end
                         else
                          continue
                         end
                        elseif image(y+1,x+-4) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     elseif image(y+-2,x+1) < c_b 
                      if image(y+-2,x+-3) > cb 
                      else
                       continue
                      end
                     else
                      if image(y+-1,x+-2) > cb 
                       if image(y+-3,x+1) > cb 
                        if image(y+-1,x+3) > cb 
                         if image(y+-1,x+2) > cb 
                          if image(y+-1,x+4) > cb 
                          else
                           continue
                          end
                         elseif image(y+-1,x+2) < c_b 
                          continue
                         else
                          if image(y+2,x+-1) > cb 
                          elseif image(y+2,x+-1) < c_b 
                           continue
                          else
                           if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                            continue
                           else
                            if image(y+1,x+2) > cb 
                            else
                             continue
                            end
                           end
                          end
                         end
                        else
                        end
                       elseif image(y+-3,x+1) < c_b 
                       else
                        if image(y+2,x+0) > cb 
                        elseif image(y+2,x+0) < c_b 
                         continue
                        else
                         if image(y+0,x+-2) > cb 
                          if image(y+-2,x+3) < c_b
                           continue
                          else
                          end
                         elseif image(y+0,x+-2) < c_b 
                          continue
                         else
                          if image(y+-1,x+3) > cb 
                          elseif image(y+-1,x+3) < c_b 
                           continue
                          else
                           if image(y+1,x+3) > cb 
                            if image(y+-4,x+0) > cb 
                             if image(y+1,x+4) > cb 
                              if image(y+-1,x+4) > cb 
                               if image(y+1,x+-3) > cb 
                                if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                                 continue
                                else
                                end
                               elseif image(y+1,x+-3) < c_b 
                                continue
                               else
                               end
                              else
                               continue
                              end
                             elseif image(y+1,x+4) < c_b 
                              continue
                             else
                             end
                            elseif image(y+-4,x+0) < c_b 
                             continue
                            else
                             if image(y+-3,x+0) > cb 
                             elseif image(y+-3,x+0) < c_b 
                              continue
                             else
                              if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                               continue
                              else
                              end
                             end
                            end
                           elseif image(y+1,x+3) < c_b 
                            continue
                           else
                            if image(y+-3,x+0) > cb 
                             if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                              continue
                             else
                             end
                            else
                             continue
                            end
                           end
                          end
                         end
                        end
                       end
                      elseif image(y+-1,x+-2) < c_b 
                       continue
                      else
                       if image(y+2,x+-1) > cb 
                        if image(y+-4,x+1) > cb 
                        elseif image(y+-4,x+1) < c_b 
                         continue
                        else
                         if image(y+-2,x+0) > cb 
                         elseif image(y+-2,x+0) < c_b 
                          continue
                         else
                          if image(y+1,x+2) > cb 
                           if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                            continue
                           else
                           end
                          elseif image(y+1,x+2) < c_b 
                           continue
                          else
                           if image(y+-2,x+3) > cb 
                           else
                            continue
                           end
                          end
                         end
                        end
                       elseif image(y+2,x+-1) < c_b 
                        continue
                       else
                        if image(y+1,x+2) > cb 
                         if image(y+1,x+-3) > cb 
                          if image(y+-1,x+3) > cb 
                           if image(y+-3,x+1) > cb 
                            if image(y+-1,x+2) > cb 
                            else
                             continue
                            end
                           elseif image(y+-3,x+1) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-1,x+3) < c_b 
                           continue
                          else
                           if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                            continue
                           else
                            if image(y+-3,x+2) > cb 
                            elseif image(y+-3,x+2) < c_b 
                             continue
                            else
                             if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                              continue
                             else
                             end
                            end
                           end
                          end
                         elseif image(y+1,x+-3) < c_b 
                          continue
                         else
                          if image(y+-2,x+-3) > cb 
                          elseif image(y+-2,x+-3) < c_b 
                           continue
                          else
                           if image(y+-2,x+-2) > cb 
                            if image(y+0,x+2) > cb 
                            elseif image(y+0,x+2) < c_b 
                             continue
                            else
                             if image(y+2,x+0) > cb 
                              if image(y+-4,x+-1) > cb 
                              elseif image(y+-4,x+-1) < c_b 
                               continue
                              else
                               if image(y+-4,x+1) > cb 
                               else
                                continue
                               end
                              end
                             elseif image(y+2,x+0) < c_b 
                              continue
                             else
                              if image(y+-1,x+3) > cb 
                              else
                               continue
                              end
                             end
                            end
                           elseif image(y+-2,x+-2) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        elseif image(y+1,x+2) < c_b 
                         continue
                        else
                         if image(y+-2,x+-2) > cb 
                          if image(y+2,x+2) > cb 
                           if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                            continue
                           else
                            if image(y+-2,x+3) < c_b
                             continue
                            else
                             if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                              continue
                             else
                             end
                            end
                           end
                          elseif image(y+2,x+2) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-2,x+-2) < c_b 
                          continue
                         else
                          if image(y+-4,x+1) > cb 
                          elseif image(y+-4,x+1) < c_b 
                           continue
                          else
                           if image(y+-1,x+4) > cb 
                           elseif image(y+-1,x+4) < c_b 
                            continue
                           else
                            if image(y+1,x+-3) > cb 
                            else
                             continue
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+2,x+1) < c_b 
                    continue
                   else
                    if image(y+-2,x+1) > cb 
                     if image(y+-3,x+1) > cb 
                      if image(y+3,x+1) > cb 
                      elseif image(y+3,x+1) < c_b 
                       continue
                      else
                       if image(y+-1,x+-2) > cb 
                       elseif image(y+-1,x+-2) < c_b 
                        continue
                       else
                        if image(y+-1,x+3) > cb 
                        elseif image(y+-1,x+3) < c_b 
                         continue
                        else
                         if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      end
                     elseif image(y+-3,x+1) < c_b 
                      continue
                     else
                      if image(y+-4,x+-1) > cb 
                       if image(y+0,x+4) > cb 
                        if image(y+-1,x+2) > cb 
                         if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                          continue
                         else
                         end
                        elseif image(y+-1,x+2) < c_b 
                         continue
                        else
                        end
                       else
                        continue
                       end
                      elseif image(y+-4,x+-1) < c_b 
                       continue
                      else
                      end
                     end
                    elseif image(y+-2,x+1) < c_b 
                    else
                     if image(y+-3,x+1) > cb 
                      if image(y+-1,x+-2) > cb 
                       if image(y+-1,x+3) > cb 
                        if image(y+1,x+-2) > cb 
                        elseif image(y+1,x+-2) < c_b 
                         continue
                        else
                         if image(y+-1,x+2) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+-1,x+3) < c_b 
                        if image(y+0,x+4) < c_b
                        else
                         continue
                        end
                       else
                       end
                      elseif image(y+-1,x+-2) < c_b 
                       continue
                      else
                       if image(y+-2,x+-2) > cb 
                        if image(y+1,x+2) > cb 
                         if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                          continue
                         else
                          if image(y+-2,x+-3) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+1,x+2) < c_b 
                         continue
                        else
                         if image(y+2,x+-1) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+-2,x+-2) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+-3,x+1) < c_b 
                      continue
                     else
                      if image(y+1,x+-2) > cb 
                       if image(y+-1,x+4) > cb 
                       elseif image(y+-1,x+4) < c_b 
                        continue
                       else
                        if image(y+2,x+0) > cb 
                        else
                         continue
                        end
                       end
                      elseif image(y+1,x+-2) < c_b 
                       continue
                      else
                       if image(y+1,x+2) > cb 
                        if image(y+1,x+-3) > cb 
                         if image(y+-1,x+4) > cb 
                          if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                           continue
                          else
                           if image(y+-1,x+2) > cb 
                           else
                            continue
                           end
                          end
                         elseif image(y+-1,x+4) < c_b 
                          continue
                         else
                          if image(y+4,x+0) > cb 
                           if image(y+0,x+-2) > cb | image(y+0,x+-2) < c_b 
                            continue
                           else
                           end
                          else
                           continue
                          end
                         end
                        elseif image(y+1,x+-3) < c_b 
                         continue
                        else
                         if image(y+4,x+1) > cb 
                         elseif image(y+4,x+1) < c_b 
                          continue
                         else
                          if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+1,x+2) < c_b 
                        continue
                       else
                        if image(y+0,x+2) > cb 
                         if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                          continue
                         else
                         end
                        elseif image(y+0,x+2) < c_b 
                        else
                         if image(y+2,x+-1) > cb 
                          if image(y+0,x+-3) > cb 
                          elseif image(y+0,x+-3) < c_b 
                           continue
                          else
                           if image(y+1,x+4) > cb | image(y+1,x+4) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+2,x+-1) < c_b 
                          continue
                         else
                          if image(y+2,x+0) > cb 
                           if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                            continue
                           else
                           end
                          elseif image(y+2,x+0) < c_b 
                          else
                           if image(y+-2,x+-2) > cb 
                            if image(y+-4,x+0) > cb 
                             if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                              continue
                             else
                             end
                            elseif image(y+-4,x+0) < c_b 
                             continue
                            else
                             if image(y+-3,x+0) > cb 
                              if image(y+2,x+2) > cb 
                              elseif image(y+2,x+2) < c_b 
                               continue
                              else
                               if image(y+-3,x+2) > cb 
                                if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                                 continue
                                else
                                end
                               else
                                continue
                               end
                              end
                             elseif image(y+-3,x+0) < c_b 
                              continue
                             else
                              if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                               continue
                              else
                               if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                                continue
                               else
                               end
                              end
                             end
                            end
                           elseif image(y+-2,x+-2) < c_b 
                            continue
                           else
                            if image(y+0,x+-4) > cb 
                            else
                             continue
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+3,x+-1) < c_b 
                   continue
                  else
                   if image(y+1,x+-3) > cb 
                   elseif image(y+1,x+-3) < c_b 
                    continue
                   else
                    if image(y+-2,x+0) > cb 
                     if image(y+-1,x+-2) > cb 
                      if image(y+3,x+1) > cb 
                      elseif image(y+3,x+1) < c_b 
                       continue
                      else
                       if image(y+-2,x+1) > cb 
                       elseif image(y+-2,x+1) < c_b 
                        continue
                       else
                        if image(y+-4,x+1) > cb 
                         if image(y+-1,x+3) > cb 
                          if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-1,x+3) < c_b 
                          continue
                         else
                         end
                        else
                         continue
                        end
                       end
                      end
                     elseif image(y+-1,x+-2) < c_b 
                      continue
                     else
                      if image(y+-2,x+1) > cb 
                       if image(y+-1,x+-4) > cb 
                       elseif image(y+-1,x+-4) < c_b 
                        continue
                       else
                        if image(y+-3,x+2) > cb 
                         if image(y+-3,x+0) > cb 
                          if image(y+2,x+2) > cb 
                          else
                           continue
                          end
                         else
                          continue
                         end
                        elseif image(y+-3,x+2) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+-2,x+1) < c_b 
                       continue
                      else
                       if image(y+1,x+2) > cb 
                        if image(y+-2,x+-2) > cb 
                        elseif image(y+-2,x+-2) < c_b 
                         continue
                        else
                         if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+1,x+2) < c_b 
                        continue
                       else
                        if image(y+-1,x+2) > cb 
                        else
                         continue
                        end
                       end
                      end
                     end
                    elseif image(y+-2,x+0) < c_b 
                     continue
                    else
                     if image(y+0,x+3) > cb 
                      if image(y+-2,x+-3) > cb 
                       if image(y+1,x+2) > cb 
                        if image(y+-1,x+3) > cb 
                        elseif image(y+-1,x+3) < c_b 
                         continue
                        else
                         if image(y+3,x+-2) > cb 
                          if image(y+0,x+-2) > cb 
                          else
                           continue
                          end
                         elseif image(y+3,x+-2) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+1,x+2) < c_b 
                        continue
                       else
                        if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+-2,x+-3) < c_b 
                       continue
                      else
                      end
                     elseif image(y+0,x+3) < c_b 
                      continue
                     else
                      if image(y+-1,x+-2) > cb 
                       if image(y+-3,x+1) > cb 
                        if image(y+-1,x+3) > cb 
                         if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                          continue
                         else
                         end
                        elseif image(y+-1,x+3) < c_b 
                         continue
                        else
                        end
                       elseif image(y+-3,x+1) < c_b 
                        continue
                       else
                        if image(y+-3,x+2) > cb 
                        elseif image(y+-3,x+2) < c_b 
                         continue
                        else
                         if image(y+-1,x+-4) > cb 
                          if image(y+-4,x+0) > cb 
                           if image(y+1,x+2) > cb 
                           else
                            continue
                           end
                          elseif image(y+-4,x+0) < c_b 
                           continue
                          else
                           if image(y+-3,x+0) > cb 
                           elseif image(y+-3,x+0) < c_b 
                            continue
                           else
                            if image(y+-2,x+3) > cb 
                            else
                             continue
                            end
                           end
                          end
                         elseif image(y+-1,x+-4) < c_b 
                          continue
                         else
                          if image(y+-1,x+-3) > cb 
                          else
                           continue
                          end
                         end
                        end
                       end
                      elseif image(y+-1,x+-2) < c_b 
                       continue
                      else
                       if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                        continue
                       else
                        if image(y+-1,x+4) > cb 
                        elseif image(y+-1,x+4) < c_b 
                         continue
                        else
                         if image(y+1,x+2) > cb 
                          if image(y+1,x+3) > cb | image(y+1,x+3) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  end
                 end
                elseif image(y+3,x+2) < c_b 
                 if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                 else
                  if image(y+2,x+2) > cb 
                   continue
                  elseif image(y+2,x+2) < c_b 
                  else
                   if image(y+-3,x+2) > cb 
                   else
                    continue
                   end
                  end
                 end
                else
                 if image(y+-4,x+1) > cb 
                  if image(y+2,x+-1) > cb 
                   if image(y+-2,x+3) > cb 
                    if image(y+-3,x+2) > cb 
                     if image(y+-2,x+-2) > cb 
                      if image(y+0,x+-2) > cb 
                      elseif image(y+0,x+-2) < c_b 
                       continue
                      else
                       if image(y+-3,x+1) > cb 
                       elseif image(y+-3,x+1) < c_b 
                        continue
                       else
                        if image(y+3,x+0) > cb 
                        else
                         continue
                        end
                       end
                      end
                     elseif image(y+-2,x+-2) < c_b 
                      continue
                     else
                      if image(y+0,x+-3) > cb 
                      else
                       continue
                      end
                     end
                    elseif image(y+-3,x+2) < c_b 
                     continue
                    else
                     if image(y+-2,x+0) > cb 
                      if image(y+-2,x+1) > cb 
                      elseif image(y+-2,x+1) < c_b 
                       continue
                      else
                       if image(y+1,x+2) > cb 
                       elseif image(y+1,x+2) < c_b 
                        continue
                       else
                        if image(y+-1,x+-2) > cb 
                         if image(y+1,x+3) > cb 
                          if image(y+-1,x+2) > cb 
                          elseif image(y+-1,x+2) < c_b 
                           continue
                          else
                           if image(y+1,x+-2) > cb | image(y+1,x+-2) < c_b 
                            continue
                           else
                            if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                             continue
                            else
                            end
                           end
                          end
                         elseif image(y+1,x+3) < c_b 
                          continue
                         else
                          if image(y+1,x+-2) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+-1,x+-2) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     elseif image(y+-2,x+0) < c_b 
                      continue
                     else
                      if image(y+0,x+2) > cb 
                       if image(y+1,x+2) > cb 
                       elseif image(y+1,x+2) < c_b 
                        continue
                       else
                        if image(y+-1,x+2) > cb 
                        else
                         continue
                        end
                       end
                      elseif image(y+0,x+2) < c_b 
                       continue
                      else
                      end
                     end
                    end
                   elseif image(y+-2,x+3) < c_b 
                    if image(y+2,x+1) > cb 
                    elseif image(y+2,x+1) < c_b 
                     continue
                    else
                     if image(y+4,x+1) > cb 
                     elseif image(y+4,x+1) < c_b 
                      continue
                     else
                      if image(y+-1,x+-4) > cb 
                       if image(y+-1,x+3) > cb 
                        continue
                       elseif image(y+-1,x+3) < c_b 
                        if image(y+0,x+-2) > cb | image(y+0,x+-2) < c_b 
                         continue
                        else
                        end
                       else
                       end
                      elseif image(y+-1,x+-4) < c_b 
                      else
                       if image(y+-3,x+1) > cb 
                       else
                        continue
                       end
                      end
                     end
                    end
                   else
                    if image(y+1,x+4) > cb 
                     if image(y+-4,x+-1) > cb 
                      if image(y+0,x+2) < c_b
                       if image(y+3,x+0) > cb 
                       elseif image(y+3,x+0) < c_b 
                        continue
                       else
                        if image(y+-3,x+1) > cb 
                        else
                         continue
                        end
                       end
                      else
                      end
                     elseif image(y+-4,x+-1) < c_b 
                      continue
                     else
                      if image(y+-3,x+1) > cb 
                      elseif image(y+-3,x+1) < c_b 
                       continue
                      else
                       if image(y+0,x+3) > cb 
                       elseif image(y+0,x+3) < c_b 
                        continue
                       else
                        if image(y+-4,x+0) > cb 
                         if image(y+-2,x+-3) > cb 
                         else
                          continue
                         end
                        else
                         continue
                        end
                       end
                      end
                     end
                    elseif image(y+1,x+4) < c_b 
                     continue
                    else
                     if image(y+2,x+0) > cb 
                      if image(y+-2,x+-2) > cb 
                      elseif image(y+-2,x+-2) < c_b 
                       continue
                      else
                       if image(y+4,x+1) > cb 
                        if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                         continue
                        else
                        end
                       elseif image(y+4,x+1) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+2,x+0) < c_b 
                      continue
                     else
                      if image(y+1,x+-4) > cb 
                       if image(y+-1,x+-2) > cb 
                       elseif image(y+-1,x+-2) < c_b 
                        continue
                       else
                        if image(y+-3,x+2) > cb 
                        elseif image(y+-3,x+2) < c_b 
                         continue
                        else
                         if image(y+1,x+-2) > cb 
                          if image(y+-3,x+1) > cb 
                           if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-3,x+1) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        end
                       end
                      elseif image(y+1,x+-4) < c_b 
                       continue
                      else
                       if image(y+3,x+0) > cb 
                       elseif image(y+3,x+0) < c_b 
                        continue
                       else
                        if image(y+-4,x+-1) > cb 
                         if image(y+-3,x+1) > cb 
                          if image(y+-2,x+0) > cb 
                           if image(y+0,x+3) > cb | image(y+0,x+3) < c_b 
                            continue
                           else
                           end
                          else
                           continue
                          end
                         else
                          continue
                         end
                        elseif image(y+-4,x+-1) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+2,x+-1) < c_b 
                  else
                   if image(y+4,x+1) > cb 
                    if image(y+1,x+-2) > cb 
                     if image(y+-4,x+0) > cb 
                     elseif image(y+-4,x+0) < c_b 
                      continue
                     else
                      if image(y+-3,x+2) > cb 
                      elseif image(y+-3,x+2) < c_b 
                       continue
                      else
                       if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    elseif image(y+1,x+-2) < c_b 
                     continue
                    else
                     if image(y+-1,x+3) > cb | image(y+-1,x+3) < c_b 
                     else
                      if image(y+-2,x+-3) > cb 
                       if image(y+4,x+0) > cb 
                        if image(y+0,x+3) > cb 
                         if image(y+1,x+-4) > cb 
                          if image(y+-1,x+-2) > cb 
                           if image(y+-3,x+1) > cb 
                           elseif image(y+-3,x+1) < c_b 
                            continue
                           else
                            if image(y+2,x+1) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+-1,x+-2) < c_b 
                           continue
                          else
                           if image(y+0,x+-3) > cb 
                            if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                             continue
                            else
                            end
                           elseif image(y+0,x+-3) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+1,x+-4) < c_b 
                          continue
                         else
                         end
                        elseif image(y+0,x+3) < c_b 
                         continue
                        else
                         if image(y+-2,x+-2) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+4,x+0) < c_b 
                        continue
                       else
                        if image(y+-3,x+1) > cb 
                        else
                         continue
                        end
                       end
                      elseif image(y+-2,x+-3) < c_b 
                       continue
                      else
                       if image(y+-3,x+2) > cb 
                        if image(y+-2,x+3) > cb 
                         if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                          continue
                         else
                         end
                        elseif image(y+-2,x+3) < c_b 
                         continue
                        else
                        end
                       elseif image(y+-3,x+2) < c_b 
                        continue
                       else
                        if image(y+0,x+-2) > cb 
                        else
                         continue
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+4,x+1) < c_b 
                   else
                    if image(y+-2,x+1) > cb 
                     if image(y+1,x+3) > cb 
                      if image(y+-3,x+1) > cb 
                      elseif image(y+-3,x+1) < c_b 
                       continue
                      else
                       if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+1,x+3) < c_b 
                      continue
                     else
                      if image(y+-1,x+-2) > cb 
                      elseif image(y+-1,x+-2) < c_b 
                       continue
                      else
                       if image(y+-1,x+-4) > cb 
                        if image(y+-1,x+4) > cb 
                         if image(y+1,x+-2) > cb 
                         else
                          continue
                         end
                        elseif image(y+-1,x+4) < c_b 
                         continue
                        else
                        end
                       else
                        continue
                       end
                      end
                     end
                    elseif image(y+-2,x+1) < c_b 
                     continue
                    else
                     if image(y+-1,x+-2) > cb 
                      if image(y+-3,x+1) > cb 
                       if image(y+-1,x+3) > cb 
                        if image(y+1,x+2) > cb 
                        elseif image(y+1,x+2) < c_b 
                         continue
                        else
                         if image(y+1,x+-2) > cb 
                          if image(y+-2,x+3) > cb 
                           if image(y+0,x+3) > cb 
                            if image(y+1,x+3) > cb 
                             if image(y+2,x+2) > cb 
                             else
                              continue
                             end
                            elseif image(y+1,x+3) < c_b 
                             continue
                            else
                            end
                           elseif image(y+0,x+3) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-2,x+3) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        end
                       else
                       end
                      elseif image(y+-3,x+1) < c_b 
                       continue
                      else
                       if image(y+1,x+2) > cb 
                        if image(y+0,x+-2) > cb 
                        elseif image(y+0,x+-2) < c_b 
                         continue
                        else
                         if image(y+2,x+-2) > cb 
                         elseif image(y+2,x+-2) < c_b 
                          continue
                         else
                          if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+1,x+2) < c_b 
                        continue
                       else
                        if image(y+-1,x+4) > cb 
                         if image(y+1,x+-2) > cb 
                          if image(y+-2,x+3) > cb 
                           if image(y+-3,x+0) > cb 
                            if image(y+-2,x+-3) > cb 
                             if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                              continue
                             else
                              if image(y+-3,x+2) > cb 
                               if image(y+2,x+-2) > cb | image(y+2,x+-2) < c_b 
                                continue
                               else
                               end
                              elseif image(y+-3,x+2) < c_b 
                               continue
                              else
                              end
                             end
                            elseif image(y+-2,x+-3) < c_b 
                             continue
                            else
                            end
                           else
                            continue
                           end
                          elseif image(y+-2,x+3) < c_b 
                           continue
                          else
                          end
                         elseif image(y+1,x+-2) < c_b 
                          continue
                         else
                          if image(y+3,x+0) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+-1,x+4) < c_b 
                        else
                         if image(y+2,x+1) > cb 
                         elseif image(y+2,x+1) < c_b 
                          continue
                         else
                          if image(y+-4,x+-1) > cb 
                           if image(y+0,x+2) > cb 
                            if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                             continue
                            else
                            end
                           else
                            continue
                           end
                          elseif image(y+-4,x+-1) < c_b 
                           continue
                          else
                           if image(y+-3,x+0) > cb 
                           else
                            continue
                           end
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+-1,x+-2) < c_b 
                      continue
                     else
                      if image(y+1,x+2) > cb 
                       if image(y+1,x+-4) > cb 
                        if image(y+-2,x+-3) > cb 
                         if image(y+1,x+4) > cb 
                          if image(y+3,x+-1) > cb 
                          elseif image(y+3,x+-1) < c_b 
                           continue
                          else
                           if image(y+-1,x+-4) > cb 
                            if image(y+-3,x+1) > cb 
                            elseif image(y+-3,x+1) < c_b 
                             continue
                            else
                             if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                              continue
                             else
                             end
                            end
                           else
                            continue
                           end
                          end
                         else
                          continue
                         end
                        elseif image(y+-2,x+-3) < c_b 
                         continue
                        else
                         if image(y+-1,x+2) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+1,x+-4) < c_b 
                        continue
                       else
                       end
                      elseif image(y+1,x+2) < c_b 
                       continue
                      else
                       if image(y+-1,x+2) > cb 
                        if image(y+-2,x+3) > cb 
                        else
                         continue
                        end
                       elseif image(y+-1,x+2) < c_b 
                        continue
                       else
                        if image(y+1,x+-2) > cb 
                         if image(y+-1,x+4) > cb 
                          if image(y+0,x+-3) > cb 
                          else
                           continue
                          end
                         elseif image(y+-1,x+4) < c_b 
                          continue
                         else
                          if image(y+0,x+-3) > cb | image(y+0,x+-3) < c_b 
                           continue
                          else
                          end
                         end
                        else
                         continue
                        end
                       end
                      end
                     end
                    end
                   end
                  end
                 elseif image(y+-4,x+1) < c_b 
                  if image(y+-4,x+-1) > cb 
                   if image(y+3,x+1) > cb 
                    if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                     continue
                    else
                    end
                   elseif image(y+3,x+1) < c_b 
                    continue
                   else
                    if image(y+-2,x+3) > cb 
                     if image(y+4,x+1) > cb 
                     elseif image(y+4,x+1) < c_b 
                      continue
                     else
                      if image(y+1,x+2) > cb 
                      elseif image(y+1,x+2) < c_b 
                       continue
                      else
                       if image(y+2,x+2) > cb 
                       else
                        continue
                       end
                      end
                     end
                    elseif image(y+-2,x+3) < c_b 
                     continue
                    else
                     if image(y+-1,x+4) > cb 
                     elseif image(y+-1,x+4) < c_b 
                      continue
                     else
                      if image(y+-3,x+1) > cb 
                       continue
                      elseif image(y+-3,x+1) < c_b 
                       if image(y+-2,x+1) < c_b
                        if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                         continue
                        else
                        end
                       else
                        continue
                       end
                      else
                      end
                     end
                    end
                   end
                  elseif image(y+-4,x+-1) < c_b 
                  else
                   if image(y+-1,x+4) > cb 
                    if image(y+2,x+0) > cb 
                     if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                      continue
                     else
                     end
                    elseif image(y+2,x+0) < c_b 
                     continue
                    else
                    end
                   elseif image(y+-1,x+4) < c_b 
                    continue
                   else
                    if image(y+3,x+0) > cb | image(y+3,x+0) < c_b 
                     continue
                    else
                     if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                      continue
                     else
                     end
                    end
                   end
                  end
                 else
                  if image(y+4,x+1) > cb 
                   if image(y+-1,x+2) > cb 
                   elseif image(y+-1,x+2) < c_b 
                    continue
                   else
                    if image(y+-1,x+-2) > cb 
                     if image(y+-2,x+0) > cb 
                     elseif image(y+-2,x+0) < c_b 
                      continue
                     else
                      if image(y+-2,x+3) > cb 
                       if image(y+2,x+0) > cb 
                        if image(y+2,x+1) > cb 
                        elseif image(y+2,x+1) < c_b 
                         continue
                        else
                         if image(y+-4,x+-1) > cb 
                          if image(y+-3,x+1) > cb 
                          elseif image(y+-3,x+1) < c_b 
                           continue
                          else
                           if image(y+0,x+-2) > cb 
                            if image(y+1,x+2) > cb 
                            elseif image(y+1,x+2) < c_b 
                             continue
                            else
                             if image(y+2,x+2) > cb 
                             else
                              continue
                             end
                            end
                           elseif image(y+0,x+-2) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+-4,x+-1) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+2,x+0) < c_b 
                        continue
                       else
                        if image(y+0,x+2) > cb 
                         if image(y+1,x+2) > cb 
                         else
                          continue
                         end
                        elseif image(y+0,x+2) < c_b 
                         continue
                        else
                         if image(y+3,x+-2) > cb 
                         elseif image(y+3,x+-2) < c_b 
                          continue
                         else
                          if image(y+2,x+-1) > cb | image(y+2,x+-1) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       end
                      elseif image(y+-2,x+3) < c_b 
                       continue
                      else
                       if image(y+-3,x+-1) > cb 
                        if image(y+1,x+-2) > cb 
                        elseif image(y+1,x+-2) < c_b 
                         continue
                        else
                         if image(y+0,x+3) > cb 
                          if image(y+-1,x+3) > cb 
                          elseif image(y+-1,x+3) < c_b 
                           continue
                          else
                           if image(y+2,x+-2) > cb 
                           elseif image(y+2,x+-2) < c_b 
                            continue
                           else
                            if image(y+2,x+1) > cb 
                            else
                             continue
                            end
                           end
                          end
                         elseif image(y+0,x+3) < c_b 
                          continue
                         else
                          if image(y+0,x+-4) > cb 
                          elseif image(y+0,x+-4) < c_b 
                           continue
                          else
                           if image(y+1,x+-4) > cb 
                            if image(y+-3,x+0) > cb 
                            else
                             continue
                            end
                           elseif image(y+1,x+-4) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        end
                       elseif image(y+-3,x+-1) < c_b 
                        continue
                       else
                        if image(y+0,x+4) > cb 
                        elseif image(y+0,x+4) < c_b 
                         continue
                        else
                         if image(y+1,x+2) > cb 
                         elseif image(y+1,x+2) < c_b 
                          continue
                         else
                          if image(y+1,x+4) > cb | image(y+1,x+4) < c_b 
                           continue
                          else
                           if image(y+-1,x+-4) > cb 
                           else
                            continue
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+-1,x+-2) < c_b 
                     continue
                    else
                     if image(y+-3,x+-1) > cb 
                      if image(y+1,x+2) > cb 
                      elseif image(y+1,x+2) < c_b 
                       continue
                      else
                       if image(y+-4,x+-1) > cb 
                        if image(y+2,x+0) > cb 
                         if image(y+1,x+4) > cb 
                          if image(y+-2,x+0) > cb 
                           if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-2,x+0) < c_b 
                           continue
                          else
                           if image(y+0,x+-2) > cb 
                            if image(y+-1,x+-4) > cb 
                            else
                             continue
                            end
                           else
                            continue
                           end
                          end
                         elseif image(y+1,x+4) < c_b 
                          continue
                         else
                          if image(y+2,x+2) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+2,x+0) < c_b 
                         continue
                        else
                         if image(y+1,x+-2) > cb 
                         elseif image(y+1,x+-2) < c_b 
                          continue
                         else
                          if image(y+3,x+-1) > cb 
                           if image(y+1,x+4) > cb 
                            if image(y+-3,x+1) > cb 
                             if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                              continue
                             else
                             end
                            elseif image(y+-3,x+1) < c_b 
                             continue
                            else
                             if image(y+4,x+0) > cb 
                             else
                              continue
                             end
                            end
                           elseif image(y+1,x+4) < c_b 
                            continue
                           else
                            if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                             continue
                            else
                            end
                           end
                          elseif image(y+3,x+-1) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+-4,x+-1) < c_b 
                        continue
                       else
                        if image(y+3,x+-2) > cb 
                        else
                         continue
                        end
                       end
                      end
                     elseif image(y+-3,x+-1) < c_b 
                      continue
                     else
                      if image(y+-1,x+4) > cb 
                      elseif image(y+-1,x+4) < c_b 
                       continue
                      else
                       if image(y+0,x+2) > cb 
                       else
                        continue
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+4,x+1) < c_b 
                   if image(y+-2,x+3) > cb 
                    if image(y+-4,x+-1) > cb 
                     if image(y+1,x+2) > cb 
                     elseif image(y+1,x+2) < c_b 
                      continue
                     else
                      if image(y+-3,x+2) > cb 
                      else
                       continue
                      end
                     end
                    elseif image(y+-4,x+-1) < c_b 
                     continue
                    else
                    end
                   elseif image(y+-2,x+3) < c_b 
                    continue
                   else
                    if image(y+-1,x+4) > cb 
                    elseif image(y+-1,x+4) < c_b 
                     continue
                    else
                     if image(y+1,x+3) > cb 
                      if image(y+-3,x+1) < c_b
                       continue
                      else
                      end
                     else
                      continue
                     end
                    end
                   end
                  else
                   if image(y+-4,x+-1) > cb 
                    if image(y+-1,x+3) > cb 
                     if image(y+-3,x+2) > cb 
                      if image(y+2,x+-1) > cb 
                       if image(y+-2,x+-2) > cb 
                       else
                        continue
                       end
                      elseif image(y+2,x+-1) < c_b 
                       continue
                      else
                       if image(y+1,x+2) > cb 
                       elseif image(y+1,x+2) < c_b 
                        continue
                       else
                        if image(y+-1,x+2) > cb 
                        else
                         continue
                        end
                       end
                      end
                     elseif image(y+-3,x+2) < c_b 
                     else
                      if image(y+-2,x+3) > cb 
                       if image(y+1,x+2) > cb 
                        if image(y+2,x+-2) > cb 
                        elseif image(y+2,x+-2) < c_b 
                         continue
                        else
                         if image(y+-4,x+0) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+1,x+2) < c_b 
                        continue
                       else
                        if image(y+1,x+3) > cb 
                         if image(y+-1,x+2) > cb 
                         elseif image(y+-1,x+2) < c_b 
                          continue
                         else
                          if image(y+2,x+2) > cb 
                           if image(y+1,x+-4) > cb 
                           else
                            continue
                           end
                          elseif image(y+2,x+2) < c_b 
                           continue
                          else
                           if image(y+0,x+-3) > cb 
                            if image(y+-2,x+1) > cb 
                            elseif image(y+-2,x+1) < c_b 
                             continue
                            else
                             if image(y+2,x+1) > cb 
                             elseif image(y+2,x+1) < c_b 
                              continue
                             else
                              if image(y+-2,x+-2) > cb 
                               if image(y+2,x+-2) > cb | image(y+2,x+-2) < c_b 
                                continue
                               else
                                if image(y+2,x+-1) > cb 
                                else
                                 continue
                                end
                               end
                              elseif image(y+-2,x+-2) < c_b 
                               continue
                              else
                               if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                                continue
                               else
                               end
                              end
                             end
                            end
                           elseif image(y+0,x+-3) < c_b 
                            continue
                           else
                            if image(y+2,x+0) > cb 
                             if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                              continue
                             else
                             end
                            elseif image(y+2,x+0) < c_b 
                             continue
                            else
                             if image(y+-2,x+0) > cb 
                              if image(y+2,x+-1) > cb 
                               if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                                continue
                               else
                               end
                              else
                               continue
                              end
                             else
                              continue
                             end
                            end
                           end
                          end
                         end
                        elseif image(y+1,x+3) < c_b 
                         continue
                        else
                         if image(y+-2,x+-3) > cb 
                          if image(y+4,x+0) > cb 
                           if image(y+2,x+0) > cb 
                            if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                             continue
                            else
                            end
                           elseif image(y+2,x+0) < c_b 
                           else
                            continue
                           end
                          elseif image(y+4,x+0) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-2,x+-3) < c_b 
                          continue
                         else
                          if image(y+2,x+-1) > cb 
                          else
                           continue
                          end
                         end
                        end
                       end
                      elseif image(y+-2,x+3) < c_b 
                       continue
                      else
                       if image(y+1,x+4) > cb 
                        if image(y+1,x+-2) > cb 
                         if image(y+-1,x+4) > cb 
                         elseif image(y+-1,x+4) < c_b 
                          continue
                         else
                          if image(y+0,x+2) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+1,x+-2) < c_b 
                         continue
                        else
                         if image(y+2,x+-2) > cb 
                          if image(y+-2,x+0) > cb 
                          elseif image(y+-2,x+0) < c_b 
                           continue
                          else
                           if image(y+1,x+2) > cb 
                            if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                             continue
                            else
                            end
                           else
                            continue
                           end
                          end
                         else
                          continue
                         end
                        end
                       elseif image(y+1,x+4) < c_b 
                        continue
                       else
                        if image(y+1,x+2) > cb 
                         if image(y+2,x+-2) > cb 
                         elseif image(y+2,x+-2) < c_b 
                          continue
                         else
                          if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+1,x+2) < c_b 
                         continue
                        else
                         if image(y+-2,x+1) > cb 
                         else
                          continue
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+-1,x+3) < c_b 
                    else
                     if image(y+-1,x+4) > cb 
                      if image(y+1,x+-2) > cb 
                       if image(y+1,x+4) > cb 
                        if image(y+-2,x+-2) > cb 
                        else
                         continue
                        end
                       elseif image(y+1,x+4) < c_b 
                        continue
                       else
                        if image(y+-2,x+3) > cb 
                        elseif image(y+-2,x+3) < c_b 
                         continue
                        else
                         if image(y+1,x+2) > cb 
                         elseif image(y+1,x+2) < c_b 
                          continue
                         else
                          if image(y+-4,x+0) > cb 
                           if image(y+2,x+-1) > cb 
                           else
                            continue
                           end
                          else
                           continue
                          end
                         end
                        end
                       end
                      elseif image(y+1,x+-2) < c_b 
                       continue
                      else
                       if image(y+1,x+2) > cb 
                       elseif image(y+1,x+2) < c_b 
                        continue
                       else
                        if image(y+-2,x+0) > cb 
                         if image(y+2,x+-2) > cb 
                         elseif image(y+2,x+-2) < c_b 
                          continue
                         else
                          if image(y+-3,x+1) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+-2,x+0) < c_b 
                         continue
                        else
                         if image(y+2,x+-1) > cb 
                          if image(y+0,x+-4) > cb 
                           if image(y+1,x+3) > cb 
                           else
                            continue
                           end
                          elseif image(y+0,x+-4) < c_b 
                          else
                           continue
                          end
                         else
                          continue
                         end
                        end
                       end
                      end
                     elseif image(y+-1,x+4) < c_b 
                      if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                       continue
                      else
                      end
                     else
                      if image(y+2,x+0) > cb 
                       if image(y+-3,x+1) > cb 
                       elseif image(y+-3,x+1) < c_b 
                        continue
                       else
                        if image(y+-1,x+-2) > cb 
                        elseif image(y+-1,x+-2) < c_b 
                         continue
                        else
                         if image(y+1,x+-4) > cb 
                          if image(y+-2,x+0) > cb 
                          else
                           continue
                          end
                         elseif image(y+1,x+-4) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      elseif image(y+2,x+0) < c_b 
                       if image(y+-2,x+0) > cb 
                       else
                        continue
                       end
                      else
                       if image(y+1,x+2) > cb 
                        if image(y+1,x+-2) > cb 
                        elseif image(y+1,x+-2) < c_b 
                         continue
                        else
                         if image(y+1,x+4) > cb 
                         elseif image(y+1,x+4) < c_b 
                          continue
                         else
                          if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+1,x+2) < c_b 
                       else
                        if image(y+-2,x+3) > cb 
                         if image(y+-4,x+0) > cb 
                          if image(y+1,x+-4) > cb 
                          else
                           continue
                          end
                         elseif image(y+-4,x+0) < c_b 
                          continue
                         else
                         end
                        elseif image(y+-2,x+3) < c_b 
                         if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                          continue
                         else
                         end
                        else
                         if image(y+-3,x+0) > cb 
                          if image(y+2,x+-1) > cb 
                           if image(y+-1,x+-2) > cb 
                            if image(y+-1,x+-4) > cb 
                            elseif image(y+-1,x+-4) < c_b 
                             continue
                            else
                             if image(y+-2,x+0) > cb 
                             elseif image(y+-2,x+0) < c_b 
                              continue
                             else
                              if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                               continue
                              else
                              end
                             end
                            end
                           else
                            continue
                           end
                          elseif image(y+2,x+-1) < c_b 
                           continue
                          else
                           if image(y+-4,x+0) > cb 
                            if image(y+-3,x+1) > cb 
                             if image(y+-1,x+-4) > cb 
                             elseif image(y+-1,x+-4) < c_b 
                              continue
                             else
                              if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                               continue
                              else
                              end
                             end
                            else
                             continue
                            end
                           elseif image(y+-4,x+0) < c_b 
                            continue
                           else
                            if image(y+-1,x+-2) > cb 
                            elseif image(y+-1,x+-2) < c_b 
                             continue
                            else
                             if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                              continue
                             else
                              if image(y+-2,x+-2) > cb 
                              elseif image(y+-2,x+-2) < c_b 
                               continue
                              else
                               if image(y+-1,x+2) > cb 
                               else
                                continue
                               end
                              end
                             end
                            end
                           end
                          end
                         elseif image(y+-3,x+0) < c_b 
                          continue
                         else
                          if image(y+-3,x+2) > cb 
                          elseif image(y+-3,x+2) < c_b 
                           continue
                          else
                           if image(y+-4,x+0) > cb 
                            if image(y+2,x+-1) > cb 
                             if image(y+-1,x+-4) > cb 
                             elseif image(y+-1,x+-4) < c_b 
                              continue
                             else
                              if image(y+-2,x+0) > cb 
                              else
                               continue
                              end
                             end
                            else
                             continue
                            end
                           elseif image(y+-4,x+0) < c_b 
                            continue
                           else
                            if image(y+-2,x+0) > cb 
                             if image(y+1,x+-2) > cb 
                              if image(y+1,x+4) > cb | image(y+1,x+4) < c_b 
                               continue
                              else
                              end
                             else
                              continue
                             end
                            elseif image(y+-2,x+0) < c_b 
                             continue
                            else
                             if image(y+-1,x+2) > cb 
                             elseif image(y+-1,x+2) < c_b 
                              continue
                             else
                              if image(y+3,x+1) < c_b
                              else
                               continue
                              end
                             end
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+-4,x+-1) < c_b 
                    continue
                   else
                    if image(y+2,x+-1) > cb 
                     if image(y+-1,x+4) > cb 
                     elseif image(y+-1,x+4) < c_b 
                      if image(y+-1,x+2) > cb 
                       continue
                      elseif image(y+-1,x+2) < c_b 
                      else
                       if image(y+0,x+2) > cb 
                       else
                        continue
                       end
                      end
                     else
                      if image(y+2,x+0) > cb 
                       if image(y+-1,x+3) > cb 
                        if image(y+-2,x+3) > cb 
                        elseif image(y+-2,x+3) < c_b 
                         continue
                        else
                         if image(y+3,x+0) > cb | image(y+3,x+0) < c_b 
                          continue
                         else
                         end
                        end
                       else
                       end
                      elseif image(y+2,x+0) < c_b 
                       continue
                      else
                       if image(y+-2,x+3) > cb 
                       elseif image(y+-2,x+3) < c_b 
                        continue
                       else
                        if image(y+-3,x+2) > cb 
                        elseif image(y+-3,x+2) < c_b 
                         continue
                        else
                         if image(y+-2,x+0) > cb 
                          if image(y+4,x+0) > cb 
                          elseif image(y+4,x+0) < c_b 
                           continue
                          else
                           if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+-2,x+0) < c_b 
                          continue
                         else
                          if image(y+1,x+2) > cb 
                           if image(y+-2,x+-3) > cb 
                           else
                            continue
                           end
                          elseif image(y+1,x+2) < c_b 
                           continue
                          else
                           if image(y+2,x+1) > cb 
                           elseif image(y+2,x+1) < c_b 
                            continue
                           else
                            if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                            else
                             if image(y+-1,x+2) > cb 
                             elseif image(y+-1,x+2) < c_b 
                              continue
                             else
                              if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                               continue
                              else
                              end
                             end
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+2,x+-1) < c_b 
                     continue
                    else
                     if image(y+-2,x+3) > cb 
                      if image(y+1,x+2) > cb 
                       if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                        continue
                       else
                       end
                      elseif image(y+1,x+2) < c_b 
                       continue
                      else
                       if image(y+-1,x+3) > cb 
                        if image(y+-1,x+2) > cb 
                         if image(y+-3,x+-1) > cb 
                         else
                          continue
                         end
                        elseif image(y+-1,x+2) < c_b 
                         continue
                        else
                         if image(y+-2,x+0) > cb 
                          if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        end
                       elseif image(y+-1,x+3) < c_b 
                        continue
                       else
                        if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     elseif image(y+-2,x+3) < c_b 
                      if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                       continue
                      else
                      end
                     else
                      if image(y+-2,x+0) > cb 
                       if image(y+-3,x+0) > cb 
                       elseif image(y+-3,x+0) < c_b 
                        continue
                       else
                        if image(y+-2,x+-3) > cb 
                         if image(y+2,x+-2) > cb 
                         elseif image(y+2,x+-2) < c_b 
                          continue
                         else
                          if image(y+-1,x+-4) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+-2,x+-3) < c_b 
                         continue
                        else
                         if image(y+-1,x+2) > cb 
                          if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        end
                       end
                      elseif image(y+-2,x+0) < c_b 
                       continue
                      else
                       if image(y+1,x+-2) > cb 
                        if image(y+-1,x+4) > cb 
                        elseif image(y+-1,x+4) < c_b 
                         continue
                        else
                         if image(y+2,x+2) < c_b
                          continue
                         else
                          if image(y+-3,x+2) > cb 
                          elseif image(y+-3,x+2) < c_b 
                           continue
                          else
                           if image(y+2,x+-2) > cb | image(y+2,x+-2) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        end
                       elseif image(y+1,x+-2) < c_b 
                        continue
                       else
                        if image(y+3,x+1) > cb 
                        elseif image(y+3,x+1) < c_b 
                         continue
                        else
                         if image(y+-3,x+2) > cb 
                          if image(y+-1,x+-2) > cb 
                          else
                           continue
                          end
                         else
                          continue
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  end
                 end
                end
               elseif image(y+4,x+-1) < c_b 
                if image(y+1,x+-2) > cb 
                 if image(y+3,x+2) > cb 
                  if image(y+0,x+-4) > cb 
                   if image(y+0,x+4) > cb 
                   elseif image(y+0,x+4) < c_b 
                    continue
                   else
                    if image(y+-3,x+1) > cb 
                    elseif image(y+-3,x+1) < c_b 
                     continue
                    else
                     if image(y+2,x+0) < c_b
                      if image(y+-2,x+3) > cb 
                      else
                       continue
                      end
                     else
                     end
                    end
                   end
                  elseif image(y+0,x+-4) < c_b 
                   continue
                  else
                   if image(y+2,x+2) > cb 
                   elseif image(y+2,x+2) < c_b 
                    continue
                   else
                    if image(y+-1,x+2) > cb | image(y+-1,x+2) < c_b 
                    else
                     continue
                    end
                   end
                  end
                 elseif image(y+3,x+2) < c_b 
                  continue
                 else
                  if image(y+-3,x+1) > cb 
                   if image(y+1,x+2) < c_b
                    if image(y+-1,x+2) < c_b
                    else
                     continue
                    end
                   else
                   end
                  elseif image(y+-3,x+1) < c_b 
                  else
                   if image(y+4,x+0) > cb 
                    continue
                   elseif image(y+4,x+0) < c_b 
                    if image(y+0,x+4) > cb 
                    elseif image(y+0,x+4) < c_b 
                     continue
                    else
                     if image(y+-3,x+0) > cb 
                     elseif image(y+-3,x+0) < c_b 
                      continue
                     else
                      if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                       continue
                      else
                      end
                     end
                    end
                   else
                    if image(y+-2,x+3) > cb 
                     continue
                    elseif image(y+-2,x+3) < c_b 
                     if image(y+0,x+2) > cb 
                      continue
                     elseif image(y+0,x+2) < c_b 
                     else
                      if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                       continue
                      else
                      end
                     end
                    else
                     if image(y+2,x+0) > cb 
                     elseif image(y+2,x+0) < c_b 
                      continue
                     else
                      if image(y+-1,x+-2) > cb 
                      elseif image(y+-1,x+-2) < c_b 
                       continue
                      else
                       if image(y+-4,x+1) > cb 
                       else
                        continue
                       end
                      end
                     end
                    end
                   end
                  end
                 end
                elseif image(y+1,x+-2) < c_b 
                else
                 if image(y+3,x+2) > cb 
                  if image(y+0,x+2) > cb | image(y+0,x+2) < c_b 
                  else
                   if image(y+-4,x+0) > cb 
                    if image(y+-2,x+1) > cb 
                    elseif image(y+-2,x+1) < c_b 
                     continue
                    else
                     if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                      continue
                     else
                     end
                    end
                   elseif image(y+-4,x+0) < c_b 
                    continue
                   else
                   end
                  end
                 elseif image(y+3,x+2) < c_b 
                  continue
                 else
                  if image(y+-2,x+-2) > cb 
                   if image(y+-3,x+2) > cb 
                    if image(y+-1,x+-2) > cb 
                     if image(y+-1,x+3) > cb 
                      if image(y+-2,x+1) > cb 
                      else
                       continue
                      end
                     elseif image(y+-1,x+3) < c_b 
                      continue
                     else
                     end
                    else
                     continue
                    end
                   elseif image(y+-3,x+2) < c_b 
                   else
                    if image(y+2,x+0) > cb 
                    elseif image(y+2,x+0) < c_b 
                     if image(y+-3,x+1) > cb 
                     elseif image(y+-3,x+1) < c_b 
                      continue
                     else
                      if image(y+-1,x+2) > cb 
                       if image(y+-3,x+0) > cb 
                       else
                        continue
                       end
                      elseif image(y+-1,x+2) < c_b 
                      else
                       continue
                      end
                     end
                    else
                     if image(y+-1,x+2) > cb | image(y+-1,x+2) < c_b 
                      continue
                     else
                     end
                    end
                   end
                  else
                   continue
                  end
                 end
                end
               else
                if image(y+-4,x+-1) > cb 
                 if image(y+1,x+-3) > cb 
                  if image(y+-1,x+4) > cb 
                   if image(y+1,x+4) > cb 
                    if image(y+-2,x+-2) > cb 
                     if image(y+3,x+-1) > cb 
                      if image(y+3,x+2) > cb 
                       if image(y+2,x+-2) > cb 
                       elseif image(y+2,x+-2) < c_b 
                        continue
                       else
                        if image(y+-3,x+1) > cb 
                         if image(y+-1,x+2) > cb 
                         elseif image(y+-1,x+2) < c_b 
                          continue
                         else
                          if image(y+0,x+3) > cb | image(y+0,x+3) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+-3,x+1) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+3,x+2) < c_b 
                       continue
                      else
                      end
                     elseif image(y+3,x+-1) < c_b 
                      if image(y+0,x+3) > cb 
                      elseif image(y+0,x+3) < c_b 
                       continue
                      else
                       if image(y+1,x+-2) > cb 
                       elseif image(y+1,x+-2) < c_b 
                        continue
                       else
                        if image(y+-3,x+1) > cb 
                        else
                         continue
                        end
                       end
                      end
                     else
                     end
                    elseif image(y+-2,x+-2) < c_b 
                     continue
                    else
                     if image(y+0,x+-4) > cb 
                     elseif image(y+0,x+-4) < c_b 
                      continue
                     else
                      if image(y+2,x+2) > cb 
                      elseif image(y+2,x+2) < c_b 
                       continue
                      else
                       if image(y+3,x+2) > cb 
                        if image(y+4,x+1) > cb 
                        elseif image(y+4,x+1) < c_b 
                         continue
                        else
                         if image(y+2,x+-2) > cb | image(y+2,x+-2) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+3,x+2) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    end
                   elseif image(y+1,x+4) < c_b 
                    continue
                   else
                    if image(y+3,x+2) > cb 
                     if image(y+2,x+2) > cb 
                     elseif image(y+2,x+2) < c_b 
                      continue
                     else
                      if image(y+-1,x+-4) > cb 
                      elseif image(y+-1,x+-4) < c_b 
                       continue
                      else
                       if image(y+1,x+-4) > cb 
                        if image(y+-2,x+3) > cb 
                        elseif image(y+-2,x+3) < c_b 
                         continue
                        else
                         if image(y+0,x+2) > cb | image(y+0,x+2) < c_b 
                          continue
                         else
                          if image(y+0,x+3) > cb 
                          elseif image(y+0,x+3) < c_b 
                           continue
                          else
                           if image(y+0,x+-4) > cb 
                            if image(y+3,x+0) > cb 
                            elseif image(y+3,x+0) < c_b 
                             continue
                            else
                             if image(y+-4,x+0) > cb 
                              if image(y+0,x+4) > cb 
                               if image(y+-2,x+1) > cb 
                                if image(y+0,x+-2) > cb 
                                else
                                 continue
                                end
                               elseif image(y+-2,x+1) < c_b 
                                continue
                               else
                               end
                              else
                               continue
                              end
                             else
                              continue
                             end
                            end
                           elseif image(y+0,x+-4) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        end
                       elseif image(y+1,x+-4) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    elseif image(y+3,x+2) < c_b 
                     continue
                    else
                     if image(y+1,x+2) > cb 
                      if image(y+2,x+-2) > cb 
                      elseif image(y+2,x+-2) < c_b 
                       continue
                      else
                       if image(y+-1,x+2) > cb 
                       elseif image(y+-1,x+2) < c_b 
                        continue
                       else
                        if image(y+4,x+1) > cb 
                        elseif image(y+4,x+1) < c_b 
                         continue
                        else
                         if image(y+2,x+1) > cb 
                         elseif image(y+2,x+1) < c_b 
                          continue
                         else
                          if image(y+-4,x+1) < c_b
                          else
                           continue
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+1,x+2) < c_b 
                      continue
                     else
                     end
                    end
                   end
                  elseif image(y+-1,x+4) < c_b 
                  else
                   if image(y+3,x+-1) > cb 
                    if image(y+2,x+-2) > cb 
                     if image(y+2,x+2) > cb 
                     elseif image(y+2,x+2) < c_b 
                      continue
                     else
                      if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                      else
                       if image(y+3,x+2) > cb 
                        if image(y+-2,x+0) > cb 
                        elseif image(y+-2,x+0) < c_b 
                         continue
                        else
                         if image(y+-1,x+-2) > cb 
                          if image(y+-1,x+-4) > cb 
                          elseif image(y+-1,x+-4) < c_b 
                           continue
                          else
                           if image(y+-3,x+1) > cb 
                           elseif image(y+-3,x+1) < c_b 
                            continue
                           else
                            if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                             continue
                            else
                            end
                           end
                          end
                         elseif image(y+-1,x+-2) < c_b 
                          continue
                         else
                          if image(y+-3,x+1) > cb 
                           if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-3,x+1) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+3,x+2) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    elseif image(y+2,x+-2) < c_b 
                     continue
                    else
                     if image(y+0,x+-3) > cb 
                      if image(y+-3,x+1) > cb 
                      elseif image(y+-3,x+1) < c_b 
                       continue
                      else
                       if image(y+1,x+3) > cb 
                       elseif image(y+1,x+3) < c_b 
                        continue
                       else
                        if image(y+2,x+1) > cb 
                         if image(y+-4,x+1) > cb 
                         elseif image(y+-4,x+1) < c_b 
                          continue
                         else
                          if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                           continue
                          else
                          end
                         end
                        else
                         continue
                        end
                       end
                      end
                     elseif image(y+0,x+-3) < c_b 
                      continue
                     else
                      if image(y+-2,x+1) > cb 
                      elseif image(y+-2,x+1) < c_b 
                       continue
                      else
                       if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                        continue
                       else
                        if image(y+1,x+3) > cb | image(y+1,x+3) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+3,x+-1) < c_b 
                    if image(y+-3,x+1) > cb 
                     if image(y+0,x+-3) > cb 
                      if image(y+-2,x+3) > cb 
                       if image(y+-3,x+2) > cb 
                       else
                        continue
                       end
                      else
                      end
                     else
                      continue
                     end
                    elseif image(y+-3,x+1) < c_b 
                     continue
                    else
                     if image(y+3,x+2) > cb 
                      if image(y+0,x+2) > cb | image(y+0,x+2) < c_b 
                      else
                       continue
                      end
                     elseif image(y+3,x+2) < c_b 
                      continue
                     else
                     end
                    end
                   else
                    if image(y+-1,x+-4) > cb 
                     if image(y+1,x+2) > cb 
                      if image(y+3,x+2) > cb 
                      elseif image(y+3,x+2) < c_b 
                       continue
                      else
                       if image(y+1,x+4) > cb 
                       elseif image(y+1,x+4) < c_b 
                        continue
                       else
                        if image(y+2,x+-2) > cb 
                        elseif image(y+2,x+-2) < c_b 
                         continue
                        else
                         if image(y+-3,x+1) > cb 
                         elseif image(y+-3,x+1) < c_b 
                          continue
                         else
                          if image(y+2,x+1) > cb 
                          elseif image(y+2,x+1) < c_b 
                           continue
                          else
                           if image(y+4,x+0) > cb 
                           elseif image(y+4,x+0) < c_b 
                            continue
                           else
                            if image(y+-1,x+2) > cb 
                            else
                             continue
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+1,x+2) < c_b 
                      if image(y+-4,x+1) > cb 
                      else
                       continue
                      end
                     else
                     end
                    elseif image(y+-1,x+-4) < c_b 
                     if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                      continue
                     else
                     end
                    else
                     if image(y+1,x+3) > cb 
                      if image(y+0,x+-2) > cb 
                      elseif image(y+0,x+-2) < c_b 
                       continue
                      else
                       if image(y+1,x+4) > cb 
                       elseif image(y+1,x+4) < c_b 
                        continue
                       else
                        if image(y+3,x+2) > cb 
                        elseif image(y+3,x+2) < c_b 
                         continue
                        else
                         if image(y+1,x+2) > cb 
                          if image(y+-2,x+1) > cb 
                           if image(y+-3,x+2) > cb 
                            if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                             continue
                            else
                            end
                           elseif image(y+-3,x+2) < c_b 
                            continue
                           else
                           end
                          else
                           continue
                          end
                         elseif image(y+1,x+2) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      end
                     elseif image(y+1,x+3) < c_b 
                      continue
                     else
                      if image(y+3,x+2) > cb 
                       if image(y+2,x+2) > cb 
                       elseif image(y+2,x+2) < c_b 
                        continue
                       else
                        if image(y+2,x+-2) > cb 
                         if image(y+-3,x+1) > cb 
                          if image(y+4,x+1) > cb 
                           if image(y+-2,x+-3) > cb 
                            if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                            else
                             continue
                            end
                           elseif image(y+-2,x+-3) < c_b 
                            continue
                           else
                           end
                          elseif image(y+4,x+1) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-3,x+1) < c_b 
                          continue
                         else
                          if image(y+1,x+-2) > cb 
                           if image(y+0,x+2) > cb 
                           elseif image(y+0,x+2) < c_b 
                            continue
                           else
                            if image(y+-3,x+2) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+1,x+-2) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+2,x+-2) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+3,x+2) < c_b 
                       continue
                      else
                       if image(y+0,x+2) > cb 
                        if image(y+-4,x+0) > cb 
                        else
                         continue
                        end
                       else
                       end
                      end
                     end
                    end
                   end
                  end
                 elseif image(y+1,x+-3) < c_b 
                  continue
                 else
                  if image(y+2,x+-2) > cb 
                   if image(y+-1,x+-4) > cb 
                   elseif image(y+-1,x+-4) < c_b 
                    if image(y+3,x+2) > cb 
                     if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                      continue
                     else
                     end
                    elseif image(y+3,x+2) < c_b 
                     continue
                    else
                    end
                   else
                    if image(y+1,x+4) > cb 
                    elseif image(y+1,x+4) < c_b 
                     continue
                    else
                     if image(y+4,x+1) > cb 
                     elseif image(y+4,x+1) < c_b 
                      continue
                     else
                      if image(y+0,x+-2) > cb 
                       if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                        continue
                       else
                        if image(y+-4,x+0) > cb 
                         if image(y+-3,x+0) > cb 
                         elseif image(y+-3,x+0) < c_b 
                          continue
                         else
                          if image(y+2,x+2) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+-4,x+0) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+0,x+-2) < c_b 
                       continue
                      else
                      end
                     end
                    end
                   end
                  elseif image(y+2,x+-2) < c_b 
                   continue
                  else
                   if image(y+3,x+2) > cb 
                    if image(y+1,x+2) > cb 
                     if image(y+0,x+2) > cb 
                      if image(y+0,x+3) > cb 
                      elseif image(y+0,x+3) < c_b 
                       continue
                      else
                       if image(y+-4,x+0) > cb 
                       elseif image(y+-4,x+0) < c_b 
                        continue
                       else
                        if image(y+-1,x+-4) > cb 
                        else
                         continue
                        end
                       end
                      end
                     elseif image(y+0,x+2) < c_b 
                      continue
                     else
                      if image(y+-2,x+0) > cb 
                       if image(y+-2,x+-3) > cb 
                       elseif image(y+-2,x+-3) < c_b 
                        continue
                       else
                        if image(y+4,x+1) > cb 
                        elseif image(y+4,x+1) < c_b 
                         continue
                        else
                         if image(y+-2,x+-2) > cb 
                          if image(y+1,x+4) > cb 
                          elseif image(y+1,x+4) < c_b 
                           continue
                          else
                           if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                            continue
                           else
                           end
                          end
                         else
                          continue
                         end
                        end
                       end
                      elseif image(y+-2,x+0) < c_b 
                       continue
                      else
                       if image(y+0,x+-4) > cb 
                        if image(y+-3,x+2) > cb 
                        elseif image(y+-3,x+2) < c_b 
                         continue
                        else
                         if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                          continue
                         else
                          if image(y+-3,x+0) > cb 
                           if image(y+4,x+0) > cb 
                            if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                             continue
                            else
                            end
                           elseif image(y+4,x+0) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-3,x+0) < c_b 
                           continue
                          else
                           if image(y+-2,x+-3) > cb 
                            if image(y+-1,x+-4) > cb 
                             if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                              continue
                             else
                              if image(y+4,x+1) > cb 
                              else
                               continue
                              end
                             end
                            elseif image(y+-1,x+-4) < c_b 
                             continue
                            else
                            end
                           elseif image(y+-2,x+-3) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        end
                       elseif image(y+0,x+-4) < c_b 
                        continue
                       else
                        if image(y+0,x+4) > cb 
                        elseif image(y+0,x+4) < c_b 
                         continue
                        else
                         if image(y+-2,x+3) > cb 
                         elseif image(y+-2,x+3) < c_b 
                          continue
                         else
                          if image(y+4,x+0) > cb | image(y+4,x+0) < c_b 
                           continue
                          else
                           if image(y+-4,x+0) > cb 
                           elseif image(y+-4,x+0) < c_b 
                            continue
                           else
                            if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                             continue
                            else
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+1,x+2) < c_b 
                     continue
                    else
                     if image(y+-1,x+4) > cb 
                      if image(y+0,x+-4) > cb 
                       if image(y+-3,x+1) > cb 
                        if image(y+-1,x+-2) < c_b
                         continue
                        else
                         if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+-3,x+1) < c_b 
                        continue
                       else
                        if image(y+2,x+1) > cb 
                        elseif image(y+2,x+1) < c_b 
                         continue
                        else
                         if image(y+-1,x+-4) > cb 
                          if image(y+-2,x+-2) > cb 
                           if image(y+1,x+-2) > cb 
                           else
                            continue
                           end
                          elseif image(y+-2,x+-2) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-1,x+-4) < c_b 
                          continue
                         else
                          if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       end
                      elseif image(y+0,x+-4) < c_b 
                       continue
                      else
                       if image(y+3,x+-1) > cb 
                        if image(y+-4,x+1) > cb 
                         if image(y+3,x+1) > cb 
                         else
                          continue
                         end
                        else
                         continue
                        end
                       elseif image(y+3,x+-1) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+-1,x+4) < c_b 
                      continue
                     else
                      if image(y+-3,x+1) > cb 
                       if image(y+-1,x+-2) > cb 
                       elseif image(y+-1,x+-2) < c_b 
                        continue
                       else
                        if image(y+-2,x+1) > cb 
                         if image(y+4,x+1) > cb 
                          if image(y+1,x+3) > cb 
                          elseif image(y+1,x+3) < c_b 
                           continue
                          else
                           if image(y+3,x+-1) > cb 
                           else
                            continue
                           end
                          end
                         elseif image(y+4,x+1) < c_b 
                          continue
                         else
                         end
                        elseif image(y+-2,x+1) < c_b 
                         continue
                        else
                         if image(y+3,x+-1) > cb 
                          if image(y+2,x+-1) > cb 
                          elseif image(y+2,x+-1) < c_b 
                           continue
                          else
                           if image(y+-2,x+-3) > cb 
                            if image(y+2,x+2) > cb | image(y+2,x+2) < c_b 
                             continue
                            else
                             if image(y+2,x+1) > cb 
                             else
                              continue
                             end
                            end
                           elseif image(y+-2,x+-3) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+3,x+-1) < c_b 
                          if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        end
                       end
                      elseif image(y+-3,x+1) < c_b 
                       continue
                      else
                       if image(y+2,x+-1) > cb 
                        if image(y+3,x+-2) > cb 
                        else
                         continue
                        end
                       elseif image(y+2,x+-1) < c_b 
                        continue
                       else
                        if image(y+-1,x+2) > cb 
                        elseif image(y+-1,x+2) < c_b 
                         continue
                        else
                         if image(y+-2,x+1) > cb 
                         elseif image(y+-2,x+1) < c_b 
                          continue
                         else
                          if image(y+-3,x+2) > cb 
                           if image(y+-1,x+-4) > cb 
                           else
                            continue
                           end
                          else
                           continue
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+3,x+2) < c_b 
                    if image(y+-2,x+1) > cb 
                    else
                     continue
                    end
                   else
                    if image(y+1,x+4) > cb 
                    elseif image(y+1,x+4) < c_b 
                     continue
                    else
                     if image(y+0,x+2) > cb 
                      if image(y+-4,x+0) > cb 
                      else
                       continue
                      end
                     elseif image(y+0,x+2) < c_b 
                      continue
                     else
                     end
                    end
                   end
                  end
                 end
                elseif image(y+-4,x+-1) < c_b 
                else
                 if image(y+3,x+2) > cb 
                  if image(y+1,x+2) > cb 
                   if image(y+1,x+-3) > cb 
                    if image(y+-1,x+-2) > cb 
                    elseif image(y+-1,x+-2) < c_b 
                     continue
                    else
                     if image(y+3,x+-1) > cb 
                      if image(y+2,x+-2) > cb 
                      else
                       continue
                      end
                     elseif image(y+3,x+-1) < c_b 
                      continue
                     else
                     end
                    end
                   elseif image(y+1,x+-3) < c_b 
                    continue
                   else
                    if image(y+2,x+-2) > cb 
                    elseif image(y+2,x+-2) < c_b 
                     continue
                    else
                     if image(y+-1,x+4) > cb 
                     elseif image(y+-1,x+4) < c_b 
                      continue
                     else
                      if image(y+-4,x+0) > cb 
                      elseif image(y+-4,x+0) < c_b 
                       continue
                      else
                       if image(y+-2,x+3) > cb 
                       elseif image(y+-2,x+3) < c_b 
                        continue
                       else
                        if image(y+-1,x+2) > cb 
                        elseif image(y+-1,x+2) < c_b 
                         continue
                        else
                         if image(y+-1,x+-4) < c_b
                          continue
                         else
                          if image(y+0,x+2) > cb 
                          else
                           continue
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+1,x+2) < c_b 
                  else
                   if image(y+-1,x+-4) > cb 
                    if image(y+2,x+-2) > cb 
                     if image(y+2,x+1) > cb 
                      if image(y+1,x+-2) > cb 
                       if image(y+-1,x+4) > cb 
                       elseif image(y+-1,x+4) < c_b 
                        if image(y+2,x+0) > cb 
                        else
                         continue
                        end
                       else
                        if image(y+0,x+-2) > cb 
                        elseif image(y+0,x+-2) < c_b 
                         continue
                        else
                         if image(y+-2,x+0) > cb 
                         elseif image(y+-2,x+0) < c_b 
                          continue
                         else
                          if image(y+1,x+-4) > cb 
                           if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                            continue
                           else
                           end
                          elseif image(y+1,x+-4) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       end
                      elseif image(y+1,x+-2) < c_b 
                       continue
                      else
                       if image(y+-3,x+2) > cb 
                        if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                         continue
                        else
                        end
                       elseif image(y+-3,x+2) < c_b 
                        continue
                       else
                        if image(y+0,x+4) > cb 
                        elseif image(y+0,x+4) < c_b 
                         continue
                        else
                         if image(y+3,x+-2) > cb 
                          if image(y+-1,x+-3) > cb 
                           if image(y+1,x+3) > cb 
                            if image(y+-4,x+0) > cb 
                            else
                             continue
                            end
                           elseif image(y+1,x+3) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-1,x+-3) < c_b 
                           continue
                          else
                           if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+3,x+-2) < c_b 
                          continue
                         else
                          if image(y+-4,x+0) > cb 
                          else
                           continue
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+2,x+1) < c_b 
                      continue
                     else
                      if image(y+-1,x+4) > cb 
                       if image(y+-2,x+3) > cb 
                        if image(y+2,x+-1) > cb 
                         if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                          continue
                         else
                         end
                        elseif image(y+2,x+-1) < c_b 
                         continue
                        else
                         if image(y+-3,x+1) > cb 
                         elseif image(y+-3,x+1) < c_b 
                          continue
                         else
                          if image(y+-1,x+2) > cb 
                          else
                           continue
                          end
                         end
                        end
                       elseif image(y+-2,x+3) < c_b 
                        continue
                       else
                        if image(y+1,x+4) > cb 
                         if image(y+1,x+-2) > cb 
                         elseif image(y+1,x+-2) < c_b 
                          continue
                         else
                          if image(y+-1,x+-2) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+1,x+4) < c_b 
                         continue
                        else
                         if image(y+-1,x+2) > cb 
                         else
                          continue
                         end
                        end
                       end
                      elseif image(y+-1,x+4) < c_b 
                       continue
                      else
                       if image(y+-2,x+1) > cb 
                       elseif image(y+-2,x+1) < c_b 
                        continue
                       else
                        if image(y+-3,x+1) > cb 
                         if image(y+-4,x+0) > cb 
                         elseif image(y+-4,x+0) < c_b 
                          continue
                         else
                          if image(y+2,x+2) > cb | image(y+2,x+2) < c_b 
                           continue
                          else
                           if image(y+-1,x+-2) > cb 
                           else
                            continue
                           end
                          end
                         end
                        elseif image(y+-3,x+1) < c_b 
                         continue
                        else
                         if image(y+3,x+-2) > cb 
                          if image(y+2,x+0) > cb 
                          elseif image(y+2,x+0) < c_b 
                           continue
                          else
                           if image(y+-1,x+2) > cb 
                           elseif image(y+-1,x+2) < c_b 
                            continue
                           else
                            if image(y+0,x+3) > cb 
                             if image(y+2,x+-1) > cb 
                             else
                              continue
                             end
                            elseif image(y+0,x+3) < c_b 
                             continue
                            else
                             if image(y+-3,x+2) > cb 
                              if image(y+-4,x+1) > cb 
                              else
                               continue
                              end
                             else
                              continue
                             end
                            end
                           end
                          end
                         else
                          continue
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+2,x+-2) < c_b 
                     continue
                    else
                     if image(y+1,x+-3) > cb 
                      if image(y+3,x+-1) > cb 
                       if image(y+-1,x+-2) > cb 
                       else
                        continue
                       end
                      elseif image(y+3,x+-1) < c_b 
                       if image(y+-1,x+3) > cb 
                        continue
                       elseif image(y+-1,x+3) < c_b 
                       else
                        if image(y+2,x+0) < c_b
                        else
                         continue
                        end
                       end
                      else
                      end
                     elseif image(y+1,x+-3) < c_b 
                      continue
                     else
                      if image(y+-3,x+1) > cb 
                       if image(y+-1,x+-2) > cb 
                       elseif image(y+-1,x+-2) < c_b 
                        continue
                       else
                        if image(y+-2,x+1) > cb 
                        else
                         continue
                        end
                       end
                      elseif image(y+-3,x+1) < c_b 
                       continue
                      else
                       if image(y+0,x+-2) > cb 
                        if image(y+3,x+1) > cb 
                        else
                         continue
                        end
                       elseif image(y+0,x+-2) < c_b 
                        continue
                       else
                        if image(y+3,x+-2) > cb 
                         if image(y+-1,x+3) > cb | image(y+-1,x+3) < c_b 
                          continue
                         else
                          if image(y+-3,x+0) > cb 
                          elseif image(y+-3,x+0) < c_b 
                           continue
                          else
                           if image(y+-2,x+3) > cb 
                           else
                            continue
                           end
                          end
                         end
                        else
                         continue
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+-1,x+-4) < c_b 
                    if image(y+-2,x+-2) > cb 
                    else
                     continue
                    end
                   else
                    if image(y+2,x+-2) > cb 
                     if image(y+2,x+2) > cb 
                     elseif image(y+2,x+2) < c_b 
                      continue
                     else
                      if image(y+1,x+-2) > cb 
                       if image(y+1,x+3) > cb 
                       elseif image(y+1,x+3) < c_b 
                        continue
                       else
                        if image(y+0,x+-4) > cb 
                        elseif image(y+0,x+-4) < c_b 
                         continue
                        else
                         if image(y+0,x+4) > cb 
                          if image(y+3,x+-2) > cb 
                           if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                            continue
                           else
                           end
                          elseif image(y+3,x+-2) < c_b 
                           continue
                          else
                          end
                         elseif image(y+0,x+4) < c_b 
                          continue
                         else
                          if image(y+-2,x+0) > cb 
                           if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                            continue
                           else
                           end
                          else
                           continue
                          end
                         end
                        end
                       end
                      elseif image(y+1,x+-2) < c_b 
                       continue
                      else
                      end
                     end
                    elseif image(y+2,x+-2) < c_b 
                     continue
                    else
                     if image(y+1,x+-3) > cb 
                      if image(y+3,x+-1) > cb 
                       continue
                      elseif image(y+3,x+-1) < c_b 
                       if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                        continue
                       else
                       end
                      else
                      end
                     elseif image(y+1,x+-3) < c_b 
                      continue
                     else
                      if image(y+-1,x+4) > cb 
                       if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                        continue
                       else
                       end
                      elseif image(y+-1,x+4) < c_b 
                       continue
                      else
                       if image(y+-2,x+1) > cb 
                        if image(y+1,x+-4) > cb 
                         if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                          continue
                         else
                         end
                        elseif image(y+1,x+-4) < c_b 
                         continue
                        else
                         if image(y+-2,x+0) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+-2,x+1) < c_b 
                        continue
                       else
                        if image(y+-1,x+2) > cb 
                        else
                         continue
                        end
                       end
                      end
                     end
                    end
                   end
                  end
                 elseif image(y+3,x+2) < c_b 
                  continue
                 else
                  if image(y+1,x+2) > cb 
                   if image(y+1,x+4) > cb 
                   elseif image(y+1,x+4) < c_b 
                    continue
                   else
                    if image(y+2,x+-2) > cb 
                     if image(y+-2,x+-3) > cb 
                     elseif image(y+-2,x+-3) < c_b 
                      continue
                     else
                      if image(y+1,x+-2) > cb 
                      elseif image(y+1,x+-2) < c_b 
                       continue
                      else
                       if image(y+2,x+2) > cb | image(y+2,x+2) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    elseif image(y+2,x+-2) < c_b 
                     continue
                    else
                     if image(y+-2,x+0) > cb 
                     elseif image(y+-2,x+0) < c_b 
                      continue
                     else
                      if image(y+2,x+1) > cb 
                       if image(y+-4,x+0) > cb 
                        if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                         continue
                        else
                        end
                       elseif image(y+-4,x+0) < c_b 
                        continue
                       else
                       end
                      elseif image(y+2,x+1) < c_b 
                       continue
                      else
                       if image(y+1,x+3) > cb | image(y+1,x+3) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+1,x+2) < c_b 
                   if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                    continue
                   else
                   end
                  else
                  end
                 end
                end
               end
              end
             elseif image(y+2,x+-3) < c_b 
              if image(y+3,x+2) > cb 
               if image(y+2,x+-2) > cb | image(y+2,x+-2) < c_b 
               else
                if image(y+-1,x+2) > cb 
                 if image(y+2,x+1) > cb 
                  if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                  else
                   if image(y+3,x+1) > cb 
                    if image(y+4,x+-1) > cb 
                    else
                     if image(y+-2,x+2) > cb 
                     elseif image(y+-2,x+2) < c_b 
                      continue
                     else
                      if image(y+0,x+-2) > cb | image(y+0,x+-2) < c_b 
                       continue
                      else
                      end
                     end
                    end
                   elseif image(y+3,x+1) < c_b 
                    continue
                   else
                    if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                     continue
                    else
                    end
                   end
                  end
                 elseif image(y+2,x+1) < c_b 
                  if image(y+-2,x+-2) > cb 
                  else
                   continue
                  end
                 else
                  if image(y+0,x+2) > cb 
                   if image(y+1,x+-3) > cb 
                    continue
                   elseif image(y+1,x+-3) < c_b 
                    if image(y+-2,x+-3) > cb 
                     if image(y+-2,x+0) > cb 
                      if image(y+1,x+2) > cb 
                      elseif image(y+1,x+2) < c_b 
                       continue
                      else
                       if image(y+-3,x+1) > cb 
                       else
                        continue
                       end
                      end
                     elseif image(y+-2,x+0) < c_b 
                      continue
                     else
                      if image(y+0,x+-3) < c_b
                      else
                       continue
                      end
                     end
                    elseif image(y+-2,x+-3) < c_b 
                     continue
                    else
                     if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                     else
                      if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                       continue
                      else
                       if image(y+0,x+-3) < c_b
                       else
                        continue
                       end
                      end
                     end
                    end
                   else
                   end
                  elseif image(y+0,x+2) < c_b 
                   continue
                  else
                   if image(y+4,x+-1) > cb 
                   elseif image(y+4,x+-1) < c_b 
                    if image(y+1,x+-3) < c_b
                    else
                     continue
                    end
                   else
                    if image(y+1,x+-4) > cb 
                     continue
                    elseif image(y+1,x+-4) < c_b 
                     if image(y+1,x+2) > cb 
                     else
                      continue
                     end
                    else
                     if image(y+1,x+-2) > cb 
                      continue
                     elseif image(y+1,x+-2) < c_b 
                     else
                      if image(y+0,x+-2) > cb 
                       continue
                      elseif image(y+0,x+-2) < c_b 
                      else
                       if image(y+-1,x+4) > cb 
                        if image(y+-1,x+-3) > cb 
                        elseif image(y+-1,x+-3) < c_b 
                         continue
                        else
                         if image(y+1,x+2) > cb 
                          if image(y+0,x+4) > cb 
                          else
                           continue
                          end
                         else
                          continue
                         end
                        end
                       elseif image(y+-1,x+4) < c_b 
                       else
                        if image(y+-1,x+-2) > cb 
                         if image(y+-2,x+3) > cb 
                         else
                          continue
                         end
                        else
                         continue
                        end
                       end
                      end
                     end
                    end
                   end
                  end
                 end
                elseif image(y+-1,x+2) < c_b 
                 if image(y+-2,x+-2) > cb 
                 elseif image(y+-2,x+-2) < c_b 
                  continue
                 else
                  if image(y+2,x+1) > cb 
                  else
                   continue
                  end
                 end
                else
                 if image(y+2,x+1) > cb 
                  if image(y+0,x+-2) > cb 
                  elseif image(y+0,x+-2) < c_b 
                   if image(y+-2,x+3) > cb 
                    if image(y+-2,x+0) > cb 
                    else
                     continue
                    end
                   elseif image(y+-2,x+3) < c_b 
                   else
                    if image(y+1,x+-4) > cb 
                     continue
                    elseif image(y+1,x+-4) < c_b 
                     if image(y+3,x+-1) > cb 
                      if image(y+-1,x+-4) > cb 
                       continue
                      else
                      end
                     elseif image(y+3,x+-1) < c_b 
                      continue
                     else
                      if image(y+-2,x+-2) > cb 
                       if image(y+-1,x+-4) > cb 
                        continue
                       elseif image(y+-1,x+-4) < c_b 
                        if image(y+1,x+2) > cb 
                         if image(y+4,x+1) > cb | image(y+4,x+1) < c_b 
                          continue
                         else
                          if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+1,x+2) < c_b 
                         continue
                        else
                        end
                       else
                       end
                      elseif image(y+-2,x+-2) < c_b 
                       continue
                      else
                       if image(y+1,x+2) > cb | image(y+1,x+2) < c_b 
                        continue
                       else
                        if image(y+4,x+-1) > cb 
                         if image(y+-2,x+1) > cb 
                         else
                          continue
                         end
                        else
                         continue
                        end
                       end
                      end
                     end
                    else
                     if image(y+-1,x+-3) > cb 
                      continue
                     else
                     end
                    end
                   end
                  else
                   if image(y+-2,x+2) > cb 
                    if image(y+-2,x+-2) > cb 
                    elseif image(y+-2,x+-2) < c_b 
                     continue
                    else
                     if image(y+4,x+0) > cb 
                      if image(y+0,x+2) > cb 
                       if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                        continue
                       else
                       end
                      elseif image(y+0,x+2) < c_b 
                       continue
                      else
                      end
                     else
                      continue
                     end
                    end
                   elseif image(y+-2,x+2) < c_b 
                   else
                    if image(y+0,x+2) > cb 
                     if image(y+1,x+-2) > cb 
                      continue
                     elseif image(y+1,x+-2) < c_b 
                      if image(y+-4,x+1) > cb 
                      elseif image(y+-4,x+1) < c_b 
                       continue
                      else
                       if image(y+-1,x+4) > cb 
                        if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                         continue
                        else
                        end
                       elseif image(y+-1,x+4) < c_b 
                        continue
                       else
                       end
                      end
                     else
                     end
                    elseif image(y+0,x+2) < c_b 
                     continue
                    else
                     if image(y+2,x+0) > cb 
                      if image(y+-1,x+-2) > cb 
                       if image(y+-3,x+1) > cb 
                       elseif image(y+-3,x+1) < c_b 
                        continue
                       else
                        if image(y+3,x+0) > cb 
                        elseif image(y+3,x+0) < c_b 
                         continue
                        else
                         if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      elseif image(y+-1,x+-2) < c_b 
                       continue
                      else
                       if image(y+-3,x+0) > cb 
                        if image(y+-1,x+4) > cb 
                         if image(y+0,x+-4) > cb 
                          continue
                         elseif image(y+0,x+-4) < c_b 
                         else
                          if image(y+2,x+-1) > cb 
                          else
                           continue
                          end
                         end
                        else
                        end
                       elseif image(y+-3,x+0) < c_b 
                        continue
                       else
                        if image(y+0,x+3) > cb 
                        elseif image(y+0,x+3) < c_b 
                         continue
                        else
                         if image(y+1,x+-4) < c_b
                          if image(y+-1,x+3) > cb | image(y+-1,x+3) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        end
                       end
                      end
                     elseif image(y+2,x+0) < c_b 
                      continue
                     else
                      if image(y+1,x+2) > cb 
                       if image(y+-2,x+0) > cb 
                        if image(y+3,x+-1) > cb 
                         continue
                        elseif image(y+3,x+-1) < c_b 
                         if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                          continue
                         else
                         end
                        else
                         if image(y+-1,x+-3) > cb 
                         elseif image(y+-1,x+-3) < c_b 
                          continue
                         else
                          if image(y+-4,x+-1) > cb 
                          else
                           continue
                          end
                         end
                        end
                       elseif image(y+-2,x+0) < c_b 
                        continue
                       else
                        if image(y+1,x+-2) > cb 
                         continue
                        elseif image(y+1,x+-2) < c_b 
                        else
                         if image(y+4,x+-1) > cb | image(y+4,x+-1) < c_b 
                         else
                          if image(y+-2,x+-2) > cb 
                           if image(y+2,x+-1) > cb 
                            continue
                           elseif image(y+2,x+-1) < c_b 
                           else
                            if image(y+1,x+-4) > cb 
                             continue
                            elseif image(y+1,x+-4) < c_b 
                             if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                              continue
                             else
                             end
                            else
                             if image(y+-4,x+1) > cb 
                              continue
                             elseif image(y+-4,x+1) < c_b 
                             else
                              if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                               continue
                              else
                              end
                             end
                            end
                           end
                          elseif image(y+-2,x+-2) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       end
                      elseif image(y+1,x+2) < c_b 
                       continue
                      else
                       if image(y+-1,x+-4) > cb 
                        if image(y+1,x+3) > cb 
                         if image(y+4,x+0) > cb | image(y+4,x+0) < c_b 
                          continue
                         else
                         end
                        else
                         continue
                        end
                       elseif image(y+-1,x+-4) < c_b 
                        continue
                       else
                        if image(y+1,x+-2) > cb 
                         continue
                        elseif image(y+1,x+-2) < c_b 
                        else
                         if image(y+-1,x+-2) > cb 
                          if image(y+0,x+3) > cb | image(y+0,x+3) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-1,x+-2) < c_b 
                          continue
                         else
                          if image(y+-1,x+4) > cb 
                           continue
                          elseif image(y+-1,x+4) < c_b 
                           if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                            continue
                           else
                           end
                          else
                           if image(y+4,x+-1) > cb 
                           elseif image(y+4,x+-1) < c_b 
                            continue
                           else
                            if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                             continue
                            else
                             if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                              continue
                             else
                             end
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  end
                 elseif image(y+2,x+1) < c_b 
                 else
                  if image(y+-1,x+-2) > cb 
                   if image(y+-3,x+1) > cb 
                    if image(y+1,x+-4) > cb 
                     continue
                    elseif image(y+1,x+-4) < c_b 
                     if image(y+0,x+-4) > cb 
                      continue
                     elseif image(y+0,x+-4) < c_b 
                      if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                       continue
                      else
                      end
                     else
                     end
                    else
                     if image(y+-1,x+-4) > cb 
                     elseif image(y+-1,x+-4) < c_b 
                      continue
                     else
                      if image(y+-2,x+2) > cb 
                       if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                        continue
                       else
                       end
                      elseif image(y+-2,x+2) < c_b 
                       continue
                      else
                      end
                     end
                    end
                   elseif image(y+-3,x+1) < c_b 
                   else
                    if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
                    else
                     if image(y+0,x+-4) > cb 
                      continue
                     elseif image(y+0,x+-4) < c_b 
                      if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                       continue
                      else
                      end
                     else
                      if image(y+4,x+-1) > cb 
                       if image(y+-3,x+2) > cb 
                       else
                        continue
                       end
                      elseif image(y+4,x+-1) < c_b 
                       if image(y+2,x+0) > cb | image(y+2,x+0) < c_b 
                        continue
                       else
                       end
                      else
                       if image(y+1,x+2) > cb 
                        if image(y+-2,x+0) < c_b
                         continue
                        else
                         if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+1,x+2) < c_b 
                        continue
                       else
                        if image(y+1,x+-4) < c_b
                         if image(y+-1,x+3) > cb | image(y+-1,x+3) < c_b 
                          continue
                         else
                         end
                        else
                         continue
                        end
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+-1,x+-2) < c_b 
                   continue
                  else
                   if image(y+1,x+2) > cb 
                    if image(y+1,x+-3) > cb 
                     continue
                    elseif image(y+1,x+-3) < c_b 
                     if image(y+-2,x+0) > cb 
                      if image(y+-2,x+-3) > cb 
                      else
                       continue
                      end
                     elseif image(y+-2,x+0) < c_b 
                      continue
                     else
                      if image(y+0,x+-2) < c_b
                      else
                       continue
                      end
                     end
                    else
                     if image(y+0,x+2) > cb 
                     elseif image(y+0,x+2) < c_b 
                      continue
                     else
                      if image(y+-4,x+1) > cb 
                      elseif image(y+-4,x+1) < c_b 
                       continue
                      else
                       if image(y+-2,x+2) > cb 
                        continue
                       elseif image(y+-2,x+2) < c_b 
                       else
                        if image(y+-1,x+3) > cb 
                        elseif image(y+-1,x+3) < c_b 
                         continue
                        else
                         if image(y+-2,x+3) < c_b
                         else
                          continue
                         end
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+1,x+2) < c_b 
                    continue
                   else
                    if image(y+2,x+-1) > cb 
                    elseif image(y+2,x+-1) < c_b 
                     if image(y+-1,x+4) < c_b
                     else
                      continue
                     end
                    else
                     if image(y+3,x+1) > cb 
                      if image(y+0,x+4) > cb 
                       if image(y+2,x+2) > cb | image(y+2,x+2) < c_b 
                        continue
                       else
                        if image(y+-3,x+0) > cb 
                        else
                         continue
                        end
                       end
                      elseif image(y+0,x+4) < c_b 
                      else
                       if image(y+1,x+-2) > cb 
                        continue
                       elseif image(y+1,x+-2) < c_b 
                        if image(y+-2,x+3) > cb 
                         continue
                        elseif image(y+-2,x+3) < c_b 
                        else
                         if image(y+-1,x+3) < c_b
                         else
                          continue
                         end
                        end
                       else
                        if image(y+4,x+-1) > cb 
                         if image(y+-2,x+1) > cb 
                         else
                          continue
                         end
                        else
                         continue
                        end
                       end
                      end
                     elseif image(y+3,x+1) < c_b 
                      continue
                     else
                      if image(y+-4,x+1) > cb 
                       continue
                      elseif image(y+-4,x+1) < c_b 
                      else
                       if image(y+0,x+-4) < c_b
                        if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                         continue
                        else
                        end
                       else
                        continue
                       end
                      end
                     end
                    end
                   end
                  end
                 end
                end
               end
              elseif image(y+3,x+2) < c_b 
               if image(y+-2,x+3) > cb 
                if image(y+1,x+-4) > cb 
                elseif image(y+1,x+-4) < c_b 
                 if image(y+-2,x+-3) > cb 
                  if image(y+1,x+2) > cb 
                  elseif image(y+1,x+2) < c_b 
                   continue
                  else
                   if image(y+-1,x+-4) > cb 
                    if image(y+-1,x+-3) > cb 
                    else
                     continue
                    end
                   else
                    continue
                   end
                  end
                 else
                  continue
                 end
                else
                 if image(y+-2,x+-3) > cb 
                  if image(y+-1,x+-4) > cb 
                   if image(y+-4,x+1) > cb 
                   else
                    continue
                   end
                  elseif image(y+-1,x+-4) < c_b 
                   continue
                  else
                   if image(y+0,x+-3) < c_b
                   else
                    continue
                   end
                  end
                 elseif image(y+-2,x+-3) < c_b 
                  continue
                 else
                  if image(y+1,x+2) > cb 
                   if image(y+4,x+1) > cb 
                    continue
                   elseif image(y+4,x+1) < c_b 
                   else
                    if image(y+-1,x+-4) < c_b
                    else
                     continue
                    end
                   end
                  else
                   continue
                  end
                 end
                end
               elseif image(y+-2,x+3) < c_b 
               else
                if image(y+1,x+-4) > cb 
                 continue
                elseif image(y+1,x+-4) < c_b 
                 if image(y+-2,x+-3) > cb 
                  if image(y+-4,x+0) > cb 
                  else
                   continue
                  end
                 else
                  if image(y+-3,x+2) < c_b
                  else
                   continue
                  end
                 end
                else
                 if image(y+-3,x+2) > cb 
                  if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                   continue
                  else
                  end
                 else
                 end
                end
               end
              else
               if image(y+-2,x+-3) > cb 
                if image(y+4,x+-1) > cb 
                 if image(y+-1,x+-4) > cb 
                  if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                  else
                   if image(y+0,x+-2) > cb 
                    continue
                   elseif image(y+0,x+-2) < c_b 
                   else
                    if image(y+2,x+-2) > cb 
                     continue
                    elseif image(y+2,x+-2) < c_b 
                    else
                     if image(y+1,x+-2) > cb | image(y+1,x+-2) < c_b 
                      continue
                     else
                     end
                    end
                   end
                  end
                 elseif image(y+-1,x+-4) < c_b 
                 else
                  if image(y+-1,x+2) > cb 
                   if image(y+2,x+0) > cb 
                    continue
                   elseif image(y+2,x+0) < c_b 
                    if image(y+4,x+1) > cb 
                     if image(y+-4,x+1) > cb 
                     else
                      continue
                     end
                    else
                     continue
                    end
                   else
                   end
                  else
                   continue
                  end
                 end
                elseif image(y+4,x+-1) < c_b 
                 if image(y+-1,x+-2) > cb 
                  if image(y+-2,x+3) > cb 
                   if image(y+-1,x+-4) > cb 
                    if image(y+-4,x+-1) > cb 
                     if image(y+-3,x+1) > cb 
                     elseif image(y+-3,x+1) < c_b 
                      continue
                     else
                      if image(y+-1,x+2) > cb 
                      elseif image(y+-1,x+2) < c_b 
                       continue
                      else
                       if image(y+1,x+-4) < c_b
                       else
                        continue
                       end
                      end
                     end
                    elseif image(y+-4,x+-1) < c_b 
                     continue
                    else
                     if image(y+1,x+2) > cb 
                     elseif image(y+1,x+2) < c_b 
                      continue
                     else
                      if image(y+3,x+1) > cb | image(y+3,x+1) < c_b 
                       continue
                      else
                       if image(y+3,x+0) > cb 
                        continue
                       elseif image(y+3,x+0) < c_b 
                        if image(y+-3,x+0) > cb 
                        else
                         continue
                        end
                       else
                        if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+-1,x+-4) < c_b 
                   else
                    if image(y+1,x+2) > cb 
                     if image(y+2,x+-1) > cb 
                      continue
                     elseif image(y+2,x+-1) < c_b 
                     else
                      if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                       continue
                      else
                      end
                     end
                    elseif image(y+1,x+2) < c_b 
                     continue
                    else
                     if image(y+-4,x+-1) > cb 
                      if image(y+-1,x+3) > cb | image(y+-1,x+3) < c_b 
                       continue
                      else
                       if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+-4,x+-1) < c_b 
                      continue
                     else
                      if image(y+1,x+-3) < c_b
                       if image(y+2,x+1) > cb | image(y+2,x+1) < c_b 
                        continue
                       else
                       end
                      else
                       continue
                      end
                     end
                    end
                   end
                  elseif image(y+-2,x+3) < c_b 
                   if image(y+-3,x+2) > cb 
                    continue
                   elseif image(y+-3,x+2) < c_b 
                   else
                    if image(y+1,x+-4) > cb 
                     continue
                    elseif image(y+1,x+-4) < c_b 
                     if image(y+4,x+0) > cb 
                      continue
                     elseif image(y+4,x+0) < c_b 
                     else
                      if image(y+-3,x+1) > cb 
                       if image(y+-4,x+1) > cb 
                       else
                        continue
                       end
                      elseif image(y+-3,x+1) < c_b 
                       continue
                      else
                      end
                     end
                    else
                     if image(y+-1,x+3) > cb 
                      continue
                     elseif image(y+-1,x+3) < c_b 
                      if image(y+0,x+4) > cb 
                       continue
                      elseif image(y+0,x+4) < c_b 
                       if image(y+2,x+0) > cb 
                        continue
                       elseif image(y+2,x+0) < c_b 
                       else
                        if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                         continue
                        else
                        end
                       end
                      else
                      end
                     else
                      if image(y+2,x+0) > cb 
                       continue
                      elseif image(y+2,x+0) < c_b 
                       if image(y+2,x+1) > cb 
                        continue
                       elseif image(y+2,x+1) < c_b 
                       else
                        if image(y+1,x+-2) > cb 
                         continue
                        elseif image(y+1,x+-2) < c_b 
                         if image(y+-4,x+0) > cb 
                         elseif image(y+-4,x+0) < c_b 
                          continue
                         else
                          if image(y+0,x+-4) > cb 
                          else
                           continue
                          end
                         end
                        else
                         if image(y+-4,x+-1) > cb 
                          if image(y+-4,x+1) > cb 
                          else
                           continue
                          end
                         elseif image(y+-4,x+-1) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      else
                      end
                     end
                    end
                   end
                  else
                   if image(y+-3,x+1) > cb 
                    if image(y+-1,x+-4) > cb 
                    elseif image(y+-1,x+-4) < c_b 
                     continue
                    else
                     if image(y+-2,x+2) > cb 
                      if image(y+4,x+1) < c_b
                       if image(y+1,x+-3) < c_b
                       else
                        continue
                       end
                      else
                       continue
                      end
                     elseif image(y+-2,x+2) < c_b 
                      continue
                     else
                     end
                    end
                   elseif image(y+-3,x+1) < c_b 
                    if image(y+2,x+-1) > cb 
                     continue
                    elseif image(y+2,x+-1) < c_b 
                    else
                     if image(y+-2,x+1) < c_b
                      if image(y+4,x+0) > cb | image(y+4,x+0) < c_b 
                       continue
                      else
                      end
                     else
                      continue
                     end
                    end
                   else
                    if image(y+2,x+0) > cb 
                     continue
                    elseif image(y+2,x+0) < c_b 
                     if image(y+1,x+2) > cb 
                     elseif image(y+1,x+2) < c_b 
                      continue
                     else
                      if image(y+-1,x+3) > cb 
                       if image(y+-2,x+1) > cb 
                       else
                        continue
                       end
                      elseif image(y+-1,x+3) < c_b 
                      else
                       if image(y+-3,x+2) > cb 
                        continue
                       elseif image(y+-3,x+2) < c_b 
                       else
                        if image(y+-2,x+2) < c_b
                        else
                         continue
                        end
                       end
                      end
                     end
                    else
                     if image(y+-1,x+3) > cb 
                      if image(y+-2,x+0) > cb 
                      else
                       continue
                      end
                     elseif image(y+-1,x+3) < c_b 
                      if image(y+-1,x+2) < c_b
                      else
                       continue
                      end
                     else
                     end
                    end
                   end
                  end
                 elseif image(y+-1,x+-2) < c_b 
                 else
                  if image(y+1,x+2) > cb 
                   if image(y+2,x+-2) > cb 
                    continue
                   elseif image(y+2,x+-2) < c_b 
                   else
                    if image(y+3,x+-1) > cb 
                     continue
                    else
                     if image(y+-4,x+0) > cb 
                     else
                      continue
                     end
                    end
                   end
                  elseif image(y+1,x+2) < c_b 
                   continue
                  else
                   if image(y+-2,x+3) > cb 
                    if image(y+4,x+1) > cb 
                    elseif image(y+4,x+1) < c_b 
                     continue
                    else
                     if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                      continue
                     else
                      if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                       continue
                      else
                       if image(y+-4,x+0) > cb 
                       else
                        continue
                       end
                      end
                     end
                    end
                   elseif image(y+-2,x+3) < c_b 
                    if image(y+-3,x+0) > cb 
                     if image(y+-3,x+2) > cb 
                      continue
                     elseif image(y+-3,x+2) < c_b 
                     else
                      if image(y+1,x+3) > cb 
                       if image(y+2,x+-1) < c_b
                       else
                        continue
                       end
                      elseif image(y+1,x+3) < c_b 
                       continue
                      else
                       if image(y+3,x+1) > cb 
                        continue
                       elseif image(y+3,x+1) < c_b 
                       else
                        if image(y+-4,x+-1) > cb 
                         if image(y+0,x+-4) < c_b
                         else
                          continue
                         end
                        elseif image(y+-4,x+-1) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     end
                    elseif image(y+-3,x+0) < c_b 
                     continue
                    else
                    end
                   else
                    if image(y+-3,x+2) > cb 
                     if image(y+0,x+-2) < c_b
                      if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
                       continue
                      else
                      end
                     else
                      continue
                     end
                    elseif image(y+-3,x+2) < c_b 
                    else
                     if image(y+-1,x+3) > cb 
                      continue
                     elseif image(y+-1,x+3) < c_b 
                      if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                       continue
                      else
                      end
                     else
                      if image(y+2,x+1) > cb 
                      else
                       continue
                      end
                     end
                    end
                   end
                  end
                 end
                else
                 if image(y+2,x+-2) > cb 
                  continue
                 elseif image(y+2,x+-2) < c_b 
                 else
                  if image(y+-4,x+-1) > cb 
                  elseif image(y+-4,x+-1) < c_b 
                   continue
                  else
                   if image(y+1,x+2) > cb 
                    if image(y+-1,x+-2) > cb 
                    elseif image(y+-1,x+-2) < c_b 
                     continue
                    else
                     if image(y+-3,x+0) > cb 
                     elseif image(y+-3,x+0) < c_b 
                      continue
                     else
                      if image(y+1,x+-2) < c_b
                      else
                       continue
                      end
                     end
                    end
                   elseif image(y+1,x+2) < c_b 
                    continue
                   else
                   end
                  end
                 end
                end
               elseif image(y+-2,x+-3) < c_b 
                if image(y+4,x+-1) > cb 
                elseif image(y+4,x+-1) < c_b 
                 if image(y+-2,x+3) < c_b
                 else
                  continue
                 end
                else
                 if image(y+-4,x+-1) > cb 
                  if image(y+-1,x+-4) > cb 
                   continue
                  elseif image(y+-1,x+-4) < c_b 
                  else
                   if image(y+0,x+-4) > cb 
                    continue
                   elseif image(y+0,x+-4) < c_b 
                    if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                     continue
                    else
                    end
                   else
                   end
                  end
                 elseif image(y+-4,x+-1) < c_b 
                  continue
                 else
                  if image(y+-4,x+1) < c_b
                  else
                   continue
                  end
                 end
                end
               else
                if image(y+4,x+-1) > cb 
                 if image(y+-1,x+-4) > cb 
                  if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                   continue
                  else
                  end
                 elseif image(y+-1,x+-4) < c_b 
                 else
                  if image(y+4,x+1) > cb 
                  elseif image(y+4,x+1) < c_b 
                   continue
                  else
                   if image(y+-1,x+4) < c_b
                   else
                    continue
                   end
                  end
                 end
                elseif image(y+4,x+-1) < c_b 
                 if image(y+-2,x+3) > cb 
                  if image(y+1,x+-4) > cb 
                   continue
                  elseif image(y+1,x+-4) < c_b 
                   if image(y+-1,x+-2) > cb 
                    if image(y+-1,x+-4) > cb 
                     continue
                    elseif image(y+-1,x+-4) < c_b 
                    else
                     if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                      continue
                     else
                     end
                    end
                   elseif image(y+-1,x+-2) < c_b 
                    continue
                   else
                    if image(y+2,x+1) > cb 
                     if image(y+-4,x+-1) > cb 
                     else
                      continue
                     end
                    else
                     continue
                    end
                   end
                  else
                   if image(y+1,x+2) > cb 
                    if image(y+4,x+1) > cb 
                     continue
                    elseif image(y+4,x+1) < c_b 
                     if image(y+-4,x+-1) > cb 
                     else
                      continue
                     end
                    else
                     if image(y+-1,x+-4) > cb 
                      if image(y+-2,x+-2) > cb 
                      else
                       continue
                      end
                     elseif image(y+-1,x+-4) < c_b 
                     else
                      if image(y+-1,x+-2) > cb 
                       if image(y+-4,x+1) > cb 
                       else
                        continue
                       end
                      elseif image(y+-1,x+-2) < c_b 
                      else
                       if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    end
                   else
                    continue
                   end
                  end
                 elseif image(y+-2,x+3) < c_b 
                  if image(y+-3,x+2) > cb 
                   continue
                  elseif image(y+-3,x+2) < c_b 
                   if image(y+-2,x+-2) > cb 
                   elseif image(y+-2,x+-2) < c_b 
                    continue
                   else
                    if image(y+1,x+2) > cb 
                    elseif image(y+1,x+2) < c_b 
                     continue
                    else
                     if image(y+1,x+3) > cb 
                      if image(y+-4,x+0) > cb 
                      else
                       continue
                      end
                     elseif image(y+1,x+3) < c_b 
                      continue
                     else
                     end
                    end
                   end
                  else
                   if image(y+1,x+-2) > cb 
                    continue
                   elseif image(y+1,x+-2) < c_b 
                    if image(y+4,x+1) > cb 
                     continue
                    elseif image(y+4,x+1) < c_b 
                    else
                     if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                     else
                      if image(y+-4,x+-1) > cb 
                       if image(y+-4,x+0) > cb 
                        if image(y+1,x+3) > cb 
                         if image(y+-3,x+0) > cb 
                         else
                          continue
                         end
                        elseif image(y+1,x+3) < c_b 
                         continue
                        else
                         if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                          continue
                         else
                         end
                        end
                       else
                        continue
                       end
                      elseif image(y+-4,x+-1) < c_b 
                       continue
                      else
                      end
                     end
                    end
                   else
                    if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                     continue
                    else
                    end
                   end
                  end
                 else
                  if image(y+1,x+-4) > cb 
                   continue
                  elseif image(y+1,x+-4) < c_b 
                   if image(y+-3,x+2) > cb 
                    continue
                   elseif image(y+-3,x+2) < c_b 
                    if image(y+0,x+4) > cb 
                    else
                     continue
                    end
                   else
                    if image(y+-1,x+-2) > cb 
                     if image(y+2,x+2) > cb | image(y+2,x+2) < c_b 
                      continue
                     else
                     end
                    elseif image(y+-1,x+-2) < c_b 
                     continue
                    else
                     if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                      continue
                     else
                      if image(y+0,x+2) > cb | image(y+0,x+2) < c_b 
                       continue
                      else
                       if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    end
                   end
                  else
                   if image(y+1,x+2) > cb 
                   elseif image(y+1,x+2) < c_b 
                    continue
                   else
                    if image(y+-1,x+-2) > cb 
                     if image(y+-3,x+1) > cb 
                      if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
                       continue
                      else
                      end
                     elseif image(y+-3,x+1) < c_b 
                     else
                      if image(y+2,x+0) > cb 
                       continue
                      elseif image(y+2,x+0) < c_b 
                       if image(y+-3,x+2) < c_b
                       else
                        continue
                       end
                      else
                      end
                     end
                    elseif image(y+-1,x+-2) < c_b 
                     continue
                    else
                     if image(y+-3,x+2) < c_b
                     else
                      continue
                     end
                    end
                   end
                  end
                 end
                else
                 if image(y+1,x+2) > cb 
                  if image(y+-1,x+-4) > cb 
                  elseif image(y+-1,x+-4) < c_b 
                   if image(y+1,x+4) > cb 
                   elseif image(y+1,x+4) < c_b 
                    continue
                   else
                    if image(y+-1,x+4) < c_b
                    else
                     continue
                    end
                   end
                  else
                   if image(y+-2,x+2) > cb 
                    if image(y+4,x+1) > cb 
                     if image(y+-4,x+-1) > cb 
                     else
                      continue
                     end
                    elseif image(y+4,x+1) < c_b 
                    else
                     if image(y+2,x+1) > cb 
                      if image(y+-2,x+0) > cb 
                      else
                       continue
                      end
                     elseif image(y+2,x+1) < c_b 
                     else
                      if image(y+-4,x+1) > cb 
                       if image(y+-1,x+-2) < c_b
                        if image(y+0,x+-3) > cb | image(y+0,x+-3) < c_b 
                         continue
                        else
                        end
                       else
                        continue
                       end
                      elseif image(y+-4,x+1) < c_b 
                       continue
                      else
                      end
                     end
                    end
                   elseif image(y+-2,x+2) < c_b 
                    if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                     continue
                    else
                    end
                   else
                    if image(y+1,x+4) > cb 
                    elseif image(y+1,x+4) < c_b 
                     continue
                    else
                     if image(y+2,x+0) < c_b
                     else
                      continue
                     end
                    end
                   end
                  end
                 elseif image(y+1,x+2) < c_b 
                  continue
                 else
                 end
                end
               end
              end
             else
              if image(y+-2,x+1) > cb 
               if image(y+-1,x+-2) > cb 
                if image(y+-1,x+-4) > cb 
                 if image(y+-4,x+-1) > cb 
                  if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
                  else
                   if image(y+-1,x+3) > cb 
                    if image(y+1,x+2) > cb 
                     if image(y+3,x+-2) > cb 
                      if image(y+-4,x+0) > cb 
                      elseif image(y+-4,x+0) < c_b 
                       continue
                      else
                       if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+3,x+-2) < c_b 
                      if image(y+2,x+-2) > cb 
                       continue
                      elseif image(y+2,x+-2) < c_b 
                      else
                       if image(y+2,x+0) < c_b
                        continue
                       else
                       end
                      end
                     else
                     end
                    elseif image(y+1,x+2) < c_b 
                     continue
                    else
                     if image(y+3,x+2) > cb 
                      if image(y+4,x+-1) > cb 
                       if image(y+3,x+-2) > cb 
                        if image(y+-4,x+1) > cb 
                        elseif image(y+-4,x+1) < c_b 
                         continue
                        else
                         if image(y+-2,x+-3) > cb 
                          if image(y+0,x+-4) > cb 
                           if image(y+-3,x+-1) > cb 
                           else
                            continue
                           end
                          else
                           continue
                          end
                         elseif image(y+-2,x+-3) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+3,x+-2) < c_b 
                        continue
                       else
                       end
                      elseif image(y+4,x+-1) < c_b 
                       if image(y+0,x+-2) > cb | image(y+0,x+-2) < c_b 
                        continue
                       else
                       end
                      else
                       if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                        if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                         continue
                        else
                        end
                       else
                        if image(y+-1,x+2) > cb 
                        elseif image(y+-1,x+2) < c_b 
                         continue
                        else
                         if image(y+2,x+-2) < c_b
                         else
                          continue
                         end
                        end
                       end
                      end
                     elseif image(y+3,x+2) < c_b 
                      continue
                     else
                      if image(y+4,x+-1) > cb 
                       if image(y+4,x+0) > cb 
                       elseif image(y+4,x+0) < c_b 
                        continue
                       else
                        if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+4,x+-1) < c_b 
                       if image(y+2,x+2) > cb 
                       elseif image(y+2,x+2) < c_b 
                        continue
                       else
                        if image(y+1,x+-4) > cb 
                        else
                         continue
                        end
                       end
                      else
                      end
                     end
                    end
                   elseif image(y+-1,x+3) < c_b 
                    if image(y+1,x+-3) > cb 
                     if image(y+3,x+-2) > cb 
                      if image(y+-1,x+4) < c_b
                      else
                       continue
                      end
                     else
                     end
                    elseif image(y+1,x+-3) < c_b 
                    else
                     if image(y+-2,x+3) > cb 
                      continue
                     elseif image(y+-2,x+3) < c_b 
                     else
                      if image(y+2,x+0) > cb | image(y+2,x+0) < c_b 
                      else
                       if image(y+0,x+2) > cb 
                       elseif image(y+0,x+2) < c_b 
                        if image(y+-1,x+2) > cb 
                         continue
                        elseif image(y+-1,x+2) < c_b 
                        else
                         if image(y+2,x+-2) < c_b
                         else
                          continue
                         end
                        end
                       else
                        if image(y+0,x+-4) > cb 
                        else
                         continue
                        end
                       end
                      end
                     end
                    end
                   else
                    if image(y+-3,x+1) > cb 
                    elseif image(y+-3,x+1) < c_b 
                     continue
                    else
                     if image(y+2,x+0) > cb 
                     elseif image(y+2,x+0) < c_b 
                      if image(y+-3,x+2) > cb 
                       continue
                      elseif image(y+-3,x+2) < c_b 
                      else
                       if image(y+4,x+-1) > cb 
                        continue
                       elseif image(y+4,x+-1) < c_b 
                        if image(y+2,x+1) < c_b
                        else
                         continue
                        end
                       else
                        if image(y+3,x+2) > cb 
                         continue
                        else
                        end
                       end
                      end
                     else
                      if image(y+0,x+2) > cb 
                      elseif image(y+0,x+2) < c_b 
                       continue
                      else
                       if image(y+-2,x+3) > cb 
                        if image(y+2,x+2) > cb 
                         if image(y+-1,x+4) > cb 
                         else
                          continue
                         end
                        elseif image(y+2,x+2) < c_b 
                         continue
                        else
                        end
                       elseif image(y+-2,x+3) < c_b 
                        continue
                       else
                        if image(y+1,x+2) > cb 
                        elseif image(y+1,x+2) < c_b 
                         continue
                        else
                         if image(y+-4,x+1) > cb 
                         elseif image(y+-4,x+1) < c_b 
                          continue
                         else
                          if image(y+3,x+2) > cb 
                           if image(y+4,x+-1) > cb 
                            if image(y+0,x+4) > cb 
                             if image(y+3,x+-2) > cb 
                              if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                               continue
                              else
                              end
                             elseif image(y+3,x+-2) < c_b 
                              continue
                             else
                             end
                            elseif image(y+0,x+4) < c_b 
                             continue
                            else
                            end
                           elseif image(y+4,x+-1) < c_b 
                            continue
                           else
                            if image(y+2,x+-2) < c_b
                            else
                             continue
                            end
                           end
                          elseif image(y+3,x+2) < c_b 
                           continue
                          else
                           if image(y+2,x+2) > cb 
                            if image(y+1,x+4) > cb 
                            else
                             continue
                            end
                           elseif image(y+2,x+2) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  end
                 elseif image(y+-4,x+-1) < c_b 
                 else
                  if image(y+2,x+2) > cb 
                   if image(y+-2,x+2) > cb 
                   elseif image(y+-2,x+2) < c_b 
                    continue
                   else
                    if image(y+-1,x+3) > cb 
                     if image(y+1,x+2) > cb 
                     elseif image(y+1,x+2) < c_b 
                      continue
                     else
                      if image(y+0,x+-2) > cb 
                      elseif image(y+0,x+-2) < c_b 
                       continue
                      else
                       if image(y+4,x+-1) > cb 
                       else
                        continue
                       end
                      end
                     end
                    elseif image(y+-1,x+3) < c_b 
                    else
                     if image(y+-3,x+1) > cb 
                     elseif image(y+-3,x+1) < c_b 
                      continue
                     else
                      if image(y+-3,x+0) > cb 
                      elseif image(y+-3,x+0) < c_b 
                       continue
                      else
                       if image(y+0,x+3) > cb 
                       elseif image(y+0,x+3) < c_b 
                        continue
                       else
                        if image(y+0,x+-4) > cb 
                         if image(y+-4,x+1) > cb 
                         elseif image(y+-4,x+1) < c_b 
                          continue
                         else
                          if image(y+2,x+1) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+0,x+-4) < c_b 
                         continue
                        else
                         if image(y+1,x+3) > cb 
                         elseif image(y+1,x+3) < c_b 
                          continue
                         else
                          if image(y+2,x+1) > cb 
                           if image(y+-3,x+2) > cb 
                           else
                            continue
                           end
                          elseif image(y+2,x+1) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+2,x+2) < c_b 
                   continue
                  else
                   if image(y+0,x+2) > cb 
                    if image(y+4,x+-1) > cb 
                    elseif image(y+4,x+-1) < c_b 
                     if image(y+1,x+2) > cb 
                     elseif image(y+1,x+2) < c_b 
                      continue
                     else
                      if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                       continue
                      else
                       if image(y+2,x+-1) > cb 
                        continue
                       elseif image(y+2,x+-1) < c_b 
                       else
                        if image(y+0,x+-2) > cb 
                        else
                         continue
                        end
                       end
                      end
                     end
                    else
                     if image(y+0,x+-4) > cb 
                     elseif image(y+0,x+-4) < c_b 
                      continue
                     else
                      if image(y+1,x+4) > cb 
                      elseif image(y+1,x+4) < c_b 
                       continue
                      else
                       if image(y+-3,x+-1) > cb 
                       elseif image(y+-3,x+-1) < c_b 
                        continue
                       else
                        if image(y+0,x+-3) > cb 
                        else
                         continue
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+0,x+2) < c_b 
                    if image(y+-1,x+4) > cb 
                     continue
                    elseif image(y+-1,x+4) < c_b 
                    else
                     if image(y+-4,x+0) > cb 
                      if image(y+-2,x+2) > cb 
                       if image(y+0,x+3) < c_b
                       else
                        continue
                       end
                      elseif image(y+-2,x+2) < c_b 
                       continue
                      else
                      end
                     elseif image(y+-4,x+0) < c_b 
                      continue
                     else
                     end
                    end
                   else
                    if image(y+3,x+1) > cb 
                     if image(y+-3,x+2) > cb 
                     elseif image(y+-3,x+2) < c_b 
                      continue
                     else
                      if image(y+4,x+0) > cb 
                       if image(y+2,x+-2) > cb 
                        if image(y+-4,x+1) < c_b
                        else
                         continue
                        end
                       elseif image(y+2,x+-2) < c_b 
                        continue
                       else
                       end
                      elseif image(y+4,x+0) < c_b 
                       continue
                      else
                       if image(y+-3,x+1) > cb 
                       else
                        continue
                       end
                      end
                     end
                    elseif image(y+3,x+1) < c_b 
                     if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                      continue
                     else
                     end
                    else
                     if image(y+3,x+2) > cb 
                      if image(y+1,x+-3) > cb 
                       if image(y+3,x+-1) < c_b
                        continue
                       else
                       end
                      elseif image(y+1,x+-3) < c_b 
                      else
                       if image(y+4,x+-1) > cb 
                        if image(y+4,x+1) > cb 
                        elseif image(y+4,x+1) < c_b 
                         continue
                        else
                         if image(y+-4,x+1) > cb 
                          if image(y+3,x+0) > cb 
                          elseif image(y+3,x+0) < c_b 
                           continue
                          else
                           if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+-4,x+1) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+4,x+-1) < c_b 
                       else
                        if image(y+-2,x+2) > cb 
                         if image(y+0,x+-3) > cb 
                          if image(y+-1,x+4) > cb 
                           if image(y+0,x+-2) > cb 
                            if image(y+-3,x+0) > cb 
                            else
                             continue
                            end
                           elseif image(y+0,x+-2) < c_b 
                            continue
                           else
                            if image(y+1,x+-4) > cb 
                             if image(y+-1,x+2) > cb 
                             else
                              continue
                             end
                            else
                             continue
                            end
                           end
                          elseif image(y+-1,x+4) < c_b 
                           continue
                          else
                           if image(y+2,x+-2) > cb 
                            continue
                           elseif image(y+2,x+-2) < c_b 
                           else
                            if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                             continue
                            else
                            end
                           end
                          end
                         elseif image(y+0,x+-3) < c_b 
                          continue
                         else
                          if image(y+3,x+-2) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+-2,x+2) < c_b 
                         continue
                        else
                         if image(y+-3,x+1) > cb 
                         else
                          continue
                         end
                        end
                       end
                      end
                     elseif image(y+3,x+2) < c_b 
                      continue
                     else
                      if image(y+4,x+-1) > cb 
                       if image(y+-4,x+1) > cb 
                        if image(y+0,x+-2) > cb 
                        elseif image(y+0,x+-2) < c_b 
                         continue
                        else
                         if image(y+3,x+-2) > cb 
                         elseif image(y+3,x+-2) < c_b 
                          continue
                         else
                          if image(y+1,x+-4) > cb 
                          elseif image(y+1,x+-4) < c_b 
                           continue
                          else
                           if image(y+2,x+-1) > cb 
                           else
                            continue
                           end
                          end
                         end
                        end
                       else
                       end
                      elseif image(y+4,x+-1) < c_b 
                      else
                       if image(y+1,x+2) > cb 
                        if image(y+-1,x+2) > cb | image(y+-1,x+2) < c_b 
                         continue
                        else
                        end
                       elseif image(y+1,x+2) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    end
                   end
                  end
                 end
                elseif image(y+-1,x+-4) < c_b 
                else
                 if image(y+1,x+2) > cb 
                  if image(y+3,x+-1) > cb 
                  elseif image(y+3,x+-1) < c_b 
                   if image(y+2,x+-2) > cb 
                    continue
                   elseif image(y+2,x+-2) < c_b 
                   else
                    if image(y+3,x+2) > cb 
                     if image(y+0,x+3) > cb 
                     else
                      continue
                     end
                    elseif image(y+3,x+2) < c_b 
                    else
                     if image(y+-1,x+4) > cb 
                      if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                       continue
                      else
                       if image(y+2,x+-1) > cb 
                        continue
                       elseif image(y+2,x+-1) < c_b 
                        if image(y+4,x+1) > cb 
                         continue
                        elseif image(y+4,x+1) < c_b 
                        else
                         if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                          continue
                         else
                         end
                        end
                       else
                       end
                      end
                     elseif image(y+-1,x+4) < c_b 
                      continue
                     else
                     end
                    end
                   end
                  else
                   if image(y+0,x+2) > cb 
                    if image(y+3,x+2) > cb | image(y+3,x+2) < c_b 
                    else
                     if image(y+1,x+4) > cb 
                      if image(y+-1,x+3) > cb 
                      elseif image(y+-1,x+3) < c_b 
                       continue
                      else
                       if image(y+-2,x+-3) > cb 
                       elseif image(y+-2,x+-3) < c_b 
                        continue
                       else
                        if image(y+-2,x+3) > cb 
                        else
                         continue
                        end
                       end
                      end
                     elseif image(y+1,x+4) < c_b 
                      continue
                     else
                      if image(y+-2,x+0) > cb 
                      elseif image(y+-2,x+0) < c_b 
                       continue
                      else
                       if image(y+2,x+-1) > cb 
                       elseif image(y+2,x+-1) < c_b 
                        continue
                       else
                        if image(y+4,x+0) > cb | image(y+4,x+0) < c_b 
                        else
                         if image(y+2,x+2) > cb 
                          if image(y+-4,x+-1) > cb 
                           if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-4,x+-1) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+0,x+2) < c_b 
                    continue
                   else
                    if image(y+-2,x+-3) > cb 
                     if image(y+-2,x+0) > cb 
                      if image(y+-3,x+0) > cb 
                       if image(y+1,x+3) > cb 
                       elseif image(y+1,x+3) < c_b 
                        continue
                       else
                        if image(y+1,x+-3) > cb 
                         if image(y+-2,x+3) > cb 
                          if image(y+0,x+-4) > cb 
                          else
                           continue
                          end
                         elseif image(y+-2,x+3) < c_b 
                          continue
                         else
                         end
                        else
                        end
                       end
                      elseif image(y+-3,x+0) < c_b 
                       continue
                      else
                       if image(y+0,x+-4) > cb 
                        if image(y+-2,x+2) > cb 
                        else
                         continue
                        end
                       elseif image(y+0,x+-4) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+-2,x+0) < c_b 
                      continue
                     else
                      if image(y+0,x+-2) > cb 
                      elseif image(y+0,x+-2) < c_b 
                       continue
                      else
                       if image(y+4,x+0) > cb 
                       elseif image(y+4,x+0) < c_b 
                        continue
                       else
                        if image(y+2,x+1) > cb 
                         if image(y+-2,x+2) > cb 
                         else
                          continue
                         end
                        else
                         continue
                        end
                       end
                      end
                     end
                    elseif image(y+-2,x+-3) < c_b 
                     continue
                    else
                     if image(y+2,x+1) > cb 
                     elseif image(y+2,x+1) < c_b 
                      continue
                     else
                      if image(y+2,x+-1) > cb 
                      elseif image(y+2,x+-1) < c_b 
                       if image(y+-1,x+4) < c_b
                       else
                        continue
                       end
                      else
                       if image(y+4,x+-1) > cb | image(y+4,x+-1) < c_b 
                       else
                        if image(y+-1,x+4) > cb 
                         if image(y+1,x+-4) > cb 
                          if image(y+-1,x+2) > cb | image(y+-1,x+2) < c_b 
                           continue
                          else
                          end
                         elseif image(y+1,x+-4) < c_b 
                          continue
                         else
                         end
                        elseif image(y+-1,x+4) < c_b 
                         continue
                        else
                         if image(y+-2,x+2) > cb 
                          if image(y+0,x+-4) > cb 
                          elseif image(y+0,x+-4) < c_b 
                           continue
                          else
                           if image(y+1,x+-2) < c_b
                           else
                            continue
                           end
                          end
                         elseif image(y+-2,x+2) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  end
                 elseif image(y+1,x+2) < c_b 
                  if image(y+0,x+-2) > cb 
                  elseif image(y+0,x+-2) < c_b 
                   continue
                  else
                   if image(y+2,x+0) > cb 
                   elseif image(y+2,x+0) < c_b 
                    continue
                   else
                    if image(y+-3,x+2) > cb 
                     if image(y+1,x+4) > cb | image(y+1,x+4) < c_b 
                      continue
                     else
                     end
                    else
                     continue
                    end
                   end
                  end
                 else
                  if image(y+3,x+2) > cb 
                   if image(y+4,x+-1) > cb 
                    if image(y+2,x+1) > cb 
                     if image(y+-3,x+1) > cb 
                     elseif image(y+-3,x+1) < c_b 
                      continue
                     else
                      if image(y+2,x+0) > cb 
                      elseif image(y+2,x+0) < c_b 
                       continue
                      else
                       if image(y+-4,x+0) > cb 
                        if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                         continue
                        else
                        end
                       else
                       end
                      end
                     end
                    elseif image(y+2,x+1) < c_b 
                    else
                     if image(y+-1,x+2) > cb 
                      if image(y+4,x+0) > cb 
                      elseif image(y+4,x+0) < c_b 
                       continue
                      else
                       if image(y+2,x+-2) > cb 
                       elseif image(y+2,x+-2) < c_b 
                        continue
                       else
                        if image(y+3,x+-2) > cb 
                        elseif image(y+3,x+-2) < c_b 
                         continue
                        else
                         if image(y+4,x+1) > cb 
                         elseif image(y+4,x+1) < c_b 
                          continue
                         else
                          if image(y+0,x+3) > cb | image(y+0,x+3) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+-1,x+2) < c_b 
                     else
                      if image(y+-2,x+2) > cb 
                       if image(y+3,x+-2) > cb 
                        if image(y+2,x+-2) > cb 
                        elseif image(y+2,x+-2) < c_b 
                         continue
                        else
                         if image(y+-4,x+-1) > cb 
                          if image(y+2,x+-1) > cb 
                          elseif image(y+2,x+-1) < c_b 
                           continue
                          else
                           if image(y+-1,x+3) > cb 
                            if image(y+2,x+2) > cb 
                             if image(y+-4,x+1) > cb 
                             else
                              continue
                             end
                            elseif image(y+2,x+2) < c_b 
                             continue
                            else
                             if image(y+3,x+1) > cb | image(y+3,x+1) < c_b 
                              continue
                             else
                             end
                            end
                           elseif image(y+-1,x+3) < c_b 
                            continue
                           else
                            if image(y+1,x+-3) > cb 
                            else
                             continue
                            end
                           end
                          end
                         elseif image(y+-4,x+-1) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+3,x+-2) < c_b 
                        continue
                       else
                        if image(y+4,x+1) > cb 
                         if image(y+-3,x+-1) > cb 
                         elseif image(y+-3,x+-1) < c_b 
                          continue
                         else
                          if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+4,x+1) < c_b 
                         continue
                        else
                         if image(y+1,x+4) > cb 
                         elseif image(y+1,x+4) < c_b 
                          continue
                         else
                          if image(y+2,x+-1) > cb 
                          else
                           continue
                          end
                         end
                        end
                       end
                      elseif image(y+-2,x+2) < c_b 
                       continue
                      else
                       if image(y+-2,x+0) > cb 
                       elseif image(y+-2,x+0) < c_b 
                        continue
                       else
                        if image(y+3,x+1) > cb 
                        else
                         continue
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+4,x+-1) < c_b 
                    if image(y+-2,x+-3) > cb 
                    elseif image(y+-2,x+-3) < c_b 
                     continue
                    else
                     if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                      continue
                     else
                     end
                    end
                   else
                    if image(y+2,x+1) > cb 
                     if image(y+-2,x+-2) > cb 
                     elseif image(y+-2,x+-2) < c_b 
                      continue
                     else
                      if image(y+-4,x+1) > cb 
                      else
                       continue
                      end
                     end
                    elseif image(y+2,x+1) < c_b 
                    else
                     if image(y+-2,x+2) > cb 
                      if image(y+0,x+2) > cb 
                      elseif image(y+0,x+2) < c_b 
                       if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                        continue
                       else
                       end
                      else
                       if image(y+2,x+-2) > cb | image(y+2,x+-2) < c_b 
                       else
                        if image(y+0,x+-3) > cb 
                         if image(y+-1,x+4) > cb 
                          if image(y+2,x+-1) > cb | image(y+2,x+-1) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-1,x+4) < c_b 
                         else
                          if image(y+-4,x+-1) > cb 
                           if image(y+1,x+-3) > cb 
                           elseif image(y+1,x+-3) < c_b 
                            continue
                           else
                            if image(y+1,x+-2) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+-4,x+-1) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+0,x+-3) < c_b 
                         continue
                        else
                         if image(y+-4,x+-1) > cb 
                          if image(y+3,x+-2) > cb 
                           if image(y+-1,x+2) > cb 
                           elseif image(y+-1,x+2) < c_b 
                            continue
                           else
                            if image(y+1,x+-2) > cb 
                            elseif image(y+1,x+-2) < c_b 
                             continue
                            else
                             if image(y+0,x+-4) < c_b
                             else
                              continue
                             end
                            end
                           end
                          elseif image(y+3,x+-2) < c_b 
                           if image(y+-1,x+2) > cb 
                           else
                            continue
                           end
                          else
                           if image(y+0,x+-4) > cb 
                            if image(y+-1,x+4) > cb 
                            else
                             continue
                            end
                           elseif image(y+0,x+-4) < c_b 
                            if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                             continue
                            else
                            end
                           else
                            if image(y+1,x+-2) > cb 
                             if image(y+-2,x+3) > cb 
                             elseif image(y+-2,x+3) < c_b 
                              continue
                             else
                              if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                               continue
                              else
                              end
                             end
                            elseif image(y+1,x+-2) < c_b 
                             if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                              continue
                             else
                             end
                            else
                             if image(y+2,x+-1) > cb 
                             elseif image(y+2,x+-1) < c_b 
                              if image(y+-2,x+3) > cb 
                              else
                               continue
                              end
                             else
                              if image(y+1,x+-3) > cb 
                              elseif image(y+1,x+-3) < c_b 
                               continue
                              else
                               if image(y+0,x+-2) > cb 
                                if image(y+-1,x+2) > cb 
                                 if image(y+2,x+2) > cb 
                                  if image(y+3,x+0) > cb 
                                  else
                                   continue
                                  end
                                 elseif image(y+2,x+2) < c_b 
                                  continue
                                 else
                                 end
                                else
                                 continue
                                end
                               elseif image(y+0,x+-2) < c_b 
                                continue
                               else
                                if image(y+2,x+0) > cb 
                                elseif image(y+2,x+0) < c_b 
                                 continue
                                else
                                 if image(y+4,x+0) > cb 
                                  if image(y+4,x+1) > cb | image(y+4,x+1) < c_b 
                                   continue
                                  else
                                  end
                                 else
                                  continue
                                 end
                                end
                               end
                              end
                             end
                            end
                           end
                          end
                         elseif image(y+-4,x+-1) < c_b 
                          continue
                         else
                          if image(y+2,x+2) > cb 
                          elseif image(y+2,x+2) < c_b 
                           continue
                          else
                           if image(y+3,x+1) > cb 
                           elseif image(y+3,x+1) < c_b 
                            continue
                           else
                            if image(y+0,x+-4) > cb 
                             if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                              continue
                             else
                             end
                            elseif image(y+0,x+-4) < c_b 
                            else
                             if image(y+2,x+-1) > cb 
                             else
                              continue
                             end
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+-2,x+2) < c_b 
                      continue
                     else
                      if image(y+-1,x+3) > cb 
                       if image(y+0,x+-3) > cb 
                        if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                         continue
                        else
                        end
                       elseif image(y+0,x+-3) < c_b 
                        continue
                       else
                        if image(y+-2,x+0) > cb 
                         if image(y+0,x+-4) > cb 
                         else
                          continue
                         end
                        elseif image(y+-2,x+0) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+-1,x+3) < c_b 
                       if image(y+1,x+-3) > cb 
                       elseif image(y+1,x+-3) < c_b 
                        continue
                       else
                        if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                         continue
                        else
                        end
                       end
                      else
                       if image(y+-3,x+1) > cb 
                       elseif image(y+-3,x+1) < c_b 
                        continue
                       else
                        if image(y+2,x+-2) > cb 
                        elseif image(y+2,x+-2) < c_b 
                         continue
                        else
                         if image(y+0,x+-3) > cb 
                          if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                           continue
                          else
                          end
                         elseif image(y+0,x+-3) < c_b 
                          continue
                         else
                          if image(y+0,x+4) > cb 
                          else
                           continue
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+3,x+2) < c_b 
                   if image(y+-4,x+1) > cb 
                   else
                    continue
                   end
                  else
                   if image(y+4,x+-1) > cb 
                    if image(y+4,x+0) > cb 
                     if image(y+-1,x+3) > cb | image(y+-1,x+3) < c_b 
                     else
                      if image(y+-2,x+2) > cb 
                       if image(y+4,x+1) > cb 
                       elseif image(y+4,x+1) < c_b 
                        continue
                       else
                        if image(y+2,x+-1) > cb 
                        elseif image(y+2,x+-1) < c_b 
                         continue
                        else
                         if image(y+1,x+4) > cb 
                          if image(y+2,x+-2) > cb | image(y+2,x+-2) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        end
                       end
                      elseif image(y+-2,x+2) < c_b 
                       continue
                      else
                      end
                     end
                    elseif image(y+4,x+0) < c_b 
                     continue
                    else
                     if image(y+3,x+-2) > cb 
                      if image(y+1,x+3) > cb 
                      elseif image(y+1,x+3) < c_b 
                       continue
                      else
                       if image(y+1,x+4) > cb 
                        if image(y+-1,x+-3) > cb 
                        else
                         continue
                        end
                       elseif image(y+1,x+4) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+3,x+-2) < c_b 
                      continue
                     else
                      if image(y+1,x+-2) > cb 
                      elseif image(y+1,x+-2) < c_b 
                       continue
                      else
                       if image(y+-4,x+-1) > cb 
                        if image(y+2,x+-1) > cb 
                        elseif image(y+2,x+-1) < c_b 
                         continue
                        else
                         if image(y+1,x+-3) > cb 
                         elseif image(y+1,x+-3) < c_b 
                          continue
                         else
                          if image(y+0,x+3) > cb 
                           if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                            continue
                           else
                           end
                          elseif image(y+0,x+3) < c_b 
                           continue
                          else
                           if image(y+-1,x+2) > cb 
                           elseif image(y+-1,x+2) < c_b 
                            continue
                           else
                            if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
                             continue
                            else
                             if image(y+-4,x+1) > cb 
                             else
                              continue
                             end
                            end
                           end
                          end
                         end
                        end
                       elseif image(y+-4,x+-1) < c_b 
                        continue
                       else
                        if image(y+-2,x+3) > cb 
                        elseif image(y+-2,x+3) < c_b 
                         continue
                        else
                         if image(y+-2,x+-3) > cb 
                         else
                          continue
                         end
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+4,x+-1) < c_b 
                    if image(y+-2,x+2) > cb 
                     if image(y+0,x+-2) > cb 
                      if image(y+0,x+3) > cb 
                      else
                       continue
                      end
                     elseif image(y+0,x+-2) < c_b 
                      continue
                     else
                      if image(y+-1,x+3) > cb 
                       if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                        continue
                       else
                        if image(y+4,x+0) < c_b
                         if image(y+2,x+0) > cb 
                          continue
                         elseif image(y+2,x+0) < c_b 
                          if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                           continue
                          else
                           if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                            continue
                           else
                           end
                          end
                         else
                          if image(y+-1,x+2) > cb 
                          else
                           continue
                          end
                         end
                        else
                         continue
                        end
                       end
                      else
                       continue
                      end
                     end
                    elseif image(y+-2,x+2) < c_b 
                     continue
                    else
                     if image(y+-3,x+1) > cb 
                      if image(y+-1,x+3) > cb 
                       if image(y+-2,x+3) > cb 
                       else
                        continue
                       end
                      elseif image(y+-1,x+3) < c_b 
                       continue
                      else
                      end
                     else
                      continue
                     end
                    end
                   else
                   end
                  end
                 end
                end
               elseif image(y+-1,x+-2) < c_b 
                if image(y+3,x+2) > cb 
                 if image(y+2,x+1) > cb 
                 elseif image(y+2,x+1) < c_b 
                  continue
                 else
                  if image(y+1,x+-4) > cb 
                  elseif image(y+1,x+-4) < c_b 
                   if image(y+4,x+-1) > cb | image(y+4,x+-1) < c_b 
                   else
                    continue
                   end
                  else
                   if image(y+-2,x+2) > cb 
                   elseif image(y+-2,x+2) < c_b 
                    continue
                   else
                    if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                     continue
                    else
                    end
                   end
                  end
                 end
                elseif image(y+3,x+2) < c_b 
                 if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                  continue
                 else
                  if image(y+1,x+2) > cb 
                   if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                    continue
                   else
                   end
                  else
                   continue
                  end
                 end
                else
                 if image(y+4,x+-1) > cb 
                  if image(y+2,x+-1) > cb | image(y+2,x+-1) < c_b 
                   continue
                  else
                  end
                 elseif image(y+4,x+-1) < c_b 
                  if image(y+-2,x+-3) > cb 
                  elseif image(y+-2,x+-3) < c_b 
                   continue
                  else
                   if image(y+0,x+-2) < c_b
                   else
                    continue
                   end
                  end
                 else
                  if image(y+-1,x+-4) > cb 
                   continue
                  elseif image(y+-1,x+-4) < c_b 
                  else
                   if image(y+-2,x+-3) > cb 
                    continue
                   elseif image(y+-2,x+-3) < c_b 
                    if image(y+4,x+1) < c_b
                    else
                     continue
                    end
                   else
                   end
                  end
                 end
                end
               else
                if image(y+2,x+1) > cb 
                 if image(y+-2,x+2) > cb 
                  if image(y+4,x+1) > cb 
                   if image(y+-1,x+-4) > cb 
                   elseif image(y+-1,x+-4) < c_b 
                    if image(y+1,x+3) > cb 
                    elseif image(y+1,x+3) < c_b 
                     continue
                    else
                     if image(y+4,x+-1) > cb 
                     elseif image(y+4,x+-1) < c_b 
                      continue
                     else
                      if image(y+1,x+2) > cb 
                      elseif image(y+1,x+2) < c_b 
                       continue
                      else
                       if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                        continue
                       else
                        if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     end
                    end
                   else
                    if image(y+4,x+0) > cb 
                    elseif image(y+4,x+0) < c_b 
                     continue
                    else
                     if image(y+1,x+4) > cb 
                     elseif image(y+1,x+4) < c_b 
                      continue
                     else
                      if image(y+-2,x+-2) > cb 
                      elseif image(y+-2,x+-2) < c_b 
                       continue
                      else
                       if image(y+-2,x+0) > cb 
                        if image(y+1,x+-2) > cb 
                        elseif image(y+1,x+-2) < c_b 
                         if image(y+-2,x+-3) > cb 
                         else
                          continue
                         end
                        else
                         if image(y+-4,x+-1) > cb 
                         elseif image(y+-4,x+-1) < c_b 
                          continue
                         else
                          if image(y+-4,x+0) > cb 
                           if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-4,x+0) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+-2,x+0) < c_b 
                        continue
                       else
                        if image(y+-1,x+2) > cb | image(y+-1,x+2) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+4,x+1) < c_b 
                  else
                   if image(y+1,x+4) > cb 
                    if image(y+0,x+2) > cb 
                     if image(y+1,x+-2) > cb 
                     elseif image(y+1,x+-2) < c_b 
                      if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                      else
                       if image(y+2,x+-2) > cb 
                        continue
                       elseif image(y+2,x+-2) < c_b 
                       else
                        if image(y+1,x+-3) > cb 
                         continue
                        elseif image(y+1,x+-3) < c_b 
                         if image(y+3,x+1) > cb 
                          if image(y+-1,x+4) > cb | image(y+-1,x+4) < c_b 
                           continue
                          else
                          end
                         elseif image(y+3,x+1) < c_b 
                          continue
                         else
                          if image(y+-2,x+-2) > cb 
                          elseif image(y+-2,x+-2) < c_b 
                           continue
                          else
                           if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        else
                         if image(y+-3,x+0) > cb 
                         else
                          continue
                         end
                        end
                       end
                      end
                     else
                      if image(y+4,x+-1) > cb 
                       if image(y+-2,x+-3) > cb 
                        if image(y+-2,x+0) > cb 
                        elseif image(y+-2,x+0) < c_b 
                         continue
                        else
                         if image(y+-3,x+2) > cb 
                         elseif image(y+-3,x+2) < c_b 
                          continue
                         else
                          if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+-2,x+-3) < c_b 
                        continue
                       else
                        if image(y+-1,x+-4) > cb 
                         if image(y+-1,x+4) > cb 
                         elseif image(y+-1,x+4) < c_b 
                          continue
                         else
                          if image(y+0,x+-4) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+-1,x+-4) < c_b 
                         continue
                        else
                         if image(y+-3,x+-1) > cb 
                          if image(y+-3,x+1) > cb 
                          elseif image(y+-3,x+1) < c_b 
                           continue
                          else
                           if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                            continue
                           else
                           end
                          end
                         else
                          continue
                         end
                        end
                       end
                      elseif image(y+4,x+-1) < c_b 
                      else
                       if image(y+-4,x+0) > cb 
                       elseif image(y+-4,x+0) < c_b 
                        continue
                       else
                        if image(y+1,x+3) > cb 
                         if image(y+-2,x+0) > cb 
                         elseif image(y+-2,x+0) < c_b 
                          continue
                         else
                          if image(y+-3,x+2) > cb 
                          elseif image(y+-3,x+2) < c_b 
                           continue
                          else
                           if image(y+-4,x+1) < c_b
                           else
                            continue
                           end
                          end
                         end
                        else
                         continue
                        end
                       end
                      end
                     end
                    elseif image(y+0,x+2) < c_b 
                     continue
                    else
                     if image(y+-2,x+-2) > cb 
                      if image(y+-4,x+0) > cb 
                       if image(y+-2,x+0) > cb 
                        if image(y+3,x+-1) < c_b
                         continue
                        else
                        end
                       elseif image(y+-2,x+0) < c_b 
                        continue
                       else
                        if image(y+-2,x+-3) > cb 
                         if image(y+-3,x+-1) > cb 
                          if image(y+-2,x+3) > cb 
                           if image(y+0,x+4) > cb 
                           elseif image(y+0,x+4) < c_b 
                            continue
                           else
                            if image(y+2,x+0) > cb | image(y+2,x+0) < c_b 
                             continue
                            else
                            end
                           end
                          else
                           continue
                          end
                         else
                          continue
                         end
                        else
                         continue
                        end
                       end
                      elseif image(y+-4,x+0) < c_b 
                       continue
                      else
                       if image(y+2,x+-1) > cb 
                        if image(y+1,x+3) > cb 
                        elseif image(y+1,x+3) < c_b 
                         continue
                        else
                         if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+2,x+-1) < c_b 
                        continue
                       else
                        if image(y+-2,x+0) > cb 
                         if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                         else
                          if image(y+3,x+2) > cb 
                           if image(y+1,x+2) > cb 
                            if image(y+-3,x+0) > cb 
                             if image(y+-2,x+-3) > cb 
                             elseif image(y+-2,x+-3) < c_b 
                              continue
                             else
                              if image(y+-4,x+-1) > cb 
                              else
                               continue
                              end
                             end
                            elseif image(y+-3,x+0) < c_b 
                             continue
                            else
                             if image(y+1,x+-2) > cb 
                             else
                              continue
                             end
                            end
                           elseif image(y+1,x+2) < c_b 
                            continue
                           else
                            if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                             continue
                            else
                            end
                           end
                          elseif image(y+3,x+2) < c_b 
                           continue
                          else
                           if image(y+4,x+-1) > cb 
                            if image(y+-1,x+4) > cb 
                             if image(y+-1,x+2) > cb 
                             else
                              continue
                             end
                            elseif image(y+-1,x+4) < c_b 
                             continue
                            else
                            end
                           elseif image(y+4,x+-1) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        else
                         continue
                        end
                       end
                      end
                     elseif image(y+-2,x+-2) < c_b 
                      continue
                     else
                      if image(y+2,x+0) > cb 
                       if image(y+-3,x+2) > cb 
                       elseif image(y+-3,x+2) < c_b 
                        continue
                       else
                        if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+2,x+0) < c_b 
                       continue
                      else
                       if image(y+-1,x+2) > cb 
                        if image(y+4,x+-1) > cb 
                         if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                          continue
                         else
                         end
                        elseif image(y+4,x+-1) < c_b 
                         continue
                        else
                         if image(y+-1,x+-4) > cb 
                          if image(y+0,x+3) > cb 
                          else
                           continue
                          end
                         else
                         end
                        end
                       elseif image(y+-1,x+2) < c_b 
                        continue
                       else
                        if image(y+3,x+2) > cb 
                         if image(y+-4,x+1) > cb 
                          if image(y+0,x+-4) > cb 
                           if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                            continue
                           else
                            if image(y+0,x+3) > cb 
                            else
                             continue
                            end
                           end
                          else
                           continue
                          end
                         elseif image(y+-4,x+1) < c_b 
                          continue
                         else
                         end
                        elseif image(y+3,x+2) < c_b 
                         continue
                        else
                         if image(y+4,x+-1) > cb 
                          if image(y+-4,x+-1) > cb 
                          else
                           continue
                          end
                         elseif image(y+4,x+-1) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+1,x+4) < c_b 
                    continue
                   else
                    if image(y+-3,x+-1) > cb 
                    elseif image(y+-3,x+-1) < c_b 
                     continue
                    else
                     if image(y+-2,x+-2) > cb 
                     elseif image(y+-2,x+-2) < c_b 
                      continue
                     else
                      if image(y+3,x+0) > cb 
                      elseif image(y+3,x+0) < c_b 
                       continue
                      else
                       if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    end
                   end
                  end
                 elseif image(y+-2,x+2) < c_b 
                 else
                  if image(y+4,x+-1) > cb 
                   if image(y+2,x+2) > cb 
                    if image(y+0,x+-4) > cb 
                     if image(y+1,x+2) > cb 
                     elseif image(y+1,x+2) < c_b 
                      continue
                     else
                      if image(y+4,x+1) > cb 
                       if image(y+-4,x+0) > cb 
                       elseif image(y+-4,x+0) < c_b 
                        continue
                       else
                        if image(y+-2,x+-3) > cb 
                        else
                         continue
                        end
                       end
                      elseif image(y+4,x+1) < c_b 
                       continue
                      else
                       if image(y+-4,x+-1) > cb 
                        if image(y+-1,x+4) > cb | image(y+-1,x+4) < c_b 
                         continue
                        else
                        end
                       else
                        continue
                       end
                      end
                     end
                    elseif image(y+0,x+-4) < c_b 
                     if image(y+-3,x+2) > cb 
                      if image(y+1,x+-4) > cb 
                       continue
                      elseif image(y+1,x+-4) < c_b 
                       if image(y+3,x+-1) > cb 
                       else
                        continue
                       end
                      else
                      end
                     elseif image(y+-3,x+2) < c_b 
                      continue
                     else
                     end
                    else
                     if image(y+4,x+1) > cb 
                      if image(y+-1,x+3) > cb 
                       if image(y+0,x+3) > cb 
                       elseif image(y+0,x+3) < c_b 
                        continue
                       else
                        if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                         continue
                        else
                        end
                       end
                      else
                      end
                     elseif image(y+4,x+1) < c_b 
                      continue
                     else
                      if image(y+1,x+4) > cb 
                      elseif image(y+1,x+4) < c_b 
                       continue
                      else
                       if image(y+3,x+-2) > cb 
                       elseif image(y+3,x+-2) < c_b 
                        continue
                       else
                        if image(y+1,x+2) > cb 
                        elseif image(y+1,x+2) < c_b 
                         continue
                        else
                         if image(y+2,x+-1) > cb 
                         else
                          continue
                         end
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+2,x+2) < c_b 
                    continue
                   else
                    if image(y+0,x+-2) > cb 
                     continue
                    elseif image(y+0,x+-2) < c_b 
                    else
                     if image(y+-1,x+-4) > cb 
                      if image(y+-4,x+0) > cb 
                       if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                        continue
                       else
                       end
                      else
                       continue
                      end
                     elseif image(y+-1,x+-4) < c_b 
                      continue
                     else
                      if image(y+-2,x+-3) > cb 
                      elseif image(y+-2,x+-3) < c_b 
                       continue
                      else
                       if image(y+-2,x+-2) > cb 
                        if image(y+0,x+-4) > cb 
                        else
                         continue
                        end
                       elseif image(y+-2,x+-2) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+4,x+-1) < c_b 
                   if image(y+3,x+0) > cb 
                    continue
                   elseif image(y+3,x+0) < c_b 
                    if image(y+-1,x+3) > cb 
                    else
                     continue
                    end
                   else
                   end
                  else
                   if image(y+1,x+2) > cb 
                    if image(y+0,x+-3) > cb 
                     if image(y+0,x+2) > cb 
                     elseif image(y+0,x+2) < c_b 
                      continue
                     else
                      if image(y+0,x+4) > cb 
                      elseif image(y+0,x+4) < c_b 
                       continue
                      else
                       if image(y+2,x+-1) > cb | image(y+2,x+-1) < c_b 
                       else
                        if image(y+-2,x+0) > cb 
                         if image(y+3,x+2) > cb 
                          if image(y+-2,x+-3) > cb 
                          elseif image(y+-2,x+-3) < c_b 
                           continue
                          else
                           if image(y+-1,x+-3) > cb 
                            if image(y+1,x+-3) > cb 
                            else
                             continue
                            end
                           elseif image(y+-1,x+-3) < c_b 
                            continue
                           else
                           end
                          end
                         else
                          continue
                         end
                        else
                         continue
                        end
                       end
                      end
                     end
                    elseif image(y+0,x+-3) < c_b 
                     if image(y+1,x+-4) > cb 
                      continue
                     elseif image(y+1,x+-4) < c_b 
                      if image(y+3,x+0) > cb | image(y+3,x+0) < c_b 
                       continue
                      else
                       if image(y+-4,x+1) > cb 
                        if image(y+-3,x+2) > cb 
                        else
                         continue
                        end
                       elseif image(y+-4,x+1) < c_b 
                        continue
                       else
                       end
                      end
                     else
                     end
                    else
                     if image(y+-4,x+-1) > cb 
                      if image(y+0,x+2) > cb 
                      elseif image(y+0,x+2) < c_b 
                       continue
                      else
                       if image(y+-1,x+-4) > cb 
                        if image(y+-2,x+0) > cb 
                         if image(y+1,x+-4) > cb 
                          if image(y+-1,x+-3) > cb 
                           if image(y+-2,x+-3) > cb 
                           else
                            continue
                           end
                          elseif image(y+-1,x+-3) < c_b 
                           continue
                          else
                           if image(y+1,x+4) > cb 
                           elseif image(y+1,x+4) < c_b 
                            continue
                           else
                            if image(y+2,x+-1) > cb 
                             continue
                            elseif image(y+2,x+-1) < c_b 
                             if image(y+1,x+-2) < c_b
                             else
                              continue
                             end
                            else
                            end
                           end
                          end
                         elseif image(y+1,x+-4) < c_b 
                          continue
                         else
                         end
                        elseif image(y+-2,x+0) < c_b 
                         continue
                        else
                         if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+-1,x+-4) < c_b 
                        if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                         continue
                        else
                        end
                       else
                        if image(y+1,x+-4) > cb 
                         if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                          continue
                         else
                         end
                        else
                        end
                       end
                      end
                     elseif image(y+-4,x+-1) < c_b 
                      continue
                     else
                      if image(y+-2,x+-3) > cb 
                      elseif image(y+-2,x+-3) < c_b 
                       continue
                      else
                       if image(y+0,x+2) > cb 
                       elseif image(y+0,x+2) < c_b 
                        continue
                       else
                        if image(y+-2,x+3) > cb 
                        elseif image(y+-2,x+3) < c_b 
                         continue
                        else
                         if image(y+-1,x+3) > cb 
                         elseif image(y+-1,x+3) < c_b 
                          continue
                         else
                          if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                           continue
                          else
                           if image(y+4,x+0) > cb 
                           elseif image(y+4,x+0) < c_b 
                            continue
                           else
                            if image(y+1,x+4) > cb 
                             if image(y+3,x+2) > cb | image(y+3,x+2) < c_b 
                              continue
                             else
                             end
                            else
                             continue
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+1,x+2) < c_b 
                    continue
                   else
                    if image(y+2,x+-1) > cb | image(y+2,x+-1) < c_b 
                    else
                     if image(y+3,x+2) > cb 
                      if image(y+-1,x+4) > cb 
                       if image(y+1,x+-2) > cb 
                       elseif image(y+1,x+-2) < c_b 
                        continue
                       else
                        if image(y+-1,x+3) > cb 
                         if image(y+0,x+4) > cb 
                          if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        else
                         continue
                        end
                       end
                      elseif image(y+-1,x+4) < c_b 
                      else
                       if image(y+3,x+-2) > cb 
                        if image(y+2,x+2) > cb 
                        elseif image(y+2,x+2) < c_b 
                         continue
                        else
                         if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                          continue
                         else
                          if image(y+-4,x+-1) > cb 
                          else
                           continue
                          end
                         end
                        end
                       elseif image(y+3,x+-2) < c_b 
                        continue
                       else
                        if image(y+2,x+0) > cb 
                         if image(y+-4,x+-1) > cb 
                          if image(y+4,x+1) > cb 
                          elseif image(y+4,x+1) < c_b 
                           continue
                          else
                           if image(y+-2,x+-2) > cb 
                            if image(y+0,x+-2) > cb 
                            else
                             continue
                            end
                           elseif image(y+-2,x+-2) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+-4,x+-1) < c_b 
                          continue
                         else
                          if image(y+-1,x+3) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+2,x+0) < c_b 
                         continue
                        else
                         if image(y+1,x+-3) > cb 
                         elseif image(y+1,x+-3) < c_b 
                          continue
                         else
                          if image(y+1,x+4) > cb 
                           if image(y+4,x+1) > cb | image(y+4,x+1) < c_b 
                            continue
                           else
                            if image(y+-2,x+-2) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+1,x+4) < c_b 
                           continue
                          else
                           if image(y+2,x+-2) < c_b
                           else
                            continue
                           end
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+3,x+2) < c_b 
                      continue
                     else
                     end
                    end
                   end
                  end
                 end
                elseif image(y+2,x+1) < c_b 
                 if image(y+4,x+-1) > cb 
                  if image(y+3,x+1) > cb 
                   continue
                  elseif image(y+3,x+1) < c_b 
                   if image(y+-4,x+0) > cb 
                    if image(y+2,x+-2) > cb | image(y+2,x+-2) < c_b 
                     continue
                    else
                    end
                   else
                    continue
                   end
                  else
                  end
                 elseif image(y+4,x+-1) < c_b 
                  if image(y+1,x+2) > cb 
                   if image(y+1,x+-4) > cb 
                   elseif image(y+1,x+-4) < c_b 
                    if image(y+-2,x+-3) > cb 
                    else
                     continue
                    end
                   else
                    if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                     continue
                    else
                     if image(y+4,x+0) > cb 
                      continue
                     elseif image(y+4,x+0) < c_b 
                     else
                      if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                       continue
                      else
                      end
                     end
                    end
                   end
                  elseif image(y+1,x+2) < c_b 
                  else
                   if image(y+4,x+1) > cb 
                   elseif image(y+4,x+1) < c_b 
                    continue
                   else
                    if image(y+-2,x+-3) > cb 
                     if image(y+3,x+-2) > cb 
                      continue
                     elseif image(y+3,x+-2) < c_b 
                      if image(y+3,x+2) > cb 
                       if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                        continue
                       else
                       end
                      else
                       continue
                      end
                     else
                      if image(y+-2,x+-2) > cb 
                      else
                       continue
                      end
                     end
                    else
                     continue
                    end
                   end
                  end
                 else
                  if image(y+3,x+2) > cb 
                   if image(y+2,x+-2) > cb 
                    continue
                   elseif image(y+2,x+-2) < c_b 
                   else
                    if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                     continue
                    else
                    end
                   end
                  elseif image(y+3,x+2) < c_b 
                   if image(y+1,x+2) > cb 
                    if image(y+3,x+0) > cb 
                     continue
                    elseif image(y+3,x+0) < c_b 
                    else
                     if image(y+0,x+-4) > cb 
                      continue
                     elseif image(y+0,x+-4) < c_b 
                     else
                      if image(y+4,x+1) < c_b
                      else
                       continue
                      end
                     end
                    end
                   else
                    continue
                   end
                  else
                   if image(y+-1,x+3) < c_b
                    continue
                   else
                   end
                  end
                 end
                else
                 if image(y+0,x+3) > cb 
                  if image(y+-2,x+-2) > cb 
                   if image(y+0,x+2) > cb 
                    if image(y+4,x+-1) > cb 
                     if image(y+4,x+1) > cb 
                      if image(y+3,x+-1) > cb 
                       if image(y+-1,x+-4) > cb 
                        if image(y+1,x+2) > cb 
                         if image(y+-2,x+-3) > cb 
                         elseif image(y+-2,x+-3) < c_b 
                          continue
                         else
                          if image(y+-2,x+3) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+1,x+2) < c_b 
                         continue
                        else
                         if image(y+1,x+-4) > cb 
                         elseif image(y+1,x+-4) < c_b 
                          continue
                         else
                          if image(y+3,x+-2) > cb 
                           if image(y+3,x+1) > cb 
                            if image(y+2,x+2) > cb 
                             if image(y+-3,x+0) > cb 
                             else
                              continue
                             end
                            elseif image(y+2,x+2) < c_b 
                             continue
                            else
                             if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                              continue
                             else
                             end
                            end
                           elseif image(y+3,x+1) < c_b 
                            continue
                           else
                           end
                          elseif image(y+3,x+-2) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       else
                       end
                      else
                      end
                     elseif image(y+4,x+1) < c_b 
                     else
                      if image(y+1,x+2) > cb 
                       if image(y+-2,x+-3) > cb 
                       elseif image(y+-2,x+-3) < c_b 
                        continue
                       else
                        if image(y+-1,x+2) > cb 
                         if image(y+2,x+-2) < c_b
                          continue
                         else
                         end
                        elseif image(y+-1,x+2) < c_b 
                         continue
                        else
                         if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                          continue
                         else
                          if image(y+3,x+2) > cb 
                          elseif image(y+3,x+2) < c_b 
                           continue
                          else
                           if image(y+-2,x+2) > cb 
                            if image(y+2,x+2) > cb | image(y+2,x+2) < c_b 
                             continue
                            else
                            end
                           elseif image(y+-2,x+2) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        end
                       end
                      elseif image(y+1,x+2) < c_b 
                       continue
                      else
                       if image(y+3,x+-2) > cb 
                       elseif image(y+3,x+-2) < c_b 
                        continue
                       else
                        if image(y+4,x+0) > cb 
                         if image(y+1,x+-3) > cb 
                         elseif image(y+1,x+-3) < c_b 
                          continue
                         else
                          if image(y+-4,x+1) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+4,x+0) < c_b 
                         continue
                        else
                         if image(y+-1,x+-4) > cb 
                          if image(y+-3,x+2) > cb 
                           if image(y+-4,x+-1) > cb 
                            if image(y+-2,x+-3) > cb 
                             if image(y+1,x+-4) > cb 
                             elseif image(y+1,x+-4) < c_b 
                              continue
                             else
                              if image(y+-1,x+-3) > cb 
                               if image(y+0,x+-3) > cb 
                               else
                                continue
                               end
                              elseif image(y+-1,x+-3) < c_b 
                               continue
                              else
                              end
                             end
                            else
                             continue
                            end
                           else
                            continue
                           end
                          elseif image(y+-3,x+2) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-1,x+-4) < c_b 
                         else
                          if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+4,x+-1) < c_b 
                     if image(y+3,x+2) > cb | image(y+3,x+2) < c_b 
                     else
                      if image(y+1,x+2) > cb 
                       if image(y+3,x+-1) > cb 
                        continue
                       elseif image(y+3,x+-1) < c_b 
                        if image(y+1,x+-2) > cb 
                        elseif image(y+1,x+-2) < c_b 
                         if image(y+-2,x+-3) > cb 
                          if image(y+2,x+-2) > cb 
                           continue
                          elseif image(y+2,x+-2) < c_b 
                          else
                           if image(y+1,x+-3) < c_b
                           else
                            continue
                           end
                          end
                         elseif image(y+-2,x+-3) < c_b 
                          continue
                         else
                          if image(y+-1,x+-4) < c_b
                          else
                           continue
                          end
                         end
                        else
                         if image(y+1,x+-4) > cb 
                          if image(y+4,x+0) < c_b
                          else
                           continue
                          end
                         elseif image(y+1,x+-4) < c_b 
                          continue
                         else
                          if image(y+2,x+2) > cb 
                           if image(y+4,x+1) > cb 
                            continue
                           elseif image(y+4,x+1) < c_b 
                           else
                            if image(y+2,x+-1) > cb 
                             continue
                            elseif image(y+2,x+-1) < c_b 
                             if image(y+0,x+4) > cb 
                              if image(y+-2,x+-3) > cb 
                               if image(y+2,x+-2) < c_b
                               else
                                continue
                               end
                              else
                               continue
                              end
                             elseif image(y+0,x+4) < c_b 
                              continue
                             else
                             end
                            else
                             if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                              continue
                             else
                             end
                            end
                           end
                          elseif image(y+2,x+2) < c_b 
                           continue
                          else
                           if image(y+-3,x+0) > cb 
                            if image(y+3,x+-2) > cb 
                             continue
                            elseif image(y+3,x+-2) < c_b 
                             if image(y+3,x+0) < c_b
                              if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                              else
                               if image(y+2,x+-2) > cb 
                                continue
                               elseif image(y+2,x+-2) < c_b 
                                if image(y+-2,x+-3) > cb 
                                else
                                 continue
                                end
                               else
                                if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                                 continue
                                else
                                 if image(y+-2,x+2) > cb 
                                  if image(y+2,x+-1) < c_b
                                  else
                                   continue
                                  end
                                 elseif image(y+-2,x+2) < c_b 
                                  continue
                                 else
                                 end
                                end
                               end
                              end
                             else
                              continue
                             end
                            else
                             if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                              continue
                             else
                              if image(y+2,x+-1) > cb | image(y+2,x+-1) < c_b 
                               continue
                              else
                              end
                             end
                            end
                           elseif image(y+-3,x+0) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        end
                       else
                        if image(y+-2,x+-3) > cb 
                        elseif image(y+-2,x+-3) < c_b 
                         continue
                        else
                         if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                          continue
                         else
                          if image(y+2,x+-1) > cb 
                           continue
                          elseif image(y+2,x+-1) < c_b 
                           if image(y+2,x+0) < c_b
                           else
                            continue
                           end
                          else
                          end
                         end
                        end
                       end
                      elseif image(y+1,x+2) < c_b 
                       continue
                      else
                       if image(y+0,x+-3) > cb | image(y+0,x+-3) < c_b 
                       else
                        if image(y+4,x+0) > cb 
                         continue
                        elseif image(y+4,x+0) < c_b 
                         if image(y+4,x+1) > cb | image(y+4,x+1) < c_b 
                          continue
                         else
                          if image(y+3,x+-2) > cb 
                           continue
                          elseif image(y+3,x+-2) < c_b 
                           if image(y+1,x+4) > cb | image(y+1,x+4) < c_b 
                            continue
                           else
                            if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                             continue
                            else
                            end
                           end
                          else
                           if image(y+2,x+-1) > cb | image(y+2,x+-1) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        else
                         if image(y+1,x+-4) > cb 
                         elseif image(y+1,x+-4) < c_b 
                          continue
                         else
                          if image(y+-1,x+3) > cb | image(y+-1,x+3) < c_b 
                           continue
                          else
                           if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    else
                     if image(y+1,x+-2) > cb 
                     elseif image(y+1,x+-2) < c_b 
                      if image(y+-2,x+-3) > cb 
                       if image(y+1,x+2) > cb 
                        if image(y+4,x+0) < c_b
                         if image(y+-1,x+-4) > cb 
                         elseif image(y+-1,x+-4) < c_b 
                          continue
                         else
                          if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                           continue
                          else
                          end
                         end
                        else
                        end
                       elseif image(y+1,x+2) < c_b 
                        continue
                       else
                        if image(y+3,x+2) > cb 
                         if image(y+1,x+-3) > cb 
                          continue
                         elseif image(y+1,x+-3) < c_b 
                          if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                           continue
                          else
                          end
                         else
                         end
                        elseif image(y+3,x+2) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+-2,x+-3) < c_b 
                       continue
                      else
                       if image(y+4,x+1) > cb 
                        if image(y+2,x+2) > cb 
                        elseif image(y+2,x+2) < c_b 
                         continue
                        else
                         if image(y+-1,x+-4) > cb 
                          continue
                         elseif image(y+-1,x+-4) < c_b 
                         else
                          if image(y+2,x+-2) < c_b
                          else
                           continue
                          end
                         end
                        end
                       elseif image(y+4,x+1) < c_b 
                       else
                        if image(y+1,x+2) > cb 
                         if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                         else
                          if image(y+3,x+2) > cb 
                           if image(y+2,x+-1) > cb 
                            continue
                           elseif image(y+2,x+-1) < c_b 
                           else
                            if image(y+0,x+-3) > cb | image(y+0,x+-3) < c_b 
                             continue
                            else
                             if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                              continue
                             else
                             end
                            end
                           end
                          elseif image(y+3,x+2) < c_b 
                           continue
                          else
                           if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        elseif image(y+1,x+2) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     else
                      if image(y+-2,x+0) > cb 
                       if image(y+2,x+-1) > cb 
                       elseif image(y+2,x+-1) < c_b 
                        if image(y+3,x+2) > cb 
                        elseif image(y+3,x+2) < c_b 
                         continue
                        else
                         if image(y+-2,x+-3) > cb 
                          if image(y+3,x+-1) > cb 
                           continue
                          elseif image(y+3,x+-1) < c_b 
                           if image(y+-4,x+-1) > cb 
                            if image(y+-1,x+-4) > cb 
                            elseif image(y+-1,x+-4) < c_b 
                             continue
                            else
                             if image(y+2,x+-2) > cb 
                              continue
                             elseif image(y+2,x+-2) < c_b 
                             else
                              if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                               continue
                              else
                               if image(y+0,x+-4) > cb 
                               elseif image(y+0,x+-4) < c_b 
                                continue
                               else
                                if image(y+2,x+2) > cb | image(y+2,x+2) < c_b 
                                 continue
                                else
                                end
                               end
                              end
                             end
                            end
                           elseif image(y+-4,x+-1) < c_b 
                            continue
                           else
                            if image(y+2,x+-2) < c_b
                            else
                             continue
                            end
                           end
                          else
                          end
                         elseif image(y+-2,x+-3) < c_b 
                          continue
                         else
                          if image(y+1,x+2) > cb 
                           if image(y+4,x+0) > cb 
                            continue
                           elseif image(y+4,x+0) < c_b 
                           else
                            if image(y+1,x+4) > cb | image(y+1,x+4) < c_b 
                             continue
                            else
                            end
                           end
                          elseif image(y+1,x+2) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       else
                        if image(y+-2,x+-3) > cb 
                         if image(y+1,x+-3) > cb 
                         elseif image(y+1,x+-3) < c_b 
                          if image(y+1,x+2) > cb 
                          elseif image(y+1,x+2) < c_b 
                           continue
                          else
                           if image(y+3,x+2) > cb | image(y+3,x+2) < c_b 
                            continue
                           else
                           end
                          end
                         else
                          if image(y+3,x+-1) > cb 
                           if image(y+2,x+2) > cb 
                           elseif image(y+2,x+2) < c_b 
                            continue
                           else
                            if image(y+4,x+1) > cb 
                             continue
                            elseif image(y+4,x+1) < c_b 
                            else
                             if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                              continue
                             else
                             end
                            end
                           end
                          elseif image(y+3,x+-1) < c_b 
                           if image(y+3,x+-2) > cb 
                            continue
                           elseif image(y+3,x+-2) < c_b 
                            if image(y+2,x+2) > cb 
                            elseif image(y+2,x+2) < c_b 
                             continue
                            else
                             if image(y+-1,x+-4) > cb 
                             elseif image(y+-1,x+-4) < c_b 
                              continue
                             else
                              if image(y+1,x+2) > cb | image(y+1,x+2) < c_b 
                               continue
                              else
                              end
                             end
                            end
                           else
                           end
                          else
                          end
                         end
                        elseif image(y+-2,x+-3) < c_b 
                         continue
                        else
                         if image(y+-1,x+2) > cb 
                          if image(y+1,x+4) > cb 
                           if image(y+-2,x+3) > cb 
                           elseif image(y+-2,x+3) < c_b 
                            continue
                           else
                            if image(y+3,x+-1) > cb 
                             if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                              continue
                             else
                             end
                            elseif image(y+3,x+-1) < c_b 
                             continue
                            else
                             if image(y+-4,x+-1) > cb 
                             elseif image(y+-4,x+-1) < c_b 
                              continue
                             else
                              if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                               continue
                              else
                              end
                             end
                            end
                           end
                          elseif image(y+1,x+4) < c_b 
                           continue
                          else
                           if image(y+0,x+4) > cb 
                            if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                             continue
                            else
                             if image(y+1,x+2) > cb 
                              if image(y+-3,x+1) > cb 
                               if image(y+2,x+2) > cb 
                               elseif image(y+2,x+2) < c_b 
                                continue
                               else
                                if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                                 continue
                                else
                                end
                               end
                              else
                               continue
                              end
                             elseif image(y+1,x+2) < c_b 
                              continue
                             else
                             end
                            end
                           elseif image(y+0,x+4) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+-1,x+2) < c_b 
                          continue
                         else
                          if image(y+-2,x+3) > cb 
                           if image(y+3,x+2) > cb 
                           elseif image(y+3,x+2) < c_b 
                            continue
                           else
                            if image(y+-1,x+3) > cb 
                             if image(y+1,x+2) > cb 
                              if image(y+-1,x+-4) < c_b
                              else
                               continue
                              end
                             elseif image(y+1,x+2) < c_b 
                              continue
                             else
                             end
                            elseif image(y+-1,x+3) < c_b 
                             continue
                            else
                            end
                           end
                          elseif image(y+-2,x+3) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       end
                      elseif image(y+-2,x+0) < c_b 
                       continue
                      else
                       if image(y+1,x+4) > cb 
                        if image(y+4,x+1) > cb 
                         if image(y+3,x+2) > cb 
                         elseif image(y+3,x+2) < c_b 
                          continue
                         else
                          if image(y+-1,x+-4) > cb 
                           if image(y+-4,x+1) > cb 
                            if image(y+1,x+2) > cb 
                             if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                              continue
                             else
                             end
                            elseif image(y+1,x+2) < c_b 
                             continue
                            else
                            end
                           elseif image(y+-4,x+1) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-1,x+-4) < c_b 
                           continue
                          else
                           if image(y+1,x+2) > cb | image(y+1,x+2) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        elseif image(y+4,x+1) < c_b 
                        else
                         if image(y+-1,x+2) > cb 
                          if image(y+2,x+-1) > cb 
                          elseif image(y+2,x+-1) < c_b 
                           if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                            continue
                           else
                           end
                          else
                           if image(y+-3,x+-1) > cb 
                           elseif image(y+-3,x+-1) < c_b 
                            continue
                           else
                            if image(y+-2,x+3) > cb 
                             if image(y+3,x+-2) > cb 
                              continue
                             elseif image(y+3,x+-2) < c_b 
                              if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                               continue
                              else
                              end
                             else
                             end
                            else
                             continue
                            end
                           end
                          end
                         elseif image(y+-1,x+2) < c_b 
                          continue
                         else
                          if image(y+3,x+2) > cb 
                          elseif image(y+3,x+2) < c_b 
                           continue
                          else
                           if image(y+-2,x+2) > cb 
                            if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                             continue
                            else
                             if image(y+-4,x+-1) > cb 
                              if image(y+1,x+2) > cb | image(y+1,x+2) < c_b 
                               continue
                              else
                              end
                             elseif image(y+-4,x+-1) < c_b 
                              continue
                             else
                             end
                            end
                           elseif image(y+-2,x+2) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        end
                       elseif image(y+1,x+4) < c_b 
                        continue
                       else
                        if image(y+3,x+2) > cb 
                        elseif image(y+3,x+2) < c_b 
                         continue
                        else
                         if image(y+1,x+2) > cb 
                          if image(y+-1,x+-4) > cb 
                           if image(y+-4,x+-1) > cb 
                           else
                            continue
                           end
                          elseif image(y+-1,x+-4) < c_b 
                           continue
                          else
                           if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                            continue
                           else
                            if image(y+-4,x+1) > cb 
                            else
                             continue
                            end
                           end
                          end
                         elseif image(y+1,x+2) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+0,x+2) < c_b 
                    continue
                   else
                    if image(y+3,x+2) > cb 
                     if image(y+4,x+-1) > cb 
                      if image(y+4,x+0) > cb 
                       if image(y+3,x+-2) > cb 
                        if image(y+3,x+1) > cb 
                         if image(y+2,x+2) > cb 
                          if image(y+-4,x+1) > cb 
                           if image(y+-2,x+-3) > cb 
                           elseif image(y+-2,x+-3) < c_b 
                            continue
                           else
                            if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                             continue
                            else
                            end
                           end
                          elseif image(y+-4,x+1) < c_b 
                          else
                           if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+2,x+2) < c_b 
                          continue
                         else
                          if image(y+-1,x+2) > cb 
                           if image(y+-1,x+-4) > cb 
                            if image(y+1,x+-4) > cb 
                            elseif image(y+1,x+-4) < c_b 
                             continue
                            else
                             if image(y+-3,x+2) > cb 
                              if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                               continue
                              else
                              end
                             elseif image(y+-3,x+2) < c_b 
                              continue
                             else
                             end
                            end
                           elseif image(y+-1,x+-4) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-1,x+2) < c_b 
                           continue
                          else
                           if image(y+-2,x+2) > cb 
                            if image(y+2,x+-1) > cb 
                            elseif image(y+2,x+-1) < c_b 
                             continue
                            else
                             if image(y+3,x+-1) < c_b
                              continue
                             else
                              if image(y+-4,x+0) > cb 
                              else
                               continue
                              end
                             end
                            end
                           elseif image(y+-2,x+2) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        elseif image(y+3,x+1) < c_b 
                         continue
                        else
                        end
                       elseif image(y+3,x+-2) < c_b 
                        continue
                       else
                        if image(y+4,x+1) > cb 
                        elseif image(y+4,x+1) < c_b 
                         continue
                        else
                         if image(y+-2,x+-3) > cb 
                          if image(y+-4,x+0) > cb 
                          else
                           continue
                          end
                         elseif image(y+-2,x+-3) < c_b 
                          continue
                         else
                          if image(y+1,x+2) > cb 
                           if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                            continue
                           else
                            if image(y+-3,x+2) > cb 
                             if image(y+0,x+-4) > cb 
                             else
                              continue
                             end
                            elseif image(y+-3,x+2) < c_b 
                             continue
                            else
                            end
                           end
                          elseif image(y+1,x+2) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       end
                      elseif image(y+4,x+0) < c_b 
                       continue
                      else
                       if image(y+4,x+1) > cb 
                       elseif image(y+4,x+1) < c_b 
                        continue
                       else
                        if image(y+1,x+2) > cb 
                         if image(y+-2,x+-3) > cb 
                         elseif image(y+-2,x+-3) < c_b 
                          continue
                         else
                          if image(y+-1,x+3) > cb 
                          elseif image(y+-1,x+3) < c_b 
                           continue
                          else
                           if image(y+-3,x+2) > cb 
                            if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                             continue
                            else
                             if image(y+-1,x+2) > cb 
                             else
                              continue
                             end
                            end
                           elseif image(y+-3,x+2) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        elseif image(y+1,x+2) < c_b 
                         continue
                        else
                         if image(y+3,x+-2) > cb 
                          if image(y+3,x+1) > cb 
                           if image(y+-1,x+2) > cb 
                           else
                            continue
                           end
                          elseif image(y+3,x+1) < c_b 
                           continue
                          else
                          end
                         elseif image(y+3,x+-2) < c_b 
                          continue
                         else
                          if image(y+-1,x+2) > cb 
                           if image(y+1,x+-4) > cb 
                           elseif image(y+1,x+-4) < c_b 
                            continue
                           else
                            if image(y+2,x+2) > cb 
                             if image(y+-2,x+3) > cb 
                             else
                              continue
                             end
                            else
                             continue
                            end
                           end
                          else
                           continue
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+4,x+-1) < c_b 
                      if image(y+2,x+-2) > cb 
                       continue
                      elseif image(y+2,x+-2) < c_b 
                      else
                       if image(y+4,x+0) < c_b
                        if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                         continue
                        else
                        end
                       else
                        continue
                       end
                      end
                     else
                      if image(y+1,x+2) > cb 
                       if image(y+-2,x+-3) > cb 
                        if image(y+-2,x+0) > cb 
                         if image(y+-3,x+0) > cb 
                          if image(y+3,x+-1) < c_b
                           continue
                          else
                          end
                         else
                          continue
                         end
                        elseif image(y+-2,x+0) < c_b 
                         continue
                        else
                         if image(y+4,x+0) > cb 
                         elseif image(y+4,x+0) < c_b 
                          continue
                         else
                          if image(y+2,x+2) > cb | image(y+2,x+2) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+-2,x+-3) < c_b 
                        continue
                       else
                        if image(y+4,x+1) > cb 
                         if image(y+1,x+4) > cb 
                          if image(y+-1,x+2) > cb 
                          elseif image(y+-1,x+2) < c_b 
                           continue
                          else
                           if image(y+-4,x+1) > cb 
                            if image(y+-3,x+2) > cb 
                             if image(y+0,x+4) > cb 
                              if image(y+1,x+-4) > cb 
                               if image(y+-1,x+-4) > cb 
                               else
                                continue
                               end
                              elseif image(y+1,x+-4) < c_b 
                               continue
                              else
                              end
                             elseif image(y+0,x+4) < c_b 
                              continue
                             else
                              if image(y+3,x+1) > cb 
                              else
                               continue
                              end
                             end
                            elseif image(y+-3,x+2) < c_b 
                             continue
                            else
                            end
                           elseif image(y+-4,x+1) < c_b 
                            continue
                           else
                            if image(y+-2,x+2) > cb 
                            else
                             continue
                            end
                           end
                          end
                         elseif image(y+1,x+4) < c_b 
                          continue
                         else
                          if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+4,x+1) < c_b 
                         continue
                        else
                         if image(y+-2,x+2) > cb 
                          if image(y+-1,x+2) > cb 
                           if image(y+-4,x+-1) > cb 
                            if image(y+-2,x+0) > cb 
                             if image(y+2,x+2) > cb 
                              if image(y+-2,x+3) > cb 
                              else
                               continue
                              end
                             else
                              continue
                             end
                            else
                             continue
                            end
                           else
                            continue
                           end
                          elseif image(y+-1,x+2) < c_b 
                           continue
                          else
                           if image(y+1,x+-4) > cb 
                            if image(y+-2,x+3) > cb 
                             if image(y+-1,x+-4) > cb 
                             else
                              continue
                             end
                            elseif image(y+-2,x+3) < c_b 
                             continue
                            else
                            end
                           else
                            continue
                           end
                          end
                         elseif image(y+-2,x+2) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      elseif image(y+1,x+2) < c_b 
                       continue
                      else
                       if image(y+-1,x+2) > cb 
                        if image(y+2,x+2) > cb 
                         if image(y+-4,x+-1) > cb 
                          if image(y+-1,x+-4) > cb 
                           if image(y+0,x+-4) > cb 
                            if image(y+-4,x+0) > cb 
                             if image(y+0,x+4) > cb 
                             elseif image(y+0,x+4) < c_b 
                              continue
                             else
                              if image(y+1,x+-4) > cb 
                              else
                               continue
                              end
                             end
                            elseif image(y+-4,x+0) < c_b 
                             continue
                            else
                             if image(y+-2,x+0) > cb 
                             else
                              continue
                             end
                            end
                           elseif image(y+0,x+-4) < c_b 
                            continue
                           else
                            if image(y+3,x+-2) > cb 
                            elseif image(y+3,x+-2) < c_b 
                             continue
                            else
                             if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                              continue
                             else
                              if image(y+-1,x+4) > cb 
                              else
                               continue
                              end
                             end
                            end
                           end
                          elseif image(y+-1,x+-4) < c_b 
                           if image(y+-1,x+3) > cb 
                           else
                            continue
                           end
                          else
                           if image(y+-2,x+0) > cb 
                            if image(y+2,x+-1) > cb 
                            elseif image(y+2,x+-1) < c_b 
                             continue
                            else
                             if image(y+-3,x+1) > cb 
                             elseif image(y+-3,x+1) < c_b 
                              continue
                             else
                              if image(y+-4,x+1) > cb 
                              else
                               continue
                              end
                             end
                            end
                           else
                            continue
                           end
                          end
                         elseif image(y+-4,x+-1) < c_b 
                          continue
                         else
                          if image(y+2,x+-1) > cb | image(y+2,x+-1) < c_b 
                          else
                           if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        elseif image(y+2,x+2) < c_b 
                         continue
                        else
                         if image(y+0,x+-4) > cb 
                          if image(y+-4,x+0) > cb 
                           if image(y+-1,x+4) > cb 
                            if image(y+3,x+-1) > cb 
                             if image(y+-1,x+-4) > cb 
                             else
                              continue
                             end
                            elseif image(y+3,x+-1) < c_b 
                             continue
                            else
                            end
                           elseif image(y+-1,x+4) < c_b 
                            continue
                           else
                            if image(y+1,x+-4) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+-4,x+0) < c_b 
                           continue
                          else
                           if image(y+1,x+-4) > cb 
                           else
                            continue
                           end
                          end
                         elseif image(y+0,x+-4) < c_b 
                         else
                          if image(y+3,x+-1) > cb 
                           if image(y+2,x+-1) > cb 
                           elseif image(y+2,x+-1) < c_b 
                            continue
                           else
                            if image(y+3,x+-2) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+3,x+-1) < c_b 
                           if image(y+2,x+-2) < c_b
                           else
                            continue
                           end
                          else
                           if image(y+3,x+-2) > cb 
                           elseif image(y+3,x+-2) < c_b 
                            continue
                           else
                            if image(y+2,x+-1) > cb 
                            elseif image(y+2,x+-1) < c_b 
                             continue
                            else
                             if image(y+0,x+-3) > cb 
                              continue
                             elseif image(y+0,x+-3) < c_b 
                             else
                              if image(y+2,x+-2) > cb 
                               continue
                              elseif image(y+2,x+-2) < c_b 
                              else
                               if image(y+-2,x+3) > cb 
                                if image(y+1,x+-4) > cb 
                                 if image(y+-1,x+-4) > cb 
                                  if image(y+-3,x+2) > cb 
                                  else
                                   continue
                                  end
                                 else
                                  continue
                                 end
                                else
                                 continue
                                end
                               elseif image(y+-2,x+3) < c_b 
                                continue
                               else
                                if image(y+4,x+0) > cb 
                                 if image(y+4,x+1) > cb | image(y+4,x+1) < c_b 
                                  continue
                                 else
                                 end
                                else
                                 continue
                                end
                               end
                              end
                             end
                            end
                           end
                          end
                         end
                        end
                       elseif image(y+-1,x+2) < c_b 
                        continue
                       else
                        if image(y+3,x+-2) > cb 
                         if image(y+3,x+0) > cb 
                          if image(y+-1,x+4) > cb 
                           if image(y+4,x+0) > cb 
                           elseif image(y+4,x+0) < c_b 
                            continue
                           else
                            if image(y+-1,x+-4) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+-1,x+4) < c_b 
                           continue
                          else
                          end
                         elseif image(y+3,x+0) < c_b 
                          continue
                         else
                         end
                        elseif image(y+3,x+-2) < c_b 
                         if image(y+0,x+-4) < c_b
                          continue
                         else
                         end
                        else
                         if image(y+1,x+-3) > cb 
                          if image(y+0,x+-4) > cb 
                          else
                           continue
                          end
                         elseif image(y+1,x+-3) < c_b 
                          if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                           continue
                          else
                          end
                         else
                          if image(y+2,x+-2) > cb | image(y+2,x+-2) < c_b 
                          else
                           if image(y+0,x+-4) > cb 
                            if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                             continue
                            else
                             if image(y+-1,x+4) > cb 
                             else
                              continue
                             end
                            end
                           elseif image(y+0,x+-4) < c_b 
                           else
                            if image(y+0,x+-3) > cb 
                             if image(y+-1,x+4) > cb 
                             else
                              continue
                             end
                            elseif image(y+0,x+-3) < c_b 
                            else
                             if image(y+3,x+-1) > cb 
                              if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                               continue
                              else
                              end
                             else
                              continue
                             end
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+3,x+2) < c_b 
                     continue
                    else
                     if image(y+4,x+-1) > cb 
                      if image(y+4,x+0) > cb 
                       if image(y+-4,x+1) > cb 
                        if image(y+1,x+2) > cb 
                         if image(y+-2,x+-3) > cb 
                         elseif image(y+-2,x+-3) < c_b 
                          continue
                         else
                          if image(y+-1,x+4) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+1,x+2) < c_b 
                         continue
                        else
                        end
                       elseif image(y+-4,x+1) < c_b 
                        continue
                       else
                        if image(y+4,x+1) > cb 
                        elseif image(y+4,x+1) < c_b 
                         continue
                        else
                         if image(y+2,x+-1) > cb 
                         elseif image(y+2,x+-1) < c_b 
                          continue
                         else
                          if image(y+3,x+-2) > cb 
                          else
                           continue
                          end
                         end
                        end
                       end
                      elseif image(y+4,x+0) < c_b 
                       continue
                      else
                       if image(y+3,x+-2) > cb 
                        if image(y+2,x+-2) > cb 
                         if image(y+-4,x+1) > cb 
                         else
                          continue
                         end
                        elseif image(y+2,x+-2) < c_b 
                         continue
                        else
                        end
                       elseif image(y+3,x+-2) < c_b 
                        continue
                       else
                        if image(y+4,x+1) > cb 
                        elseif image(y+4,x+1) < c_b 
                         continue
                        else
                         if image(y+-1,x+2) > cb 
                          if image(y+1,x+-4) > cb 
                           if image(y+-2,x+-3) > cb 
                           elseif image(y+-2,x+-3) < c_b 
                            continue
                           else
                            if image(y+0,x+-3) > cb | image(y+0,x+-3) < c_b 
                             continue
                            else
                            end
                           end
                          elseif image(y+1,x+-4) < c_b 
                           continue
                          else
                           if image(y+2,x+2) > cb 
                           else
                            continue
                           end
                          end
                         elseif image(y+-1,x+2) < c_b 
                          continue
                         else
                          if image(y+1,x+2) > cb 
                           if image(y+-2,x+-3) > cb 
                           else
                            continue
                           end
                          else
                           continue
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+4,x+-1) < c_b 
                      if image(y+3,x+-2) > cb 
                       continue
                      elseif image(y+3,x+-2) < c_b 
                       if image(y+1,x+2) > cb 
                        if image(y+2,x+-2) < c_b
                         if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                          continue
                         else
                         end
                        else
                         continue
                        end
                       else
                        continue
                       end
                      else
                       if image(y+4,x+0) > cb 
                        continue
                       elseif image(y+4,x+0) < c_b 
                        if image(y+2,x+-1) > cb 
                        elseif image(y+2,x+-1) < c_b 
                         continue
                        else
                         if image(y+4,x+1) > cb 
                          continue
                         elseif image(y+4,x+1) < c_b 
                          if image(y+1,x+2) > cb 
                          else
                           continue
                          end
                         else
                         end
                        end
                       else
                        if image(y+1,x+-4) > cb 
                        elseif image(y+1,x+-4) < c_b 
                         continue
                        else
                         if image(y+2,x+2) > cb 
                          if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        end
                       end
                      end
                     else
                      if image(y+1,x+2) > cb 
                       if image(y+-2,x+-3) > cb 
                        if image(y+-2,x+0) > cb 
                        elseif image(y+-2,x+0) < c_b 
                         continue
                        else
                         if image(y+-1,x+-4) > cb 
                          if image(y+-4,x+-1) > cb 
                          else
                           continue
                          end
                         else
                          continue
                         end
                        end
                       elseif image(y+-2,x+-3) < c_b 
                        continue
                       else
                        if image(y+-2,x+2) > cb 
                         if image(y+-4,x+0) > cb 
                          if image(y+2,x+2) > cb 
                           if image(y+-1,x+2) > cb 
                           elseif image(y+-1,x+2) < c_b 
                            continue
                           else
                            if image(y+-4,x+1) > cb 
                             if image(y+1,x+-4) > cb 
                             else
                              continue
                             end
                            elseif image(y+-4,x+1) < c_b 
                             continue
                            else
                            end
                           end
                          elseif image(y+2,x+2) < c_b 
                           continue
                          else
                           if image(y+3,x+-2) > cb 
                           else
                            continue
                           end
                          end
                         elseif image(y+-4,x+0) < c_b 
                          continue
                         else
                         end
                        elseif image(y+-2,x+2) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+1,x+2) < c_b 
                       continue
                      else
                      end
                     end
                    end
                   end
                  elseif image(y+-2,x+-2) < c_b 
                   continue
                  else
                   if image(y+2,x+2) > cb 
                    if image(y+-1,x+2) > cb 
                     if image(y+3,x+2) > cb 
                      if image(y+1,x+-3) > cb 
                      elseif image(y+1,x+-3) < c_b 
                       if image(y+1,x+-4) > cb 
                        continue
                       elseif image(y+1,x+-4) < c_b 
                        if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                        else
                         if image(y+4,x+0) > cb 
                          if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                           continue
                          else
                          end
                         elseif image(y+4,x+0) < c_b 
                          continue
                         else
                          if image(y+2,x+-2) < c_b
                          else
                           continue
                          end
                         end
                        end
                       else
                        if image(y+4,x+1) > cb 
                        elseif image(y+4,x+1) < c_b 
                         continue
                        else
                         if image(y+3,x+1) > cb | image(y+3,x+1) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      else
                       if image(y+0,x+2) > cb 
                       elseif image(y+0,x+2) < c_b 
                        continue
                       else
                        if image(y+-4,x+0) > cb 
                         if image(y+-1,x+-4) > cb 
                          if image(y+0,x+-4) > cb 
                          elseif image(y+0,x+-4) < c_b 
                           continue
                          else
                           if image(y+-2,x+-3) > cb 
                            if image(y+2,x+-1) > cb | image(y+2,x+-1) < c_b 
                            else
                             if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                              continue
                             else
                             end
                            end
                           elseif image(y+-2,x+-3) < c_b 
                            continue
                           else
                            if image(y+3,x+-2) > cb 
                            elseif image(y+3,x+-2) < c_b 
                             continue
                            else
                             if image(y+4,x+-1) > cb 
                              if image(y+-2,x+3) > cb 
                              else
                               continue
                              end
                             else
                              continue
                             end
                            end
                           end
                          end
                         elseif image(y+-1,x+-4) < c_b 
                         else
                          if image(y+-2,x+0) > cb 
                           if image(y+2,x+-1) > cb | image(y+2,x+-1) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-2,x+0) < c_b 
                           continue
                          else
                           if image(y+4,x+-1) > cb 
                           else
                            continue
                           end
                          end
                         end
                        elseif image(y+-4,x+0) < c_b 
                         continue
                        else
                         if image(y+4,x+-1) > cb 
                         elseif image(y+4,x+-1) < c_b 
                          continue
                         else
                          if image(y+-4,x+-1) > cb 
                           if image(y+-3,x+1) > cb 
                           else
                            continue
                           end
                          else
                           continue
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+3,x+2) < c_b 
                      continue
                     else
                      if image(y+-2,x+0) > cb 
                       if image(y+1,x+-2) > cb 
                        continue
                       elseif image(y+1,x+-2) < c_b 
                        if image(y+4,x+1) > cb 
                        elseif image(y+4,x+1) < c_b 
                         if image(y+1,x+-4) > cb 
                          continue
                         elseif image(y+1,x+-4) < c_b 
                          if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                           continue
                          else
                          end
                         else
                         end
                        else
                         if image(y+-1,x+-4) > cb 
                          continue
                         elseif image(y+-1,x+-4) < c_b 
                          if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                           continue
                          else
                          end
                         else
                          if image(y+-1,x+4) > cb 
                           if image(y+-4,x+-1) > cb 
                            if image(y+-2,x+-3) > cb 
                            else
                             continue
                            end
                           elseif image(y+-4,x+-1) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-1,x+4) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       else
                        if image(y+2,x+-1) > cb 
                        elseif image(y+2,x+-1) < c_b 
                         if image(y+-3,x+2) > cb 
                          if image(y+4,x+1) < c_b
                           if image(y+2,x+-2) > cb | image(y+2,x+-2) < c_b 
                            continue
                           else
                           end
                          else
                           continue
                          end
                         elseif image(y+-3,x+2) < c_b 
                          continue
                         else
                         end
                        else
                         if image(y+-4,x+-1) > cb 
                          if image(y+3,x+-2) > cb 
                          elseif image(y+3,x+-2) < c_b 
                           if image(y+-1,x+-4) < c_b
                           else
                            continue
                           end
                          else
                           if image(y+1,x+-3) < c_b
                            if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                             continue
                            else
                            end
                           else
                           end
                          end
                         elseif image(y+-4,x+-1) < c_b 
                          continue
                         else
                          if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                           continue
                          else
                           if image(y+-3,x+-1) > cb 
                           else
                            continue
                           end
                          end
                         end
                        end
                       end
                      elseif image(y+-2,x+0) < c_b 
                       continue
                      else
                       if image(y+-2,x+3) > cb 
                        if image(y+-1,x+-4) < c_b
                        else
                         continue
                        end
                       elseif image(y+-2,x+3) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    elseif image(y+-1,x+2) < c_b 
                     continue
                    else
                     if image(y+0,x+2) > cb 
                      if image(y+3,x+2) > cb 
                      elseif image(y+3,x+2) < c_b 
                       continue
                      else
                       if image(y+-1,x+4) > cb 
                        if image(y+4,x+1) > cb 
                        else
                         continue
                        end
                       elseif image(y+-1,x+4) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+0,x+2) < c_b 
                      continue
                     else
                      if image(y+-2,x+2) > cb 
                       if image(y+3,x+0) > cb 
                       elseif image(y+3,x+0) < c_b 
                        continue
                       else
                        if image(y+0,x+-4) > cb 
                         if image(y+1,x+-4) > cb 
                          if image(y+1,x+2) > cb 
                           if image(y+-1,x+-4) > cb 
                           elseif image(y+-1,x+-4) < c_b 
                            continue
                           else
                            if image(y+-1,x+3) > cb | image(y+-1,x+3) < c_b 
                             continue
                            else
                            end
                           end
                          elseif image(y+1,x+2) < c_b 
                           continue
                          else
                           if image(y+-2,x+3) > cb 
                            if image(y+4,x+1) > cb 
                            elseif image(y+4,x+1) < c_b 
                             continue
                            else
                             if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                              continue
                             else
                             end
                            end
                           else
                            continue
                           end
                          end
                         else
                          continue
                         end
                        elseif image(y+0,x+-4) < c_b 
                        else
                         if image(y+4,x+-1) > cb 
                          if image(y+4,x+1) > cb 
                          elseif image(y+4,x+1) < c_b 
                           continue
                          else
                           if image(y+-2,x+-3) > cb 
                           else
                            continue
                           end
                          end
                         elseif image(y+4,x+-1) < c_b 
                          if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                           continue
                          else
                          end
                         else
                          if image(y+3,x+2) > cb 
                           if image(y+1,x+2) > cb 
                            if image(y+4,x+1) > cb 
                             if image(y+1,x+4) > cb 
                              if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                               continue
                              else
                               if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                                continue
                               else
                               end
                              end
                             else
                              continue
                             end
                            elseif image(y+4,x+1) < c_b 
                             continue
                            else
                             if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                              continue
                             else
                             end
                            end
                           elseif image(y+1,x+2) < c_b 
                            continue
                           else
                            if image(y+3,x+-2) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+3,x+2) < c_b 
                           continue
                          else
                           if image(y+1,x+2) > cb 
                            if image(y+-4,x+1) > cb 
                             if image(y+-2,x+-3) > cb 
                             else
                              continue
                             end
                            elseif image(y+-4,x+1) < c_b 
                             continue
                            else
                            end
                           elseif image(y+1,x+2) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        end
                       end
                      elseif image(y+-2,x+2) < c_b 
                       continue
                      else
                       if image(y+1,x+2) > cb 
                        if image(y+3,x+-2) > cb 
                         if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                          continue
                         else
                         end
                        elseif image(y+3,x+-2) < c_b 
                        else
                         if image(y+-4,x+-1) > cb 
                         elseif image(y+-4,x+-1) < c_b 
                          continue
                         else
                          if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+1,x+2) < c_b 
                        continue
                       else
                        if image(y+3,x+2) > cb 
                         if image(y+0,x+-4) > cb 
                          if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                           continue
                          else
                          end
                         elseif image(y+0,x+-4) < c_b 
                         else
                          if image(y+3,x+-2) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+3,x+2) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+2,x+2) < c_b 
                    continue
                   else
                    if image(y+1,x+2) > cb 
                     if image(y+-1,x+4) > cb 
                      if image(y+4,x+1) > cb 
                       if image(y+3,x+-1) > cb 
                       elseif image(y+3,x+-1) < c_b 
                        continue
                       else
                        if image(y+-1,x+-4) > cb 
                         if image(y+-2,x+-3) > cb 
                         elseif image(y+-2,x+-3) < c_b 
                          continue
                         else
                          if image(y+3,x+2) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+-1,x+-4) < c_b 
                        else
                         if image(y+-2,x+-3) < c_b
                          continue
                         else
                         end
                        end
                       end
                      elseif image(y+4,x+1) < c_b 
                       if image(y+1,x+-4) > cb 
                       elseif image(y+1,x+-4) < c_b 
                        if image(y+4,x+-1) > cb | image(y+4,x+-1) < c_b 
                         continue
                        else
                         if image(y+3,x+2) > cb | image(y+3,x+2) < c_b 
                          continue
                         else
                         end
                        end
                       else
                        if image(y+0,x+-4) > cb 
                         continue
                        else
                        end
                       end
                      else
                       if image(y+-1,x+-4) > cb 
                        if image(y+3,x+2) > cb 
                        elseif image(y+3,x+2) < c_b 
                         continue
                        else
                         if image(y+-3,x+0) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+-1,x+-4) < c_b 
                        if image(y+4,x+-1) < c_b
                         if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                          continue
                         else
                          if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                           continue
                          else
                          end
                         end
                        else
                        end
                       else
                        if image(y+-4,x+1) > cb 
                         if image(y+-2,x+-3) > cb 
                         elseif image(y+-2,x+-3) < c_b 
                          continue
                         else
                          if image(y+3,x+2) < c_b
                           continue
                          else
                           if image(y+3,x+-2) > cb 
                           elseif image(y+3,x+-2) < c_b 
                            continue
                           else
                            if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
                             continue
                            else
                            end
                           end
                          end
                         end
                        elseif image(y+-4,x+1) < c_b 
                         continue
                        else
                         if image(y+-2,x+0) > cb 
                          if image(y+4,x+-1) > cb | image(y+4,x+-1) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        end
                       end
                      end
                     elseif image(y+-1,x+4) < c_b 
                     else
                      if image(y+1,x+-4) > cb 
                       if image(y+0,x+4) > cb 
                        if image(y+0,x+-2) > cb 
                        else
                         continue
                        end
                       elseif image(y+0,x+4) < c_b 
                        continue
                       else
                       end
                      elseif image(y+1,x+-4) < c_b 
                       if image(y+4,x+0) > cb | image(y+4,x+0) < c_b 
                        continue
                       else
                        if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                         continue
                        else
                        end
                       end
                      else
                       if image(y+-3,x+2) > cb 
                        if image(y+-1,x+-4) > cb 
                         continue
                        elseif image(y+-1,x+-4) < c_b 
                        else
                         if image(y+0,x+2) > cb 
                          if image(y+3,x+-1) > cb 
                           if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                            continue
                           else
                           end
                          else
                          end
                         elseif image(y+0,x+2) < c_b 
                          continue
                         else
                          if image(y+-1,x+2) > cb | image(y+-1,x+2) < c_b 
                           continue
                          else
                           if image(y+-2,x+2) > cb 
                            if image(y+2,x+-2) > cb 
                            else
                             continue
                            end
                           elseif image(y+-2,x+2) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        end
                       elseif image(y+-3,x+2) < c_b 
                       else
                        if image(y+3,x+1) > cb 
                         if image(y+-3,x+0) > cb 
                         else
                          continue
                         end
                        else
                        end
                       end
                      end
                     end
                    elseif image(y+1,x+2) < c_b 
                     continue
                    else
                     if image(y+3,x+2) > cb 
                      if image(y+0,x+2) > cb 
                       if image(y+1,x+-3) > cb 
                        if image(y+-3,x+0) > cb 
                        else
                         continue
                        end
                       elseif image(y+1,x+-3) < c_b 
                        if image(y+2,x+-2) < c_b
                        else
                         continue
                        end
                       else
                        if image(y+1,x+-2) > cb 
                         continue
                        else
                        end
                       end
                      elseif image(y+0,x+2) < c_b 
                       continue
                      else
                       if image(y+4,x+-1) > cb 
                        if image(y+4,x+0) > cb 
                         if image(y+0,x+-4) > cb 
                          if image(y+-2,x+3) > cb 
                           if image(y+-1,x+3) > cb 
                            if image(y+-1,x+2) > cb 
                             if image(y+1,x+-4) > cb 
                             else
                              continue
                             end
                            elseif image(y+-1,x+2) < c_b 
                             continue
                            else
                            end
                           elseif image(y+-1,x+3) < c_b 
                            continue
                           else
                            if image(y+-1,x+-3) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+-2,x+3) < c_b 
                           continue
                          else
                          end
                         elseif image(y+0,x+-4) < c_b 
                          continue
                         else
                          if image(y+-2,x+0) > cb 
                          elseif image(y+-2,x+0) < c_b 
                           continue
                          else
                           if image(y+3,x+-1) > cb 
                           else
                            continue
                           end
                          end
                         end
                        elseif image(y+4,x+0) < c_b 
                         continue
                        else
                         if image(y+3,x+-2) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+4,x+-1) < c_b 
                        if image(y+-2,x+-3) > cb 
                        else
                         continue
                        end
                       else
                        if image(y+0,x+-4) > cb 
                         if image(y+-1,x+2) > cb 
                          if image(y+-1,x+4) > cb 
                          elseif image(y+-1,x+4) < c_b 
                           continue
                          else
                           if image(y+0,x+-3) > cb 
                           else
                            continue
                           end
                          end
                         elseif image(y+-1,x+2) < c_b 
                          continue
                         else
                          if image(y+-1,x+-4) > cb 
                           if image(y+-1,x+-3) > cb 
                           else
                            continue
                           end
                          elseif image(y+-1,x+-4) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+0,x+-4) < c_b 
                         if image(y+0,x+-3) > cb 
                          continue
                         elseif image(y+0,x+-3) < c_b 
                          if image(y+0,x+-2) < c_b
                          else
                           continue
                          end
                         else
                         end
                        else
                         if image(y+2,x+-2) > cb 
                          if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                           continue
                          else
                          end
                         elseif image(y+2,x+-2) < c_b 
                         else
                          if image(y+1,x+-3) > cb 
                          elseif image(y+1,x+-3) < c_b 
                           continue
                          else
                           if image(y+1,x+-2) > cb 
                           elseif image(y+1,x+-2) < c_b 
                            continue
                           else
                            if image(y+3,x+-2) > cb 
                            else
                             continue
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+3,x+2) < c_b 
                      continue
                     else
                      if image(y+4,x+-1) > cb 
                       if image(y+4,x+1) > cb 
                       elseif image(y+4,x+1) < c_b 
                        continue
                       else
                        if image(y+3,x+-2) > cb 
                         if image(y+-1,x+3) > cb 
                         elseif image(y+-1,x+3) < c_b 
                          continue
                         else
                          if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+3,x+-2) < c_b 
                         continue
                        else
                         if image(y+0,x+-4) < c_b
                         else
                          if image(y+1,x+-2) > cb 
                          else
                           continue
                          end
                         end
                        end
                       end
                      elseif image(y+4,x+-1) < c_b 
                       if image(y+0,x+-4) > cb 
                       else
                        continue
                       end
                      else
                      end
                     end
                    end
                   end
                  end
                 elseif image(y+0,x+3) < c_b 
                  if image(y+-1,x+3) > cb 
                   continue
                  elseif image(y+-1,x+3) < c_b 
                  else
                   if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                    continue
                   else
                    if image(y+0,x+-3) > cb | image(y+0,x+-3) < c_b 
                     continue
                    else
                    end
                   end
                  end
                 else
                  if image(y+3,x+2) > cb 
                   if image(y+2,x+2) > cb 
                    if image(y+4,x+-1) > cb 
                     if image(y+4,x+1) > cb 
                      if image(y+-1,x+4) > cb 
                       if image(y+-4,x+1) > cb 
                        if image(y+-1,x+-4) < c_b
                         continue
                        else
                        end
                       elseif image(y+-4,x+1) < c_b 
                       else
                        if image(y+-1,x+-4) > cb 
                         if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                          continue
                         else
                         end
                        elseif image(y+-1,x+-4) < c_b 
                         continue
                        else
                         if image(y+-3,x+-1) > cb 
                          if image(y+-1,x+-3) > cb 
                           if image(y+-4,x+-1) > cb 
                           else
                            continue
                           end
                          elseif image(y+-1,x+-3) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        end
                       end
                      elseif image(y+-1,x+4) < c_b 
                       if image(y+0,x+-3) > cb | image(y+0,x+-3) < c_b 
                        continue
                       else
                       end
                      else
                       if image(y+-2,x+-2) > cb 
                       elseif image(y+-2,x+-2) < c_b 
                        continue
                       else
                        if image(y+-1,x+-4) > cb 
                         if image(y+3,x+-2) > cb 
                          if image(y+1,x+2) > cb 
                           if image(y+-2,x+-3) > cb 
                           else
                            continue
                           end
                          elseif image(y+1,x+2) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        elseif image(y+-1,x+-4) < c_b 
                        else
                         if image(y+-3,x+1) > cb 
                         elseif image(y+-3,x+1) < c_b 
                          continue
                         else
                          if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+4,x+1) < c_b 
                      continue
                     else
                      if image(y+3,x+-2) > cb 
                       if image(y+1,x+4) > cb 
                        if image(y+-4,x+0) > cb 
                         if image(y+-2,x+-3) > cb 
                         elseif image(y+-2,x+-3) < c_b 
                          continue
                         else
                          if image(y+0,x+-4) > cb 
                           if image(y+1,x+-4) > cb 
                           elseif image(y+1,x+-4) < c_b 
                            continue
                           else
                            if image(y+1,x+2) > cb | image(y+1,x+2) < c_b 
                             continue
                            else
                            end
                           end
                          else
                          end
                         end
                        elseif image(y+-4,x+0) < c_b 
                         continue
                        else
                         if image(y+-1,x+4) > cb | image(y+-1,x+4) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+1,x+4) < c_b 
                        continue
                       else
                       end
                      elseif image(y+3,x+-2) < c_b 
                       continue
                      else
                       if image(y+1,x+-4) > cb 
                       elseif image(y+1,x+-4) < c_b 
                        continue
                       else
                        if image(y+1,x+2) > cb 
                         if image(y+-2,x+-3) > cb 
                         elseif image(y+-2,x+-3) < c_b 
                          continue
                         else
                          if image(y+-2,x+2) > cb 
                           if image(y+-4,x+1) > cb 
                            if image(y+-1,x+2) > cb 
                             if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                              continue
                             else
                              if image(y+1,x+-2) > cb | image(y+1,x+-2) < c_b 
                               continue
                              else
                              end
                             end
                            else
                             continue
                            end
                           elseif image(y+-4,x+1) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-2,x+2) < c_b 
                           continue
                          else
                           if image(y+-4,x+-1) > cb 
                           else
                            continue
                           end
                          end
                         end
                        elseif image(y+1,x+2) < c_b 
                         continue
                        else
                         if image(y+-1,x+4) > cb 
                          if image(y+-3,x+0) > cb 
                           if image(y+0,x+4) > cb 
                            if image(y+-1,x+3) > cb | image(y+-1,x+3) < c_b 
                             continue
                            else
                            end
                           elseif image(y+0,x+4) < c_b 
                            continue
                           else
                            if image(y+-1,x+2) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+-3,x+0) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-1,x+4) < c_b 
                         else
                          if image(y+-2,x+2) > cb 
                           if image(y+2,x+-1) > cb 
                           elseif image(y+2,x+-1) < c_b 
                            continue
                           else
                            if image(y+-4,x+-1) > cb 
                             if image(y+-1,x+2) > cb 
                              if image(y+4,x+0) > cb 
                               if image(y+1,x+-2) > cb | image(y+1,x+-2) < c_b 
                                continue
                               else
                               end
                              else
                               continue
                              end
                             else
                              continue
                             end
                            elseif image(y+-4,x+-1) < c_b 
                             continue
                            else
                            end
                           end
                          elseif image(y+-2,x+2) < c_b 
                           continue
                          else
                           if image(y+-3,x+-1) > cb 
                            if image(y+-4,x+0) > cb 
                             if image(y+-2,x+-2) > cb 
                              if image(y+-4,x+1) > cb 
                              else
                               continue
                              end
                             else
                              continue
                             end
                            elseif image(y+-4,x+0) < c_b 
                             continue
                            else
                            end
                           else
                            continue
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+4,x+-1) < c_b 
                     if image(y+2,x+-2) > cb 
                      continue
                     elseif image(y+2,x+-2) < c_b 
                     else
                      if image(y+-1,x+4) > cb 
                       if image(y+-1,x+-4) > cb 
                        if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                         continue
                        else
                        end
                       elseif image(y+-1,x+-4) < c_b 
                        continue
                       else
                       end
                      elseif image(y+-1,x+4) < c_b 
                       continue
                      else
                       if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                        continue
                       else
                        if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                         continue
                        else
                         if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      end
                     end
                    else
                     if image(y+-1,x+2) > cb 
                      if image(y+-4,x+-1) > cb 
                       if image(y+-1,x+-4) > cb 
                        if image(y+1,x+-4) > cb 
                        elseif image(y+1,x+-4) < c_b 
                         continue
                        else
                         if image(y+0,x+2) > cb 
                         elseif image(y+0,x+2) < c_b 
                          continue
                         else
                          if image(y+1,x+2) > cb 
                           if image(y+-2,x+0) > cb 
                            if image(y+-2,x+-3) > cb 
                            elseif image(y+-2,x+-3) < c_b 
                             continue
                            else
                             if image(y+-1,x+4) > cb 
                             else
                              continue
                             end
                            end
                           else
                            continue
                           end
                          elseif image(y+1,x+2) < c_b 
                           continue
                          else
                           if image(y+1,x+4) > cb 
                            if image(y+2,x+-2) < c_b
                            else
                             continue
                            end
                           elseif image(y+1,x+4) < c_b 
                            continue
                           else
                            if image(y+3,x+1) > cb | image(y+3,x+1) < c_b 
                             continue
                            else
                             if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                              continue
                             else
                             end
                            end
                           end
                          end
                         end
                        end
                       elseif image(y+-1,x+-4) < c_b 
                        if image(y+0,x+-2) > cb 
                         continue
                        elseif image(y+0,x+-2) < c_b 
                        else
                         if image(y+0,x+-3) > cb 
                          continue
                         elseif image(y+0,x+-3) < c_b 
                          if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                           continue
                          else
                          end
                         else
                          if image(y+-2,x+3) > cb 
                          else
                           continue
                          end
                         end
                        end
                       else
                        if image(y+3,x+-2) > cb 
                        elseif image(y+3,x+-2) < c_b 
                         if image(y+2,x+-2) > cb 
                          continue
                         elseif image(y+2,x+-2) < c_b 
                         else
                          if image(y+0,x+2) > cb 
                          elseif image(y+0,x+2) < c_b 
                           continue
                          else
                           if image(y+-2,x+-2) > cb 
                            if image(y+3,x+1) > cb 
                             if image(y+4,x+0) > cb 
                              if image(y+0,x+-4) < c_b
                              else
                               continue
                              end
                             elseif image(y+4,x+0) < c_b 
                              continue
                             else
                             end
                            else
                             continue
                            end
                           else
                            continue
                           end
                          end
                         end
                        else
                         if image(y+1,x+-2) > cb 
                         elseif image(y+1,x+-2) < c_b 
                          if image(y+2,x+-2) > cb 
                           continue
                          elseif image(y+2,x+-2) < c_b 
                          else
                           if image(y+0,x+2) > cb 
                            if image(y+0,x+-2) > cb 
                             continue
                            elseif image(y+0,x+-2) < c_b 
                            else
                             if image(y+1,x+3) > cb | image(y+1,x+3) < c_b 
                              continue
                             else
                             end
                            end
                           elseif image(y+0,x+2) < c_b 
                            continue
                           else
                            if image(y+3,x+-1) < c_b
                            else
                             continue
                            end
                           end
                          end
                         else
                          if image(y+-2,x+0) > cb 
                           if image(y+-3,x+1) > cb 
                            if image(y+2,x+-1) < c_b
                             if image(y+-2,x+-3) > cb 
                              if image(y+1,x+2) > cb 
                              elseif image(y+1,x+2) < c_b 
                               continue
                              else
                               if image(y+2,x+-2) < c_b
                               else
                                continue
                               end
                              end
                             elseif image(y+-2,x+-3) < c_b 
                              continue
                             else
                             end
                            else
                            end
                           elseif image(y+-3,x+1) < c_b 
                            continue
                           else
                            if image(y+0,x+2) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+-2,x+0) < c_b 
                           continue
                          else
                           if image(y+0,x+2) > cb 
                           else
                            continue
                           end
                          end
                         end
                        end
                       end
                      elseif image(y+-4,x+-1) < c_b 
                       continue
                      else
                       if image(y+0,x+4) > cb 
                        continue
                       elseif image(y+0,x+4) < c_b 
                       else
                        if image(y+4,x+0) > cb 
                        elseif image(y+4,x+0) < c_b 
                         continue
                        else
                         if image(y+2,x+-2) > cb | image(y+2,x+-2) < c_b 
                         else
                          if image(y+0,x+-4) > cb 
                           if image(y+-4,x+1) > cb 
                            if image(y+0,x+2) > cb 
                            else
                             continue
                            end
                           elseif image(y+-4,x+1) < c_b 
                            continue
                           else
                           end
                          elseif image(y+0,x+-4) < c_b 
                           continue
                          else
                           if image(y+-4,x+1) > cb 
                            if image(y+-2,x+0) > cb 
                            else
                             continue
                            end
                           elseif image(y+-4,x+1) < c_b 
                            continue
                           else
                            if image(y+0,x+2) > cb 
                             if image(y+-3,x+0) > cb 
                             elseif image(y+-3,x+0) < c_b 
                              continue
                             else
                              if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                               continue
                              else
                              end
                             end
                            elseif image(y+0,x+2) < c_b 
                             continue
                            else
                             if image(y+1,x+4) > cb 
                              if image(y+-2,x+3) > cb 
                               if image(y+3,x+-2) < c_b
                               else
                                continue
                               end
                              elseif image(y+-2,x+3) < c_b 
                               continue
                              else
                              end
                             else
                              continue
                             end
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+-1,x+2) < c_b 
                      continue
                     else
                      if image(y+1,x+2) > cb 
                       if image(y+-2,x+2) > cb 
                        if image(y+-2,x+-3) > cb 
                         if image(y+-2,x+0) > cb 
                         else
                          continue
                         end
                        elseif image(y+-2,x+-3) < c_b 
                         continue
                        else
                         if image(y+-1,x+-4) > cb 
                          if image(y+1,x+-4) > cb 
                          else
                           continue
                          end
                         elseif image(y+-1,x+-4) < c_b 
                         else
                          if image(y+0,x+2) > cb 
                          elseif image(y+0,x+2) < c_b 
                           continue
                          else
                           if image(y+4,x+1) > cb 
                            if image(y+1,x+4) > cb 
                             if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                              continue
                             else
                             end
                            elseif image(y+1,x+4) < c_b 
                             continue
                            else
                             if image(y+2,x+-2) < c_b
                             else
                              continue
                             end
                            end
                           elseif image(y+4,x+1) < c_b 
                            continue
                           else
                            if image(y+-1,x+4) < c_b
                            else
                             continue
                            end
                           end
                          end
                         end
                        end
                       elseif image(y+-2,x+2) < c_b 
                        continue
                       else
                        if image(y+1,x+-4) > cb 
                         if image(y+-2,x+-2) > cb 
                          if image(y+1,x+4) > cb 
                          elseif image(y+1,x+4) < c_b 
                           continue
                          else
                           if image(y+-3,x+2) > cb 
                            if image(y+-1,x+4) > cb 
                             continue
                            elseif image(y+-1,x+4) < c_b 
                            else
                             if image(y+2,x+-1) > cb | image(y+2,x+-1) < c_b 
                              continue
                             else
                             end
                            end
                           elseif image(y+-3,x+2) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+-2,x+-2) < c_b 
                          continue
                         else
                          if image(y+-1,x+-4) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+1,x+-4) < c_b 
                         if image(y+-2,x+-3) > cb 
                         else
                          continue
                         end
                        else
                         if image(y+4,x+1) > cb | image(y+4,x+1) < c_b 
                         else
                          if image(y+3,x+-1) > cb 
                           continue
                          elseif image(y+3,x+-1) < c_b 
                           if image(y+2,x+-2) > cb 
                            continue
                           elseif image(y+2,x+-2) < c_b 
                           else
                            if image(y+-3,x+-1) > cb 
                             if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                              continue
                             else
                             end
                            elseif image(y+-3,x+-1) < c_b 
                             continue
                            else
                            end
                           end
                          else
                           if image(y+1,x+4) > cb 
                           elseif image(y+1,x+4) < c_b 
                            continue
                           else
                            if image(y+-4,x+-1) < c_b
                             continue
                            else
                             if image(y+-2,x+-3) > cb 
                             else
                              continue
                             end
                            end
                           end
                          end
                         end
                        end
                       end
                      elseif image(y+1,x+2) < c_b 
                       continue
                      else
                       if image(y+3,x+-2) > cb 
                        if image(y+-1,x+4) > cb 
                         if image(y+-4,x+-1) > cb 
                         elseif image(y+-4,x+-1) < c_b 
                          continue
                         else
                          if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+-1,x+4) < c_b 
                         continue
                        else
                        end
                       elseif image(y+3,x+-2) < c_b 
                        if image(y+2,x+-2) > cb 
                         continue
                        elseif image(y+2,x+-2) < c_b 
                        else
                         if image(y+-1,x+4) > cb 
                         elseif image(y+-1,x+4) < c_b 
                          if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                           continue
                          else
                          end
                         else
                          if image(y+1,x+-2) < c_b
                           if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                            continue
                           else
                           end
                          else
                           continue
                          end
                         end
                        end
                       else
                        if image(y+-1,x+4) > cb 
                         if image(y+2,x+-2) > cb | image(y+2,x+-2) < c_b 
                         else
                          if image(y+1,x+-3) > cb 
                           if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                            continue
                           else
                           end
                          elseif image(y+1,x+-3) < c_b 
                           continue
                          else
                           if image(y+0,x+-4) > cb 
                            if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                             continue
                            else
                            end
                           elseif image(y+0,x+-4) < c_b 
                           else
                            if image(y+2,x+-1) > cb 
                            elseif image(y+2,x+-1) < c_b 
                             continue
                            else
                             if image(y+2,x+0) > cb 
                             else
                              continue
                             end
                            end
                           end
                          end
                         end
                        elseif image(y+-1,x+4) < c_b 
                         if image(y+3,x+-1) > cb 
                          continue
                         elseif image(y+3,x+-1) < c_b 
                          if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                           continue
                          else
                           if image(y+2,x+-1) < c_b
                           else
                            continue
                           end
                          end
                         else
                          if image(y+1,x+-3) > cb 
                           continue
                          elseif image(y+1,x+-3) < c_b 
                           if image(y+-1,x+3) < c_b
                           else
                            continue
                           end
                          else
                          end
                         end
                        else
                         if image(y+1,x+-3) > cb 
                         elseif image(y+1,x+-3) < c_b 
                          if image(y+2,x+-2) < c_b
                          else
                           continue
                          end
                         else
                          if image(y+2,x+-1) > cb 
                          elseif image(y+2,x+-1) < c_b 
                           if image(y+2,x+-2) < c_b
                           else
                            continue
                           end
                          else
                           if image(y+2,x+-2) > cb 
                            continue
                           elseif image(y+2,x+-2) < c_b 
                           else
                            if image(y+0,x+2) > cb 
                            elseif image(y+0,x+2) < c_b 
                             continue
                            else
                             if image(y+4,x+0) > cb 
                              if image(y+4,x+1) > cb 
                               if image(y+0,x+4) < c_b
                               else
                                continue
                               end
                              elseif image(y+4,x+1) < c_b 
                               continue
                              else
                               if image(y+1,x+4) > cb 
                               else
                                continue
                               end
                              end
                             elseif image(y+4,x+0) < c_b 
                              continue
                             else
                              if image(y+3,x+-1) > cb 
                               if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                                continue
                               else
                               end
                              else
                               continue
                              end
                             end
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+2,x+2) < c_b 
                    continue
                   else
                    if image(y+4,x+-1) > cb 
                     if image(y+3,x+-2) > cb 
                      if image(y+-1,x+2) > cb 
                       if image(y+-1,x+-4) > cb 
                        if image(y+1,x+3) > cb 
                        elseif image(y+1,x+3) < c_b 
                         continue
                        else
                         if image(y+-2,x+3) > cb 
                          if image(y+2,x+-2) > cb 
                          else
                           continue
                          end
                         elseif image(y+-2,x+3) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+-1,x+-4) < c_b 
                        continue
                       else
                       end
                      elseif image(y+-1,x+2) < c_b 
                       continue
                      else
                       if image(y+2,x+-1) > cb 
                        if image(y+4,x+1) > cb 
                        elseif image(y+4,x+1) < c_b 
                         continue
                        else
                         if image(y+-4,x+-1) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+2,x+-1) < c_b 
                        continue
                       else
                        if image(y+-2,x+-2) > cb 
                         if image(y+2,x+-2) > cb 
                         elseif image(y+2,x+-2) < c_b 
                          continue
                         else
                          if image(y+3,x+1) > cb 
                           if image(y+0,x+4) > cb 
                            if image(y+-2,x+2) > cb 
                             if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                              continue
                             else
                              if image(y+-2,x+0) > cb 
                              else
                               continue
                              end
                             end
                            elseif image(y+-2,x+2) < c_b 
                             continue
                            else
                            end
                           elseif image(y+0,x+4) < c_b 
                            if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                             continue
                            else
                            end
                           else
                            if image(y+1,x+-3) > cb 
                             if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                              continue
                             else
                             end
                            elseif image(y+1,x+-3) < c_b 
                             continue
                            else
                             if image(y+3,x+0) > cb | image(y+3,x+0) < c_b 
                              continue
                             else
                              if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                               continue
                              else
                              end
                             end
                            end
                           end
                          elseif image(y+3,x+1) < c_b 
                           continue
                          else
                           if image(y+1,x+3) > cb 
                           elseif image(y+1,x+3) < c_b 
                            continue
                           else
                            if image(y+-1,x+-4) > cb 
                             if image(y+-4,x+-1) > cb 
                             else
                              continue
                             end
                            elseif image(y+-1,x+-4) < c_b 
                             continue
                            else
                             if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                              continue
                             else
                              if image(y+-2,x+0) > cb 
                               if image(y+1,x+2) > cb 
                               else
                                continue
                               end
                              elseif image(y+-2,x+0) < c_b 
                               continue
                              else
                              end
                             end
                            end
                           end
                          end
                         end
                        elseif image(y+-2,x+-2) < c_b 
                         continue
                        else
                         if image(y+-4,x+0) > cb 
                          if image(y+-3,x+2) > cb 
                          elseif image(y+-3,x+2) < c_b 
                           continue
                          else
                           if image(y+-3,x+1) > cb 
                            if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                             continue
                            else
                            end
                           else
                            continue
                           end
                          end
                         elseif image(y+-4,x+0) < c_b 
                          continue
                         else
                          if image(y+-1,x+3) > cb 
                          else
                           continue
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+3,x+-2) < c_b 
                      continue
                     else
                      if image(y+4,x+1) > cb 
                       if image(y+-1,x+-3) > cb 
                       elseif image(y+-1,x+-3) < c_b 
                        if image(y+-2,x+3) > cb 
                        else
                         continue
                        end
                       else
                        if image(y+-4,x+-1) > cb 
                        elseif image(y+-4,x+-1) < c_b 
                         continue
                        else
                         if image(y+-2,x+-2) > cb 
                         elseif image(y+-2,x+-2) < c_b 
                          continue
                         else
                          if image(y+3,x+-1) > cb 
                           if image(y+-3,x+-1) > cb 
                            if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                             continue
                            else
                            end
                           elseif image(y+-3,x+-1) < c_b 
                            continue
                           else
                           end
                          elseif image(y+3,x+-1) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       end
                      elseif image(y+4,x+1) < c_b 
                       continue
                      else
                       if image(y+-1,x+2) > cb 
                        if image(y+4,x+0) > cb 
                        elseif image(y+4,x+0) < c_b 
                         continue
                        else
                         if image(y+1,x+-2) > cb 
                         elseif image(y+1,x+-2) < c_b 
                          continue
                         else
                          if image(y+-2,x+-3) > cb 
                          elseif image(y+-2,x+-3) < c_b 
                           continue
                          else
                           if image(y+-1,x+-4) > cb 
                            if image(y+1,x+-4) > cb 
                             if image(y+1,x+3) > cb 
                             else
                              continue
                             end
                            else
                             continue
                            end
                           elseif image(y+-1,x+-4) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        end
                       elseif image(y+-1,x+2) < c_b 
                        continue
                       else
                        if image(y+3,x+0) > cb 
                         if image(y+-3,x+2) > cb 
                          if image(y+2,x+0) > cb 
                          elseif image(y+2,x+0) < c_b 
                           continue
                          else
                           if image(y+1,x+4) > cb 
                            if image(y+-2,x+-3) > cb 
                            else
                             continue
                            end
                           else
                            continue
                           end
                          end
                         elseif image(y+-3,x+2) < c_b 
                          continue
                         else
                         end
                        elseif image(y+3,x+0) < c_b 
                         continue
                        else
                         if image(y+1,x+4) > cb 
                          if image(y+4,x+0) > cb 
                           if image(y+-4,x+0) > cb 
                           else
                            continue
                           end
                          else
                           continue
                          end
                         else
                          continue
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+4,x+-1) < c_b 
                     if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                     else
                      if image(y+-1,x+-3) > cb 
                       if image(y+-2,x+2) > cb 
                       else
                        continue
                       end
                      else
                       continue
                      end
                     end
                    else
                     if image(y+2,x+-2) > cb 
                      if image(y+-2,x+-3) > cb 
                      elseif image(y+-2,x+-3) < c_b 
                       continue
                      else
                       if image(y+1,x+-4) > cb 
                       elseif image(y+1,x+-4) < c_b 
                        continue
                       else
                        if image(y+-1,x+2) > cb 
                         if image(y+-2,x+-2) > cb 
                         else
                          continue
                         end
                        elseif image(y+-1,x+2) < c_b 
                         continue
                        else
                         if image(y+3,x+1) > cb 
                         elseif image(y+3,x+1) < c_b 
                          continue
                         else
                          if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+2,x+-2) < c_b 
                     else
                      if image(y+0,x+2) > cb 
                       if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                        continue
                       else
                       end
                      elseif image(y+0,x+2) < c_b 
                       if image(y+1,x+-3) > cb 
                       else
                        continue
                       end
                      else
                       if image(y+-1,x+4) > cb 
                        if image(y+0,x+-4) > cb 
                         if image(y+-1,x+-4) > cb 
                          if image(y+-2,x+-2) > cb 
                           if image(y+1,x+-3) > cb 
                           elseif image(y+1,x+-3) < c_b 
                            continue
                           else
                            if image(y+-1,x+2) > cb 
                             if image(y+-4,x+0) > cb 
                             elseif image(y+-4,x+0) < c_b 
                              continue
                             else
                              if image(y+-2,x+0) > cb 
                              else
                               continue
                              end
                             end
                            else
                             continue
                            end
                           end
                          elseif image(y+-2,x+-2) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-1,x+-4) < c_b 
                          continue
                         else
                         end
                        elseif image(y+0,x+-4) < c_b 
                         if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                          continue
                         else
                         end
                        else
                         if image(y+3,x+-2) > cb 
                          if image(y+3,x+1) > cb 
                           if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                            continue
                           else
                            if image(y+-1,x+2) > cb 
                            elseif image(y+-1,x+2) < c_b 
                             continue
                            else
                             if image(y+3,x+-1) > cb 
                              if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                               continue
                              else
                              end
                             elseif image(y+3,x+-1) < c_b 
                              continue
                             else
                             end
                            end
                           end
                          elseif image(y+3,x+1) < c_b 
                           continue
                          else
                          end
                         elseif image(y+3,x+-2) < c_b 
                          if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                           continue
                          else
                          end
                         else
                          if image(y+1,x+-3) > cb 
                          elseif image(y+1,x+-3) < c_b 
                           continue
                          else
                           if image(y+0,x+-3) > cb 
                            continue
                           elseif image(y+0,x+-3) < c_b 
                           else
                            if image(y+1,x+2) > cb 
                            elseif image(y+1,x+2) < c_b 
                             continue
                            else
                             if image(y+1,x+-4) > cb 
                              if image(y+-1,x+-4) > cb 
                              else
                               continue
                              end
                             elseif image(y+1,x+-4) < c_b 
                              continue
                             else
                              if image(y+3,x+-1) > cb 
                               if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                                continue
                               else
                               end
                              elseif image(y+3,x+-1) < c_b 
                               continue
                              else
                               if image(y+4,x+0) > cb 
                                if image(y+4,x+1) > cb | image(y+4,x+1) < c_b 
                                 continue
                                else
                                end
                               else
                                continue
                               end
                              end
                             end
                            end
                           end
                          end
                         end
                        end
                       elseif image(y+-1,x+4) < c_b 
                        if image(y+3,x+-1) > cb 
                         continue
                        elseif image(y+3,x+-1) < c_b 
                         if image(y+-2,x+-3) > cb 
                         else
                          continue
                         end
                        else
                        end
                       else
                        if image(y+2,x+-1) > cb 
                        elseif image(y+2,x+-1) < c_b 
                         if image(y+-1,x+2) > cb 
                          if image(y+4,x+1) > cb 
                          elseif image(y+4,x+1) < c_b 
                           continue
                          else
                           if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                            continue
                           else
                           end
                          end
                         else
                          continue
                         end
                        else
                         if image(y+1,x+-4) > cb 
                          if image(y+1,x+-3) > cb 
                          elseif image(y+1,x+-3) < c_b 
                           continue
                          else
                           if image(y+-1,x+2) > cb 
                            if image(y+1,x+3) > cb 
                             if image(y+2,x+0) > cb | image(y+2,x+0) < c_b 
                              continue
                             else
                              if image(y+-4,x+0) > cb 
                              else
                               continue
                              end
                             end
                            else
                             continue
                            end
                           else
                            continue
                           end
                          end
                         elseif image(y+1,x+-4) < c_b 
                          continue
                         else
                          if image(y+1,x+2) > cb 
                           if image(y+-2,x+-3) > cb 
                           else
                            continue
                           end
                          elseif image(y+1,x+2) < c_b 
                           continue
                          else
                           if image(y+3,x+-1) > cb 
                            if image(y+0,x+4) > cb 
                            elseif image(y+0,x+4) < c_b 
                             continue
                            else
                             if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                              continue
                             else
                              if image(y+-4,x+-1) > cb 
                              else
                               continue
                              end
                             end
                            end
                           elseif image(y+3,x+-1) < c_b 
                            continue
                           else
                            if image(y+0,x+4) > cb 
                             if image(y+4,x+0) > cb 
                              if image(y+4,x+1) > cb | image(y+4,x+1) < c_b 
                               continue
                              else
                              end
                             else
                              continue
                             end
                            else
                             continue
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+3,x+2) < c_b 
                   if image(y+-2,x+-3) > cb 
                   else
                    continue
                   end
                  else
                   if image(y+4,x+-1) > cb 
                    if image(y+4,x+1) > cb 
                     if image(y+-2,x+2) > cb 
                     elseif image(y+-2,x+2) < c_b 
                      continue
                     else
                      if image(y+-1,x+-4) > cb 
                       if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                        continue
                       else
                       end
                      elseif image(y+-1,x+-4) < c_b 
                       continue
                      else
                      end
                     end
                    elseif image(y+4,x+1) < c_b 
                     continue
                    else
                     if image(y+-1,x+2) > cb 
                      if image(y+-1,x+-4) > cb 
                       if image(y+3,x+-2) > cb 
                       elseif image(y+3,x+-2) < c_b 
                        continue
                       else
                        if image(y+1,x+-4) > cb 
                         if image(y+2,x+0) > cb 
                          continue
                         elseif image(y+2,x+0) < c_b 
                          if image(y+-1,x+4) < c_b
                          else
                           continue
                          end
                         else
                          if image(y+1,x+3) > cb 
                           if image(y+0,x+-3) > cb 
                            if image(y+-4,x+1) > cb 
                             if image(y+-2,x+-3) > cb 
                             else
                              continue
                             end
                            elseif image(y+-4,x+1) < c_b 
                             continue
                            else
                            end
                           elseif image(y+0,x+-3) < c_b 
                            continue
                           else
                           end
                          elseif image(y+1,x+3) < c_b 
                           continue
                          else
                           if image(y+-2,x+-3) > cb 
                           else
                            continue
                           end
                          end
                         end
                        elseif image(y+1,x+-4) < c_b 
                         continue
                        else
                         if image(y+4,x+0) > cb 
                          if image(y+-4,x+0) > cb 
                          else
                           continue
                          end
                         else
                          continue
                         end
                        end
                       end
                      elseif image(y+-1,x+-4) < c_b 
                       continue
                      else
                       if image(y+-3,x+-1) > cb 
                       elseif image(y+-3,x+-1) < c_b 
                        continue
                       else
                        if image(y+-4,x+-1) > cb 
                        else
                         continue
                        end
                       end
                      end
                     elseif image(y+-1,x+2) < c_b 
                      continue
                     else
                      if image(y+2,x+-1) > cb 
                       if image(y+-4,x+0) > cb 
                       elseif image(y+-4,x+0) < c_b 
                        continue
                       else
                        if image(y+2,x+0) > cb 
                        elseif image(y+2,x+0) < c_b 
                         continue
                        else
                         if image(y+-3,x+0) > cb 
                          if image(y+-2,x+-2) > cb 
                          else
                           continue
                          end
                         else
                          continue
                         end
                        end
                       end
                      elseif image(y+2,x+-1) < c_b 
                       continue
                      else
                       if image(y+1,x+3) > cb 
                        if image(y+3,x+-2) > cb 
                         if image(y+3,x+1) > cb 
                          if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
                           continue
                          else
                          end
                         elseif image(y+3,x+1) < c_b 
                          continue
                         else
                          if image(y+1,x+-4) > cb 
                           if image(y+-4,x+1) > cb 
                           else
                            continue
                           end
                          elseif image(y+1,x+-4) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+3,x+-2) < c_b 
                         continue
                        else
                         if image(y+4,x+0) > cb 
                          if image(y+-2,x+-2) > cb 
                          elseif image(y+-2,x+-2) < c_b 
                           continue
                          else
                           if image(y+0,x+-4) > cb 
                           else
                            continue
                           end
                          end
                         elseif image(y+4,x+0) < c_b 
                          continue
                         else
                          if image(y+1,x+4) > cb | image(y+1,x+4) < c_b 
                           continue
                          else
                           if image(y+-4,x+1) > cb 
                           else
                            continue
                           end
                          end
                         end
                        end
                       elseif image(y+1,x+3) < c_b 
                        continue
                       else
                        if image(y+1,x+-2) > cb 
                        elseif image(y+1,x+-2) < c_b 
                         continue
                        else
                         if image(y+3,x+-2) > cb 
                          if image(y+2,x+2) > cb 
                           if image(y+-3,x+-1) > cb 
                           else
                            continue
                           end
                          elseif image(y+2,x+2) < c_b 
                           continue
                          else
                           if image(y+-1,x+-4) > cb 
                            if image(y+-1,x+4) > cb | image(y+-1,x+4) < c_b 
                             continue
                            else
                            end
                           else
                            continue
                           end
                          end
                         elseif image(y+3,x+-2) < c_b 
                          continue
                         else
                          if image(y+1,x+4) > cb 
                           if image(y+4,x+0) > cb 
                            if image(y+-2,x+-2) > cb 
                             if image(y+-4,x+1) > cb 
                             else
                              continue
                             end
                            else
                             continue
                            end
                           else
                            continue
                           end
                          else
                           continue
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+4,x+-1) < c_b 
                    if image(y+2,x+-2) > cb 
                    elseif image(y+2,x+-2) < c_b 
                     if image(y+1,x+2) > cb 
                     elseif image(y+1,x+2) < c_b 
                      continue
                     else
                      if image(y+0,x+2) > cb 
                      else
                       continue
                      end
                     end
                    else
                     if image(y+-2,x+2) > cb 
                      if image(y+0,x+2) > cb 
                      elseif image(y+0,x+2) < c_b 
                       continue
                      else
                       if image(y+2,x+-1) > cb 
                       elseif image(y+2,x+-1) < c_b 
                        continue
                       else
                        if image(y+1,x+4) > cb 
                         if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                          continue
                         else
                          if image(y+-1,x+2) > cb 
                           if image(y+1,x+2) > cb 
                           else
                            continue
                           end
                          elseif image(y+-1,x+2) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+1,x+4) < c_b 
                         continue
                        else
                         if image(y+1,x+-3) > cb 
                          if image(y+2,x+2) > cb | image(y+2,x+2) < c_b 
                           continue
                          else
                          end
                         elseif image(y+1,x+-3) < c_b 
                          continue
                         else
                          if image(y+-1,x+2) > cb 
                           if image(y+2,x+2) > cb 
                            if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                             continue
                            else
                            end
                           else
                            continue
                           end
                          else
                           continue
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+-2,x+2) < c_b 
                      continue
                     else
                      if image(y+0,x+-3) > cb 
                      else
                       continue
                      end
                     end
                    end
                   else
                    if image(y+1,x+2) > cb 
                     if image(y+-2,x+-3) > cb 
                      if image(y+-2,x+0) > cb 
                       if image(y+1,x+-3) > cb 
                        if image(y+1,x+-2) > cb 
                        elseif image(y+1,x+-2) < c_b 
                         continue
                        else
                         if image(y+-1,x+-4) > cb 
                          if image(y+-3,x+2) > cb 
                          else
                           continue
                          end
                         else
                          continue
                         end
                        end
                       elseif image(y+1,x+-3) < c_b 
                       else
                        if image(y+-3,x+-1) > cb 
                        elseif image(y+-3,x+-1) < c_b 
                         continue
                        else
                         if image(y+-4,x+0) < c_b
                         else
                          continue
                         end
                        end
                       end
                      elseif image(y+-2,x+0) < c_b 
                       continue
                      else
                       if image(y+2,x+-1) > cb 
                       elseif image(y+2,x+-1) < c_b 
                        continue
                       else
                        if image(y+0,x+4) > cb 
                         if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
                          continue
                         else
                         end
                        else
                         continue
                        end
                       end
                      end
                     elseif image(y+-2,x+-3) < c_b 
                      continue
                     else
                      if image(y+-2,x+2) > cb 
                       if image(y+-1,x+2) > cb 
                        if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                         continue
                        else
                         if image(y+2,x+-1) > cb 
                         elseif image(y+2,x+-1) < c_b 
                          continue
                         else
                          if image(y+-1,x+3) > cb 
                           if image(y+1,x+4) > cb 
                            if image(y+-4,x+-1) > cb 
                            elseif image(y+-4,x+-1) < c_b 
                             continue
                            else
                             if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                              continue
                             else
                             end
                            end
                           elseif image(y+1,x+4) < c_b 
                            continue
                           else
                            if image(y+2,x+0) > cb 
                             continue
                            elseif image(y+2,x+0) < c_b 
                            else
                             if image(y+1,x+3) > cb 
                              if image(y+-2,x+-2) > cb 
                              elseif image(y+-2,x+-2) < c_b 
                               continue
                              else
                               if image(y+0,x+2) > cb 
                               else
                                continue
                               end
                              end
                             else
                              continue
                             end
                            end
                           end
                          elseif image(y+-1,x+3) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+-1,x+2) < c_b 
                        continue
                       else
                        if image(y+-4,x+-1) > cb 
                         if image(y+1,x+-2) > cb | image(y+1,x+-2) < c_b 
                         else
                          if image(y+4,x+1) > cb 
                           if image(y+-4,x+1) > cb 
                           else
                            continue
                           end
                          elseif image(y+4,x+1) < c_b 
                          else
                           if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        elseif image(y+-4,x+-1) < c_b 
                         continue
                        else
                         if image(y+1,x+3) > cb 
                          if image(y+-2,x+0) > cb 
                          elseif image(y+-2,x+0) < c_b 
                           continue
                          else
                           if image(y+-4,x+0) > cb 
                           else
                            continue
                           end
                          end
                         else
                          continue
                         end
                        end
                       end
                      elseif image(y+-2,x+2) < c_b 
                       continue
                      else
                       if image(y+1,x+-4) > cb 
                        if image(y+1,x+4) > cb 
                        else
                         continue
                        end
                       elseif image(y+1,x+-4) < c_b 
                        if image(y+-1,x+2) > cb | image(y+-1,x+2) < c_b 
                         continue
                        else
                        end
                       else
                        if image(y+-4,x+-1) > cb 
                        elseif image(y+-4,x+-1) < c_b 
                         continue
                        else
                         if image(y+1,x+3) > cb 
                         elseif image(y+1,x+3) < c_b 
                          continue
                         else
                          if image(y+-3,x+1) > cb 
                          else
                           continue
                          end
                         end
                        end
                       end
                      end
                     end
                    else
                    end
                   end
                  end
                 end
                end
               end
              elseif image(y+-2,x+1) < c_b 
               if image(y+-2,x+2) > cb 
               elseif image(y+-2,x+2) < c_b 
                if image(y+-1,x+-2) > cb | image(y+-1,x+-2) < c_b 
                else
                 if image(y+2,x+1) > cb | image(y+2,x+1) < c_b 
                 else
                  if image(y+-4,x+1) > cb 
                   continue
                  elseif image(y+-4,x+1) < c_b 
                   if image(y+0,x+2) > cb | image(y+0,x+2) < c_b 
                    continue
                   else
                   end
                  else
                   if image(y+-4,x+0) > cb 
                    if image(y+-2,x+-3) < c_b
                     continue
                    else
                    end
                   elseif image(y+-4,x+0) < c_b 
                    continue
                   else
                    if image(y+2,x+0) > cb 
                    else
                     continue
                    end
                   end
                  end
                 end
                end
               else
                if image(y+-4,x+0) > cb 
                elseif image(y+-4,x+0) < c_b 
                 if image(y+2,x+0) > cb 
                  if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                   continue
                  else
                  end
                 else
                 end
                else
                 if image(y+1,x+2) > cb 
                  if image(y+0,x+-3) > cb 
                  elseif image(y+0,x+-3) < c_b 
                   continue
                  else
                   if image(y+0,x+-4) > cb 
                    if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                     continue
                    else
                    end
                   else
                   end
                  end
                 elseif image(y+1,x+2) < c_b 
                 else
                  if image(y+2,x+1) > cb 
                   if image(y+0,x+-2) > cb 
                   elseif image(y+0,x+-2) < c_b 
                    continue
                   else
                    if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                     continue
                    else
                     if image(y+-4,x+-1) > cb 
                      if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                       continue
                      else
                      end
                     elseif image(y+-4,x+-1) < c_b 
                      continue
                     else
                     end
                    end
                   end
                  elseif image(y+2,x+1) < c_b 
                  else
                   if image(y+1,x+-3) > cb 
                    if image(y+2,x+2) > cb 
                     if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                      continue
                     else
                     end
                    elseif image(y+2,x+2) < c_b 
                     continue
                    else
                    end
                   elseif image(y+1,x+-3) < c_b 
                    continue
                   else
                    if image(y+4,x+0) > cb 
                     if image(y+1,x+-4) > cb 
                      if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                       continue
                      else
                      end
                     else
                      continue
                     end
                    elseif image(y+4,x+0) < c_b 
                    else
                     if image(y+3,x+1) > cb 
                      if image(y+3,x+-2) < c_b
                      else
                       continue
                      end
                     elseif image(y+3,x+1) < c_b 
                      continue
                     else
                      if image(y+-4,x+-1) > cb 
                      elseif image(y+-4,x+-1) < c_b 
                       continue
                      else
                       if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                       else
                        continue
                       end
                      end
                     end
                    end
                   end
                  end
                 end
                end
               end
              else
               if image(y+1,x+2) > cb 
                if image(y+3,x+-2) > cb 
                 if image(y+1,x+-3) > cb 
                  if image(y+2,x+-1) > cb 
                   if image(y+-4,x+0) > cb 
                   elseif image(y+-4,x+0) < c_b 
                    continue
                   else
                    if image(y+2,x+-2) > cb 
                    elseif image(y+2,x+-2) < c_b 
                     continue
                    else
                     if image(y+0,x+2) > cb 
                     elseif image(y+0,x+2) < c_b 
                      continue
                     else
                      if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                      else
                       if image(y+-1,x+4) > cb | image(y+-1,x+4) < c_b 
                        continue
                       else
                        if image(y+0,x+-2) > cb 
                        else
                         continue
                        end
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+2,x+-1) < c_b 
                   continue
                  else
                   if image(y+-3,x+1) > cb 
                    if image(y+-1,x+3) > cb 
                     if image(y+-1,x+2) > cb 
                     elseif image(y+-1,x+2) < c_b 
                      continue
                     else
                      if image(y+1,x+-2) > cb 
                      elseif image(y+1,x+-2) < c_b 
                       continue
                      else
                       if image(y+3,x+-1) > cb 
                        if image(y+-2,x+2) > cb 
                        else
                         continue
                        end
                       elseif image(y+3,x+-1) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    elseif image(y+-1,x+3) < c_b 
                    else
                     if image(y+-1,x+-2) > cb 
                     elseif image(y+-1,x+-2) < c_b 
                      continue
                     else
                      if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                       continue
                      else
                      end
                     end
                    end
                   elseif image(y+-3,x+1) < c_b 
                    continue
                   else
                    if image(y+-1,x+3) > cb 
                     if image(y+-4,x+0) > cb 
                     elseif image(y+-4,x+0) < c_b 
                      continue
                     else
                      if image(y+4,x+0) > cb 
                       if image(y+-1,x+2) > cb 
                       elseif image(y+-1,x+2) < c_b 
                        continue
                       else
                        if image(y+-2,x+3) > cb 
                         if image(y+3,x+0) > cb 
                          if image(y+-3,x+0) > cb 
                          elseif image(y+-3,x+0) < c_b 
                           continue
                          else
                           if image(y+-1,x+-2) > cb | image(y+-1,x+-2) < c_b 
                            continue
                           else
                           end
                          end
                         else
                          continue
                         end
                        elseif image(y+-2,x+3) < c_b 
                         continue
                        else
                        end
                       end
                      else
                      end
                     end
                    elseif image(y+-1,x+3) < c_b 
                     continue
                    else
                     if image(y+0,x+-2) > cb 
                      if image(y+2,x+1) > cb 
                      elseif image(y+2,x+1) < c_b 
                       continue
                      else
                       if image(y+3,x+0) > cb | image(y+3,x+0) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+0,x+-2) < c_b 
                      continue
                     else
                      if image(y+-1,x+-4) > cb 
                       if image(y+0,x+-4) > cb 
                        if image(y+0,x+4) > cb 
                         if image(y+2,x+0) > cb 
                          if image(y+-1,x+-3) > cb 
                          else
                           continue
                          end
                         elseif image(y+2,x+0) < c_b 
                          continue
                         else
                          if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                           continue
                          else
                           if image(y+2,x+1) > cb 
                            if image(y+-3,x+2) > cb 
                            elseif image(y+-3,x+2) < c_b 
                             continue
                            else
                             if image(y+1,x+4) > cb 
                              if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                               continue
                              else
                               if image(y+-4,x+0) > cb 
                               else
                                continue
                               end
                              end
                             elseif image(y+1,x+4) < c_b 
                              continue
                             else
                             end
                            end
                           elseif image(y+2,x+1) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        elseif image(y+0,x+4) < c_b 
                         continue
                        else
                        end
                       else
                        continue
                       end
                      elseif image(y+-1,x+-4) < c_b 
                       continue
                      else
                      end
                     end
                    end
                   end
                  end
                 elseif image(y+1,x+-3) < c_b 
                  if image(y+2,x+1) > cb 
                  elseif image(y+2,x+1) < c_b 
                   continue
                  else
                   if image(y+-4,x+0) > cb 
                   else
                    continue
                   end
                  end
                 else
                  if image(y+-4,x+-1) > cb 
                   if image(y+3,x+-1) > cb 
                    if image(y+-2,x+-3) > cb 
                    elseif image(y+-2,x+-3) < c_b 
                     continue
                    else
                     if image(y+1,x+-4) > cb 
                      if image(y+2,x+1) > cb 
                       if image(y+-4,x+1) > cb 
                       elseif image(y+-4,x+1) < c_b 
                        continue
                       else
                        if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+2,x+1) < c_b 
                       continue
                      else
                       if image(y+-4,x+0) > cb 
                        if image(y+-1,x+4) > cb 
                         if image(y+-4,x+1) > cb 
                          if image(y+-1,x+2) > cb 
                          elseif image(y+-1,x+2) < c_b 
                           continue
                          else
                           if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                            continue
                           else
                           end
                          end
                         else
                          continue
                         end
                        else
                         continue
                        end
                       elseif image(y+-4,x+0) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+1,x+-4) < c_b 
                      if image(y+2,x+-1) > cb 
                      else
                       continue
                      end
                     else
                      if image(y+3,x+2) > cb 
                      elseif image(y+3,x+2) < c_b 
                       continue
                      else
                       if image(y+-2,x+-2) > cb 
                       elseif image(y+-2,x+-2) < c_b 
                        continue
                       else
                        if image(y+-2,x+2) > cb 
                         if image(y+-1,x+4) > cb | image(y+-1,x+4) < c_b 
                          continue
                         else
                         end
                        elseif image(y+-2,x+2) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+3,x+-1) < c_b 
                    continue
                   else
                    if image(y+0,x+2) > cb 
                     if image(y+1,x+-4) > cb 
                     elseif image(y+1,x+-4) < c_b 
                      if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                       continue
                      else
                      end
                     else
                      if image(y+3,x+2) > cb 
                      elseif image(y+3,x+2) < c_b 
                       continue
                      else
                       if image(y+-1,x+3) > cb 
                       elseif image(y+-1,x+3) < c_b 
                        continue
                       else
                        if image(y+-2,x+3) > cb 
                         continue
                        elseif image(y+-2,x+3) < c_b 
                        else
                         if image(y+4,x+0) > cb 
                          if image(y+-3,x+0) > cb 
                          else
                           continue
                          end
                         elseif image(y+4,x+0) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+0,x+2) < c_b 
                     continue
                    else
                     if image(y+2,x+-2) > cb 
                     elseif image(y+2,x+-2) < c_b 
                      continue
                     else
                      if image(y+-2,x+0) > cb 
                      elseif image(y+-2,x+0) < c_b 
                       continue
                      else
                       if image(y+-2,x+2) > cb 
                        if image(y+1,x+-4) > cb 
                         if image(y+-1,x+-3) > cb 
                         else
                          continue
                         end
                        elseif image(y+1,x+-4) < c_b 
                         continue
                        else
                        end
                       elseif image(y+-2,x+2) < c_b 
                        continue
                       else
                        if image(y+-2,x+-3) > cb 
                         if image(y+0,x+4) > cb 
                          if image(y+-3,x+1) > cb 
                          elseif image(y+-3,x+1) < c_b 
                           continue
                          else
                           if image(y+-1,x+-4) > cb 
                            if image(y+2,x+0) > cb 
                            elseif image(y+2,x+0) < c_b 
                             continue
                            else
                             if image(y+0,x+-2) > cb 
                             elseif image(y+0,x+-2) < c_b 
                              continue
                             else
                              if image(y+2,x+2) > cb 
                               if image(y+-1,x+-2) > cb | image(y+-1,x+-2) < c_b 
                                continue
                               else
                                if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                                 continue
                                else
                                end
                               end
                              elseif image(y+2,x+2) < c_b 
                               continue
                              else
                              end
                             end
                            end
                           elseif image(y+-1,x+-4) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+0,x+4) < c_b 
                          continue
                         else
                          if image(y+0,x+-3) > cb | image(y+0,x+-3) < c_b 
                           continue
                          else
                           if image(y+-1,x+-2) > cb 
                           elseif image(y+-1,x+-2) < c_b 
                            continue
                           else
                            if image(y+3,x+2) > cb 
                             if image(y+3,x+0) > cb 
                              if image(y+-1,x+-4) > cb 
                               if image(y+-3,x+2) > cb 
                                if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                                 continue
                                else
                                end
                               elseif image(y+-3,x+2) < c_b 
                                continue
                               else
                               end
                              else
                               continue
                              end
                             else
                              continue
                             end
                            elseif image(y+3,x+2) < c_b 
                             continue
                            else
                            end
                           end
                          end
                         end
                        elseif image(y+-2,x+-3) < c_b 
                         continue
                        else
                         if image(y+-4,x+1) < c_b
                          continue
                         else
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+-4,x+-1) < c_b 
                   continue
                  else
                   if image(y+-2,x+-3) > cb 
                    if image(y+3,x+-1) > cb 
                    elseif image(y+3,x+-1) < c_b 
                     continue
                    else
                     if image(y+0,x+3) > cb 
                      if image(y+-3,x+2) > cb 
                      elseif image(y+-3,x+2) < c_b 
                       continue
                      else
                       if image(y+-1,x+-3) > cb 
                        if image(y+-1,x+3) > cb 
                         if image(y+1,x+-4) > cb 
                         elseif image(y+1,x+-4) < c_b 
                          continue
                         else
                          if image(y+0,x+-2) > cb 
                           if image(y+0,x+-4) > cb 
                            if image(y+-3,x+-1) > cb 
                            else
                             continue
                            end
                           elseif image(y+0,x+-4) < c_b 
                            continue
                           else
                           end
                          else
                           continue
                          end
                         end
                        elseif image(y+-1,x+3) < c_b 
                         continue
                        else
                        end
                       elseif image(y+-1,x+-3) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+0,x+3) < c_b 
                      continue
                     else
                      if image(y+-3,x+2) > cb 
                      elseif image(y+-3,x+2) < c_b 
                       continue
                      else
                       if image(y+-1,x+-4) > cb 
                        if image(y+0,x+-2) > cb | image(y+0,x+-2) < c_b 
                         continue
                        else
                         if image(y+2,x+0) > cb | image(y+2,x+0) < c_b 
                          continue
                         else
                         end
                        end
                       else
                        continue
                       end
                      end
                     end
                    end
                   elseif image(y+-2,x+-3) < c_b 
                    continue
                   else
                    if image(y+2,x+-2) > cb 
                     if image(y+3,x+-1) > cb 
                     elseif image(y+3,x+-1) < c_b 
                      continue
                     else
                      if image(y+0,x+2) > cb 
                      elseif image(y+0,x+2) < c_b 
                       continue
                      else
                       if image(y+-3,x+-1) > cb 
                        if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                         continue
                        else
                         if image(y+-1,x+-2) > cb 
                         elseif image(y+-1,x+-2) < c_b 
                          continue
                         else
                          if image(y+0,x+-3) > cb | image(y+0,x+-3) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       else
                        continue
                       end
                      end
                     end
                    elseif image(y+2,x+-2) < c_b 
                     continue
                    else
                     if image(y+-1,x+2) > cb 
                      if image(y+2,x+-1) > cb 
                       if image(y+-3,x+2) > cb 
                       else
                        continue
                       end
                      elseif image(y+2,x+-1) < c_b 
                       continue
                      else
                      end
                     elseif image(y+-1,x+2) < c_b 
                     else
                      if image(y+-1,x+-2) > cb 
                       if image(y+0,x+-4) > cb 
                       elseif image(y+0,x+-4) < c_b 
                        continue
                       else
                        if image(y+3,x+2) < c_b
                         continue
                        else
                         if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      elseif image(y+-1,x+-2) < c_b 
                       continue
                      else
                       if image(y+0,x+-4) > cb 
                        if image(y+-4,x+1) > cb 
                         if image(y+-4,x+0) > cb 
                         else
                          continue
                         end
                        elseif image(y+-4,x+1) < c_b 
                         continue
                        else
                        end
                       elseif image(y+0,x+-4) < c_b 
                        continue
                       else
                        if image(y+0,x+2) > cb 
                         if image(y+3,x+-1) > cb 
                          if image(y+-2,x+2) > cb 
                           continue
                          elseif image(y+-2,x+2) < c_b 
                          else
                           if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                            continue
                           else
                            if image(y+-4,x+0) > cb 
                            elseif image(y+-4,x+0) < c_b 
                             continue
                            else
                             if image(y+-2,x+3) > cb 
                             else
                              continue
                             end
                            end
                           end
                          end
                         elseif image(y+3,x+-1) < c_b 
                          continue
                         else
                         end
                        elseif image(y+0,x+2) < c_b 
                         continue
                        else
                         if image(y+-3,x+-1) > cb 
                          if image(y+-2,x+2) > cb 
                           continue
                          elseif image(y+-2,x+2) < c_b 
                          else
                           if image(y+-1,x+3) > cb 
                            if image(y+2,x+1) > cb 
                            else
                             continue
                            end
                           else
                            continue
                           end
                          end
                         elseif image(y+-3,x+-1) < c_b 
                          continue
                         else
                          if image(y+-2,x+0) > cb 
                           if image(y+-4,x+1) > cb 
                           else
                            continue
                           end
                          elseif image(y+-2,x+0) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  end
                 end
                elseif image(y+3,x+-2) < c_b 
                 if image(y+2,x+-2) > cb 
                  continue
                 elseif image(y+2,x+-2) < c_b 
                  if image(y+-2,x+-3) > cb 
                  elseif image(y+-2,x+-3) < c_b 
                   continue
                  else
                   if image(y+3,x+2) > cb | image(y+3,x+2) < c_b 
                   else
                    if image(y+-4,x+0) > cb 
                    elseif image(y+-4,x+0) < c_b 
                     continue
                    else
                     if image(y+-3,x+1) < c_b
                     else
                      continue
                     end
                    end
                   end
                  end
                 else
                  if image(y+2,x+0) > cb 
                  elseif image(y+2,x+0) < c_b 
                   if image(y+4,x+-1) > cb 
                    continue
                   elseif image(y+4,x+-1) < c_b 
                    if image(y+-3,x+2) > cb 
                     if image(y+-2,x+2) > cb 
                      if image(y+-1,x+-4) > cb 
                      else
                       continue
                      end
                     else
                      continue
                     end
                    elseif image(y+-3,x+2) < c_b 
                    else
                     if image(y+1,x+-3) > cb 
                      if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                       continue
                      else
                      end
                     elseif image(y+1,x+-3) < c_b 
                      continue
                     else
                      if image(y+2,x+2) > cb 
                       if image(y+4,x+1) > cb 
                        continue
                       elseif image(y+4,x+1) < c_b 
                        if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                         continue
                        else
                         if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                          continue
                         else
                         end
                        end
                       else
                       end
                      else
                       continue
                      end
                     end
                    end
                   else
                    if image(y+-2,x+-2) > cb 
                    else
                     continue
                    end
                   end
                  else
                   if image(y+0,x+2) > cb 
                    if image(y+3,x+2) > cb 
                     if image(y+1,x+-3) > cb 
                     elseif image(y+1,x+-3) < c_b 
                      if image(y+-1,x+2) > cb 
                      elseif image(y+-1,x+2) < c_b 
                       continue
                      else
                       if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                        continue
                       else
                        if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     else
                      if image(y+0,x+3) > cb 
                      elseif image(y+0,x+3) < c_b 
                       continue
                      else
                       if image(y+-3,x+2) > cb 
                        continue
                       else
                       end
                      end
                     end
                    elseif image(y+3,x+2) < c_b 
                     continue
                    else
                     if image(y+0,x+-2) > cb | image(y+0,x+-2) < c_b 
                     else
                      if image(y+3,x+1) > cb | image(y+3,x+1) < c_b 
                       continue
                      else
                       if image(y+4,x+0) > cb 
                       elseif image(y+4,x+0) < c_b 
                        if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                         if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                          continue
                         else
                         end
                        else
                        end
                       else
                        if image(y+0,x+-3) > cb 
                         if image(y+-4,x+0) > cb 
                          if image(y+-3,x+1) > cb 
                          else
                           continue
                          end
                         elseif image(y+-4,x+0) < c_b 
                          continue
                         else
                         end
                        elseif image(y+0,x+-3) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+0,x+2) < c_b 
                    continue
                   else
                    if image(y+-3,x+2) > cb 
                     if image(y+-1,x+4) > cb 
                     elseif image(y+-1,x+4) < c_b 
                      continue
                     else
                      if image(y+-1,x+-3) > cb 
                       if image(y+-4,x+1) > cb 
                       else
                        continue
                       end
                      else
                       continue
                      end
                     end
                    elseif image(y+-3,x+2) < c_b 
                     if image(y+-1,x+-3) > cb 
                     elseif image(y+-1,x+-3) < c_b 
                      continue
                     else
                      if image(y+3,x+1) > cb 
                      elseif image(y+3,x+1) < c_b 
                       continue
                      else
                       if image(y+2,x+-1) > cb 
                        continue
                       elseif image(y+2,x+-1) < c_b 
                       else
                        if image(y+-2,x+2) < c_b
                         if image(y+-1,x+-2) > cb 
                         else
                          continue
                         end
                        else
                         continue
                        end
                       end
                      end
                     end
                    else
                     if image(y+-2,x+0) > cb 
                      if image(y+3,x+-1) > cb 
                       continue
                      elseif image(y+3,x+-1) < c_b 
                       if image(y+4,x+-1) > cb 
                        continue
                       elseif image(y+4,x+-1) < c_b 
                        if image(y+-1,x+-2) > cb 
                        elseif image(y+-1,x+-2) < c_b 
                         continue
                        else
                         if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                          continue
                         else
                         end
                        end
                       else
                        if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                         continue
                        else
                        end
                       end
                      else
                      end
                     elseif image(y+-2,x+0) < c_b 
                      continue
                     else
                      if image(y+0,x+-3) > cb 
                       if image(y+-1,x+3) > cb 
                        continue
                       elseif image(y+-1,x+3) < c_b 
                        if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                         continue
                        else
                        end
                       else
                        if image(y+0,x+-4) > cb 
                        elseif image(y+0,x+-4) < c_b 
                         continue
                        else
                         if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      elseif image(y+0,x+-3) < c_b 
                       continue
                      else
                       if image(y+-1,x+3) > cb | image(y+-1,x+3) < c_b 
                       else
                        if image(y+-1,x+-4) > cb 
                         if image(y+1,x+-4) < c_b
                         else
                          continue
                         end
                        elseif image(y+-1,x+-4) < c_b 
                         continue
                        else
                         if image(y+-2,x+-2) > cb 
                          if image(y+4,x+-1) > cb 
                           continue
                          elseif image(y+4,x+-1) < c_b 
                          else
                           if image(y+-2,x+2) > cb 
                            continue
                           elseif image(y+-2,x+2) < c_b 
                           else
                            if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                             continue
                            else
                             if image(y+-4,x+-1) > cb 
                              if image(y+-2,x+-3) > cb 
                               if image(y+1,x+-2) < c_b
                               else
                                continue
                               end
                              elseif image(y+-2,x+-3) < c_b 
                               continue
                              else
                              end
                             else
                              continue
                             end
                            end
                           end
                          end
                         else
                          continue
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  end
                 end
                else
                 if image(y+0,x+2) > cb 
                  if image(y+-3,x+1) > cb 
                   if image(y+1,x+-3) > cb 
                    if image(y+3,x+-1) > cb 
                     if image(y+-1,x+3) > cb 
                      if image(y+-1,x+2) > cb 
                      elseif image(y+-1,x+2) < c_b 
                       continue
                      else
                       if image(y+2,x+-1) > cb 
                        if image(y+4,x+0) > cb 
                        elseif image(y+4,x+0) < c_b 
                         continue
                        else
                         if image(y+-2,x+2) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+2,x+-1) < c_b 
                        continue
                       else
                        if image(y+-2,x+2) > cb 
                        elseif image(y+-2,x+2) < c_b 
                         continue
                        else
                         if image(y+1,x+-2) > cb 
                          if image(y+0,x+-4) > cb 
                          else
                           continue
                          end
                         elseif image(y+1,x+-2) < c_b 
                          continue
                         else
                          if image(y+3,x+2) > cb 
                           if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                            continue
                           else
                            if image(y+-1,x+-4) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+3,x+2) < c_b 
                           continue
                          else
                           if image(y+4,x+1) > cb 
                           else
                            continue
                           end
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+-1,x+3) < c_b 
                      continue
                     else
                     end
                    elseif image(y+3,x+-1) < c_b 
                    else
                     if image(y+3,x+2) > cb 
                     elseif image(y+3,x+2) < c_b 
                      continue
                     else
                      if image(y+1,x+3) > cb 
                       if image(y+4,x+0) > cb 
                        if image(y+-2,x+3) > cb 
                        elseif image(y+-2,x+3) < c_b 
                         continue
                        else
                         if image(y+-1,x+3) > cb | image(y+-1,x+3) < c_b 
                          continue
                         else
                         end
                        end
                       else
                       end
                      else
                       continue
                      end
                     end
                    end
                   elseif image(y+1,x+-3) < c_b 
                    if image(y+1,x+-2) > cb 
                     continue
                    elseif image(y+1,x+-2) < c_b 
                    else
                     if image(y+1,x+-4) > cb 
                      continue
                     elseif image(y+1,x+-4) < c_b 
                      if image(y+4,x+-1) > cb 
                       continue
                      elseif image(y+4,x+-1) < c_b 
                      else
                       if image(y+-2,x+-2) > cb 
                       else
                        continue
                       end
                      end
                     else
                     end
                    end
                   else
                    if image(y+3,x+2) > cb 
                     if image(y+0,x+3) > cb 
                      if image(y+-2,x+-3) > cb 
                      elseif image(y+-2,x+-3) < c_b 
                       continue
                      else
                       if image(y+3,x+-1) > cb 
                        if image(y+-4,x+-1) > cb 
                         if image(y+1,x+-4) > cb 
                          if image(y+-2,x+2) > cb 
                          elseif image(y+-2,x+2) < c_b 
                           continue
                          else
                           if image(y+-1,x+-4) > cb 
                           elseif image(y+-1,x+-4) < c_b 
                            continue
                           else
                            if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                             continue
                            else
                            end
                           end
                          end
                         else
                         end
                        elseif image(y+-4,x+-1) < c_b 
                         continue
                        else
                         if image(y+-1,x+2) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+3,x+-1) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+0,x+3) < c_b 
                      continue
                     else
                      if image(y+3,x+1) > cb 
                      elseif image(y+3,x+1) < c_b 
                       continue
                      else
                       if image(y+-2,x+0) > cb 
                       elseif image(y+-2,x+0) < c_b 
                        continue
                       else
                        if image(y+1,x+4) > cb 
                        elseif image(y+1,x+4) < c_b 
                         continue
                        else
                         if image(y+-2,x+-2) > cb 
                          if image(y+0,x+-4) > cb 
                          else
                           continue
                          end
                         elseif image(y+-2,x+-2) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+3,x+2) < c_b 
                    else
                     if image(y+-2,x+2) > cb 
                      if image(y+-1,x+-4) > cb 
                       if image(y+-4,x+-1) > cb 
                        if image(y+4,x+-1) > cb | image(y+4,x+-1) < c_b 
                         if image(y+0,x+-4) > cb 
                         else
                          continue
                         end
                        else
                        end
                       elseif image(y+-4,x+-1) < c_b 
                        continue
                       else
                        if image(y+-1,x+-2) > cb 
                        elseif image(y+-1,x+-2) < c_b 
                         continue
                        else
                         if image(y+-2,x+0) > cb 
                         elseif image(y+-2,x+0) < c_b 
                          continue
                         else
                          if image(y+3,x+0) < c_b
                          else
                           continue
                          end
                         end
                        end
                       end
                      elseif image(y+-1,x+-4) < c_b 
                      else
                       if image(y+-2,x+0) > cb 
                        if image(y+-2,x+-3) > cb 
                        elseif image(y+-2,x+-3) < c_b 
                         continue
                        else
                         if image(y+-1,x+4) > cb 
                          if image(y+-1,x+-2) > cb 
                          elseif image(y+-1,x+-2) < c_b 
                           continue
                          else
                           if image(y+4,x+1) < c_b
                           else
                            continue
                           end
                          end
                         elseif image(y+-1,x+4) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+-2,x+0) < c_b 
                        continue
                       else
                        if image(y+-1,x+-2) > cb 
                         if image(y+2,x+2) > cb 
                         elseif image(y+2,x+2) < c_b 
                          continue
                         else
                          if image(y+-2,x+-3) > cb 
                           if image(y+-1,x+4) > cb | image(y+-1,x+4) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-2,x+-3) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+-1,x+-2) < c_b 
                         continue
                        else
                         if image(y+2,x+1) > cb 
                         elseif image(y+2,x+1) < c_b 
                          continue
                         else
                          if image(y+4,x+0) > cb 
                           if image(y+-4,x+1) > cb 
                            if image(y+4,x+-1) > cb 
                            elseif image(y+4,x+-1) < c_b 
                             continue
                            else
                             if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                              continue
                             else
                             end
                            end
                           else
                            continue
                           end
                          elseif image(y+4,x+0) < c_b 
                           continue
                          else
                           if image(y+-1,x+4) > cb | image(y+-1,x+4) < c_b 
                            continue
                           else
                            if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                             continue
                            else
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+-2,x+2) < c_b 
                      continue
                     else
                      if image(y+1,x+4) > cb 
                       if image(y+4,x+-1) > cb 
                        if image(y+-3,x+2) > cb 
                         if image(y+-2,x+0) > cb 
                         elseif image(y+-2,x+0) < c_b 
                          continue
                         else
                          if image(y+4,x+0) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+-3,x+2) < c_b 
                         continue
                        else
                        end
                       elseif image(y+4,x+-1) < c_b 
                        if image(y+0,x+-3) > cb 
                         if image(y+2,x+2) > cb | image(y+2,x+2) < c_b 
                          continue
                         else
                         end
                        elseif image(y+0,x+-3) < c_b 
                         continue
                        else
                        end
                       else
                       end
                      elseif image(y+1,x+4) < c_b 
                       continue
                      else
                       if image(y+-2,x+0) > cb 
                       elseif image(y+-2,x+0) < c_b 
                        continue
                       else
                        if image(y+-1,x+-2) > cb 
                        elseif image(y+-1,x+-2) < c_b 
                         continue
                        else
                         if image(y+-2,x+-3) > cb 
                          if image(y+4,x+-1) > cb 
                          elseif image(y+4,x+-1) < c_b 
                           continue
                          else
                           if image(y+-1,x+3) > cb 
                            if image(y+-1,x+-4) > cb 
                            else
                             continue
                            end
                           else
                            continue
                           end
                          end
                         elseif image(y+-2,x+-3) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+-3,x+1) < c_b 
                   if image(y+-2,x+-3) > cb 
                    if image(y+-4,x+1) > cb 
                     continue
                    elseif image(y+-4,x+1) < c_b 
                    else
                     if image(y+0,x+-4) > cb 
                     elseif image(y+0,x+-4) < c_b 
                      continue
                     else
                      if image(y+0,x+3) > cb 
                       if image(y+-1,x+4) > cb 
                        if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                         continue
                        else
                        end
                       elseif image(y+-1,x+4) < c_b 
                        continue
                       else
                       end
                      else
                       continue
                      end
                     end
                    end
                   elseif image(y+-2,x+-3) < c_b 
                    continue
                   else
                    if image(y+0,x+4) > cb 
                    elseif image(y+0,x+4) < c_b 
                     continue
                    else
                     if image(y+-4,x+-1) > cb 
                     else
                      continue
                     end
                    end
                   end
                  else
                   if image(y+3,x+2) > cb 
                    if image(y+1,x+-3) > cb 
                     if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                     else
                      if image(y+3,x+-1) > cb 
                       if image(y+2,x+0) > cb 
                       elseif image(y+2,x+0) < c_b 
                        continue
                       else
                        if image(y+4,x+0) > cb 
                         if image(y+-1,x+3) > cb 
                         elseif image(y+-1,x+3) < c_b 
                          continue
                         else
                          if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                           continue
                          else
                          end
                         end
                        else
                         continue
                        end
                       end
                      elseif image(y+3,x+-1) < c_b 
                       continue
                      else
                      end
                     end
                    elseif image(y+1,x+-3) < c_b 
                     if image(y+3,x+1) > cb 
                      if image(y+-1,x+-4) > cb 
                       if image(y+-3,x+2) > cb 
                        if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                         continue
                        else
                        end
                       elseif image(y+-3,x+2) < c_b 
                        continue
                       else
                       end
                      elseif image(y+-1,x+-4) < c_b 
                       if image(y+0,x+-2) > cb 
                        continue
                       elseif image(y+0,x+-2) < c_b 
                        if image(y+2,x+0) > cb 
                        else
                         continue
                        end
                       else
                       end
                      else
                       if image(y+0,x+-4) > cb 
                        continue
                       elseif image(y+0,x+-4) < c_b 
                        if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                        else
                         if image(y+-4,x+0) > cb 
                          if image(y+0,x+-2) > cb 
                           continue
                          elseif image(y+0,x+-2) < c_b 
                           if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                            continue
                           else
                           end
                          else
                          end
                         else
                          continue
                         end
                        end
                       else
                       end
                      end
                     elseif image(y+3,x+1) < c_b 
                      continue
                     else
                      if image(y+-2,x+0) > cb 
                      elseif image(y+-2,x+0) < c_b 
                       continue
                      else
                       if image(y+2,x+-2) > cb 
                        continue
                       elseif image(y+2,x+-2) < c_b 
                       else
                        if image(y+-2,x+3) > cb 
                         continue
                        elseif image(y+-2,x+3) < c_b 
                        else
                         if image(y+-3,x+0) > cb 
                          if image(y+-1,x+3) > cb 
                          else
                           continue
                          end
                         else
                          continue
                         end
                        end
                       end
                      end
                     end
                    else
                     if image(y+0,x+3) > cb 
                      if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                      else
                       if image(y+3,x+-1) > cb 
                        if image(y+-4,x+0) > cb 
                        elseif image(y+-4,x+0) < c_b 
                         continue
                        else
                         if image(y+2,x+-1) > cb 
                          if image(y+-2,x+3) > cb 
                          elseif image(y+-2,x+3) < c_b 
                           continue
                          else
                           if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                           else
                            continue
                           end
                          end
                         elseif image(y+2,x+-1) < c_b 
                          continue
                         else
                          if image(y+-3,x+2) > cb 
                           if image(y+-1,x+-2) > cb 
                            if image(y+-1,x+4) > cb 
                            elseif image(y+-1,x+4) < c_b 
                             continue
                            else
                             if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                              continue
                             else
                             end
                            end
                           else
                            continue
                           end
                          elseif image(y+-3,x+2) < c_b 
                          else
                           if image(y+-1,x+3) > cb 
                           elseif image(y+-1,x+3) < c_b 
                            continue
                           else
                            if image(y+-4,x+-1) > cb 
                            elseif image(y+-4,x+-1) < c_b 
                             continue
                            else
                             if image(y+-4,x+1) > cb 
                             else
                              continue
                             end
                            end
                           end
                          end
                         end
                        end
                       else
                       end
                      end
                     elseif image(y+0,x+3) < c_b 
                      continue
                     else
                      if image(y+1,x+4) > cb 
                       if image(y+-3,x+-1) > cb 
                       elseif image(y+-3,x+-1) < c_b 
                        continue
                       else
                        if image(y+-2,x+-3) > cb 
                        else
                         continue
                        end
                       end
                      elseif image(y+1,x+4) < c_b 
                       continue
                      else
                       if image(y+-2,x+-3) > cb 
                        if image(y+3,x+0) > cb 
                        elseif image(y+3,x+0) < c_b 
                         continue
                        else
                         if image(y+-2,x+0) > cb 
                         elseif image(y+-2,x+0) < c_b 
                          continue
                         else
                          if image(y+-2,x+2) > cb 
                           if image(y+-1,x+-4) > cb 
                           elseif image(y+-1,x+-4) < c_b 
                            continue
                           else
                            if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                             continue
                            else
                            end
                           end
                          elseif image(y+-2,x+2) < c_b 
                           continue
                          else
                           if image(y+2,x+1) > cb 
                            if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                            else
                             if image(y+-1,x+3) > cb 
                             elseif image(y+-1,x+3) < c_b 
                              continue
                             else
                              if image(y+0,x+-2) > cb 
                              else
                               continue
                              end
                             end
                            end
                           elseif image(y+2,x+1) < c_b 
                            continue
                           else
                            if image(y+-2,x+3) < c_b
                            else
                             continue
                            end
                           end
                          end
                         end
                        end
                       elseif image(y+-2,x+-3) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    end
                   elseif image(y+3,x+2) < c_b 
                    if image(y+2,x+0) < c_b
                    else
                     continue
                    end
                   else
                    if image(y+1,x+4) > cb 
                     if image(y+-2,x+2) > cb 
                      if image(y+-1,x+-2) > cb 
                       if image(y+-1,x+-4) > cb 
                       elseif image(y+-1,x+-4) < c_b 
                        continue
                       else
                        if image(y+2,x+2) > cb 
                        elseif image(y+2,x+2) < c_b 
                         continue
                        else
                         if image(y+0,x+-2) > cb 
                         elseif image(y+0,x+-2) < c_b 
                          continue
                         else
                          if image(y+-2,x+0) > cb 
                          elseif image(y+-2,x+0) < c_b 
                           continue
                          else
                           if image(y+4,x+-1) > cb 
                           elseif image(y+4,x+-1) < c_b 
                            continue
                           else
                            if image(y+-2,x+-3) > cb 
                             if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                              continue
                             else
                             end
                            elseif image(y+-2,x+-3) < c_b 
                             continue
                            else
                            end
                           end
                          end
                         end
                        end
                       end
                      elseif image(y+-1,x+-2) < c_b 
                       continue
                      else
                       if image(y+-2,x+0) > cb 
                       elseif image(y+-2,x+0) < c_b 
                        continue
                       else
                        if image(y+-1,x+-4) > cb 
                         if image(y+-4,x+-1) > cb 
                          if image(y+4,x+0) > cb 
                           if image(y+4,x+1) > cb 
                            if image(y+4,x+-1) > cb 
                            elseif image(y+4,x+-1) < c_b 
                             continue
                            else
                             if image(y+1,x+-4) > cb 
                             else
                              continue
                             end
                            end
                           else
                            continue
                           end
                          else
                          end
                         elseif image(y+-4,x+-1) < c_b 
                          continue
                         else
                          if image(y+2,x+-2) < c_b
                          else
                           continue
                          end
                         end
                        elseif image(y+-1,x+-4) < c_b 
                        else
                         if image(y+4,x+-1) > cb 
                         elseif image(y+4,x+-1) < c_b 
                          continue
                         else
                          if image(y+-1,x+4) > cb 
                           if image(y+2,x+-1) > cb 
                           elseif image(y+2,x+-1) < c_b 
                            if image(y+2,x+-2) > cb 
                             continue
                            elseif image(y+2,x+-2) < c_b 
                            else
                             if image(y+-4,x+1) < c_b
                             else
                              continue
                             end
                            end
                           else
                            if image(y+-4,x+1) > cb 
                             if image(y+2,x+1) > cb 
                             else
                              continue
                             end
                            elseif image(y+-4,x+1) < c_b 
                            else
                             continue
                            end
                           end
                          elseif image(y+-1,x+4) < c_b 
                           continue
                          else
                           if image(y+-3,x+-1) > cb 
                           else
                            continue
                           end
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+-2,x+2) < c_b 
                     else
                      if image(y+4,x+-1) > cb 
                       if image(y+-2,x+0) > cb 
                        if image(y+0,x+4) > cb 
                        elseif image(y+0,x+4) < c_b 
                         continue
                        else
                         if image(y+-1,x+2) > cb | image(y+-1,x+2) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+-2,x+0) < c_b 
                        continue
                       else
                        if image(y+3,x+-1) > cb 
                        elseif image(y+3,x+-1) < c_b 
                         continue
                        else
                         if image(y+4,x+1) > cb 
                          if image(y+3,x+1) > cb 
                           if image(y+-4,x+0) > cb 
                           elseif image(y+-4,x+0) < c_b 
                            continue
                           else
                            if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                             continue
                            else
                            end
                           end
                          elseif image(y+3,x+1) < c_b 
                           continue
                          else
                           if image(y+1,x+-4) > cb 
                            if image(y+-4,x+-1) > cb 
                             if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                              continue
                             else
                             end
                            else
                             continue
                            end
                           elseif image(y+1,x+-4) < c_b 
                            continue
                           else
                            if image(y+1,x+-2) < c_b
                             if image(y+-4,x+1) > cb 
                              continue
                             elseif image(y+-4,x+1) < c_b 
                             else
                              if image(y+-4,x+-1) > cb 
                              else
                               continue
                              end
                             end
                            else
                            end
                           end
                          end
                         elseif image(y+4,x+1) < c_b 
                          continue
                         else
                          if image(y+-1,x+4) > cb 
                           if image(y+-2,x+-3) > cb 
                            if image(y+2,x+2) > cb 
                             if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                              continue
                             else
                              if image(y+0,x+-3) > cb 
                              elseif image(y+0,x+-3) < c_b 
                               continue
                              else
                               if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                                continue
                               else
                               end
                              end
                             end
                            elseif image(y+2,x+2) < c_b 
                             continue
                            else
                             if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                              continue
                             else
                              if image(y+-1,x+-3) > cb 
                              else
                               continue
                              end
                             end
                            end
                           elseif image(y+-2,x+-3) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-1,x+4) < c_b 
                           continue
                          else
                           if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                            continue
                           else
                            if image(y+-4,x+-1) > cb 
                            else
                             continue
                            end
                           end
                          end
                         end
                        end
                       end
                      elseif image(y+4,x+-1) < c_b 
                       if image(y+-3,x+2) > cb 
                        continue
                       elseif image(y+-3,x+2) < c_b 
                        if image(y+-4,x+-1) > cb 
                        else
                         continue
                        end
                       else
                        if image(y+2,x+2) > cb 
                         if image(y+2,x+0) > cb | image(y+2,x+0) < c_b 
                         else
                          if image(y+3,x+-1) > cb 
                           continue
                          elseif image(y+3,x+-1) < c_b 
                           if image(y+-3,x+-1) > cb 
                            if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                             continue
                            else
                             if image(y+-4,x+-1) > cb 
                             else
                              continue
                             end
                            end
                           elseif image(y+-3,x+-1) < c_b 
                            continue
                           else
                           end
                          else
                          end
                         end
                        elseif image(y+2,x+2) < c_b 
                         continue
                        else
                         if image(y+-2,x+-3) > cb 
                          if image(y+2,x+0) > cb | image(y+2,x+0) < c_b 
                           continue
                          else
                           if image(y+1,x+-4) > cb 
                           elseif image(y+1,x+-4) < c_b 
                            continue
                           else
                            if image(y+-2,x+0) > cb 
                            else
                             continue
                            end
                           end
                          end
                         elseif image(y+-2,x+-3) < c_b 
                          continue
                         else
                          if image(y+-2,x+-2) > cb 
                          else
                           continue
                          end
                         end
                        end
                       end
                      else
                      end
                     end
                    elseif image(y+1,x+4) < c_b 
                     continue
                    else
                     if image(y+3,x+0) > cb 
                     elseif image(y+3,x+0) < c_b 
                      if image(y+-4,x+1) > cb 
                      elseif image(y+-4,x+1) < c_b 
                       continue
                      else
                       if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                        continue
                       else
                       end
                      end
                     else
                      if image(y+-3,x+2) > cb 
                       if image(y+-1,x+-3) > cb 
                       elseif image(y+-1,x+-3) < c_b 
                        continue
                       else
                        if image(y+-2,x+-3) > cb 
                         if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                          continue
                         else
                         end
                        elseif image(y+-2,x+-3) < c_b 
                         continue
                        else
                         if image(y+-3,x+-1) > cb 
                         else
                          continue
                         end
                        end
                       end
                      elseif image(y+-3,x+2) < c_b 
                       if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                       else
                        if image(y+-4,x+1) > cb 
                         continue
                        elseif image(y+-4,x+1) < c_b 
                         if image(y+0,x+-2) > cb 
                          continue
                         elseif image(y+0,x+-2) < c_b 
                         else
                          if image(y+2,x+-1) < c_b
                          else
                           continue
                          end
                         end
                        else
                        end
                       end
                      else
                       if image(y+-4,x+-1) > cb 
                        if image(y+-2,x+-3) > cb 
                         if image(y+-2,x+0) > cb 
                          if image(y+1,x+-3) > cb 
                           if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                            continue
                           else
                           end
                          elseif image(y+1,x+-3) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-2,x+0) < c_b 
                          continue
                         else
                          if image(y+2,x+1) > cb 
                           if image(y+-1,x+3) > cb 
                           elseif image(y+-1,x+3) < c_b 
                            continue
                           else
                            if image(y+2,x+2) > cb 
                             if image(y+-1,x+-3) > cb 
                             else
                              continue
                             end
                            else
                             continue
                            end
                           end
                          elseif image(y+2,x+1) < c_b 
                           continue
                          else
                           if image(y+-1,x+2) > cb 
                            if image(y+1,x+-3) > cb 
                            elseif image(y+1,x+-3) < c_b 
                             continue
                            else
                             if image(y+-1,x+-3) > cb 
                              if image(y+-1,x+-2) > cb 
                               if image(y+-2,x+2) > cb 
                                if image(y+-4,x+0) > cb 
                                else
                                 continue
                                end
                               else
                                continue
                               end
                              elseif image(y+-1,x+-2) < c_b 
                               continue
                              else
                              end
                             else
                              continue
                             end
                            end
                           elseif image(y+-1,x+2) < c_b 
                            continue
                           else
                            if image(y+1,x+-4) > cb 
                             if image(y+4,x+-1) > cb 
                              continue
                             elseif image(y+4,x+-1) < c_b 
                             else
                              if image(y+0,x+4) > cb 
                               if image(y+-1,x+4) > cb | image(y+-1,x+4) < c_b 
                                continue
                               else
                               end
                              else
                               continue
                              end
                             end
                            elseif image(y+1,x+-4) < c_b 
                            else
                             continue
                            end
                           end
                          end
                         end
                        elseif image(y+-2,x+-3) < c_b 
                         continue
                        else
                         if image(y+1,x+-4) > cb 
                          if image(y+-1,x+-2) > cb 
                          elseif image(y+-1,x+-2) < c_b 
                           continue
                          else
                           if image(y+2,x+1) > cb 
                           else
                            continue
                           end
                          end
                         else
                         end
                        end
                       elseif image(y+-4,x+-1) < c_b 
                        continue
                       else
                        if image(y+-2,x+2) > cb 
                        elseif image(y+-2,x+2) < c_b 
                         continue
                        else
                         if image(y+-2,x+-3) > cb 
                          if image(y+-2,x+0) > cb 
                          elseif image(y+-2,x+0) < c_b 
                           continue
                          else
                           if image(y+-1,x+3) > cb | image(y+-1,x+3) < c_b 
                            continue
                           else
                            if image(y+-1,x+-2) > cb 
                             if image(y+1,x+3) > cb 
                             else
                              continue
                             end
                            elseif image(y+-1,x+-2) < c_b 
                             continue
                            else
                             if image(y+2,x+-1) < c_b
                             else
                              continue
                             end
                            end
                           end
                          end
                         elseif image(y+-2,x+-3) < c_b 
                          continue
                         else
                          if image(y+0,x+-4) > cb 
                          else
                           continue
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  end
                 elseif image(y+0,x+2) < c_b 
                 else
                  if image(y+-2,x+0) > cb 
                   if image(y+-4,x+-1) > cb 
                    if image(y+-1,x+3) > cb 
                     if image(y+3,x+-1) > cb 
                      if image(y+1,x+-3) > cb 
                       if image(y+-3,x+1) > cb 
                        if image(y+1,x+-2) < c_b
                         continue
                        else
                         if image(y+-2,x+2) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+-3,x+1) < c_b 
                        continue
                       else
                       end
                      elseif image(y+1,x+-3) < c_b 
                       continue
                      else
                       if image(y+-2,x+-3) > cb 
                       elseif image(y+-2,x+-3) < c_b 
                        continue
                       else
                        if image(y+0,x+-4) > cb 
                         if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                          continue
                         else
                         end
                        elseif image(y+0,x+-4) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     elseif image(y+3,x+-1) < c_b 
                     else
                      if image(y+-2,x+-3) > cb 
                       if image(y+3,x+2) > cb 
                       elseif image(y+3,x+2) < c_b 
                        continue
                       else
                        if image(y+1,x+4) > cb 
                         if image(y+4,x+-1) > cb 
                          if image(y+2,x+2) > cb 
                           if image(y+-1,x+4) > cb | image(y+-1,x+4) < c_b 
                            continue
                           else
                           end
                          elseif image(y+2,x+2) < c_b 
                           continue
                          else
                          end
                         else
                         end
                        elseif image(y+1,x+4) < c_b 
                         continue
                        else
                         if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      elseif image(y+-2,x+-3) < c_b 
                       continue
                      else
                       if image(y+-2,x+2) > cb 
                        if image(y+-1,x+-2) > cb 
                        elseif image(y+-1,x+-2) < c_b 
                         continue
                        else
                         if image(y+4,x+1) > cb 
                          if image(y+-2,x+-2) > cb 
                          elseif image(y+-2,x+-2) < c_b 
                           continue
                          else
                           if image(y+1,x+4) > cb 
                           else
                            continue
                           end
                          end
                         elseif image(y+4,x+1) < c_b 
                          continue
                         else
                          if image(y+-4,x+1) > cb 
                           if image(y+0,x+-4) > cb 
                            if image(y+-4,x+0) > cb 
                            else
                             continue
                            end
                           else
                            continue
                           end
                          elseif image(y+-4,x+1) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+-2,x+2) < c_b 
                        continue
                       else
                        if image(y+1,x+-4) > cb 
                         if image(y+-2,x+3) > cb 
                          if image(y+0,x+-4) > cb 
                          else
                           continue
                          end
                         elseif image(y+-2,x+3) < c_b 
                          continue
                         else
                         end
                        else
                        end
                       end
                      end
                     end
                    elseif image(y+-1,x+3) < c_b 
                     if image(y+-2,x+-3) > cb 
                     elseif image(y+-2,x+-3) < c_b 
                      continue
                     else
                      if image(y+1,x+-4) > cb 
                       if image(y+-2,x+-2) > cb 
                       else
                        continue
                       end
                      else
                      end
                     end
                    else
                     if image(y+0,x+-3) > cb 
                     elseif image(y+0,x+-3) < c_b 
                      if image(y+-1,x+-3) > cb 
                       continue
                      elseif image(y+-1,x+-3) < c_b 
                       if image(y+-3,x+1) > cb 
                       elseif image(y+-3,x+1) < c_b 
                        continue
                       else
                        if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                         continue
                        else
                        end
                       end
                      else
                      end
                     else
                      if image(y+1,x+-4) > cb 
                       if image(y+-2,x+-3) > cb 
                        if image(y+3,x+-1) > cb 
                         if image(y+0,x+-4) > cb 
                         elseif image(y+0,x+-4) < c_b 
                          continue
                         else
                          if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+3,x+-1) < c_b 
                         continue
                        else
                         if image(y+1,x+3) > cb 
                         elseif image(y+1,x+3) < c_b 
                          continue
                         else
                          if image(y+-3,x+0) > cb 
                          else
                           continue
                          end
                         end
                        end
                       elseif image(y+-2,x+-3) < c_b 
                        continue
                       else
                        if image(y+4,x+1) > cb 
                         if image(y+-4,x+1) > cb 
                          if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                           continue
                          else
                           if image(y+-2,x+-2) > cb 
                            if image(y+2,x+-1) > cb | image(y+2,x+-1) < c_b 
                             continue
                            else
                             if image(y+-3,x+2) > cb 
                              if image(y+-2,x+3) > cb 
                              else
                               continue
                              end
                             elseif image(y+-3,x+2) < c_b 
                              continue
                             else
                             end
                            end
                           else
                            continue
                           end
                          end
                         else
                          continue
                         end
                        elseif image(y+4,x+1) < c_b 
                         continue
                        else
                         if image(y+-1,x+-4) > cb 
                         elseif image(y+-1,x+-4) < c_b 
                          continue
                         else
                          if image(y+-4,x+1) > cb 
                          else
                           continue
                          end
                         end
                        end
                       end
                      elseif image(y+1,x+-4) < c_b 
                       if image(y+-2,x+-2) > cb 
                       elseif image(y+-2,x+-2) < c_b 
                        continue
                       else
                        if image(y+2,x+1) > cb | image(y+2,x+1) < c_b 
                         continue
                        else
                        end
                       end
                      else
                       if image(y+3,x+-1) < c_b
                        if image(y+3,x+1) > cb | image(y+3,x+1) < c_b 
                         continue
                        else
                         if image(y+2,x+-1) > cb 
                          continue
                         elseif image(y+2,x+-1) < c_b 
                          if image(y+-4,x+1) > cb 
                           if image(y+-1,x+-2) > cb 
                           else
                            continue
                           end
                          else
                          end
                         else
                          if image(y+2,x+0) > cb | image(y+2,x+0) < c_b 
                           continue
                          else
                           if image(y+0,x+3) > cb 
                           elseif image(y+0,x+3) < c_b 
                            continue
                           else
                            if image(y+-2,x+3) < c_b
                            else
                             continue
                            end
                           end
                          end
                         end
                        end
                       else
                       end
                      end
                     end
                    end
                   elseif image(y+-4,x+-1) < c_b 
                   else
                    if image(y+0,x+-4) > cb 
                     if image(y+4,x+0) > cb | image(y+4,x+0) < c_b 
                     else
                      if image(y+3,x+-1) > cb 
                       if image(y+-4,x+1) > cb 
                       elseif image(y+-4,x+1) < c_b 
                        continue
                       else
                        if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                         continue
                        else
                        end
                       end
                      else
                      end
                     end
                    elseif image(y+0,x+-4) < c_b 
                     if image(y+-2,x+-3) > cb 
                     elseif image(y+-2,x+-3) < c_b 
                      continue
                     else
                      if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                       continue
                      else
                      end
                     end
                    else
                     if image(y+-2,x+-3) > cb 
                      if image(y+-3,x+0) > cb 
                       if image(y+3,x+-1) < c_b
                        if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                         continue
                        else
                        end
                       else
                       end
                      elseif image(y+-3,x+0) < c_b 
                       continue
                      else
                       if image(y+3,x+2) > cb 
                        if image(y+3,x+-1) > cb 
                        elseif image(y+3,x+-1) < c_b 
                         continue
                        else
                         if image(y+-1,x+4) > cb 
                          if image(y+-1,x+-2) > cb 
                          elseif image(y+-1,x+-2) < c_b 
                           continue
                          else
                           if image(y+-1,x+2) > cb 
                           elseif image(y+-1,x+2) < c_b 
                            continue
                           else
                            if image(y+0,x+-3) > cb 
                            else
                             continue
                            end
                           end
                          end
                         elseif image(y+-1,x+4) < c_b 
                          continue
                         else
                          if image(y+-4,x+1) > cb 
                           if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-4,x+1) < c_b 
                          else
                           if image(y+2,x+0) > cb 
                            if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                             continue
                            else
                            end
                           else
                            continue
                           end
                          end
                         end
                        end
                       elseif image(y+3,x+2) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+-2,x+-3) < c_b 
                      continue
                     else
                      if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                      else
                       if image(y+-1,x+-2) > cb 
                        if image(y+-3,x+1) > cb 
                        elseif image(y+-3,x+1) < c_b 
                         continue
                        else
                         if image(y+4,x+-1) > cb 
                          if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                           continue
                          else
                          end
                         elseif image(y+4,x+-1) < c_b 
                          continue
                         else
                          if image(y+1,x+-4) > cb 
                          else
                           continue
                          end
                         end
                        end
                       elseif image(y+-1,x+-2) < c_b 
                        continue
                       else
                        if image(y+3,x+2) > cb 
                         if image(y+1,x+-2) > cb | image(y+1,x+-2) < c_b 
                         else
                          if image(y+2,x+0) > cb 
                           if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                            continue
                           else
                            if image(y+2,x+-1) > cb | image(y+2,x+-1) < c_b 
                             continue
                            else
                             if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                              continue
                             else
                             end
                            end
                           end
                          elseif image(y+2,x+0) < c_b 
                           continue
                          else
                           if image(y+-2,x+3) > cb 
                            if image(y+2,x+1) > cb 
                            else
                             continue
                            end
                           else
                            continue
                           end
                          end
                         end
                        elseif image(y+3,x+2) < c_b 
                         continue
                        else
                         if image(y+1,x+4) > cb 
                          if image(y+1,x+-2) > cb | image(y+1,x+-2) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+-2,x+0) < c_b 
                   continue
                  else
                   if image(y+1,x+-3) > cb 
                    if image(y+3,x+2) > cb 
                     if image(y+3,x+-1) > cb 
                      if image(y+0,x+-2) > cb 
                       if image(y+0,x+3) > cb 
                        if image(y+-3,x+1) > cb 
                         if image(y+-1,x+3) > cb 
                          if image(y+-3,x+2) > cb 
                          elseif image(y+-3,x+2) < c_b 
                           continue
                          else
                           if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+-1,x+3) < c_b 
                          continue
                         else
                         end
                        elseif image(y+-3,x+1) < c_b 
                         continue
                        else
                         if image(y+2,x+1) > cb 
                         elseif image(y+2,x+1) < c_b 
                          continue
                         else
                          if image(y+1,x+-2) > cb 
                          else
                           continue
                          end
                         end
                        end
                       elseif image(y+0,x+3) < c_b 
                        continue
                       else
                       end
                      elseif image(y+0,x+-2) < c_b 
                       continue
                      else
                       if image(y+2,x+0) > cb 
                        if image(y+-1,x+-2) > cb 
                        elseif image(y+-1,x+-2) < c_b 
                         continue
                        else
                         if image(y+0,x+3) > cb 
                         elseif image(y+0,x+3) < c_b 
                          continue
                         else
                          if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+2,x+0) < c_b 
                        continue
                       else
                        if image(y+-1,x+3) > cb 
                        elseif image(y+-1,x+3) < c_b 
                         continue
                        else
                         if image(y+-3,x+1) > cb 
                         else
                          continue
                         end
                        end
                       end
                      end
                     elseif image(y+3,x+-1) < c_b 
                      continue
                     else
                     end
                    elseif image(y+3,x+2) < c_b 
                     continue
                    else
                     if image(y+1,x+4) > cb 
                      if image(y+4,x+-1) > cb 
                       if image(y+-2,x+-2) > cb 
                        if image(y+-1,x+3) > cb 
                        elseif image(y+-1,x+3) < c_b 
                         continue
                        else
                         if image(y+-1,x+4) > cb 
                          if image(y+-4,x+1) > cb 
                           if image(y+0,x+-2) > cb 
                           elseif image(y+0,x+-2) < c_b 
                            continue
                           else
                            if image(y+-3,x+1) > cb 
                            else
                             continue
                            end
                           end
                          else
                           continue
                          end
                         elseif image(y+-1,x+4) < c_b 
                          continue
                         else
                         end
                        end
                       else
                        continue
                       end
                      elseif image(y+4,x+-1) < c_b 
                       if image(y+0,x+-2) > cb 
                       else
                        continue
                       end
                      else
                      end
                     elseif image(y+1,x+4) < c_b 
                      continue
                     else
                      if image(y+2,x+0) > cb 
                      elseif image(y+2,x+0) < c_b 
                       continue
                      else
                       if image(y+4,x+0) > cb 
                        if image(y+-1,x+-4) > cb 
                        elseif image(y+-1,x+-4) < c_b 
                         continue
                        else
                         if image(y+-4,x+1) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+4,x+0) < c_b 
                       else
                        if image(y+-2,x+-3) > cb 
                         if image(y+2,x+1) > cb 
                          if image(y+-2,x+-2) > cb 
                          else
                           continue
                          end
                         else
                          continue
                         end
                        elseif image(y+-2,x+-3) < c_b 
                         continue
                        else
                         if image(y+0,x+3) > cb 
                          if image(y+-4,x+0) > cb 
                          else
                           continue
                          end
                         elseif image(y+0,x+3) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+1,x+-3) < c_b 
                    if image(y+1,x+-2) > cb 
                     continue
                    elseif image(y+1,x+-2) < c_b 
                    else
                     if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
                     else
                      if image(y+0,x+-2) > cb 
                       continue
                      elseif image(y+0,x+-2) < c_b 
                       if image(y+-4,x+1) > cb 
                       else
                        continue
                       end
                      else
                       if image(y+-2,x+-3) > cb 
                        if image(y+1,x+-4) < c_b
                         if image(y+2,x+1) > cb 
                         elseif image(y+2,x+1) < c_b 
                          continue
                         else
                          if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                           continue
                          else
                           if image(y+-3,x+-1) > cb 
                           else
                            continue
                           end
                          end
                         end
                        else
                         continue
                        end
                       elseif image(y+-2,x+-3) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    end
                   else
                    if image(y+3,x+-1) > cb 
                     if image(y+-2,x+-3) > cb 
                     elseif image(y+-2,x+-3) < c_b 
                      continue
                     else
                      if image(y+-4,x+-1) > cb 
                       if image(y+1,x+-4) > cb 
                        if image(y+2,x+2) > cb 
                         if image(y+2,x+0) > cb 
                         elseif image(y+2,x+0) < c_b 
                          continue
                         else
                          if image(y+-1,x+4) > cb 
                           if image(y+-2,x+3) > cb 
                           else
                            continue
                           end
                          elseif image(y+-1,x+4) < c_b 
                           continue
                          else
                          end
                         end
                        else
                         continue
                        end
                       elseif image(y+1,x+-4) < c_b 
                        continue
                       else
                       end
                      elseif image(y+-4,x+-1) < c_b 
                       continue
                      else
                       if image(y+-1,x+-2) > cb 
                        if image(y+4,x+-1) > cb 
                        elseif image(y+4,x+-1) < c_b 
                         continue
                        else
                         if image(y+2,x+0) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+-1,x+-2) < c_b 
                        continue
                       else
                        if image(y+0,x+-4) > cb 
                        elseif image(y+0,x+-4) < c_b 
                         continue
                        else
                         if image(y+3,x+2) > cb | image(y+3,x+2) < c_b 
                          continue
                         else
                          if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+3,x+-1) < c_b 
                     if image(y+2,x+-1) > cb 
                      continue
                     elseif image(y+2,x+-1) < c_b 
                     else
                      if image(y+2,x+0) > cb | image(y+2,x+0) < c_b 
                       continue
                      else
                       if image(y+1,x+3) > cb 
                        if image(y+4,x+-1) > cb 
                         continue
                        elseif image(y+4,x+-1) < c_b 
                        else
                         if image(y+3,x+2) > cb 
                          if image(y+-2,x+2) < c_b
                          else
                           continue
                          end
                         elseif image(y+3,x+2) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+1,x+3) < c_b 
                        continue
                       else
                        if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     end
                    else
                     if image(y+-2,x+-3) > cb 
                      if image(y+3,x+2) > cb 
                       if image(y+-1,x+3) > cb 
                        if image(y+2,x+1) > cb 
                         if image(y+-3,x+1) > cb 
                          if image(y+-2,x+2) > cb 
                           if image(y+3,x+1) > cb 
                           elseif image(y+3,x+1) < c_b 
                            continue
                           else
                            if image(y+-1,x+-3) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+-2,x+2) < c_b 
                           continue
                          else
                           if image(y+4,x+1) > cb 
                            if image(y+3,x+0) > cb 
                             if image(y+4,x+0) > cb 
                              if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                               continue
                              else
                               if image(y+1,x+-4) > cb 
                               elseif image(y+1,x+-4) < c_b 
                                continue
                               else
                                if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                                 continue
                                else
                                 if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                                  continue
                                 else
                                  if image(y+-1,x+-2) > cb 
                                  elseif image(y+-1,x+-2) < c_b 
                                   continue
                                  else
                                   if image(y+0,x+-4) > cb 
                                   else
                                    continue
                                   end
                                  end
                                 end
                                end
                               end
                              end
                             elseif image(y+4,x+0) < c_b 
                              continue
                             else
                             end
                            else
                             continue
                            end
                           elseif image(y+4,x+1) < c_b 
                            continue
                           else
                            if image(y+4,x+-1) > cb 
                            elseif image(y+4,x+-1) < c_b 
                             continue
                            else
                             if image(y+3,x+0) > cb 
                              if image(y+-4,x+0) > cb 
                              else
                               continue
                              end
                             elseif image(y+3,x+0) < c_b 
                              continue
                             else
                              if image(y+-1,x+2) > cb 
                               if image(y+-3,x+2) > cb 
                               else
                                continue
                               end
                              else
                               continue
                              end
                             end
                            end
                           end
                          end
                         elseif image(y+-3,x+1) < c_b 
                          continue
                         else
                          if image(y+-1,x+2) > cb 
                           if image(y+3,x+0) > cb 
                           elseif image(y+3,x+0) < c_b 
                            continue
                           else
                            if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                             continue
                            else
                            end
                           end
                          elseif image(y+-1,x+2) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+2,x+1) < c_b 
                         continue
                        else
                         if image(y+0,x+-2) > cb 
                          if image(y+0,x+-4) > cb 
                           if image(y+-1,x+2) > cb 
                           elseif image(y+-1,x+2) < c_b 
                            continue
                           else
                            if image(y+-1,x+-4) > cb 
                             if image(y+1,x+-2) > cb 
                             else
                              continue
                             end
                            elseif image(y+-1,x+-4) < c_b 
                             continue
                            else
                            end
                           end
                          elseif image(y+0,x+-4) < c_b 
                           continue
                          else
                           if image(y+0,x+-3) > cb 
                            if image(y+2,x+0) > cb | image(y+2,x+0) < c_b 
                             continue
                            else
                            end
                           elseif image(y+0,x+-3) < c_b 
                            continue
                           else
                            if image(y+-4,x+1) > cb 
                            else
                             continue
                            end
                           end
                          end
                         elseif image(y+0,x+-2) < c_b 
                         else
                          if image(y+-2,x+2) > cb 
                           if image(y+-1,x+-2) > cb 
                            if image(y+-1,x+-4) > cb 
                            elseif image(y+-1,x+-4) < c_b 
                             continue
                            else
                             if image(y+-1,x+2) > cb 
                             else
                              continue
                             end
                            end
                           elseif image(y+-1,x+-2) < c_b 
                            continue
                           else
                            if image(y+0,x+-4) > cb 
                             if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                              continue
                             else
                              if image(y+-4,x+-1) > cb 
                              else
                               continue
                              end
                             end
                            elseif image(y+0,x+-4) < c_b 
                            else
                             continue
                            end
                           end
                          elseif image(y+-2,x+2) < c_b 
                           continue
                          else
                           if image(y+0,x+-3) > cb 
                            if image(y+0,x+-4) > cb 
                             if image(y+-1,x+-4) > cb 
                              if image(y+2,x+-2) > cb | image(y+2,x+-2) < c_b 
                              else
                               if image(y+-4,x+1) > cb 
                                if image(y+4,x+0) > cb 
                                 if image(y+4,x+1) > cb | image(y+4,x+1) < c_b 
                                  continue
                                 else
                                 end
                                else
                                 continue
                                end
                               elseif image(y+-4,x+1) < c_b 
                               else
                                continue
                               end
                              end
                             elseif image(y+-1,x+-4) < c_b 
                              continue
                             else
                             end
                            elseif image(y+0,x+-4) < c_b 
                             continue
                            else
                             if image(y+-1,x+4) > cb 
                             else
                              continue
                             end
                            end
                           elseif image(y+0,x+-3) < c_b 
                            continue
                           else
                            if image(y+3,x+0) > cb 
                             if image(y+4,x+0) > cb | image(y+4,x+0) < c_b 
                              continue
                             else
                              if image(y+-4,x+1) > cb 
                              else
                               continue
                              end
                             end
                            elseif image(y+3,x+0) < c_b 
                            else
                             if image(y+2,x+-2) > cb 
                             elseif image(y+2,x+-2) < c_b 
                              continue
                             else
                              if image(y+4,x+-1) > cb 
                               if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                                continue
                               else
                                if image(y+-3,x+-1) > cb 
                                else
                                 continue
                                end
                               end
                              else
                               continue
                              end
                             end
                            end
                           end
                          end
                         end
                        end
                       elseif image(y+-1,x+3) < c_b 
                        if image(y+-1,x+4) > cb 
                         continue
                        elseif image(y+-1,x+4) < c_b 
                        else
                         if image(y+2,x+1) > cb 
                          if image(y+-2,x+3) > cb 
                           continue
                          elseif image(y+-2,x+3) < c_b 
                          else
                           if image(y+2,x+0) > cb 
                           else
                            continue
                           end
                          end
                         elseif image(y+2,x+1) < c_b 
                          continue
                         else
                          if image(y+-1,x+2) < c_b
                          else
                           continue
                          end
                         end
                        end
                       else
                        if image(y+-3,x+1) > cb 
                         if image(y+-1,x+-2) > cb 
                         elseif image(y+-1,x+-2) < c_b 
                          continue
                         else
                          if image(y+4,x+0) > cb 
                           if image(y+4,x+1) > cb 
                            if image(y+2,x+-2) > cb | image(y+2,x+-2) < c_b 
                            else
                             if image(y+-1,x+4) > cb 
                              if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                               continue
                              else
                               if image(y+-1,x+-3) > cb 
                               else
                                continue
                               end
                              end
                             elseif image(y+-1,x+4) < c_b 
                             else
                              if image(y+1,x+-4) < c_b
                              else
                               continue
                              end
                             end
                            end
                           elseif image(y+4,x+1) < c_b 
                            continue
                           else
                           end
                          elseif image(y+4,x+0) < c_b 
                          else
                           if image(y+3,x+0) > cb 
                            if image(y+-4,x+1) > cb 
                             if image(y+0,x+-4) < c_b
                              continue
                             else
                             end
                            else
                             continue
                            end
                           elseif image(y+3,x+0) < c_b 
                            continue
                           else
                            if image(y+2,x+-2) > cb 
                            elseif image(y+2,x+-2) < c_b 
                             continue
                            else
                             if image(y+-2,x+3) > cb 
                              if image(y+-3,x+-1) > cb 
                               if image(y+0,x+-3) > cb 
                               else
                                continue
                               end
                              elseif image(y+-3,x+-1) < c_b 
                               continue
                              else
                              end
                             else
                              continue
                             end
                            end
                           end
                          end
                         end
                        elseif image(y+-3,x+1) < c_b 
                         if image(y+-4,x+1) > cb 
                          continue
                         elseif image(y+-4,x+1) < c_b 
                         else
                          if image(y+-1,x+-2) > cb 
                          else
                           continue
                          end
                         end
                        else
                         if image(y+2,x+0) > cb 
                          if image(y+-1,x+-2) > cb 
                           if image(y+3,x+0) > cb 
                           elseif image(y+3,x+0) < c_b 
                            continue
                           else
                            if image(y+4,x+1) > cb 
                            elseif image(y+4,x+1) < c_b 
                             continue
                            else
                             if image(y+-4,x+1) > cb 
                             elseif image(y+-4,x+1) < c_b 
                              continue
                             else
                              if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                               continue
                              else
                              end
                             end
                            end
                           end
                          elseif image(y+-1,x+-2) < c_b 
                           continue
                          else
                           if image(y+4,x+0) > cb 
                            if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                             continue
                            else
                             if image(y+0,x+-4) > cb 
                             elseif image(y+0,x+-4) < c_b 
                              continue
                             else
                              if image(y+1,x+3) > cb | image(y+1,x+3) < c_b 
                               continue
                              else
                              end
                             end
                            end
                           elseif image(y+4,x+0) < c_b 
                            continue
                           else
                            if image(y+-4,x+1) > cb 
                             if image(y+3,x+0) > cb 
                             elseif image(y+3,x+0) < c_b 
                              continue
                             else
                              if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                               continue
                              else
                              end
                             end
                            elseif image(y+-4,x+1) < c_b 
                             continue
                            else
                             if image(y+-2,x+2) > cb 
                              continue
                             elseif image(y+-2,x+2) < c_b 
                             else
                              if image(y+2,x+-1) > cb 
                              else
                               continue
                              end
                             end
                            end
                           end
                          end
                         elseif image(y+2,x+0) < c_b 
                          continue
                         else
                          if image(y+0,x+-2) > cb 
                           if image(y+2,x+1) > cb 
                            if image(y+0,x+-3) > cb 
                            elseif image(y+0,x+-3) < c_b 
                             continue
                            else
                             if image(y+-3,x+0) > cb 
                             elseif image(y+-3,x+0) < c_b 
                              continue
                             else
                              if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                               continue
                              else
                              end
                             end
                            end
                           elseif image(y+2,x+1) < c_b 
                            continue
                           else
                            if image(y+0,x+-4) > cb 
                             if image(y+4,x+1) > cb | image(y+4,x+1) < c_b 
                              continue
                             else
                              if image(y+4,x+0) > cb 
                              elseif image(y+4,x+0) < c_b 
                               continue
                              else
                               if image(y+-3,x+-1) > cb 
                                if image(y+-2,x+2) < c_b
                                else
                                 continue
                                end
                               elseif image(y+-3,x+-1) < c_b 
                                continue
                               else
                               end
                              end
                             end
                            elseif image(y+0,x+-4) < c_b 
                             continue
                            else
                             if image(y+-1,x+4) > cb 
                              if image(y+0,x+-3) > cb 
                              elseif image(y+0,x+-3) < c_b 
                               continue
                              else
                               if image(y+-4,x+1) > cb 
                               else
                                continue
                               end
                              end
                             elseif image(y+-1,x+4) < c_b 
                              continue
                             else
                              if image(y+-4,x+1) > cb 
                               continue
                              elseif image(y+-4,x+1) < c_b 
                              else
                               if image(y+1,x+-2) > cb 
                               else
                                continue
                               end
                              end
                             end
                            end
                           end
                          elseif image(y+0,x+-2) < c_b 
                           continue
                          else
                           if image(y+-2,x+2) > cb 
                            if image(y+-1,x+-4) > cb 
                            else
                             continue
                            end
                           elseif image(y+-2,x+2) < c_b 
                            if image(y+-1,x+-2) > cb 
                            elseif image(y+-1,x+-2) < c_b 
                             continue
                            else
                             if image(y+2,x+1) > cb 
                             elseif image(y+2,x+1) < c_b 
                              continue
                             else
                              if image(y+2,x+-2) > cb 
                               continue
                              elseif image(y+2,x+-2) < c_b 
                              else
                               if image(y+1,x+-4) > cb 
                                continue
                               elseif image(y+1,x+-4) < c_b 
                               else
                                if image(y+2,x+-1) < c_b
                                else
                                 continue
                                end
                               end
                              end
                             end
                            end
                           else
                            if image(y+2,x+-2) > cb 
                             continue
                            elseif image(y+2,x+-2) < c_b 
                            else
                             if image(y+-4,x+-1) > cb 
                              if image(y+1,x+4) > cb 
                               if image(y+0,x+-4) > cb 
                                if image(y+-1,x+-4) > cb 
                                 if image(y+4,x+1) > cb 
                                  if image(y+0,x+4) > cb 
                                   if image(y+4,x+0) > cb 
                                    if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                                     continue
                                    else
                                     if image(y+-3,x+0) > cb 
                                      if image(y+-1,x+-2) > cb 
                                       if image(y+4,x+-1) > cb 
                                       else
                                        continue
                                       end
                                      else
                                       continue
                                      end
                                     else
                                      continue
                                     end
                                    end
                                   elseif image(y+4,x+0) < c_b 
                                    continue
                                   else
                                    if image(y+3,x+0) > cb 
                                     if image(y+-4,x+1) > cb 
                                     else
                                      continue
                                     end
                                    elseif image(y+3,x+0) < c_b 
                                     continue
                                    else
                                     if image(y+4,x+-1) < c_b
                                     else
                                      continue
                                     end
                                    end
                                   end
                                  elseif image(y+0,x+4) < c_b 
                                   continue
                                  else
                                   if image(y+0,x+3) > cb 
                                    if image(y+1,x+-4) > cb 
                                     if image(y+2,x+1) > cb 
                                     else
                                      continue
                                     end
                                    else
                                     continue
                                    end
                                   elseif image(y+0,x+3) < c_b 
                                    continue
                                   else
                                    if image(y+4,x+0) > cb | image(y+4,x+0) < c_b 
                                     continue
                                    else
                                     if image(y+3,x+0) > cb 
                                      if image(y+-4,x+1) > cb 
                                      else
                                       continue
                                      end
                                     else
                                      continue
                                     end
                                    end
                                   end
                                  end
                                 elseif image(y+4,x+1) < c_b 
                                  continue
                                 else
                                  if image(y+3,x+0) > cb 
                                   if image(y+-4,x+1) > cb 
                                   else
                                    continue
                                   end
                                  elseif image(y+3,x+0) < c_b 
                                   continue
                                  else
                                   if image(y+4,x+0) > cb 
                                    if image(y+-4,x+1) > cb 
                                    else
                                     continue
                                    end
                                   else
                                    continue
                                   end
                                  end
                                 end
                                elseif image(y+-1,x+-4) < c_b 
                                 continue
                                else
                                 if image(y+-1,x+4) > cb 
                                 else
                                  continue
                                 end
                                end
                               elseif image(y+0,x+-4) < c_b 
                               else
                                if image(y+0,x+-3) > cb 
                                 if image(y+-1,x+4) > cb 
                                  if image(y+-2,x+-2) > cb 
                                  elseif image(y+-2,x+-2) < c_b 
                                   continue
                                  else
                                   if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                                    continue
                                   else
                                   end
                                  end
                                 else
                                  continue
                                 end
                                elseif image(y+0,x+-3) < c_b 
                                 continue
                                else
                                 if image(y+-4,x+1) > cb 
                                  if image(y+3,x+0) > cb 
                                   if image(y+4,x+0) > cb 
                                    if image(y+4,x+1) > cb 
                                     if image(y+1,x+-4) > cb 
                                      continue
                                     elseif image(y+1,x+-4) < c_b 
                                     else
                                      if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                                       continue
                                      else
                                       if image(y+-3,x+0) > cb 
                                       else
                                        continue
                                       end
                                      end
                                     end
                                    elseif image(y+4,x+1) < c_b 
                                     continue
                                    else
                                    end
                                   elseif image(y+4,x+0) < c_b 
                                    continue
                                   else
                                    if image(y+2,x+2) > cb 
                                    elseif image(y+2,x+2) < c_b 
                                     continue
                                    else
                                     if image(y+-1,x+-4) > cb 
                                     else
                                      continue
                                     end
                                    end
                                   end
                                  elseif image(y+3,x+0) < c_b 
                                   continue
                                  else
                                   if image(y+4,x+0) > cb 
                                    if image(y+4,x+1) > cb | image(y+4,x+1) < c_b 
                                     continue
                                    else
                                    end
                                   else
                                    continue
                                   end
                                  end
                                 elseif image(y+-4,x+1) < c_b 
                                 else
                                  if image(y+-1,x+4) > cb 
                                   if image(y+4,x+-1) > cb 
                                    if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                                     continue
                                    else
                                     if image(y+-3,x+0) > cb 
                                     else
                                      continue
                                     end
                                    end
                                   else
                                    continue
                                   end
                                  elseif image(y+-1,x+4) < c_b 
                                  else
                                   if image(y+4,x+-1) > cb 
                                    continue
                                   elseif image(y+4,x+-1) < c_b 
                                    if image(y+-2,x+-2) > cb 
                                    else
                                     continue
                                    end
                                   else
                                    if image(y+1,x+-4) < c_b
                                     if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                                      continue
                                     else
                                     end
                                    else
                                     continue
                                    end
                                   end
                                  end
                                 end
                                end
                               end
                              elseif image(y+1,x+4) < c_b 
                               continue
                              else
                               if image(y+0,x+4) > cb 
                                if image(y+1,x+-4) > cb 
                                 if image(y+2,x+1) > cb 
                                 elseif image(y+2,x+1) < c_b 
                                  continue
                                 else
                                  if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                                   continue
                                  else
                                  end
                                 end
                                elseif image(y+1,x+-4) < c_b 
                                 continue
                                else
                                 if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                                  continue
                                 else
                                  if image(y+4,x+1) > cb | image(y+4,x+1) < c_b 
                                   continue
                                  else
                                   if image(y+3,x+1) > cb | image(y+3,x+1) < c_b 
                                    continue
                                   else
                                   end
                                  end
                                 end
                                end
                               elseif image(y+0,x+4) < c_b 
                                continue
                               else
                                if image(y+3,x+0) > cb 
                                 if image(y+4,x+1) > cb 
                                  if image(y+0,x+3) > cb 
                                   if image(y+2,x+1) > cb 
                                   else
                                    continue
                                   end
                                  elseif image(y+0,x+3) < c_b 
                                   continue
                                  else
                                   if image(y+-3,x+2) > cb 
                                    if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                                     continue
                                    else
                                    end
                                   elseif image(y+-3,x+2) < c_b 
                                    continue
                                   else
                                    if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                                     continue
                                    else
                                     if image(y+-3,x+0) > cb 
                                      if image(y+0,x+-3) > cb 
                                      else
                                       continue
                                      end
                                     else
                                      continue
                                     end
                                    end
                                   end
                                  end
                                 elseif image(y+4,x+1) < c_b 
                                  continue
                                 else
                                 end
                                elseif image(y+3,x+0) < c_b 
                                 continue
                                else
                                 if image(y+-1,x+4) > cb 
                                  if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                                   continue
                                  else
                                  end
                                 else
                                  continue
                                 end
                                end
                               end
                              end
                             elseif image(y+-4,x+-1) < c_b 
                              continue
                             else
                              if image(y+-4,x+0) > cb 
                               if image(y+4,x+-1) > cb 
                                if image(y+-1,x+-2) > cb 
                                elseif image(y+-1,x+-2) < c_b 
                                 continue
                                else
                                 if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                                  continue
                                 else
                                 end
                                end
                               elseif image(y+4,x+-1) < c_b 
                                continue
                               else
                                if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                                 continue
                                else
                                 if image(y+0,x+3) > cb 
                                  if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                                   continue
                                  else
                                  end
                                 else
                                  continue
                                 end
                                end
                               end
                              elseif image(y+-4,x+0) < c_b 
                               continue
                              else
                               if image(y+0,x+-3) > cb 
                                if image(y+-1,x+-4) > cb 
                                 if image(y+4,x+-1) > cb 
                                  if image(y+-3,x+0) > cb 
                                   if image(y+-2,x+-2) > cb 
                                    if image(y+-1,x+-2) > cb 
                                    else
                                     continue
                                    end
                                   else
                                    continue
                                   end
                                  elseif image(y+-3,x+0) < c_b 
                                   continue
                                  else
                                   if image(y+-1,x+4) > cb | image(y+-1,x+4) < c_b 
                                    continue
                                   else
                                    if image(y+-3,x+-1) > cb 
                                     if image(y+-2,x+3) > cb 
                                     elseif image(y+-2,x+3) < c_b 
                                      continue
                                     else
                                      if image(y+1,x+4) > cb 
                                       if image(y+0,x+3) > cb 
                                        if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                                         continue
                                        else
                                        end
                                       else
                                        continue
                                       end
                                      elseif image(y+1,x+4) < c_b 
                                       continue
                                      else
                                       if image(y+2,x+2) > cb 
                                       else
                                        continue
                                       end
                                      end
                                     end
                                    else
                                     continue
                                    end
                                   end
                                  end
                                 else
                                  continue
                                 end
                                elseif image(y+-1,x+-4) < c_b 
                                 continue
                                else
                                end
                               elseif image(y+0,x+-3) < c_b 
                                continue
                               else
                                if image(y+-4,x+1) > cb 
                                 if image(y+-1,x+-3) > cb 
                                 else
                                  continue
                                 end
                                else
                                 continue
                                end
                               end
                              end
                             end
                            end
                           end
                          end
                         end
                        end
                       end
                      elseif image(y+3,x+2) < c_b 
                       continue
                      else
                       if image(y+1,x+4) > cb 
                        if image(y+4,x+-1) > cb 
                         if image(y+4,x+1) > cb 
                          if image(y+1,x+-4) > cb 
                           if image(y+-1,x+3) > cb 
                           elseif image(y+-1,x+3) < c_b 
                            continue
                           else
                            if image(y+0,x+3) > cb | image(y+0,x+3) < c_b 
                             continue
                            else
                            end
                           end
                          elseif image(y+1,x+-4) < c_b 
                           continue
                          else
                           if image(y+2,x+1) > cb 
                            if image(y+-1,x+-4) > cb 
                            else
                             continue
                            end
                           elseif image(y+2,x+1) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+4,x+1) < c_b 
                          continue
                         else
                          if image(y+2,x+1) > cb 
                           if image(y+-3,x+0) > cb 
                           elseif image(y+-3,x+0) < c_b 
                            continue
                           else
                            if image(y+-1,x+4) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+2,x+1) < c_b 
                           continue
                          else
                           if image(y+4,x+0) > cb 
                            if image(y+-4,x+1) > cb 
                            elseif image(y+-4,x+1) < c_b 
                             continue
                            else
                             if image(y+1,x+-2) > cb 
                             else
                              continue
                             end
                            end
                           elseif image(y+4,x+0) < c_b 
                            continue
                           else
                            if image(y+2,x+-1) < c_b
                            else
                             continue
                            end
                           end
                          end
                         end
                        elseif image(y+4,x+-1) < c_b 
                         if image(y+-4,x+-1) > cb 
                          if image(y+-1,x+2) > cb 
                          else
                           continue
                          end
                         elseif image(y+-4,x+-1) < c_b 
                          continue
                         else
                         end
                        else
                         if image(y+-2,x+2) > cb 
                          if image(y+-1,x+-2) > cb 
                           if image(y+0,x+-2) > cb 
                           elseif image(y+0,x+-2) < c_b 
                            continue
                           else
                            if image(y+-4,x+1) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+-1,x+-2) < c_b 
                           continue
                          else
                           if image(y+2,x+0) > cb 
                           elseif image(y+2,x+0) < c_b 
                            continue
                           else
                            if image(y+-1,x+-4) > cb 
                             if image(y+-4,x+-1) > cb 
                             else
                              continue
                             end
                            else
                             continue
                            end
                           end
                          end
                         elseif image(y+-2,x+2) < c_b 
                          if image(y+-1,x+-2) > cb 
                          elseif image(y+-1,x+-2) < c_b 
                           continue
                          else
                           if image(y+-4,x+1) < c_b
                           else
                            continue
                           end
                          end
                         else
                         end
                        end
                       elseif image(y+1,x+4) < c_b 
                       else
                        if image(y+4,x+0) > cb 
                         if image(y+3,x+0) > cb 
                          if image(y+0,x+4) > cb 
                          elseif image(y+0,x+4) < c_b 
                           continue
                          else
                           if image(y+-1,x+4) > cb | image(y+-1,x+4) < c_b 
                            continue
                           else
                            if image(y+0,x+-4) > cb 
                            else
                             continue
                            end
                           end
                          end
                         elseif image(y+3,x+0) < c_b 
                          continue
                         else
                         end
                        elseif image(y+4,x+0) < c_b 
                        else
                         if image(y+-3,x+1) > cb 
                          if image(y+-1,x+-2) > cb 
                          elseif image(y+-1,x+-2) < c_b 
                           continue
                          else
                           if image(y+3,x+0) > cb 
                           elseif image(y+3,x+0) < c_b 
                            continue
                           else
                            if image(y+-2,x+3) > cb 
                             if image(y+-1,x+-4) > cb 
                             else
                              continue
                             end
                            else
                             continue
                            end
                           end
                          end
                         elseif image(y+-3,x+1) < c_b 
                          continue
                         else
                          if image(y+2,x+1) > cb 
                           if image(y+-4,x+1) > cb 
                            if image(y+3,x+1) > cb | image(y+3,x+1) < c_b 
                             continue
                            else
                            end
                           elseif image(y+-4,x+1) < c_b 
                            continue
                           else
                            if image(y+1,x+-2) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+2,x+1) < c_b 
                           continue
                          else
                           if image(y+-2,x+2) < c_b
                           else
                            continue
                           end
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+-2,x+-3) < c_b 
                      continue
                     else
                      if image(y+-4,x+-1) > cb 
                       if image(y+-2,x+2) > cb 
                        if image(y+4,x+0) > cb 
                        elseif image(y+4,x+0) < c_b 
                         continue
                        else
                         if image(y+0,x+-2) > cb 
                         elseif image(y+0,x+-2) < c_b 
                          continue
                         else
                          if image(y+1,x+3) > cb 
                           if image(y+4,x+1) > cb 
                            if image(y+-3,x+1) > cb 
                            else
                             continue
                            end
                           elseif image(y+4,x+1) < c_b 
                            continue
                           else
                            if image(y+-1,x+-2) > cb 
                             if image(y+-1,x+4) > cb 
                             else
                              continue
                             end
                            else
                             continue
                            end
                           end
                          elseif image(y+1,x+3) < c_b 
                           continue
                          else
                           if image(y+-2,x+3) > cb 
                           else
                            continue
                           end
                          end
                         end
                        end
                       elseif image(y+-2,x+2) < c_b 
                        if image(y+2,x+1) > cb 
                        elseif image(y+2,x+1) < c_b 
                         continue
                        else
                         if image(y+-1,x+4) > cb 
                          continue
                         elseif image(y+-1,x+4) < c_b 
                         else
                          if image(y+-1,x+-2) > cb 
                          else
                           continue
                          end
                         end
                        end
                       else
                        if image(y+1,x+-4) > cb 
                         if image(y+-1,x+-4) > cb 
                          if image(y+4,x+-1) > cb 
                           if image(y+-3,x+0) > cb 
                            if image(y+-3,x+1) > cb 
                            elseif image(y+-3,x+1) < c_b 
                             continue
                            else
                             if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                              continue
                             else
                             end
                            end
                           elseif image(y+-3,x+0) < c_b 
                            continue
                           else
                           end
                          elseif image(y+4,x+-1) < c_b 
                           continue
                          else
                           if image(y+-1,x+-2) > cb 
                            if image(y+4,x+1) > cb 
                            elseif image(y+4,x+1) < c_b 
                             continue
                            else
                             if image(y+-4,x+1) > cb 
                             else
                              continue
                             end
                            end
                           elseif image(y+-1,x+-2) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+-1,x+-4) < c_b 
                          continue
                         else
                          if image(y+3,x+2) > cb 
                           if image(y+-1,x+-2) > cb 
                            if image(y+-4,x+1) > cb 
                            elseif image(y+-4,x+1) < c_b 
                             continue
                            else
                             if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                              continue
                             else
                             end
                            end
                           elseif image(y+-1,x+-2) < c_b 
                            continue
                           else
                            if image(y+0,x+-4) > cb 
                             if image(y+0,x+3) > cb 
                             elseif image(y+0,x+3) < c_b 
                              continue
                             else
                              if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                               continue
                              else
                              end
                             end
                            elseif image(y+0,x+-4) < c_b 
                             continue
                            else
                             if image(y+1,x+-2) < c_b
                             else
                              continue
                             end
                            end
                           end
                          elseif image(y+3,x+2) < c_b 
                           continue
                          else
                           if image(y+1,x+4) > cb 
                           elseif image(y+1,x+4) < c_b 
                            continue
                           else
                            if image(y+-4,x+0) > cb 
                            else
                             continue
                            end
                           end
                          end
                         end
                        elseif image(y+1,x+-4) < c_b 
                         if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                          continue
                         else
                         end
                        else
                        end
                       end
                      elseif image(y+-4,x+-1) < c_b 
                       continue
                      else
                       if image(y+0,x+-4) > cb 
                        if image(y+0,x+-3) > cb 
                         if image(y+3,x+1) > cb 
                          if image(y+-4,x+0) > cb 
                          elseif image(y+-4,x+0) < c_b 
                           continue
                          else
                           if image(y+-2,x+3) > cb 
                           elseif image(y+-2,x+3) < c_b 
                            continue
                           else
                            if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                             continue
                            else
                            end
                           end
                          end
                         elseif image(y+3,x+1) < c_b 
                          continue
                         else
                         end
                        elseif image(y+0,x+-3) < c_b 
                         continue
                        else
                        end
                       elseif image(y+0,x+-4) < c_b 
                       else
                        if image(y+-1,x+3) > cb 
                         if image(y+2,x+1) > cb 
                         elseif image(y+2,x+1) < c_b 
                          continue
                         else
                          if image(y+0,x+-3) > cb 
                          elseif image(y+0,x+-3) < c_b 
                           continue
                          else
                           if image(y+3,x+2) > cb 
                            if image(y+-1,x+4) > cb 
                             if image(y+3,x+0) > cb 
                             else
                              continue
                             end
                            elseif image(y+-1,x+4) < c_b 
                             continue
                            else
                            end
                           elseif image(y+3,x+2) < c_b 
                            continue
                           else
                            if image(y+-1,x+-2) > cb | image(y+-1,x+-2) < c_b 
                             continue
                            else
                            end
                           end
                          end
                         end
                        elseif image(y+-1,x+3) < c_b 
                         continue
                        else
                         if image(y+1,x+4) > cb 
                          if image(y+3,x+2) > cb 
                           if image(y+-2,x+2) > cb 
                            continue
                           elseif image(y+-2,x+2) < c_b 
                           else
                            if image(y+-1,x+-2) > cb 
                             if image(y+4,x+0) > cb 
                              if image(y+-4,x+0) > cb 
                               if image(y+-4,x+1) > cb 
                               else
                                continue
                               end
                              else
                               continue
                              end
                             elseif image(y+4,x+0) < c_b 
                              continue
                             else
                             end
                            else
                             continue
                            end
                           end
                          elseif image(y+3,x+2) < c_b 
                           continue
                          else
                           if image(y+4,x+-1) > cb | image(y+4,x+-1) < c_b 
                            continue
                           else
                            if image(y+-3,x+2) > cb 
                             if image(y+-4,x+1) > cb 
                             else
                              continue
                             end
                            elseif image(y+-3,x+2) < c_b 
                             continue
                            else
                            end
                           end
                          end
                         elseif image(y+1,x+4) < c_b 
                          continue
                         else
                          if image(y+-2,x+2) > cb 
                          elseif image(y+-2,x+2) < c_b 
                           continue
                          else
                           if image(y+1,x+-2) < c_b
                           else
                            if image(y+-2,x+3) > cb 
                            else
                             continue
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  end
                 end
                end
               elseif image(y+1,x+2) < c_b 
                if image(y+2,x+-1) > cb 
                elseif image(y+2,x+-1) < c_b 
                 if image(y+-3,x+-1) > cb 
                 elseif image(y+-3,x+-1) < c_b 
                  continue
                 else
                  if image(y+-3,x+2) > cb 
                  else
                   continue
                  end
                 end
                else
                 if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
                 else
                  if image(y+3,x+-1) > cb 
                   if image(y+0,x+-2) > cb 
                    if image(y+-1,x+4) > cb 
                     if image(y+-4,x+0) > cb 
                     else
                      continue
                     end
                    elseif image(y+-1,x+4) < c_b 
                     continue
                    else
                    end
                   else
                    continue
                   end
                  elseif image(y+3,x+-1) < c_b 
                  else
                   if image(y+0,x+-3) > cb 
                    if image(y+-1,x+4) > cb 
                     if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                      continue
                     else
                     end
                    elseif image(y+-1,x+4) < c_b 
                    else
                     continue
                    end
                   else
                    continue
                   end
                  end
                 end
                end
               else
                if image(y+3,x+2) > cb 
                 if image(y+1,x+-3) > cb 
                  if image(y+3,x+-1) > cb 
                   if image(y+2,x+-1) > cb 
                    if image(y+2,x+0) > cb 
                    elseif image(y+2,x+0) < c_b 
                     continue
                    else
                     if image(y+0,x+4) > cb 
                      if image(y+-1,x+-3) > cb 
                      elseif image(y+-1,x+-3) < c_b 
                       continue
                      else
                       if image(y+-4,x+-1) > cb 
                       else
                        continue
                       end
                      end
                     elseif image(y+0,x+4) < c_b 
                      continue
                     else
                      if image(y+-4,x+-1) > cb 
                       if image(y+-1,x+-2) > cb 
                       else
                        continue
                       end
                      elseif image(y+-4,x+-1) < c_b 
                       continue
                      else
                       if image(y+2,x+2) > cb 
                       elseif image(y+2,x+2) < c_b 
                        continue
                       else
                        if image(y+-4,x+1) > cb 
                        else
                         continue
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+2,x+-1) < c_b 
                    continue
                   else
                    if image(y+-3,x+1) > cb 
                     if image(y+-1,x+-2) > cb 
                      if image(y+-1,x+3) > cb 
                       if image(y+-2,x+2) > cb 
                       elseif image(y+-2,x+2) < c_b 
                        continue
                       else
                        if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                         continue
                        else
                         if image(y+-4,x+-1) > cb 
                         elseif image(y+-4,x+-1) < c_b 
                          continue
                         else
                          if image(y+2,x+2) > cb 
                          else
                           continue
                          end
                         end
                        end
                       end
                      elseif image(y+-1,x+3) < c_b 
                       if image(y+2,x+0) > cb 
                       else
                        continue
                       end
                      else
                      end
                     elseif image(y+-1,x+-2) < c_b 
                      continue
                     else
                      if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                       continue
                      else
                      end
                     end
                    elseif image(y+-3,x+1) < c_b 
                     continue
                    else
                     if image(y+2,x+0) > cb 
                      if image(y+-1,x+-2) > cb 
                      else
                       continue
                      end
                     elseif image(y+2,x+0) < c_b 
                      continue
                     else
                      if image(y+0,x+-2) > cb 
                       if image(y+2,x+1) > cb 
                       elseif image(y+2,x+1) < c_b 
                        continue
                       else
                        if image(y+-1,x+4) > cb 
                         if image(y+1,x+-2) < c_b
                          continue
                         else
                          if image(y+-2,x+2) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+-1,x+4) < c_b 
                         continue
                        else
                         if image(y+-1,x+2) > cb | image(y+-1,x+2) < c_b 
                         else
                          if image(y+2,x+-2) > cb 
                          elseif image(y+2,x+-2) < c_b 
                           continue
                          else
                           if image(y+-2,x+0) < c_b
                            continue
                           else
                            if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                             continue
                            else
                             if image(y+-3,x+0) > cb 
                             else
                              continue
                             end
                            end
                           end
                          end
                         end
                        end
                       end
                      elseif image(y+0,x+-2) < c_b 
                       continue
                      else
                       if image(y+2,x+-2) > cb 
                        if image(y+-4,x+-1) > cb 
                        else
                         continue
                        end
                       elseif image(y+2,x+-2) < c_b 
                        continue
                       else
                        if image(y+0,x+4) > cb 
                         if image(y+-4,x+-1) > cb 
                          if image(y+1,x+4) > cb | image(y+1,x+4) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-4,x+-1) < c_b 
                          continue
                         else
                         end
                        else
                         continue
                        end
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+3,x+-1) < c_b 
                   if image(y+0,x+2) > cb | image(y+0,x+2) < c_b 
                   else
                    if image(y+-3,x+1) > cb 
                     if image(y+-1,x+3) > cb 
                      continue
                     else
                     end
                    elseif image(y+-3,x+1) < c_b 
                    else
                     if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                     else
                      if image(y+3,x+0) > cb | image(y+3,x+0) < c_b 
                       continue
                      else
                       if image(y+1,x+3) > cb 
                       elseif image(y+1,x+3) < c_b 
                        continue
                       else
                        if image(y+4,x+-1) < c_b
                        else
                         continue
                        end
                       end
                      end
                     end
                    end
                   end
                  else
                   if image(y+2,x+-2) > cb 
                    if image(y+-4,x+-1) > cb 
                     if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                     else
                      if image(y+2,x+2) > cb 
                      elseif image(y+2,x+2) < c_b 
                       continue
                      else
                       if image(y+-4,x+1) > cb 
                       elseif image(y+-4,x+1) < c_b 
                        continue
                       else
                        if image(y+-1,x+-4) > cb 
                        else
                         continue
                        end
                       end
                      end
                     end
                    elseif image(y+-4,x+-1) < c_b 
                     continue
                    else
                     if image(y+-1,x+-4) > cb 
                      if image(y+-3,x+0) > cb 
                      elseif image(y+-3,x+0) < c_b 
                       continue
                      else
                       if image(y+2,x+-1) > cb 
                        if image(y+-1,x+4) > cb 
                        else
                         continue
                        end
                       else
                        continue
                       end
                      end
                     else
                     end
                    end
                   else
                   end
                  end
                 elseif image(y+1,x+-3) < c_b 
                  if image(y+2,x+-2) > cb 
                   if image(y+-1,x+-4) < c_b
                   else
                    continue
                   end
                  elseif image(y+2,x+-2) < c_b 
                  else
                   if image(y+-3,x+2) > cb 
                    if image(y+2,x+0) > cb 
                     if image(y+3,x+-1) > cb 
                     elseif image(y+3,x+-1) < c_b 
                      continue
                     else
                      if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                       continue
                      else
                      end
                     end
                    else
                     continue
                    end
                   elseif image(y+-3,x+2) < c_b 
                    if image(y+-4,x+0) > cb 
                     if image(y+0,x+-4) < c_b
                     else
                      continue
                     end
                    elseif image(y+-4,x+0) < c_b 
                     continue
                    else
                    end
                   else
                    if image(y+-1,x+-2) > cb 
                     if image(y+2,x+2) > cb 
                     elseif image(y+2,x+2) < c_b 
                      continue
                     else
                      if image(y+-4,x+1) > cb 
                      elseif image(y+-4,x+1) < c_b 
                       continue
                      else
                       if image(y+4,x+-1) > cb 
                        continue
                       elseif image(y+4,x+-1) < c_b 
                       else
                        if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     end
                    elseif image(y+-1,x+-2) < c_b 
                     continue
                    else
                     if image(y+-2,x+3) > cb 
                      continue
                     elseif image(y+-2,x+3) < c_b 
                      if image(y+1,x+-2) > cb 
                       continue
                      elseif image(y+1,x+-2) < c_b 
                      else
                       if image(y+4,x+1) > cb 
                        if image(y+-2,x+2) < c_b
                         if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                          continue
                         else
                         end
                        else
                         continue
                        end
                       elseif image(y+4,x+1) < c_b 
                        continue
                       else
                       end
                      end
                     else
                      if image(y+-4,x+1) > cb 
                       continue
                      elseif image(y+-4,x+1) < c_b 
                      else
                       if image(y+0,x+-3) < c_b
                        if image(y+3,x+0) > cb 
                         if image(y+-4,x+0) > cb 
                          if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-4,x+0) < c_b 
                          continue
                         else
                         end
                        else
                         continue
                        end
                       else
                        continue
                       end
                      end
                     end
                    end
                   end
                  end
                 else
                  if image(y+-1,x+-2) > cb 
                   if image(y+-3,x+1) > cb 
                    if image(y+-1,x+3) > cb 
                     if image(y+-2,x+2) > cb 
                      if image(y+-1,x+-4) > cb 
                      elseif image(y+-1,x+-4) < c_b 
                       continue
                      else
                       if image(y+3,x+0) > cb 
                        if image(y+-2,x+-3) > cb 
                        elseif image(y+-2,x+-3) < c_b 
                         continue
                        else
                         if image(y+2,x+-1) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+3,x+0) < c_b 
                        continue
                       else
                        if image(y+-4,x+-1) > cb 
                         if image(y+0,x+2) > cb 
                         elseif image(y+0,x+2) < c_b 
                          continue
                         else
                          if image(y+0,x+-2) > cb 
                           if image(y+-1,x+-3) > cb 
                            if image(y+-4,x+1) > cb 
                             if image(y+-4,x+0) > cb 
                              if image(y+-2,x+-3) > cb 
                               if image(y+-2,x+0) > cb 
                                if image(y+0,x+-3) > cb 
                                else
                                 continue
                                end
                               elseif image(y+-2,x+0) < c_b 
                                continue
                               else
                               end
                              else
                               continue
                              end
                             else
                              continue
                             end
                            elseif image(y+-4,x+1) < c_b 
                             continue
                            else
                            end
                           elseif image(y+-1,x+-3) < c_b 
                            continue
                           else
                           end
                          elseif image(y+0,x+-2) < c_b 
                           continue
                          else
                           if image(y+3,x+-2) > cb 
                            if image(y+3,x+-1) > cb 
                             if image(y+-1,x+2) > cb 
                             else
                              continue
                             end
                            elseif image(y+3,x+-1) < c_b 
                             continue
                            else
                            end
                           else
                            continue
                           end
                          end
                         end
                        elseif image(y+-4,x+-1) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     elseif image(y+-2,x+2) < c_b 
                      continue
                     else
                      if image(y+2,x+-2) > cb | image(y+2,x+-2) < c_b 
                      else
                       if image(y+-1,x+2) > cb 
                        if image(y+-4,x+-1) > cb 
                        else
                         continue
                        end
                       elseif image(y+-1,x+2) < c_b 
                        continue
                       else
                        if image(y+-1,x+-4) > cb 
                         if image(y+0,x+-2) > cb 
                          if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                           continue
                          else
                           if image(y+0,x+-3) > cb 
                            if image(y+0,x+-4) > cb 
                             if image(y+3,x+-1) > cb 
                              if image(y+-2,x+3) > cb 
                               if image(y+4,x+-1) > cb | image(y+4,x+-1) < c_b 
                                continue
                               else
                               end
                              elseif image(y+-2,x+3) < c_b 
                               continue
                              else
                              end
                             else
                              continue
                             end
                            elseif image(y+0,x+-4) < c_b 
                             continue
                            else
                             if image(y+2,x+2) > cb 
                             else
                              continue
                             end
                            end
                           else
                            continue
                           end
                          end
                         elseif image(y+0,x+-2) < c_b 
                          continue
                         else
                          if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                           continue
                          else
                           if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                            continue
                           else
                            if image(y+-4,x+0) > cb 
                             if image(y+0,x+-3) > cb 
                             else
                              continue
                             end
                            elseif image(y+-4,x+0) < c_b 
                             continue
                            else
                            end
                           end
                          end
                         end
                        elseif image(y+-1,x+-4) < c_b 
                        else
                         if image(y+0,x+-3) > cb 
                          if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                           continue
                          else
                          end
                         elseif image(y+0,x+-3) < c_b 
                          continue
                         else
                          if image(y+2,x+0) < c_b
                          else
                           continue
                          end
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+-1,x+3) < c_b 
                     if image(y+2,x+0) > cb | image(y+2,x+0) < c_b 
                     else
                      if image(y+-1,x+4) > cb 
                       continue
                      elseif image(y+-1,x+4) < c_b 
                       if image(y+0,x+2) > cb 
                        continue
                       elseif image(y+0,x+2) < c_b 
                        if image(y+0,x+3) > cb | image(y+0,x+3) < c_b 
                         continue
                        else
                        end
                       else
                       end
                      else
                       if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    else
                     if image(y+-2,x+2) > cb 
                      if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                      else
                       if image(y+2,x+1) > cb 
                       elseif image(y+2,x+1) < c_b 
                        continue
                       else
                        if image(y+-4,x+-1) > cb 
                         if image(y+2,x+-1) > cb 
                         elseif image(y+2,x+-1) < c_b 
                          continue
                         else
                          if image(y+0,x+-2) > cb 
                           if image(y+-4,x+1) > cb 
                           else
                            continue
                           end
                          else
                           continue
                          end
                         end
                        elseif image(y+-4,x+-1) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     else
                     end
                    end
                   elseif image(y+-3,x+1) < c_b 
                    if image(y+-2,x+3) > cb 
                     continue
                    elseif image(y+-2,x+3) < c_b 
                    else
                     if image(y+-2,x+2) > cb 
                      continue
                     elseif image(y+-2,x+2) < c_b 
                     else
                      if image(y+0,x+-2) > cb 
                       if image(y+-1,x+4) > cb 
                        continue
                       else
                       end
                      else
                       continue
                      end
                     end
                    end
                   else
                    if image(y+2,x+0) > cb 
                     if image(y+2,x+1) > cb 
                      if image(y+3,x+0) > cb 
                      elseif image(y+3,x+0) < c_b 
                       continue
                      else
                       if image(y+-4,x+0) > cb 
                        if image(y+-3,x+0) > cb 
                         if image(y+-1,x+-4) > cb 
                          if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        else
                         continue
                        end
                       else
                       end
                      end
                     elseif image(y+2,x+1) < c_b 
                      continue
                     else
                      if image(y+-1,x+3) < c_b
                      else
                       if image(y+3,x+0) > cb 
                       elseif image(y+3,x+0) < c_b 
                        continue
                       else
                        if image(y+-4,x+-1) > cb 
                        else
                         continue
                        end
                       end
                      end
                     end
                    elseif image(y+2,x+0) < c_b 
                     if image(y+2,x+-2) > cb 
                      continue
                     elseif image(y+2,x+-2) < c_b 
                     else
                      if image(y+-2,x+2) > cb 
                       continue
                      elseif image(y+-2,x+2) < c_b 
                      else
                       if image(y+0,x+2) > cb 
                        continue
                       elseif image(y+0,x+2) < c_b 
                       else
                        if image(y+-2,x+3) < c_b
                         if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                          continue
                         else
                         end
                        else
                         continue
                        end
                       end
                      end
                     end
                    else
                     if image(y+-2,x+2) > cb 
                      if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                      else
                       if image(y+-4,x+-1) > cb 
                        if image(y+3,x+-2) > cb 
                         if image(y+-3,x+-1) > cb 
                         else
                          continue
                         end
                        elseif image(y+3,x+-2) < c_b 
                        else
                         if image(y+2,x+1) > cb 
                         elseif image(y+2,x+1) < c_b 
                          continue
                         else
                          if image(y+0,x+2) > cb 
                           if image(y+-2,x+3) > cb 
                           else
                            continue
                           end
                          elseif image(y+0,x+2) < c_b 
                           continue
                          else
                           if image(y+0,x+-2) > cb 
                            if image(y+4,x+1) > cb 
                            elseif image(y+4,x+1) < c_b 
                             continue
                            else
                             if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                              continue
                             else
                              if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                               continue
                              else
                              end
                             end
                            end
                           elseif image(y+0,x+-2) < c_b 
                            continue
                           else
                            if image(y+0,x+-4) > cb 
                             if image(y+-3,x+2) > cb 
                             else
                              continue
                             end
                            else
                             continue
                            end
                           end
                          end
                         end
                        end
                       elseif image(y+-4,x+-1) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+-2,x+2) < c_b 
                     else
                      if image(y+2,x+-2) > cb 
                       if image(y+-1,x+4) > cb 
                        if image(y+-1,x+-4) > cb 
                         if image(y+-4,x+-1) > cb 
                         elseif image(y+-4,x+-1) < c_b 
                          continue
                         else
                          if image(y+-3,x+2) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+-1,x+-4) < c_b 
                         if image(y+-3,x+2) > cb 
                         else
                          continue
                         end
                        else
                        end
                       elseif image(y+-1,x+4) < c_b 
                       else
                        if image(y+2,x+2) > cb 
                         if image(y+-4,x+-1) > cb 
                         elseif image(y+-4,x+-1) < c_b 
                          continue
                         else
                          if image(y+-2,x+-3) > cb 
                           if image(y+-3,x+2) > cb 
                           else
                            continue
                           end
                          elseif image(y+-2,x+-3) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+2,x+2) < c_b 
                         continue
                        else
                         if image(y+1,x+-2) > cb 
                          if image(y+-2,x+3) > cb 
                          elseif image(y+-2,x+3) < c_b 
                           continue
                          else
                           if image(y+-1,x+-4) > cb 
                            if image(y+-4,x+-1) > cb 
                            else
                             continue
                            end
                           elseif image(y+-1,x+-4) < c_b 
                            continue
                           else
                            if image(y+1,x+3) > cb 
                            elseif image(y+1,x+3) < c_b 
                             continue
                            else
                             if image(y+0,x+-3) > cb 
                              if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                              else
                               if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                                continue
                               else
                               end
                              end
                             elseif image(y+0,x+-3) < c_b 
                              continue
                             else
                              if image(y+-4,x+1) > cb 
                               if image(y+3,x+1) > cb 
                                if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                                 continue
                                else
                                end
                               else
                                continue
                               end
                              else
                               continue
                              end
                             end
                            end
                           end
                          end
                         elseif image(y+1,x+-2) < c_b 
                          continue
                         else
                          if image(y+3,x+-2) > cb 
                          elseif image(y+3,x+-2) < c_b 
                           continue
                          else
                           if image(y+-4,x+-1) > cb 
                           else
                            continue
                           end
                          end
                         end
                        end
                       end
                      elseif image(y+2,x+-2) < c_b 
                      else
                       if image(y+2,x+1) > cb 
                        if image(y+0,x+-2) > cb 
                         if image(y+0,x+-3) > cb 
                          if image(y+-1,x+3) < c_b
                           if image(y+-1,x+4) < c_b
                            if image(y+0,x+2) > cb | image(y+0,x+2) < c_b 
                             continue
                            else
                            end
                           else
                            continue
                           end
                          else
                          end
                         elseif image(y+0,x+-3) < c_b 
                          continue
                         else
                          if image(y+-1,x+-4) > cb 
                           if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-1,x+-4) < c_b 
                           continue
                          else
                           if image(y+-3,x+0) > cb 
                           elseif image(y+-3,x+0) < c_b 
                            continue
                           else
                            if image(y+-3,x+2) > cb 
                            else
                             continue
                            end
                           end
                          end
                         end
                        elseif image(y+0,x+-2) < c_b 
                         continue
                        else
                         if image(y+-1,x+3) > cb 
                         elseif image(y+-1,x+3) < c_b 
                          if image(y+1,x+4) > cb 
                          elseif image(y+1,x+4) < c_b 
                           continue
                          else
                           if image(y+-1,x+4) < c_b
                           else
                            continue
                           end
                          end
                         else
                          if image(y+-4,x+0) > cb 
                           if image(y+-4,x+-1) > cb 
                            if image(y+-1,x+-4) > cb 
                             if image(y+1,x+-4) > cb 
                              if image(y+1,x+4) > cb 
                               if image(y+-3,x+2) > cb 
                                if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                                 continue
                                else
                                end
                               elseif image(y+-3,x+2) < c_b 
                                continue
                               else
                                if image(y+-1,x+4) > cb 
                                 continue
                                elseif image(y+-1,x+4) < c_b 
                                else
                                 if image(y+0,x+3) > cb 
                                  if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                                   continue
                                  else
                                  end
                                 else
                                  continue
                                 end
                                end
                               end
                              elseif image(y+1,x+4) < c_b 
                               continue
                              else
                               if image(y+0,x+4) > cb 
                               elseif image(y+0,x+4) < c_b 
                                continue
                               else
                                if image(y+-1,x+4) > cb 
                                else
                                 continue
                                end
                               end
                              end
                             elseif image(y+1,x+-4) < c_b 
                             else
                              if image(y+0,x+2) > cb 
                              else
                               continue
                              end
                             end
                            elseif image(y+-1,x+-4) < c_b 
                             continue
                            else
                             if image(y+0,x+-4) > cb 
                              if image(y+-1,x+4) > cb 
                              else
                               continue
                              end
                             elseif image(y+0,x+-4) < c_b 
                              continue
                             else
                              if image(y+2,x+-1) > cb 
                              elseif image(y+2,x+-1) < c_b 
                               continue
                              else
                               if image(y+0,x+-3) > cb 
                               else
                                continue
                               end
                              end
                             end
                            end
                           elseif image(y+-4,x+-1) < c_b 
                            continue
                           else
                            if image(y+4,x+-1) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+-4,x+0) < c_b 
                           continue
                          else
                           if image(y+-3,x+0) > cb 
                            if image(y+4,x+-1) > cb 
                             if image(y+0,x+3) > cb 
                             elseif image(y+0,x+3) < c_b 
                              continue
                             else
                              if image(y+-2,x+-2) > cb 
                              elseif image(y+-2,x+-2) < c_b 
                               continue
                              else
                               if image(y+-4,x+-1) > cb 
                               else
                                continue
                               end
                              end
                             end
                            elseif image(y+4,x+-1) < c_b 
                             continue
                            else
                             if image(y+-3,x+2) > cb 
                             else
                              continue
                             end
                            end
                           elseif image(y+-3,x+0) < c_b 
                            continue
                           else
                            if image(y+-2,x+3) > cb 
                             if image(y+3,x+0) > cb 
                             elseif image(y+3,x+0) < c_b 
                              continue
                             else
                              if image(y+3,x+1) > cb | image(y+3,x+1) < c_b 
                               continue
                              else
                              end
                             end
                            elseif image(y+-2,x+3) < c_b 
                             if image(y+-4,x+1) < c_b
                             else
                              continue
                             end
                            else
                             if image(y+-3,x+2) > cb 
                              if image(y+0,x+3) > cb | image(y+0,x+3) < c_b 
                               continue
                              else
                              end
                             elseif image(y+-3,x+2) < c_b 
                              continue
                             else
                              if image(y+-1,x+4) < c_b
                               if image(y+-3,x+-1) > cb 
                               else
                                continue
                               end
                              else
                               continue
                              end
                             end
                            end
                           end
                          end
                         end
                        end
                       elseif image(y+2,x+1) < c_b 
                        continue
                       else
                        if image(y+4,x+-1) > cb 
                         if image(y+-4,x+0) > cb 
                          if image(y+-4,x+-1) > cb 
                           if image(y+-1,x+4) > cb 
                            if image(y+0,x+2) > cb 
                             if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                              continue
                             else
                             end
                            elseif image(y+0,x+2) < c_b 
                             continue
                            else
                             if image(y+1,x+-2) > cb 
                              if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                               continue
                              else
                              end
                             elseif image(y+1,x+-2) < c_b 
                              continue
                             else
                              if image(y+0,x+-4) > cb 
                               if image(y+2,x+-1) > cb 
                               else
                                continue
                               end
                              elseif image(y+0,x+-4) < c_b 
                               continue
                              else
                               if image(y+0,x+-3) > cb 
                                if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                                 continue
                                else
                                end
                               elseif image(y+0,x+-3) < c_b 
                                continue
                               else
                                if image(y+3,x+-2) > cb 
                                 if image(y+3,x+-1) > cb 
                                  if image(y+2,x+-1) > cb 
                                  else
                                   continue
                                  end
                                 elseif image(y+3,x+-1) < c_b 
                                  continue
                                 else
                                 end
                                else
                                 continue
                                end
                               end
                              end
                             end
                            end
                           elseif image(y+-1,x+4) < c_b 
                            continue
                           else
                            if image(y+2,x+-1) > cb 
                             if image(y+-1,x+-4) > cb 
                             elseif image(y+-1,x+-4) < c_b 
                              continue
                             else
                              if image(y+-2,x+0) > cb 
                              else
                               continue
                              end
                             end
                            else
                             continue
                            end
                           end
                          elseif image(y+-4,x+-1) < c_b 
                           continue
                          else
                           if image(y+-1,x+3) > cb | image(y+-1,x+3) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+-4,x+0) < c_b 
                         else
                          if image(y+-3,x+0) > cb 
                           if image(y+-1,x+3) > cb 
                            if image(y+3,x+1) > cb | image(y+3,x+1) < c_b 
                             continue
                            else
                             if image(y+0,x+-4) > cb 
                              if image(y+0,x+2) > cb 
                              else
                               continue
                              end
                             elseif image(y+0,x+-4) < c_b 
                              continue
                             else
                             end
                            end
                           elseif image(y+-1,x+3) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-3,x+0) < c_b 
                           continue
                          else
                           if image(y+-3,x+2) > cb 
                            if image(y+-1,x+3) > cb | image(y+-1,x+3) < c_b 
                             continue
                            else
                            end
                           elseif image(y+-3,x+2) < c_b 
                            if image(y+-4,x+1) < c_b
                             if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                              continue
                             else
                             end
                            else
                             continue
                            end
                           else
                            if image(y+-1,x+4) > cb 
                             if image(y+1,x+-2) > cb 
                             elseif image(y+1,x+-2) < c_b 
                              continue
                             else
                              if image(y+3,x+0) > cb 
                               if image(y+0,x+-4) > cb 
                                if image(y+-1,x+-4) > cb 
                                 if image(y+0,x+4) > cb 
                                  if image(y+0,x+2) > cb 
                                   if image(y+-1,x+2) > cb | image(y+-1,x+2) < c_b 
                                    continue
                                   else
                                   end
                                  else
                                   continue
                                  end
                                 elseif image(y+0,x+4) < c_b 
                                  continue
                                 else
                                  if image(y+-3,x+-1) > cb 
                                  else
                                   continue
                                  end
                                 end
                                elseif image(y+-1,x+-4) < c_b 
                                 continue
                                else
                                end
                               else
                                continue
                               end
                              elseif image(y+3,x+0) < c_b 
                               continue
                              else
                               if image(y+0,x+2) > cb 
                               elseif image(y+0,x+2) < c_b 
                                continue
                               else
                                if image(y+-4,x+1) > cb 
                                elseif image(y+-4,x+1) < c_b 
                                 continue
                                else
                                 if image(y+0,x+4) > cb 
                                  if image(y+0,x+-3) > cb 
                                   if image(y+4,x+0) > cb 
                                    if image(y+-2,x+3) > cb 
                                     if image(y+-1,x+3) > cb | image(y+-1,x+3) < c_b 
                                      continue
                                     else
                                     end
                                    else
                                     continue
                                    end
                                   elseif image(y+4,x+0) < c_b 
                                    continue
                                   else
                                    if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                                     continue
                                    else
                                    end
                                   end
                                  else
                                   continue
                                  end
                                 elseif image(y+0,x+4) < c_b 
                                  continue
                                 else
                                  if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                                   continue
                                  else
                                  end
                                 end
                                end
                               end
                              end
                             end
                            elseif image(y+-1,x+4) < c_b 
                            else
                             if image(y+-2,x+3) > cb 
                              if image(y+-1,x+3) > cb 
                               if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                                continue
                               else
                               end
                              elseif image(y+-1,x+3) < c_b 
                               continue
                              else
                              end
                             elseif image(y+-2,x+3) < c_b 
                              continue
                             else
                              if image(y+-4,x+1) < c_b
                               if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                                continue
                               else
                               end
                              else
                               continue
                              end
                             end
                            end
                           end
                          end
                         end
                        elseif image(y+4,x+-1) < c_b 
                         if image(y+-2,x+3) > cb 
                          continue
                         elseif image(y+-2,x+3) < c_b 
                          if image(y+0,x+-2) > cb 
                          else
                           continue
                          end
                         else
                         end
                        else
                         if image(y+-1,x+4) > cb 
                          if image(y+0,x+-4) > cb 
                           if image(y+-1,x+-4) > cb 
                            if image(y+1,x+-2) > cb 
                             if image(y+-4,x+-1) > cb 
                             else
                              continue
                             end
                            elseif image(y+1,x+-2) < c_b 
                             continue
                            else
                             if image(y+-1,x+2) < c_b
                              continue
                             else
                              if image(y+0,x+2) > cb 
                              else
                               continue
                              end
                             end
                            end
                           elseif image(y+-1,x+-4) < c_b 
                            continue
                           else
                            if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                             continue
                            else
                            end
                           end
                          elseif image(y+0,x+-4) < c_b 
                          else
                           if image(y+0,x+-3) > cb 
                            if image(y+-2,x+-2) > cb 
                             if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                              continue
                             else
                             end
                            else
                             continue
                            end
                           elseif image(y+0,x+-3) < c_b 
                            continue
                           else
                            if image(y+0,x+2) > cb 
                            elseif image(y+0,x+2) < c_b 
                             continue
                            else
                             if image(y+3,x+-2) > cb 
                              if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                               continue
                              else
                              end
                             elseif image(y+3,x+-2) < c_b 
                              continue
                             else
                              if image(y+1,x+-2) > cb 
                               if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                                continue
                               else
                               end
                              elseif image(y+1,x+-2) < c_b 
                               continue
                              else
                               if image(y+1,x+-4) > cb 
                                continue
                               elseif image(y+1,x+-4) < c_b 
                                if image(y+-3,x+-1) > cb 
                                else
                                 continue
                                end
                               else
                                if image(y+0,x+-2) > cb 
                                 if image(y+-1,x+2) > cb 
                                 elseif image(y+-1,x+2) < c_b 
                                  continue
                                 else
                                  if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                                   continue
                                  else
                                   if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                                    continue
                                   else
                                   end
                                  end
                                 end
                                else
                                 continue
                                end
                               end
                              end
                             end
                            end
                           end
                          end
                         elseif image(y+-1,x+4) < c_b 
                          if image(y+0,x+2) > cb | image(y+0,x+2) < c_b 
                           continue
                          else
                           if image(y+2,x+-1) > cb | image(y+2,x+-1) < c_b 
                            continue
                           else
                           end
                          end
                         else
                          if image(y+1,x+-4) > cb 
                           if image(y+-4,x+1) > cb 
                            if image(y+-1,x+2) > cb 
                            elseif image(y+-1,x+2) < c_b 
                             continue
                            else
                             if image(y+2,x+-1) > cb 
                             else
                              continue
                             end
                            end
                           elseif image(y+-4,x+1) < c_b 
                           else
                            if image(y+0,x+2) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+1,x+-4) < c_b 
                          else
                           if image(y+-4,x+1) > cb 
                            if image(y+-1,x+2) > cb 
                            else
                             continue
                            end
                           elseif image(y+-4,x+1) < c_b 
                           else
                            if image(y+-3,x+2) > cb 
                             if image(y+0,x+-2) > cb 
                              if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                               continue
                              else
                              end
                             else
                              continue
                             end
                            elseif image(y+-3,x+2) < c_b 
                             continue
                            else
                             if image(y+1,x+-2) > cb 
                              continue
                             elseif image(y+1,x+-2) < c_b 
                              if image(y+-2,x+3) < c_b
                              else
                               continue
                              end
                             else
                              if image(y+2,x+-1) > cb 
                               if image(y+-2,x+0) > cb 
                               else
                                continue
                               end
                              else
                               continue
                              end
                             end
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+-1,x+-2) < c_b 
                  else
                   if image(y+2,x+-1) > cb 
                    if image(y+-4,x+1) > cb 
                     if image(y+-2,x+-2) > cb 
                      if image(y+-4,x+-1) > cb 
                       if image(y+2,x+2) > cb 
                       elseif image(y+2,x+2) < c_b 
                        continue
                       else
                        if image(y+0,x+-2) > cb 
                         if image(y+-3,x+2) > cb 
                         else
                          continue
                         end
                        elseif image(y+0,x+-2) < c_b 
                         continue
                        else
                         if image(y+2,x+-2) > cb 
                         elseif image(y+2,x+-2) < c_b 
                          continue
                         else
                          if image(y+-3,x+2) > cb 
                          elseif image(y+-3,x+2) < c_b 
                           continue
                          else
                           if image(y+-2,x+0) > cb 
                            if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                             continue
                            else
                            end
                           elseif image(y+-2,x+0) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        end
                       end
                      elseif image(y+-4,x+-1) < c_b 
                       continue
                      else
                       if image(y+-3,x+2) > cb 
                       elseif image(y+-3,x+2) < c_b 
                        continue
                       else
                        if image(y+2,x+-2) > cb 
                        elseif image(y+2,x+-2) < c_b 
                         continue
                        else
                         if image(y+-1,x+-4) > cb 
                         else
                          continue
                         end
                        end
                       end
                      end
                     elseif image(y+-2,x+-2) < c_b 
                      continue
                     else
                      if image(y+2,x+-2) > cb 
                      elseif image(y+2,x+-2) < c_b 
                       continue
                      else
                       if image(y+-3,x+1) > cb 
                        if image(y+-1,x+2) > cb | image(y+-1,x+2) < c_b 
                         continue
                        else
                         if image(y+3,x+-1) > cb 
                         elseif image(y+3,x+-1) < c_b 
                          continue
                         else
                          if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+-3,x+1) < c_b 
                        continue
                       else
                        if image(y+-3,x+2) > cb 
                         if image(y+-2,x+0) > cb 
                          if image(y+-2,x+-3) > cb 
                          else
                           continue
                          end
                         else
                          continue
                         end
                        elseif image(y+-3,x+2) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     end
                    elseif image(y+-4,x+1) < c_b 
                     if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                      continue
                     else
                     end
                    else
                     if image(y+2,x+-2) > cb 
                      if image(y+2,x+2) > cb 
                       if image(y+-1,x+-4) > cb 
                        if image(y+-4,x+-1) > cb 
                        elseif image(y+-4,x+-1) < c_b 
                         continue
                        else
                         if image(y+2,x+0) > cb 
                          if image(y+-2,x+-2) > cb 
                          elseif image(y+-2,x+-2) < c_b 
                           continue
                          else
                           if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                            continue
                           else
                           end
                          end
                         else
                          continue
                         end
                        end
                       else
                       end
                      elseif image(y+2,x+2) < c_b 
                       continue
                      else
                       if image(y+-1,x+-3) > cb 
                        if image(y+-4,x+-1) > cb 
                        else
                         continue
                        end
                       elseif image(y+-1,x+-3) < c_b 
                        continue
                       else
                        if image(y+1,x+-2) > cb 
                         if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
                         else
                          if image(y+-1,x+3) > cb 
                           if image(y+-2,x+-2) > cb 
                           else
                            continue
                           end
                          else
                           continue
                          end
                         end
                        elseif image(y+1,x+-2) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     elseif image(y+2,x+-2) < c_b 
                      continue
                     else
                      if image(y+-3,x+2) > cb 
                       if image(y+-2,x+-2) > cb 
                       elseif image(y+-2,x+-2) < c_b 
                        continue
                       else
                        if image(y+-2,x+3) > cb 
                        else
                         continue
                        end
                       end
                      elseif image(y+-3,x+2) < c_b 
                       if image(y+-4,x+0) > cb 
                       else
                        continue
                       end
                      else
                       if image(y+-1,x+3) > cb 
                        if image(y+2,x+1) > cb 
                        elseif image(y+2,x+1) < c_b 
                         continue
                        else
                         if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+-1,x+3) < c_b 
                        if image(y+-4,x+-1) > cb 
                        else
                         continue
                        end
                       else
                        if image(y+-2,x+0) > cb 
                         if image(y+0,x+-4) > cb 
                          continue
                         elseif image(y+0,x+-4) < c_b 
                         else
                          if image(y+4,x+0) > cb 
                           if image(y+-4,x+-1) > cb 
                           elseif image(y+-4,x+-1) < c_b 
                            continue
                           else
                            if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                             continue
                            else
                             if image(y+-3,x+-1) > cb 
                              if image(y+-2,x+-3) > cb 
                              else
                               continue
                              end
                             elseif image(y+-3,x+-1) < c_b 
                              continue
                             else
                             end
                            end
                           end
                          elseif image(y+4,x+0) < c_b 
                           continue
                          else
                           if image(y+-2,x+3) > cb 
                           else
                            continue
                           end
                          end
                         end
                        elseif image(y+-2,x+0) < c_b 
                         continue
                        else
                         if image(y+-1,x+-4) > cb 
                          if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-1,x+-4) < c_b 
                         else
                          if image(y+-1,x+2) > cb | image(y+-1,x+2) < c_b 
                          else
                           if image(y+1,x+-2) > cb 
                            if image(y+1,x+4) > cb | image(y+1,x+4) < c_b 
                             continue
                            else
                            end
                           elseif image(y+1,x+-2) < c_b 
                            continue
                           else
                            if image(y+1,x+-4) > cb 
                             continue
                            elseif image(y+1,x+-4) < c_b 
                            else
                             if image(y+-2,x+3) > cb 
                              if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                               continue
                              else
                              end
                             else
                              continue
                             end
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+2,x+-1) < c_b 
                    if image(y+2,x+-2) > cb 
                     continue
                    elseif image(y+2,x+-2) < c_b 
                    else
                     if image(y+0,x+2) > cb | image(y+0,x+2) < c_b 
                     else
                      if image(y+-2,x+3) > cb 
                       continue
                      elseif image(y+-2,x+3) < c_b 
                       if image(y+-1,x+3) > cb 
                        continue
                       elseif image(y+-1,x+3) < c_b 
                        if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                         continue
                        else
                        end
                       else
                       end
                      else
                       if image(y+-1,x+3) > cb | image(y+-1,x+3) < c_b 
                       else
                        continue
                       end
                      end
                     end
                    end
                   else
                    if image(y+-2,x+3) > cb 
                     if image(y+2,x+1) > cb 
                      if image(y+-2,x+2) > cb 
                       if image(y+4,x+1) > cb 
                       elseif image(y+4,x+1) < c_b 
                        continue
                       else
                        if image(y+1,x+4) > cb 
                         if image(y+-1,x+2) > cb 
                         else
                          continue
                         end
                        elseif image(y+1,x+4) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+-2,x+2) < c_b 
                       continue
                      else
                       if image(y+-1,x+3) > cb 
                        if image(y+-3,x+1) > cb 
                         if image(y+-1,x+2) > cb 
                         elseif image(y+-1,x+2) < c_b 
                          continue
                         else
                          if image(y+2,x+-2) > cb 
                          elseif image(y+2,x+-2) < c_b 
                           continue
                          else
                           if image(y+2,x+2) > cb 
                            if image(y+1,x+4) > cb | image(y+1,x+4) < c_b 
                             continue
                            else
                             if image(y+-2,x+-3) > cb 
                             else
                              continue
                             end
                            end
                           elseif image(y+2,x+2) < c_b 
                            continue
                           else
                            if image(y+-4,x+-1) > cb 
                            else
                             continue
                            end
                           end
                          end
                         end
                        elseif image(y+-3,x+1) < c_b 
                         continue
                        else
                        end
                       elseif image(y+-1,x+3) < c_b 
                        continue
                       else
                        if image(y+2,x+-2) > cb 
                        elseif image(y+2,x+-2) < c_b 
                         continue
                        else
                         if image(y+-2,x+-2) > cb 
                          if image(y+2,x+2) > cb 
                           if image(y+1,x+-4) > cb 
                            if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                             continue
                            else
                            end
                           else
                            continue
                           end
                          elseif image(y+2,x+2) < c_b 
                           continue
                          else
                           if image(y+-2,x+0) > cb 
                            if image(y+-1,x+-3) > cb 
                            else
                             continue
                            end
                           elseif image(y+-2,x+0) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+-2,x+-2) < c_b 
                          continue
                         else
                          if image(y+3,x+-2) > cb 
                           if image(y+-4,x+0) > cb 
                           else
                            continue
                           end
                          else
                           continue
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+2,x+1) < c_b 
                      continue
                     else
                      if image(y+0,x+2) > cb 
                       if image(y+3,x+-1) > cb 
                        if image(y+3,x+-2) > cb 
                         if image(y+-3,x+-1) > cb 
                         else
                          continue
                         end
                        elseif image(y+3,x+-2) < c_b 
                         continue
                        else
                         if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+3,x+-1) < c_b 
                        continue
                       else
                       end
                      elseif image(y+0,x+2) < c_b 
                       if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                        continue
                       else
                       end
                      else
                       if image(y+2,x+-2) > cb 
                        if image(y+-4,x+1) > cb 
                        elseif image(y+-4,x+1) < c_b 
                         continue
                        else
                         if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                          continue
                         else
                          if image(y+-2,x+-2) > cb 
                          elseif image(y+-2,x+-2) < c_b 
                           continue
                          else
                           if image(y+-4,x+-1) > cb 
                            if image(y+0,x+-2) > cb | image(y+0,x+-2) < c_b 
                             continue
                            else
                            end
                           else
                            continue
                           end
                          end
                         end
                        end
                       elseif image(y+2,x+-2) < c_b 
                       else
                        if image(y+-1,x+2) > cb 
                         if image(y+3,x+-2) > cb 
                          if image(y+-1,x+-4) > cb 
                           if image(y+1,x+-4) > cb 
                           else
                            continue
                           end
                          elseif image(y+-1,x+-4) < c_b 
                           continue
                          else
                          end
                         elseif image(y+3,x+-2) < c_b 
                          continue
                         else
                          if image(y+0,x+-4) > cb 
                           if image(y+-4,x+1) > cb 
                           elseif image(y+-4,x+1) < c_b 
                            continue
                           else
                            if image(y+1,x+3) > cb 
                             if image(y+-1,x+-4) > cb 
                              if image(y+-3,x+1) > cb 
                               if image(y+-4,x+0) > cb 
                               else
                                continue
                               end
                              elseif image(y+-3,x+1) < c_b 
                               continue
                              else
                              end
                             else
                              continue
                             end
                            else
                             continue
                            end
                           end
                          elseif image(y+0,x+-4) < c_b 
                           continue
                          else
                           if image(y+0,x+-3) > cb 
                           else
                            continue
                           end
                          end
                         end
                        elseif image(y+-1,x+2) < c_b 
                         continue
                        else
                         if image(y+-1,x+-4) > cb 
                          if image(y+3,x+-2) > cb 
                           if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                            continue
                           else
                            if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                             continue
                            else
                             if image(y+-3,x+2) > cb 
                             else
                              continue
                             end
                            end
                           end
                          elseif image(y+3,x+-2) < c_b 
                           continue
                          else
                           if image(y+0,x+-3) > cb 
                            if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                             continue
                            else
                             if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                              continue
                             else
                             end
                            end
                           else
                            continue
                           end
                          end
                         elseif image(y+-1,x+-4) < c_b 
                          continue
                         else
                          if image(y+0,x+-4) > cb 
                           if image(y+-1,x+4) > cb 
                            if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                             continue
                            else
                            end
                           else
                            continue
                           end
                          elseif image(y+0,x+-4) < c_b 
                           if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                            continue
                           else
                           end
                          else
                           if image(y+3,x+-2) > cb 
                            if image(y+-2,x+-2) > cb 
                             if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                              continue
                             else
                              if image(y+-1,x+4) > cb 
                              else
                               continue
                              end
                             end
                            elseif image(y+-2,x+-2) < c_b 
                             continue
                            else
                             if image(y+-3,x+1) > cb 
                             elseif image(y+-3,x+1) < c_b 
                              continue
                             else
                              if image(y+-2,x+2) > cb 
                              else
                               continue
                              end
                             end
                            end
                           elseif image(y+3,x+-2) < c_b 
                            if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                             continue
                            else
                            end
                           else
                            if image(y+0,x+-3) > cb 
                             if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                              continue
                             else
                             end
                            elseif image(y+0,x+-3) < c_b 
                            else
                             if image(y+3,x+-1) > cb 
                              if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                               continue
                              else
                               if image(y+-4,x+0) > cb 
                               else
                                continue
                               end
                              end
                             elseif image(y+3,x+-1) < c_b 
                              continue
                             else
                              if image(y+1,x+-2) > cb 
                               if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                                continue
                               else
                               end
                              else
                               continue
                              end
                             end
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+-2,x+3) < c_b 
                     if image(y+-1,x+4) > cb 
                     elseif image(y+-1,x+4) < c_b 
                      if image(y+3,x+-1) > cb 
                       if image(y+-2,x+2) > cb 
                        continue
                       elseif image(y+-2,x+2) < c_b 
                        if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                         continue
                        else
                        end
                       else
                        if image(y+0,x+2) > cb 
                        elseif image(y+0,x+2) < c_b 
                         continue
                        else
                         if image(y+-3,x+1) > cb 
                          if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        end
                       end
                      elseif image(y+3,x+-1) < c_b 
                       if image(y+-2,x+2) < c_b
                       else
                        continue
                       end
                      else
                       if image(y+0,x+2) > cb 
                        continue
                       elseif image(y+0,x+2) < c_b 
                        if image(y+2,x+1) > cb 
                        else
                         continue
                        end
                       else
                       end
                      end
                     else
                      if image(y+-2,x+2) > cb 
                       continue
                      elseif image(y+-2,x+2) < c_b 
                       if image(y+3,x+1) > cb 
                       elseif image(y+3,x+1) < c_b 
                        continue
                       else
                        if image(y+-4,x+1) > cb 
                         continue
                        elseif image(y+-4,x+1) < c_b 
                        else
                         if image(y+2,x+-2) < c_b
                         else
                          continue
                         end
                        end
                       end
                      else
                       if image(y+-4,x+1) > cb 
                        continue
                       elseif image(y+-4,x+1) < c_b 
                       else
                        if image(y+3,x+-1) > cb 
                         continue
                        elseif image(y+3,x+-1) < c_b 
                        else
                         if image(y+-3,x+1) > cb 
                         else
                          continue
                         end
                        end
                       end
                      end
                     end
                    else
                     if image(y+2,x+-2) > cb 
                      if image(y+-4,x+-1) > cb 
                      elseif image(y+-4,x+-1) < c_b 
                       continue
                      else
                       if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+2,x+-2) < c_b 
                     else
                      if image(y+-2,x+-2) > cb 
                       if image(y+0,x+2) > cb 
                        if image(y+3,x+-1) > cb 
                         if image(y+-1,x+2) > cb 
                          if image(y+-1,x+-4) > cb 
                           if image(y+4,x+-1) > cb | image(y+4,x+-1) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-1,x+-4) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-1,x+2) < c_b 
                          continue
                         else
                          if image(y+2,x+1) > cb 
                           if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                            continue
                           else
                           end
                          else
                           continue
                          end
                         end
                        elseif image(y+3,x+-1) < c_b 
                         continue
                        else
                         if image(y+0,x+3) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+0,x+2) < c_b 
                        continue
                       else
                        if image(y+-2,x+2) > cb 
                         if image(y+2,x+1) > cb 
                          if image(y+0,x+4) > cb 
                           if image(y+2,x+0) > cb | image(y+2,x+0) < c_b 
                            continue
                           else
                           end
                          elseif image(y+0,x+4) < c_b 
                           continue
                          else
                          end
                         elseif image(y+2,x+1) < c_b 
                          continue
                         else
                          if image(y+-1,x+2) > cb 
                           if image(y+-4,x+-1) > cb 
                           else
                            continue
                           end
                          else
                           continue
                          end
                         end
                        elseif image(y+-2,x+2) < c_b 
                         if image(y+3,x+0) > cb 
                         elseif image(y+3,x+0) < c_b 
                          if image(y+-4,x+-1) > cb 
                          else
                           continue
                          end
                         else
                          continue
                         end
                        else
                         if image(y+-1,x+4) > cb 
                          if image(y+3,x+-2) > cb 
                           if image(y+3,x+-1) > cb 
                            if image(y+-1,x+3) > cb 
                             if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                              continue
                             else
                              if image(y+2,x+1) > cb 
                              elseif image(y+2,x+1) < c_b 
                               continue
                              else
                               if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                                continue
                               else
                                if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                                 continue
                                else
                                end
                               end
                              end
                             end
                            else
                             continue
                            end
                           elseif image(y+3,x+-1) < c_b 
                            continue
                           else
                            if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                             continue
                            else
                            end
                           end
                          elseif image(y+3,x+-2) < c_b 
                          else
                           if image(y+0,x+-3) > cb 
                            if image(y+-1,x+-4) > cb 
                             if image(y+0,x+-4) > cb 
                              if image(y+2,x+1) > cb 
                               if image(y+-1,x+3) > cb 
                                if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                                 continue
                                else
                                end
                               else
                                continue
                               end
                              else
                               continue
                              end
                             elseif image(y+0,x+-4) < c_b 
                              continue
                             else
                             end
                            elseif image(y+-1,x+-4) < c_b 
                             continue
                            else
                             if image(y+0,x+4) > cb 
                             else
                              continue
                             end
                            end
                           elseif image(y+0,x+-3) < c_b 
                            continue
                           else
                            if image(y+0,x+-4) > cb 
                             if image(y+-1,x+-4) > cb 
                              if image(y+2,x+1) > cb 
                               if image(y+-1,x+3) < c_b
                                continue
                               else
                                if image(y+2,x+2) > cb | image(y+2,x+2) < c_b 
                                 continue
                                else
                                end
                               end
                              else
                               continue
                              end
                             elseif image(y+-1,x+-4) < c_b 
                              continue
                             else
                              if image(y+3,x+-1) > cb 
                               if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                                continue
                               else
                               end
                              elseif image(y+3,x+-1) < c_b 
                               continue
                              else
                              end
                             end
                            elseif image(y+0,x+-4) < c_b 
                             if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                              continue
                             else
                             end
                            else
                             if image(y+3,x+-1) > cb 
                              if image(y+-1,x+3) > cb 
                               if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                                continue
                               else
                                if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                                 continue
                                else
                                end
                               end
                              elseif image(y+-1,x+3) < c_b 
                               continue
                              else
                               if image(y+1,x+-4) > cb 
                               else
                                continue
                               end
                              end
                             elseif image(y+3,x+-1) < c_b 
                              continue
                             else
                              if image(y+-1,x+2) > cb 
                               if image(y+-1,x+-4) > cb 
                               else
                                continue
                               end
                              else
                               continue
                              end
                             end
                            end
                           end
                          end
                         elseif image(y+-1,x+4) < c_b 
                          if image(y+3,x+-1) > cb | image(y+3,x+-1) < c_b 
                           continue
                          else
                          end
                         else
                          if image(y+-4,x+1) > cb 
                           if image(y+2,x+2) > cb 
                            if image(y+1,x+-4) > cb 
                             if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                              continue
                             else
                              if image(y+-2,x+0) > cb 
                              else
                               continue
                              end
                             end
                            elseif image(y+1,x+-4) < c_b 
                             if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                              continue
                             else
                             end
                            else
                             continue
                            end
                           elseif image(y+2,x+2) < c_b 
                            continue
                           else
                            if image(y+2,x+1) > cb 
                             if image(y+3,x+-1) > cb 
                              if image(y+-3,x+1) > cb 
                               if image(y+-2,x+-3) > cb 
                               else
                                continue
                               end
                              else
                               continue
                              end
                             else
                              continue
                             end
                            elseif image(y+2,x+1) < c_b 
                             continue
                            else
                             if image(y+1,x+-2) > cb 
                              if image(y+-1,x+-4) > cb 
                              else
                               continue
                              end
                             else
                              continue
                             end
                            end
                           end
                          elseif image(y+-4,x+1) < c_b 
                           if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                            continue
                           else
                           end
                          else
                           if image(y+2,x+1) > cb 
                            if image(y+1,x+-4) > cb 
                             if image(y+0,x+3) < c_b
                              continue
                             else
                              if image(y+-3,x+2) > cb 
                              else
                               continue
                              end
                             end
                            elseif image(y+1,x+-4) < c_b 
                            else
                             if image(y+4,x+-1) > cb 
                              if image(y+2,x+2) > cb 
                               if image(y+-1,x+3) > cb 
                               else
                                continue
                               end
                              elseif image(y+2,x+2) < c_b 
                               continue
                              else
                               if image(y+-3,x+1) > cb 
                                if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                                 continue
                                else
                                end
                               else
                                continue
                               end
                              end
                             elseif image(y+4,x+-1) < c_b 
                             else
                              continue
                             end
                            end
                           else
                            continue
                           end
                          end
                         end
                        end
                       end
                      elseif image(y+-2,x+-2) < c_b 
                       continue
                      else
                       if image(y+3,x+-1) > cb 
                        if image(y+-3,x+1) > cb 
                         if image(y+-4,x+0) > cb 
                          if image(y+0,x+-3) > cb 
                           if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                            continue
                           else
                           end
                          elseif image(y+0,x+-3) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-4,x+0) < c_b 
                          continue
                         else
                          if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+-3,x+1) < c_b 
                         continue
                        else
                         if image(y+0,x+-4) > cb 
                          if image(y+1,x+-4) > cb 
                          else
                           continue
                          end
                         elseif image(y+0,x+-4) < c_b 
                         else
                          if image(y+-1,x+2) > cb 
                          elseif image(y+-1,x+2) < c_b 
                           continue
                          else
                           if image(y+-2,x+2) > cb 
                           elseif image(y+-2,x+2) < c_b 
                            if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                             continue
                            else
                            end
                           else
                            if image(y+-1,x+3) > cb 
                             if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                              continue
                             else
                             end
                            else
                             continue
                            end
                           end
                          end
                         end
                        end
                       elseif image(y+3,x+-1) < c_b 
                        if image(y+-3,x+2) < c_b
                        else
                         continue
                        end
                       else
                        if image(y+-1,x+4) > cb 
                         if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                         else
                          if image(y+0,x+-4) > cb 
                           if image(y+-1,x+-4) > cb 
                            if image(y+-1,x+2) > cb 
                            else
                             continue
                            end
                           elseif image(y+-1,x+-4) < c_b 
                            continue
                           else
                           end
                          elseif image(y+0,x+-4) < c_b 
                          else
                           if image(y+0,x+2) > cb 
                           elseif image(y+0,x+2) < c_b 
                            continue
                           else
                            if image(y+0,x+-3) > cb 
                             continue
                            elseif image(y+0,x+-3) < c_b 
                            else
                             if image(y+-1,x+2) > cb 
                             elseif image(y+-1,x+2) < c_b 
                              continue
                             else
                              if image(y+2,x+1) > cb 
                               if image(y+-1,x+3) > cb 
                               else
                                continue
                               end
                              else
                               continue
                              end
                             end
                            end
                           end
                          end
                         end
                        elseif image(y+-1,x+4) < c_b 
                        else
                         if image(y+0,x+2) > cb 
                         elseif image(y+0,x+2) < c_b 
                          continue
                         else
                          if image(y+1,x+-2) > cb | image(y+1,x+-2) < c_b 
                          else
                           if image(y+0,x+-4) < c_b
                            if image(y+2,x+1) > cb 
                            else
                             continue
                            end
                           else
                            continue
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  end
                 end
                elseif image(y+3,x+2) < c_b 
                 if image(y+-3,x+2) > cb 
                  if image(y+-4,x+0) > cb 
                  else
                   continue
                  end
                 elseif image(y+-3,x+2) < c_b 
                  if image(y+-1,x+3) > cb 
                   continue
                  else
                  end
                 else
                  if image(y+1,x+-2) > cb 
                   if image(y+-1,x+-4) > cb 
                   else
                    continue
                   end
                  elseif image(y+1,x+-2) < c_b 
                   if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                    continue
                   else
                   end
                  else
                   if image(y+1,x+-3) > cb 
                    continue
                   elseif image(y+1,x+-3) < c_b 
                   else
                    if image(y+3,x+1) > cb | image(y+3,x+1) < c_b 
                     continue
                    else
                     if image(y+-2,x+-3) > cb 
                     else
                      continue
                     end
                    end
                   end
                  end
                 end
                else
                 if image(y+4,x+-1) > cb 
                  if image(y+4,x+1) > cb 
                   if image(y+3,x+1) > cb 
                    if image(y+-1,x+-2) > cb 
                     if image(y+0,x+-4) > cb 
                      if image(y+-2,x+-2) > cb 
                       if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                       else
                        if image(y+2,x+1) > cb 
                         if image(y+0,x+3) > cb 
                          if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                           continue
                          else
                          end
                         elseif image(y+0,x+3) < c_b 
                          continue
                         else
                         end
                        elseif image(y+2,x+1) < c_b 
                         continue
                        else
                        end
                       end
                      else
                       continue
                      end
                     elseif image(y+0,x+-4) < c_b 
                     else
                      if image(y+2,x+-2) > cb 
                      elseif image(y+2,x+-2) < c_b 
                       continue
                      else
                       if image(y+-3,x+1) > cb 
                       elseif image(y+-3,x+1) < c_b 
                        continue
                       else
                        if image(y+2,x+1) > cb 
                        elseif image(y+2,x+1) < c_b 
                         continue
                        else
                         if image(y+2,x+2) > cb | image(y+2,x+2) < c_b 
                          continue
                         else
                          if image(y+-4,x+1) > cb 
                          elseif image(y+-4,x+1) < c_b 
                           continue
                          else
                           if image(y+-2,x+2) > cb 
                           elseif image(y+-2,x+2) < c_b 
                            continue
                           else
                            if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                             continue
                            else
                             if image(y+-1,x+3) > cb 
                              if image(y+-4,x+0) > cb 
                              else
                               continue
                              end
                             elseif image(y+-1,x+3) < c_b 
                              continue
                             else
                             end
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+-1,x+-2) < c_b 
                     continue
                    else
                     if image(y+0,x+4) > cb 
                      if image(y+-1,x+4) > cb 
                       if image(y+0,x+2) > cb 
                        if image(y+-4,x+-1) > cb 
                        else
                         continue
                        end
                       elseif image(y+0,x+2) < c_b 
                        continue
                       else
                        if image(y+-2,x+0) > cb 
                         if image(y+0,x+3) > cb 
                         elseif image(y+0,x+3) < c_b 
                          continue
                         else
                          if image(y+-4,x+1) > cb 
                           if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-4,x+1) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+-2,x+0) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+-1,x+4) < c_b 
                       continue
                      else
                       if image(y+2,x+1) > cb 
                        if image(y+2,x+-2) > cb 
                        else
                         continue
                        end
                       elseif image(y+2,x+1) < c_b 
                        continue
                       else
                        if image(y+-1,x+-4) > cb 
                         if image(y+-3,x+2) > cb 
                          if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-3,x+2) < c_b 
                          continue
                         else
                         end
                        elseif image(y+-1,x+-4) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     elseif image(y+0,x+4) < c_b 
                      continue
                     else
                      if image(y+0,x+-4) > cb 
                       if image(y+2,x+1) > cb 
                        if image(y+1,x+-4) > cb 
                        elseif image(y+1,x+-4) < c_b 
                         continue
                        else
                         if image(y+2,x+-1) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+2,x+1) < c_b 
                        continue
                       else
                       end
                      elseif image(y+0,x+-4) < c_b 
                       if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                        continue
                       else
                       end
                      else
                       if image(y+2,x+-1) > cb 
                        if image(y+-3,x+0) > cb 
                         if image(y+-2,x+0) > cb 
                          if image(y+-4,x+1) > cb 
                           if image(y+-3,x+2) > cb 
                           else
                            continue
                           end
                          elseif image(y+-4,x+1) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-2,x+0) < c_b 
                          continue
                         else
                         end
                        elseif image(y+-3,x+0) < c_b 
                         continue
                        else
                         if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+2,x+-1) < c_b 
                        continue
                       else
                        if image(y+-1,x+3) > cb 
                        elseif image(y+-1,x+3) < c_b 
                         continue
                        else
                         if image(y+1,x+4) > cb 
                          if image(y+2,x+1) > cb 
                           if image(y+-4,x+1) > cb 
                            if image(y+2,x+2) > cb | image(y+2,x+2) < c_b 
                             continue
                            else
                            end
                           else
                            continue
                           end
                          else
                           continue
                          end
                         else
                          continue
                         end
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+3,x+1) < c_b 
                    continue
                   else
                    if image(y+1,x+-4) > cb 
                     if image(y+-3,x+2) > cb 
                      if image(y+-2,x+-3) > cb 
                      elseif image(y+-2,x+-3) < c_b 
                       continue
                      else
                       if image(y+-1,x+-4) > cb 
                       else
                        continue
                       end
                      end
                     elseif image(y+-3,x+2) < c_b 
                      if image(y+-4,x+0) > cb 
                      else
                       continue
                      end
                     else
                      if image(y+-1,x+3) > cb 
                      elseif image(y+-1,x+3) < c_b 
                       continue
                      else
                       if image(y+0,x+3) > cb 
                        if image(y+-4,x+-1) > cb 
                         if image(y+1,x+3) > cb | image(y+1,x+3) < c_b 
                          continue
                         else
                         end
                        elseif image(y+-4,x+-1) < c_b 
                         continue
                        else
                        end
                       elseif image(y+0,x+3) < c_b 
                        continue
                       else
                        if image(y+4,x+0) > cb 
                         if image(y+-4,x+0) > cb 
                         elseif image(y+-4,x+0) < c_b 
                          continue
                         else
                          if image(y+3,x+-1) > cb 
                          elseif image(y+3,x+-1) < c_b 
                           continue
                          else
                           if image(y+1,x+3) > cb 
                           else
                            continue
                           end
                          end
                         end
                        else
                         continue
                        end
                       end
                      end
                     end
                    elseif image(y+1,x+-4) < c_b 
                     if image(y+-1,x+-2) > cb 
                     else
                      continue
                     end
                    else
                     if image(y+1,x+-2) > cb 
                      if image(y+-4,x+0) > cb 
                      elseif image(y+-4,x+0) < c_b 
                       continue
                      else
                       if image(y+0,x+4) > cb 
                        if image(y+0,x+-4) > cb 
                        elseif image(y+0,x+-4) < c_b 
                         continue
                        else
                         if image(y+-4,x+-1) > cb 
                          if image(y+0,x+2) > cb | image(y+0,x+2) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        end
                       elseif image(y+0,x+4) < c_b 
                        continue
                       else
                        if image(y+1,x+3) > cb 
                        else
                         continue
                        end
                       end
                      end
                     elseif image(y+1,x+-2) < c_b 
                      continue
                     else
                      if image(y+-4,x+0) > cb 
                      elseif image(y+-4,x+0) < c_b 
                       continue
                      else
                       if image(y+-2,x+-2) > cb 
                       elseif image(y+-2,x+-2) < c_b 
                        continue
                       else
                        if image(y+0,x+4) > cb 
                        else
                         continue
                        end
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+4,x+1) < c_b 
                   if image(y+2,x+-2) > cb 
                    if image(y+-3,x+2) < c_b
                     continue
                    else
                    end
                   else
                    continue
                   end
                  else
                   if image(y+2,x+0) > cb 
                    if image(y+0,x+-4) > cb 
                     if image(y+-1,x+-2) > cb 
                      if image(y+0,x+-2) > cb 
                      elseif image(y+0,x+-2) < c_b 
                       continue
                      else
                       if image(y+3,x+1) > cb 
                       elseif image(y+3,x+1) < c_b 
                        continue
                       else
                        if image(y+-3,x+2) > cb 
                        elseif image(y+-3,x+2) < c_b 
                         continue
                        else
                         if image(y+0,x+4) > cb 
                         else
                          continue
                         end
                        end
                       end
                      end
                     elseif image(y+-1,x+-2) < c_b 
                      continue
                     else
                      if image(y+1,x+4) > cb 
                       if image(y+1,x+3) > cb 
                        if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                         continue
                        else
                        end
                       elseif image(y+1,x+3) < c_b 
                        continue
                       else
                       end
                      else
                       continue
                      end
                     end
                    elseif image(y+0,x+-4) < c_b 
                    else
                     if image(y+-2,x+-2) > cb 
                     elseif image(y+-2,x+-2) < c_b 
                      continue
                     else
                      if image(y+-4,x+0) > cb 
                      elseif image(y+-4,x+0) < c_b 
                       continue
                      else
                       if image(y+-1,x+4) > cb 
                       elseif image(y+-1,x+4) < c_b 
                        continue
                       else
                        if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                         continue
                        else
                         if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+2,x+0) < c_b 
                   else
                    if image(y+-1,x+-2) > cb 
                     if image(y+-3,x+1) > cb 
                      if image(y+-1,x+3) > cb 
                       if image(y+-2,x+2) > cb 
                        if image(y+-1,x+-4) > cb 
                        elseif image(y+-1,x+-4) < c_b 
                         continue
                        else
                         if image(y+1,x+-2) > cb 
                         elseif image(y+1,x+-2) < c_b 
                          continue
                         else
                          if image(y+-1,x+2) > cb 
                           if image(y+3,x+-1) > cb 
                           else
                            continue
                           end
                          else
                           continue
                          end
                         end
                        end
                       elseif image(y+-2,x+2) < c_b 
                        continue
                       else
                        if image(y+1,x+-2) > cb 
                         if image(y+2,x+-1) > cb 
                         elseif image(y+2,x+-1) < c_b 
                          continue
                         else
                          if image(y+-1,x+-4) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+1,x+-2) < c_b 
                         continue
                        else
                         if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                          continue
                         else
                          if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       end
                      elseif image(y+-1,x+3) < c_b 
                       continue
                      else
                       if image(y+-2,x+2) > cb 
                        if image(y+1,x+-4) > cb 
                         if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                          continue
                         else
                         end
                        elseif image(y+1,x+-4) < c_b 
                         continue
                        else
                        end
                       elseif image(y+-2,x+2) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+-3,x+1) < c_b 
                      continue
                     else
                      if image(y+-2,x+2) > cb 
                       if image(y+1,x+4) > cb 
                        if image(y+-3,x+0) > cb 
                         if image(y+-2,x+-3) > cb 
                         else
                          continue
                         end
                        elseif image(y+-3,x+0) < c_b 
                         continue
                        else
                        end
                       elseif image(y+1,x+4) < c_b 
                        continue
                       else
                        if image(y+1,x+3) > cb 
                         if image(y+0,x+2) > cb 
                         elseif image(y+0,x+2) < c_b 
                          continue
                         else
                          if image(y+-1,x+-4) > cb 
                           continue
                          elseif image(y+-1,x+-4) < c_b 
                          else
                           if image(y+-4,x+-1) > cb 
                            if image(y+-4,x+1) > cb 
                            else
                             continue
                            end
                           elseif image(y+-4,x+-1) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        elseif image(y+1,x+3) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+-2,x+2) < c_b 
                      else
                       if image(y+-4,x+-1) > cb 
                        if image(y+1,x+-2) > cb 
                         if image(y+-2,x+3) > cb 
                          if image(y+-3,x+0) > cb 
                           if image(y+1,x+4) > cb 
                            if image(y+-4,x+0) > cb 
                            else
                             continue
                            end
                           elseif image(y+1,x+4) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-3,x+0) < c_b 
                           continue
                          else
                           if image(y+1,x+3) > cb 
                            if image(y+-3,x+2) > cb 
                             if image(y+2,x+-1) > cb 
                             else
                              continue
                             end
                            elseif image(y+-3,x+2) < c_b 
                             continue
                            else
                             if image(y+-1,x+3) > cb | image(y+-1,x+3) < c_b 
                              continue
                             else
                             end
                            end
                           elseif image(y+1,x+3) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+-2,x+3) < c_b 
                          continue
                         else
                          if image(y+-1,x+4) > cb 
                          elseif image(y+-1,x+4) < c_b 
                           continue
                          else
                           if image(y+2,x+-1) > cb 
                            if image(y+-4,x+1) > cb 
                             if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                              continue
                             else
                             end
                            elseif image(y+-4,x+1) < c_b 
                             continue
                            else
                             if image(y+-3,x+0) > cb 
                              if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                               continue
                              else
                              end
                             else
                              continue
                             end
                            end
                           else
                            continue
                           end
                          end
                         end
                        elseif image(y+1,x+-2) < c_b 
                         continue
                        else
                         if image(y+3,x+0) > cb 
                          if image(y+2,x+2) > cb 
                           if image(y+-4,x+0) > cb 
                            if image(y+3,x+1) > cb 
                             if image(y+0,x+-2) > cb 
                              if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                               continue
                              else
                              end
                             else
                              continue
                             end
                            elseif image(y+3,x+1) < c_b 
                             continue
                            else
                             if image(y+-2,x+0) > cb 
                             elseif image(y+-2,x+0) < c_b 
                              continue
                             else
                              if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                               continue
                              else
                              end
                             end
                            end
                           elseif image(y+-4,x+0) < c_b 
                            continue
                           else
                           end
                          elseif image(y+2,x+2) < c_b 
                           continue
                          else
                           if image(y+0,x+-4) > cb 
                            continue
                           elseif image(y+0,x+-4) < c_b 
                           else
                            if image(y+-3,x+0) > cb 
                             if image(y+0,x+-2) > cb | image(y+0,x+-2) < c_b 
                              continue
                             else
                              if image(y+4,x+0) > cb 
                               if image(y+-4,x+1) > cb 
                               elseif image(y+-4,x+1) < c_b 
                                continue
                               else
                                if image(y+-4,x+0) > cb 
                                 if image(y+-1,x+-3) > cb 
                                 else
                                  continue
                                 end
                                elseif image(y+-4,x+0) < c_b 
                                 continue
                                else
                                end
                               end
                              else
                               continue
                              end
                             end
                            else
                             continue
                            end
                           end
                          end
                         elseif image(y+3,x+0) < c_b 
                          continue
                         else
                          if image(y+-1,x+2) > cb 
                           if image(y+-4,x+1) > cb 
                           else
                            continue
                           end
                          elseif image(y+-1,x+2) < c_b 
                           continue
                          else
                           if image(y+2,x+1) > cb 
                            if image(y+0,x+-2) > cb 
                            elseif image(y+0,x+-2) < c_b 
                             continue
                            else
                             if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                              continue
                             else
                              if image(y+-3,x+0) > cb 
                              else
                               continue
                              end
                             end
                            end
                           elseif image(y+2,x+1) < c_b 
                            continue
                           else
                            if image(y+3,x+-1) > cb 
                             if image(y+3,x+-2) > cb 
                              if image(y+-1,x+-4) > cb 
                               if image(y+2,x+-1) > cb 
                                if image(y+-4,x+0) > cb 
                                else
                                 continue
                                end
                               elseif image(y+2,x+-1) < c_b 
                                continue
                               else
                                if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                                 continue
                                else
                                 if image(y+-3,x+0) > cb 
                                 elseif image(y+-3,x+0) < c_b 
                                  continue
                                 else
                                  if image(y+-4,x+1) > cb 
                                  else
                                   continue
                                  end
                                 end
                                end
                               end
                              elseif image(y+-1,x+-4) < c_b 
                               continue
                              else
                               if image(y+2,x+-1) > cb 
                                if image(y+-2,x+0) > cb 
                                 if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                                  continue
                                 else
                                 end
                                else
                                 continue
                                end
                               else
                                continue
                               end
                              end
                             else
                              continue
                             end
                            elseif image(y+3,x+-1) < c_b 
                             continue
                            else
                             if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                              continue
                             else
                             end
                            end
                           end
                          end
                         end
                        end
                       elseif image(y+-4,x+-1) < c_b 
                        continue
                       else
                        if image(y+-3,x+0) > cb 
                         if image(y+-1,x+3) > cb 
                          if image(y+-2,x+0) > cb 
                           if image(y+2,x+-1) > cb 
                           else
                            continue
                           end
                          elseif image(y+-2,x+0) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-1,x+3) < c_b 
                          continue
                         else
                          if image(y+-2,x+-2) > cb 
                          elseif image(y+-2,x+-2) < c_b 
                           continue
                          else
                           if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        elseif image(y+-3,x+0) < c_b 
                        else
                         if image(y+2,x+-1) > cb 
                          if image(y+-1,x+4) > cb 
                           if image(y+2,x+-2) > cb 
                           elseif image(y+2,x+-2) < c_b 
                            continue
                           else
                            if image(y+-1,x+-4) > cb 
                            elseif image(y+-1,x+-4) < c_b 
                             continue
                            else
                             if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                              continue
                             else
                              if image(y+1,x+3) > cb 
                              else
                               continue
                              end
                             end
                            end
                           end
                          elseif image(y+-1,x+4) < c_b 
                           continue
                          else
                           if image(y+-3,x+2) > cb 
                           else
                            continue
                           end
                          end
                         elseif image(y+2,x+-1) < c_b 
                          continue
                         else
                          if image(y+-3,x+2) > cb 
                           if image(y+-1,x+3) > cb 
                            if image(y+0,x+-4) > cb 
                            else
                             continue
                            end
                           elseif image(y+-1,x+3) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-3,x+2) < c_b 
                           continue
                          else
                           if image(y+-4,x+0) > cb 
                           elseif image(y+-4,x+0) < c_b 
                            continue
                           else
                            if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                             continue
                            else
                             if image(y+1,x+-4) > cb 
                              continue
                             elseif image(y+1,x+-4) < c_b 
                             else
                              if image(y+2,x+-2) > cb 
                               if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                                continue
                               else
                               end
                              else
                               continue
                              end
                             end
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+-1,x+-2) < c_b 
                     continue
                    else
                     if image(y+2,x+-1) > cb 
                      if image(y+-1,x+2) > cb | image(y+-1,x+2) < c_b 
                      else
                       if image(y+-4,x+1) > cb 
                        if image(y+3,x+-2) > cb 
                         if image(y+0,x+4) > cb 
                         elseif image(y+0,x+4) < c_b 
                          continue
                         else
                          if image(y+1,x+4) > cb 
                           if image(y+-3,x+1) > cb 
                            if image(y+-2,x+-3) > cb 
                            else
                             continue
                            end
                           elseif image(y+-3,x+1) < c_b 
                            continue
                           else
                           end
                          elseif image(y+1,x+4) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+3,x+-2) < c_b 
                         continue
                        else
                         if image(y+-2,x+2) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+-4,x+1) < c_b 
                        continue
                       else
                        if image(y+1,x+-2) > cb 
                         if image(y+4,x+0) > cb 
                          if image(y+-3,x+0) > cb 
                           if image(y+-1,x+4) > cb | image(y+-1,x+4) < c_b 
                            continue
                           else
                           end
                          else
                           continue
                          end
                         elseif image(y+4,x+0) < c_b 
                          continue
                         else
                          if image(y+-2,x+-2) > cb 
                           if image(y+-4,x+0) > cb 
                           elseif image(y+-4,x+0) < c_b 
                            continue
                           else
                            if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                             continue
                            else
                             if image(y+-4,x+-1) > cb 
                              if image(y+1,x+4) > cb | image(y+1,x+4) < c_b 
                               continue
                              else
                               if image(y+2,x+-2) > cb 
                                if image(y+-2,x+0) > cb 
                                elseif image(y+-2,x+0) < c_b 
                                 continue
                                else
                                 if image(y+-1,x+-4) < c_b
                                 else
                                  continue
                                 end
                                end
                               else
                                continue
                               end
                              end
                             elseif image(y+-4,x+-1) < c_b 
                              continue
                             else
                             end
                            end
                           end
                          elseif image(y+-2,x+-2) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+1,x+-2) < c_b 
                         continue
                        else
                         if image(y+-2,x+3) > cb 
                          if image(y+-4,x+-1) > cb 
                           if image(y+-1,x+3) > cb | image(y+-1,x+3) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-4,x+-1) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-2,x+3) < c_b 
                          continue
                         else
                          if image(y+3,x+0) > cb 
                           if image(y+4,x+0) > cb 
                            if image(y+-2,x+-2) > cb 
                            else
                             continue
                            end
                           else
                            continue
                           end
                          else
                           continue
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+2,x+-1) < c_b 
                      continue
                     else
                      if image(y+-1,x+2) > cb 
                       if image(y+3,x+-2) > cb 
                       elseif image(y+3,x+-2) < c_b 
                        continue
                       else
                        if image(y+0,x+-4) > cb 
                         if image(y+-4,x+-1) > cb 
                         else
                          continue
                         end
                        elseif image(y+0,x+-4) < c_b 
                         continue
                        else
                         if image(y+0,x+3) > cb | image(y+0,x+3) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      elseif image(y+-1,x+2) < c_b 
                       continue
                      else
                       if image(y+1,x+-2) > cb 
                        if image(y+-2,x+3) > cb 
                         if image(y+2,x+1) > cb 
                         else
                          continue
                         end
                        elseif image(y+-2,x+3) < c_b 
                         continue
                        else
                         if image(y+-2,x+-2) > cb 
                          if image(y+-3,x+1) > cb 
                          else
                           continue
                          end
                         elseif image(y+-2,x+-2) < c_b 
                          continue
                         else
                          if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+1,x+-2) < c_b 
                        continue
                       else
                        if image(y+-1,x+-4) > cb 
                         continue
                        elseif image(y+-1,x+-4) < c_b 
                        else
                         if image(y+2,x+1) > cb 
                          if image(y+-3,x+0) > cb 
                           if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                            continue
                           else
                            if image(y+-3,x+1) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+-3,x+0) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  end
                 elseif image(y+4,x+-1) < c_b 
                  if image(y+-3,x+2) > cb 
                   if image(y+-1,x+-2) > cb 
                    if image(y+-1,x+3) > cb 
                     if image(y+-2,x+2) > cb 
                      if image(y+-1,x+-4) > cb 
                      elseif image(y+-1,x+-4) < c_b 
                       continue
                      else
                       if image(y+1,x+-2) > cb 
                       elseif image(y+1,x+-2) < c_b 
                        continue
                       else
                        if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                         continue
                        else
                         if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      end
                     elseif image(y+-2,x+2) < c_b 
                      continue
                     else
                      if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                       continue
                      else
                      end
                     end
                    else
                     if image(y+-3,x+1) > cb 
                     else
                      continue
                     end
                    end
                   elseif image(y+-1,x+-2) < c_b 
                    continue
                   else
                    if image(y+-2,x+2) > cb 
                     if image(y+0,x+4) < c_b
                      continue
                     else
                      if image(y+-2,x+3) > cb 
                      else
                       continue
                      end
                     end
                    else
                     continue
                    end
                   end
                  elseif image(y+-3,x+2) < c_b 
                   if image(y+2,x+-1) > cb 
                    continue
                   elseif image(y+2,x+-1) < c_b 
                   else
                    if image(y+-1,x+-2) > cb 
                     if image(y+-2,x+2) > cb 
                      continue
                     elseif image(y+-2,x+2) < c_b 
                     else
                      if image(y+-4,x+-1) > cb 
                      else
                       continue
                      end
                     end
                    elseif image(y+-1,x+-2) < c_b 
                     continue
                    else
                     if image(y+3,x+-2) < c_b
                      if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                       continue
                      else
                      end
                     else
                      continue
                     end
                    end
                   end
                  else
                   if image(y+-1,x+-2) > cb 
                    if image(y+2,x+0) > cb 
                    elseif image(y+2,x+0) < c_b 
                     if image(y+-3,x+1) > cb 
                     elseif image(y+-3,x+1) < c_b 
                      continue
                     else
                      if image(y+-2,x+3) > cb 
                       if image(y+3,x+-2) > cb 
                        continue
                       elseif image(y+3,x+-2) < c_b 
                        if image(y+-2,x+0) > cb 
                        else
                         continue
                        end
                       else
                        if image(y+-1,x+2) > cb 
                         if image(y+1,x+-4) > cb | image(y+1,x+-4) < c_b 
                          continue
                         else
                          if image(y+3,x+-1) < c_b
                          else
                           continue
                          end
                         end
                        else
                         continue
                        end
                       end
                      elseif image(y+-2,x+3) < c_b 
                       if image(y+-1,x+3) > cb 
                        continue
                       elseif image(y+-1,x+3) < c_b 
                       else
                        if image(y+-3,x+0) > cb 
                         if image(y+1,x+-3) < c_b
                         else
                          continue
                         end
                        elseif image(y+-3,x+0) < c_b 
                         continue
                        else
                        end
                       end
                      else
                       if image(y+1,x+-2) > cb 
                        if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                         continue
                        else
                        end
                       elseif image(y+1,x+-2) < c_b 
                        continue
                       else
                        if image(y+-2,x+2) < c_b
                        else
                         continue
                        end
                       end
                      end
                     end
                    else
                     if image(y+-1,x+3) > cb 
                      if image(y+1,x+-2) > cb 
                       if image(y+0,x+3) > cb 
                        if image(y+2,x+-2) > cb | image(y+2,x+-2) < c_b 
                         continue
                        else
                        end
                       else
                        continue
                       end
                      elseif image(y+1,x+-2) < c_b 
                       continue
                      else
                       if image(y+2,x+-1) < c_b
                        if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                         continue
                        else
                        end
                       else
                        continue
                       end
                      end
                     elseif image(y+-1,x+3) < c_b 
                      if image(y+-2,x+2) < c_b
                      else
                       continue
                      end
                     else
                     end
                    end
                   elseif image(y+-1,x+-2) < c_b 
                    continue
                   else
                    if image(y+-1,x+2) > cb 
                     continue
                    elseif image(y+-1,x+2) < c_b 
                     if image(y+2,x+2) > cb | image(y+2,x+2) < c_b 
                      continue
                     else
                     end
                    else
                     if image(y+2,x+1) > cb 
                     elseif image(y+2,x+1) < c_b 
                      if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                       continue
                      else
                      end
                     else
                      if image(y+1,x+-2) > cb 
                       if image(y+-2,x+3) > cb 
                       else
                        continue
                       end
                      elseif image(y+1,x+-2) < c_b 
                       if image(y+-2,x+3) < c_b
                        if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                         continue
                        else
                         if image(y+4,x+0) > cb | image(y+4,x+0) < c_b 
                          continue
                         else
                         end
                        end
                       else
                        continue
                       end
                      else
                       continue
                      end
                     end
                    end
                   end
                  end
                 else
                 end
                end
               end
              end
             end
            elseif image(y+-2,x+-1) < c_b 
             if image(y+2,x+1) > cb 
              if image(y+-2,x+3) > cb 
               if image(y+-4,x+-1) < c_b
                if image(y+-4,x+1) < c_b
                else
                 continue
                end
               else
               end
              elseif image(y+-2,x+3) < c_b 
               if image(y+-2,x+1) > cb 
                continue
               elseif image(y+-2,x+1) < c_b 
               else
                if image(y+-4,x+-1) > cb 
                else
                 continue
                end
               end
              else
               if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
               else
                if image(y+1,x+-3) > cb 
                 if image(y+-2,x+-3) > cb 
                  if image(y+-4,x+1) > cb 
                  elseif image(y+-4,x+1) < c_b 
                   if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                    continue
                   else
                    if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                     continue
                    else
                    end
                   end
                  else
                   if image(y+-3,x+2) < c_b
                    continue
                   else
                   end
                  end
                 elseif image(y+-2,x+-3) < c_b 
                 else
                  if image(y+0,x+-2) > cb 
                  elseif image(y+0,x+-2) < c_b 
                   if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                    continue
                   else
                   end
                  else
                   if image(y+2,x+0) > cb 
                    if image(y+-1,x+3) > cb 
                    elseif image(y+-1,x+3) < c_b 
                     if image(y+-2,x+-2) < c_b
                     else
                      continue
                     end
                    else
                     continue
                    end
                   else
                    continue
                   end
                  end
                 end
                elseif image(y+1,x+-3) < c_b 
                else
                 if image(y+0,x+3) > cb 
                  if image(y+3,x+0) > cb 
                   if image(y+1,x+-4) < c_b
                    if image(y+-4,x+0) > cb 
                    elseif image(y+-4,x+0) < c_b 
                     continue
                    else
                     if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                      continue
                     else
                     end
                    end
                   else
                   end
                  elseif image(y+3,x+0) < c_b 
                   continue
                  else
                   if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                    continue
                   else
                   end
                  end
                 elseif image(y+0,x+3) < c_b 
                  continue
                 else
                  if image(y+-4,x+1) > cb 
                  elseif image(y+-4,x+1) < c_b 
                   if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                    continue
                   else
                   end
                  else
                   continue
                  end
                 end
                end
               end
              end
             elseif image(y+2,x+1) < c_b 
             else
              if image(y+0,x+-2) > cb 
               if image(y+1,x+2) > cb 
               elseif image(y+1,x+2) < c_b 
                continue
               else
                if image(y+2,x+0) > cb | image(y+2,x+0) < c_b 
                else
                 if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                  continue
                 else
                 end
                end
               end
              elseif image(y+0,x+-2) < c_b 
               if image(y+0,x+2) > cb 
                if image(y+3,x+-1) > cb 
                 if image(y+-3,x+2) < c_b
                  continue
                 else
                 end
                elseif image(y+3,x+-1) < c_b 
                 if image(y+-4,x+0) < c_b
                 else
                  continue
                 end
                else
                end
               elseif image(y+0,x+2) < c_b 
                continue
               else
                if image(y+2,x+-1) > cb 
                else
                 continue
                end
               end
              else
               if image(y+2,x+-2) > cb 
                if image(y+-1,x+2) > cb | image(y+-1,x+2) < c_b 
                else
                 if image(y+2,x+2) > cb 
                 else
                  continue
                 end
                end
               elseif image(y+2,x+-2) < c_b 
                if image(y+-1,x+-3) > cb 
                 if image(y+1,x+3) > cb 
                 else
                  continue
                 end
                elseif image(y+-1,x+-3) < c_b 
                 continue
                else
                end
               else
                if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                 continue
                else
                 if image(y+3,x+0) > cb 
                 elseif image(y+3,x+0) < c_b 
                  continue
                 else
                  if image(y+-1,x+-4) > cb 
                   if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                    continue
                   else
                    if image(y+-3,x+0) < c_b
                    else
                     continue
                    end
                   end
                  elseif image(y+-1,x+-4) < c_b 
                   continue
                  else
                   if image(y+-2,x+0) < c_b
                   else
                    continue
                   end
                  end
                 end
                end
               end
              end
             end
            else
             if image(y+1,x+2) > cb 
              if image(y+3,x+-1) > cb 
               if image(y+1,x+-4) > cb 
                if image(y+-2,x+-3) > cb 
                 if image(y+0,x+-2) > cb 
                  if image(y+1,x+-2) > cb 
                   if image(y+-2,x+-2) > cb 
                    if image(y+-4,x+1) < c_b
                     if image(y+-1,x+-2) > cb 
                     elseif image(y+-1,x+-2) < c_b 
                      continue
                     else
                      if image(y+-3,x+1) < c_b
                      else
                       continue
                      end
                     end
                    else
                    end
                   elseif image(y+-2,x+-2) < c_b 
                    continue
                   else
                    if image(y+2,x+1) > cb 
                    elseif image(y+2,x+1) < c_b 
                     continue
                    else
                     if image(y+-3,x+2) > cb 
                      if image(y+2,x+2) > cb 
                      elseif image(y+2,x+2) < c_b 
                       continue
                      else
                       if image(y+-2,x+1) > cb 
                       elseif image(y+-2,x+1) < c_b 
                        continue
                       else
                        if image(y+-3,x+-1) > cb 
                         if image(y+-1,x+-2) > cb 
                         elseif image(y+-1,x+-2) < c_b 
                          continue
                         else
                          if image(y+2,x+-1) > cb | image(y+2,x+-1) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+-3,x+-1) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     elseif image(y+-3,x+2) < c_b 
                      continue
                     else
                      if image(y+-1,x+4) > cb 
                       if image(y+-1,x+3) > cb 
                        if image(y+0,x+-4) > cb 
                         if image(y+0,x+2) > cb 
                         elseif image(y+0,x+2) < c_b 
                          continue
                         else
                          if image(y+-1,x+-2) > cb 
                          elseif image(y+-1,x+-2) < c_b 
                           continue
                          else
                           if image(y+-4,x+-1) > cb 
                            if image(y+4,x+1) > cb 
                            else
                             continue
                            end
                           elseif image(y+-4,x+-1) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        elseif image(y+0,x+-4) < c_b 
                         continue
                        else
                         if image(y+-2,x+3) > cb 
                          if image(y+2,x+2) > cb 
                          else
                           continue
                          end
                         else
                          continue
                         end
                        end
                       elseif image(y+-1,x+3) < c_b 
                        continue
                       else
                       end
                      elseif image(y+-1,x+4) < c_b 
                      else
                       if image(y+0,x+2) > cb 
                       elseif image(y+0,x+2) < c_b 
                        continue
                       else
                        if image(y+-3,x+-1) > cb 
                        elseif image(y+-3,x+-1) < c_b 
                         continue
                        else
                         if image(y+-1,x+-2) > cb 
                          if image(y+0,x+4) > cb 
                          elseif image(y+0,x+4) < c_b 
                           continue
                          else
                           if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+-1,x+-2) < c_b 
                          continue
                         else
                          if image(y+4,x+1) > cb 
                           if image(y+1,x+4) > cb 
                           else
                            continue
                           end
                          else
                           continue
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+1,x+-2) < c_b 
                   continue
                  else
                   if image(y+2,x+1) > cb 
                    if image(y+-3,x+1) > cb 
                     if image(y+-2,x+2) > cb 
                     elseif image(y+-2,x+2) < c_b 
                      continue
                     else
                      if image(y+4,x+-1) > cb 
                       if image(y+-3,x+0) > cb 
                       elseif image(y+-3,x+0) < c_b 
                        continue
                       else
                        if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                         continue
                        else
                        end
                       end
                      else
                       continue
                      end
                     end
                    else
                    end
                   elseif image(y+2,x+1) < c_b 
                    continue
                   else
                    if image(y+-2,x+2) > cb 
                    elseif image(y+-2,x+2) < c_b 
                     continue
                    else
                     if image(y+2,x+-2) > cb 
                      if image(y+1,x+4) > cb 
                      elseif image(y+1,x+4) < c_b 
                       continue
                      else
                       if image(y+1,x+3) > cb 
                        if image(y+-2,x+3) > cb 
                        else
                         continue
                        end
                       elseif image(y+1,x+3) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+2,x+-2) < c_b 
                      continue
                     else
                      if image(y+3,x+1) > cb 
                       if image(y+-1,x+2) > cb 
                       else
                        continue
                       end
                      elseif image(y+3,x+1) < c_b 
                       continue
                      else
                       if image(y+4,x+1) > cb | image(y+4,x+1) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    end
                   end
                  end
                 elseif image(y+0,x+-2) < c_b 
                 else
                  if image(y+-1,x+3) > cb 
                   if image(y+2,x+1) > cb 
                    if image(y+-3,x+1) > cb 
                     if image(y+-2,x+2) > cb 
                      if image(y+4,x+1) > cb 
                       if image(y+-4,x+1) > cb 
                       elseif image(y+-4,x+1) < c_b 
                        continue
                       else
                        if image(y+1,x+4) > cb 
                        elseif image(y+1,x+4) < c_b 
                         continue
                        else
                         if image(y+2,x+-3) > cb 
                         elseif image(y+2,x+-3) < c_b 
                          continue
                         else
                          if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       end
                      elseif image(y+4,x+1) < c_b 
                       continue
                      else
                       if image(y+2,x+-2) > cb 
                       elseif image(y+2,x+-2) < c_b 
                        continue
                       else
                        if image(y+1,x+-3) > cb 
                         if image(y+-2,x+-2) > cb 
                         elseif image(y+-2,x+-2) < c_b 
                          continue
                         else
                          if image(y+-2,x+1) > cb 
                          elseif image(y+-2,x+1) < c_b 
                           continue
                          else
                           if image(y+2,x+0) > cb 
                           elseif image(y+2,x+0) < c_b 
                            continue
                           else
                            if image(y+-1,x+-2) > cb 
                            else
                             continue
                            end
                           end
                          end
                         end
                        elseif image(y+1,x+-3) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     elseif image(y+-2,x+2) < c_b 
                      continue
                     else
                      if image(y+1,x+-2) > cb | image(y+1,x+-2) < c_b 
                      else
                       if image(y+1,x+4) > cb 
                        if image(y+2,x+-2) > cb 
                        elseif image(y+2,x+-2) < c_b 
                         continue
                        else
                         if image(y+1,x+-3) > cb 
                          if image(y+-1,x+2) > cb 
                          elseif image(y+-1,x+2) < c_b 
                           continue
                          else
                           if image(y+2,x+-1) > cb 
                           else
                            continue
                           end
                          end
                         elseif image(y+1,x+-3) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+1,x+4) < c_b 
                        continue
                       else
                        if image(y+-2,x+-2) > cb 
                        elseif image(y+-2,x+-2) < c_b 
                         continue
                        else
                         if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+-3,x+1) < c_b 
                     if image(y+1,x+-3) > cb 
                      if image(y+2,x+-2) < c_b
                       continue
                      else
                       if image(y+-1,x+2) > cb 
                       else
                        continue
                       end
                      end
                     elseif image(y+1,x+-3) < c_b 
                      continue
                     else
                     end
                    else
                    end
                   elseif image(y+2,x+1) < c_b 
                    continue
                   else
                    if image(y+2,x+-2) > cb 
                     if image(y+1,x+4) > cb 
                      if image(y+4,x+1) > cb 
                      elseif image(y+4,x+1) < c_b 
                       continue
                      else
                       if image(y+-2,x+-2) > cb 
                       elseif image(y+-2,x+-2) < c_b 
                        continue
                       else
                        if image(y+-3,x+2) > cb 
                         if image(y+1,x+-2) > cb 
                         elseif image(y+1,x+-2) < c_b 
                          continue
                         else
                          if image(y+0,x+-3) > cb 
                           if image(y+3,x+2) > cb 
                           elseif image(y+3,x+2) < c_b 
                            continue
                           else
                            if image(y+1,x+-3) > cb 
                             if image(y+-4,x+0) > cb 
                             elseif image(y+-4,x+0) < c_b 
                              continue
                             else
                              if image(y+-1,x+-2) > cb 
                              else
                               continue
                              end
                             end
                            else
                             continue
                            end
                           end
                          elseif image(y+0,x+-3) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+-3,x+2) < c_b 
                         continue
                        else
                         if image(y+2,x+-1) > cb 
                          if image(y+-2,x+3) > cb 
                           if image(y+-1,x+2) > cb 
                            if image(y+-3,x+1) > cb 
                            elseif image(y+-3,x+1) < c_b 
                             continue
                            else
                             if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                              continue
                             else
                              if image(y+0,x+-3) > cb 
                              elseif image(y+0,x+-3) < c_b 
                               continue
                              else
                               if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                                continue
                               else
                               end
                              end
                             end
                            end
                           elseif image(y+-1,x+2) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-2,x+3) < c_b 
                           continue
                          else
                           if image(y+-1,x+2) > cb 
                           else
                            continue
                           end
                          end
                         elseif image(y+2,x+-1) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      end
                     elseif image(y+1,x+4) < c_b 
                      continue
                     else
                      if image(y+-2,x+1) > cb 
                      elseif image(y+-2,x+1) < c_b 
                       continue
                      else
                       if image(y+4,x+1) > cb 
                        if image(y+2,x+-1) > cb 
                         if image(y+-2,x+-2) > cb 
                         else
                          continue
                         end
                        elseif image(y+2,x+-1) < c_b 
                         continue
                        else
                         if image(y+1,x+-2) > cb 
                          if image(y+2,x+2) > cb 
                          else
                           continue
                          end
                         else
                          continue
                         end
                        end
                       elseif image(y+4,x+1) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    elseif image(y+2,x+-2) < c_b 
                     continue
                    else
                     if image(y+1,x+-3) > cb 
                      if image(y+-1,x+2) > cb 
                       if image(y+-2,x+-2) > cb 
                       elseif image(y+-2,x+-2) < c_b 
                        continue
                       else
                        if image(y+-2,x+1) > cb 
                         if image(y+-4,x+1) > cb 
                          if image(y+3,x+-2) > cb 
                          elseif image(y+3,x+-2) < c_b 
                           continue
                          else
                           if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+-4,x+1) < c_b 
                          continue
                         else
                          if image(y+-1,x+-3) > cb 
                           if image(y+-3,x+1) > cb 
                            if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                             continue
                            else
                            end
                           elseif image(y+-3,x+1) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-1,x+-3) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+-2,x+1) < c_b 
                         continue
                        else
                         if image(y+2,x+-3) > cb 
                          if image(y+-2,x+2) > cb 
                           if image(y+-1,x+-2) > cb 
                           elseif image(y+-1,x+-2) < c_b 
                            continue
                           else
                            if image(y+-1,x+-3) > cb 
                             if image(y+2,x+2) > cb 
                              if image(y+1,x+-2) > cb 
                              else
                               continue
                              end
                             elseif image(y+2,x+2) < c_b 
                              continue
                             else
                             end
                            elseif image(y+-1,x+-3) < c_b 
                             continue
                            else
                             if image(y+-3,x+-1) > cb 
                             else
                              continue
                             end
                            end
                           end
                          elseif image(y+-2,x+2) < c_b 
                           continue
                          else
                           if image(y+-4,x+1) > cb 
                           elseif image(y+-4,x+1) < c_b 
                            continue
                           else
                            if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                             continue
                            else
                             if image(y+3,x+1) > cb | image(y+3,x+1) < c_b 
                              continue
                             else
                             end
                            end
                           end
                          end
                         elseif image(y+2,x+-3) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      elseif image(y+-1,x+2) < c_b 
                       continue
                      else
                       if image(y+-2,x+1) > cb 
                       elseif image(y+-2,x+1) < c_b 
                        continue
                       else
                        if image(y+2,x+2) > cb 
                         if image(y+-1,x+-2) > cb 
                          if image(y+-2,x+2) > cb 
                          elseif image(y+-2,x+2) < c_b 
                           continue
                          else
                           if image(y+1,x+-2) > cb 
                           else
                            continue
                           end
                          end
                         else
                          continue
                         end
                        elseif image(y+2,x+2) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     elseif image(y+1,x+-3) < c_b 
                      continue
                     else
                     end
                    end
                   end
                  elseif image(y+-1,x+3) < c_b 
                   if image(y+1,x+4) > cb 
                   elseif image(y+1,x+4) < c_b 
                    continue
                   else
                    if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                    else
                     if image(y+-3,x+2) > cb 
                      if image(y+-3,x+1) > cb 
                      else
                       continue
                      end
                     elseif image(y+-3,x+2) < c_b 
                     else
                      continue
                     end
                    end
                   end
                  else
                   if image(y+1,x+4) > cb 
                    if image(y+2,x+-2) > cb 
                     if image(y+4,x+1) > cb | image(y+4,x+1) < c_b 
                     else
                      if image(y+-3,x+-1) > cb 
                      elseif image(y+-3,x+-1) < c_b 
                       continue
                      else
                       if image(y+-2,x+-2) > cb 
                       elseif image(y+-2,x+-2) < c_b 
                        continue
                       else
                        if image(y+-4,x+1) > cb 
                         if image(y+2,x+0) > cb 
                         elseif image(y+2,x+0) < c_b 
                          continue
                         else
                          if image(y+2,x+1) > cb 
                           if image(y+-3,x+2) > cb 
                            if image(y+-3,x+1) > cb 
                            else
                             continue
                            end
                           elseif image(y+-3,x+2) < c_b 
                            continue
                           else
                           end
                          elseif image(y+2,x+1) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+-4,x+1) < c_b 
                        else
                         if image(y+-1,x+4) > cb 
                          if image(y+0,x+2) > cb 
                           if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                            continue
                           else
                           end
                          elseif image(y+0,x+2) < c_b 
                           continue
                          else
                           if image(y+0,x+-3) > cb 
                           elseif image(y+0,x+-3) < c_b 
                            continue
                           else
                            if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                             continue
                            else
                            end
                           end
                          end
                         elseif image(y+-1,x+4) < c_b 
                          continue
                         else
                          if image(y+-2,x+2) > cb 
                          elseif image(y+-2,x+2) < c_b 
                           if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                            continue
                           else
                           end
                          else
                           if image(y+0,x+2) > cb 
                           elseif image(y+0,x+2) < c_b 
                            continue
                           else
                            if image(y+-3,x+2) > cb 
                            else
                             continue
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+2,x+-2) < c_b 
                     continue
                    else
                     if image(y+1,x+-3) > cb 
                      if image(y+-2,x+2) > cb 
                      elseif image(y+-2,x+2) < c_b 
                       if image(y+2,x+1) > cb 
                       else
                        continue
                       end
                      else
                       if image(y+-1,x+-2) > cb 
                        if image(y+2,x+0) > cb 
                         if image(y+-4,x+1) < c_b
                          continue
                         else
                         end
                        elseif image(y+2,x+0) < c_b 
                         continue
                        else
                         if image(y+-3,x+1) > cb 
                         elseif image(y+-3,x+1) < c_b 
                          continue
                         else
                          if image(y+1,x+3) > cb 
                           if image(y+0,x+3) > cb 
                            if image(y+0,x+4) > cb 
                             if image(y+-4,x+0) > cb 
                              if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                               continue
                              else
                              end
                             else
                              continue
                             end
                            elseif image(y+0,x+4) < c_b 
                             continue
                            else
                             if image(y+2,x+-3) > cb | image(y+2,x+-3) < c_b 
                              continue
                             else
                             end
                            end
                           else
                            continue
                           end
                          elseif image(y+1,x+3) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+-1,x+-2) < c_b 
                        continue
                       else
                        if image(y+2,x+-1) > cb 
                         if image(y+-4,x+1) > cb 
                         elseif image(y+-4,x+1) < c_b 
                          continue
                         else
                          if image(y+1,x+-2) < c_b
                           continue
                          else
                           if image(y+-2,x+0) > cb 
                           else
                            continue
                           end
                          end
                         end
                        elseif image(y+2,x+-1) < c_b 
                         continue
                        else
                         if image(y+0,x+4) > cb 
                          if image(y+1,x+-2) > cb 
                          elseif image(y+1,x+-2) < c_b 
                           continue
                          else
                           if image(y+-3,x+0) > cb 
                            if image(y+-1,x+2) > cb 
                            elseif image(y+-1,x+2) < c_b 
                             continue
                            else
                             if image(y+2,x+2) > cb | image(y+2,x+2) < c_b 
                              continue
                             else
                             end
                            end
                           else
                            continue
                           end
                          end
                         elseif image(y+0,x+4) < c_b 
                          continue
                         else
                          if image(y+0,x+3) > cb 
                           if image(y+-3,x+2) > cb 
                           elseif image(y+-3,x+2) < c_b 
                            continue
                           else
                            if image(y+2,x+0) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+0,x+3) < c_b 
                           continue
                          else
                           if image(y+4,x+-1) > cb | image(y+4,x+-1) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+1,x+-3) < c_b 
                      continue
                     else
                     end
                    end
                   elseif image(y+1,x+4) < c_b 
                    continue
                   else
                    if image(y+-2,x+2) > cb 
                     if image(y+2,x+1) > cb 
                     elseif image(y+2,x+1) < c_b 
                      continue
                     else
                      if image(y+0,x+2) > cb 
                      elseif image(y+0,x+2) < c_b 
                       continue
                      else
                       if image(y+1,x+3) > cb 
                        if image(y+0,x+3) > cb 
                        else
                         continue
                        end
                       elseif image(y+1,x+3) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    elseif image(y+-2,x+2) < c_b 
                    else
                     if image(y+-4,x+1) > cb 
                      if image(y+1,x+-2) > cb 
                       if image(y+-4,x+-1) > cb 
                        if image(y+3,x+1) > cb 
                        elseif image(y+3,x+1) < c_b 
                         continue
                        else
                         if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+-4,x+-1) < c_b 
                        continue
                       else
                        if image(y+-3,x+2) > cb 
                        elseif image(y+-3,x+2) < c_b 
                         continue
                        else
                         if image(y+-4,x+0) > cb 
                         elseif image(y+-4,x+0) < c_b 
                          continue
                         else
                          if image(y+-1,x+-2) > cb 
                          else
                           continue
                          end
                         end
                        end
                       end
                      elseif image(y+1,x+-2) < c_b 
                       continue
                      else
                       if image(y+4,x+1) > cb 
                        if image(y+-3,x+-1) > cb 
                         if image(y+0,x+4) > cb 
                         elseif image(y+0,x+4) < c_b 
                          continue
                         else
                          if image(y+2,x+-3) > cb 
                           if image(y+-2,x+1) > cb 
                           elseif image(y+-2,x+1) < c_b 
                            continue
                           else
                            if image(y+-3,x+1) > cb 
                             if image(y+-2,x+-2) > cb 
                              if image(y+-3,x+0) > cb 
                              elseif image(y+-3,x+0) < c_b 
                               continue
                              else
                               if image(y+-1,x+-2) > cb 
                               else
                                continue
                               end
                              end
                             elseif image(y+-2,x+-2) < c_b 
                              continue
                             else
                              if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                               continue
                              else
                               if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                                continue
                               else
                               end
                              end
                             end
                            elseif image(y+-3,x+1) < c_b 
                             continue
                            else
                             if image(y+2,x+-1) > cb 
                             elseif image(y+2,x+-1) < c_b 
                              continue
                             else
                              if image(y+-1,x+-2) > cb 
                              else
                               continue
                              end
                             end
                            end
                           end
                          elseif image(y+2,x+-3) < c_b 
                           continue
                          else
                           if image(y+1,x+-3) > cb 
                            if image(y+-3,x+1) > cb 
                            elseif image(y+-3,x+1) < c_b 
                             continue
                            else
                             if image(y+2,x+1) > cb | image(y+2,x+1) < c_b 
                              continue
                             else
                             end
                            end
                           elseif image(y+1,x+-3) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        elseif image(y+-3,x+-1) < c_b 
                         continue
                        else
                         if image(y+2,x+1) > cb 
                          if image(y+-4,x+-1) > cb 
                          elseif image(y+-4,x+-1) < c_b 
                           continue
                          else
                           if image(y+-3,x+2) > cb 
                           else
                            continue
                           end
                          end
                         else
                          continue
                         end
                        end
                       elseif image(y+4,x+1) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+-4,x+1) < c_b 
                      if image(y+0,x+2) > cb 
                      else
                       continue
                      end
                     else
                      if image(y+-1,x+-2) > cb 
                       if image(y+2,x+0) > cb 
                       elseif image(y+2,x+0) < c_b 
                        continue
                       else
                        if image(y+0,x+3) > cb 
                        elseif image(y+0,x+3) < c_b 
                         continue
                        else
                         if image(y+3,x+2) > cb | image(y+3,x+2) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      elseif image(y+-1,x+-2) < c_b 
                       continue
                      else
                       if image(y+0,x+3) > cb 
                        if image(y+-2,x+3) > cb 
                        elseif image(y+-2,x+3) < c_b 
                         continue
                        else
                         if image(y+2,x+1) > cb 
                         elseif image(y+2,x+1) < c_b 
                          continue
                         else
                          if image(y+-1,x+2) > cb 
                          else
                           continue
                          end
                         end
                        end
                       elseif image(y+0,x+3) < c_b 
                        continue
                       else
                        if image(y+2,x+-3) > cb 
                         if image(y+-3,x+2) > cb 
                          if image(y+1,x+-2) > cb 
                          elseif image(y+1,x+-2) < c_b 
                           continue
                          else
                           if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+-3,x+2) < c_b 
                          if image(y+-3,x+-1) > cb 
                          else
                           continue
                          end
                         else
                          if image(y+-2,x+3) > cb 
                          elseif image(y+-2,x+3) < c_b 
                           continue
                          else
                           if image(y+4,x+1) > cb 
                            if image(y+-2,x+1) > cb | image(y+-2,x+1) < c_b 
                            else
                             if image(y+2,x+-2) > cb 
                              if image(y+-1,x+2) > cb 
                              elseif image(y+-1,x+2) < c_b 
                               continue
                              else
                               if image(y+0,x+4) > cb 
                                if image(y+1,x+3) > cb 
                                else
                                 continue
                                end
                               elseif image(y+0,x+4) < c_b 
                                continue
                               else
                                if image(y+0,x+2) > cb 
                                 if image(y+-3,x+0) > cb 
                                 elseif image(y+-3,x+0) < c_b 
                                  continue
                                 else
                                  if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                                   continue
                                  else
                                   if image(y+1,x+-2) > cb 
                                   else
                                    continue
                                   end
                                  end
                                 end
                                elseif image(y+0,x+2) < c_b 
                                 continue
                                else
                                 if image(y+-4,x+0) > cb 
                                  if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                                   continue
                                  else
                                  end
                                 else
                                  continue
                                 end
                                end
                               end
                              end
                             elseif image(y+2,x+-2) < c_b 
                              continue
                             else
                              if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                               continue
                              else
                              end
                             end
                            end
                           elseif image(y+4,x+1) < c_b 
                            continue
                           else
                            if image(y+2,x+-2) > cb 
                             if image(y+-2,x+-2) > cb 
                             elseif image(y+-2,x+-2) < c_b 
                              continue
                             else
                              if image(y+2,x+-1) > cb 
                               if image(y+-3,x+0) > cb 
                               else
                                continue
                               end
                              elseif image(y+2,x+-1) < c_b 
                               continue
                              else
                              end
                             end
                            else
                             continue
                            end
                           end
                          end
                         end
                        elseif image(y+2,x+-3) < c_b 
                         continue
                        else
                         if image(y+2,x+-1) > cb 
                          if image(y+1,x+-3) > cb 
                           if image(y+-3,x+2) > cb 
                           elseif image(y+-3,x+2) < c_b 
                            continue
                           else
                            if image(y+-1,x+2) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+1,x+-3) < c_b 
                           continue
                          else
                           if image(y+2,x+-2) > cb 
                            if image(y+0,x+4) > cb 
                            elseif image(y+0,x+4) < c_b 
                             continue
                            else
                             if image(y+-4,x+-1) > cb 
                             else
                              continue
                             end
                            end
                           elseif image(y+2,x+-2) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+2,x+-1) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  end
                 end
                elseif image(y+-2,x+-3) < c_b 
                 if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
                 else
                  if image(y+-2,x+-2) > cb 
                   continue
                  elseif image(y+-2,x+-2) < c_b 
                  else
                   if image(y+-1,x+4) > cb 
                   elseif image(y+-1,x+4) < c_b 
                    continue
                   else
                    if image(y+-2,x+3) > cb 
                    else
                     continue
                    end
                   end
                  end
                 end
                else
                 if image(y+-2,x+3) > cb 
                  if image(y+1,x+-2) > cb 
                   if image(y+2,x+2) > cb 
                    if image(y+4,x+-1) > cb 
                    elseif image(y+4,x+-1) < c_b 
                     continue
                    else
                     if image(y+2,x+0) > cb 
                     elseif image(y+2,x+0) < c_b 
                      continue
                     else
                      if image(y+-1,x+3) > cb 
                      elseif image(y+-1,x+3) < c_b 
                       continue
                      else
                       if image(y+0,x+-3) > cb 
                       elseif image(y+0,x+-3) < c_b 
                        continue
                       else
                        if image(y+-4,x+0) > cb 
                        else
                         continue
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+2,x+2) < c_b 
                    continue
                   else
                    if image(y+0,x+-4) > cb 
                    elseif image(y+0,x+-4) < c_b 
                     continue
                    else
                     if image(y+2,x+-2) > cb 
                      if image(y+-1,x+2) > cb 
                      elseif image(y+-1,x+2) < c_b 
                       continue
                      else
                       if image(y+-4,x+1) > cb 
                        if image(y+-2,x+1) > cb 
                         if image(y+0,x+3) > cb 
                         else
                          continue
                         end
                        else
                         continue
                        end
                       elseif image(y+-4,x+1) < c_b 
                        continue
                       else
                       end
                      end
                     else
                      continue
                     end
                    end
                   end
                  elseif image(y+1,x+-2) < c_b 
                  else
                   if image(y+-1,x+2) > cb 
                    if image(y+2,x+1) > cb 
                     if image(y+2,x+0) > cb 
                     elseif image(y+2,x+0) < c_b 
                      continue
                     else
                      if image(y+-2,x+1) > cb 
                      elseif image(y+-2,x+1) < c_b 
                       continue
                      else
                       if image(y+-1,x+-4) > cb 
                       elseif image(y+-1,x+-4) < c_b 
                        continue
                       else
                        if image(y+4,x+1) > cb 
                         if image(y+1,x+4) > cb 
                         elseif image(y+1,x+4) < c_b 
                          continue
                         else
                          if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+4,x+1) < c_b 
                         continue
                        else
                         if image(y+3,x+2) > cb | image(y+3,x+2) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+2,x+1) < c_b 
                     continue
                    else
                     if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                     else
                      if image(y+-2,x+1) > cb 
                       if image(y+-1,x+-2) > cb 
                       elseif image(y+-1,x+-2) < c_b 
                        if image(y+-3,x+-1) > cb 
                        else
                         continue
                        end
                       else
                        if image(y+-3,x+2) > cb 
                        elseif image(y+-3,x+2) < c_b 
                         continue
                        else
                         if image(y+2,x+-1) > cb 
                          if image(y+2,x+-3) > cb 
                          else
                           continue
                          end
                         elseif image(y+2,x+-1) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      elseif image(y+-2,x+1) < c_b 
                       continue
                      else
                       if image(y+3,x+-2) > cb 
                        if image(y+-3,x+-1) > cb 
                         if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                          continue
                         else
                         end
                        elseif image(y+-3,x+-1) < c_b 
                         continue
                        else
                         if image(y+2,x+-1) > cb 
                         elseif image(y+2,x+-1) < c_b 
                          continue
                         else
                          if image(y+2,x+-3) > cb 
                           if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                            continue
                           else
                            if image(y+4,x+1) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+2,x+-3) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+3,x+-2) < c_b 
                        continue
                       else
                        if image(y+2,x+-1) > cb 
                        elseif image(y+2,x+-1) < c_b 
                         continue
                        else
                         if image(y+-4,x+-1) > cb 
                          if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+-1,x+2) < c_b 
                    continue
                   else
                    if image(y+-1,x+-4) > cb 
                     if image(y+2,x+1) > cb 
                      if image(y+-2,x+0) > cb 
                       if image(y+-2,x+1) > cb 
                       elseif image(y+-2,x+1) < c_b 
                        continue
                       else
                        if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                         continue
                        else
                        end
                       end
                      else
                      end
                     elseif image(y+2,x+1) < c_b 
                      continue
                     else
                      if image(y+-3,x+1) > cb 
                      elseif image(y+-3,x+1) < c_b 
                       continue
                      else
                       if image(y+-3,x+0) < c_b
                        continue
                       else
                        if image(y+-4,x+0) > cb 
                        else
                         continue
                        end
                       end
                      end
                     end
                    elseif image(y+-1,x+-4) < c_b 
                    else
                     if image(y+2,x+1) > cb 
                      if image(y+-2,x+2) > cb 
                       if image(y+4,x+1) > cb 
                       elseif image(y+4,x+1) < c_b 
                        continue
                       else
                        if image(y+-2,x+1) > cb 
                        elseif image(y+-2,x+1) < c_b 
                         continue
                        else
                         if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                          continue
                         else
                          if image(y+0,x+2) > cb | image(y+0,x+2) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       end
                      elseif image(y+-2,x+2) < c_b 
                       continue
                      else
                       if image(y+-3,x+1) > cb 
                        if image(y+-3,x+-1) > cb 
                         if image(y+2,x+-2) > cb 
                          if image(y+-2,x+-2) > cb 
                          elseif image(y+-2,x+-2) < c_b 
                           continue
                          else
                           if image(y+-3,x+0) > cb 
                            if image(y+-2,x+1) > cb 
                            else
                             continue
                            end
                           elseif image(y+-3,x+0) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+2,x+-2) < c_b 
                          continue
                         else
                          if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                           continue
                          else
                           if image(y+2,x+-1) > cb 
                           elseif image(y+2,x+-1) < c_b 
                            continue
                           else
                            if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                             continue
                            else
                            end
                           end
                          end
                         end
                        elseif image(y+-3,x+-1) < c_b 
                         continue
                        else
                         if image(y+2,x+-1) > cb 
                         else
                          continue
                         end
                        end
                       elseif image(y+-3,x+1) < c_b 
                        continue
                       else
                        if image(y+-1,x+3) > cb 
                        elseif image(y+-1,x+3) < c_b 
                         continue
                        else
                         if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                          continue
                         else
                          if image(y+2,x+-1) > cb 
                          elseif image(y+2,x+-1) < c_b 
                           continue
                          else
                           if image(y+-1,x+-3) > cb 
                           else
                            continue
                           end
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+2,x+1) < c_b 
                      continue
                     else
                      if image(y+-2,x+1) > cb 
                       if image(y+-4,x+-1) > cb 
                        if image(y+2,x+-3) > cb 
                         if image(y+0,x+-4) > cb 
                          if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                           continue
                          else
                          end
                         elseif image(y+0,x+-4) < c_b 
                          continue
                         else
                         end
                        else
                         continue
                        end
                       else
                        continue
                       end
                      elseif image(y+-2,x+1) < c_b 
                       continue
                      else
                       if image(y+-2,x+0) > cb 
                       else
                        continue
                       end
                      end
                     end
                    end
                   end
                  end
                 elseif image(y+-2,x+3) < c_b 
                  if image(y+-2,x+2) > cb 
                   continue
                  elseif image(y+-2,x+2) < c_b 
                   if image(y+2,x+2) > cb 
                   else
                    continue
                   end
                  else
                   if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                    continue
                   else
                    if image(y+-4,x+1) > cb 
                    elseif image(y+-4,x+1) < c_b 
                     continue
                    else
                     if image(y+-1,x+-4) > cb 
                     else
                      continue
                     end
                    end
                   end
                  end
                 else
                  if image(y+-1,x+-4) > cb 
                   if image(y+-1,x+2) > cb 
                   elseif image(y+-1,x+2) < c_b 
                    if image(y+-4,x+0) > cb 
                    else
                     continue
                    end
                   else
                    if image(y+2,x+1) > cb 
                     if image(y+0,x+4) > cb 
                      if image(y+0,x+-4) > cb 
                       if image(y+-3,x+0) > cb 
                        if image(y+-1,x+3) > cb 
                        elseif image(y+-1,x+3) < c_b 
                         continue
                        else
                         if image(y+0,x+2) > cb 
                         elseif image(y+0,x+2) < c_b 
                          continue
                         else
                          if image(y+2,x+-1) > cb 
                           if image(y+-1,x+-3) > cb 
                            if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                             continue
                            else
                             if image(y+4,x+0) > cb 
                             else
                              continue
                             end
                            end
                           elseif image(y+-1,x+-3) < c_b 
                            continue
                           else
                           end
                          elseif image(y+2,x+-1) < c_b 
                           continue
                          else
                           if image(y+-3,x+1) > cb 
                           elseif image(y+-3,x+1) < c_b 
                            continue
                           else
                            if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                             continue
                            else
                             if image(y+-1,x+-3) > cb 
                             elseif image(y+-1,x+-3) < c_b 
                              continue
                             else
                              if image(y+2,x+-3) > cb | image(y+2,x+-3) < c_b 
                               continue
                              else
                              end
                             end
                            end
                           end
                          end
                         end
                        end
                       elseif image(y+-3,x+0) < c_b 
                        continue
                       else
                       end
                      elseif image(y+0,x+-4) < c_b 
                       continue
                      else
                       if image(y+-3,x+-1) > cb 
                       elseif image(y+-3,x+-1) < c_b 
                        continue
                       else
                        if image(y+0,x+2) > cb 
                        elseif image(y+0,x+2) < c_b 
                         continue
                        else
                         if image(y+-4,x+-1) > cb 
                          if image(y+2,x+-1) > cb 
                          else
                           continue
                          end
                         elseif image(y+-4,x+-1) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      end
                     elseif image(y+0,x+4) < c_b 
                      continue
                     else
                      if image(y+-3,x+2) > cb 
                       if image(y+1,x+4) > cb 
                        if image(y+0,x+-2) > cb 
                         if image(y+-1,x+-2) > cb 
                         elseif image(y+-1,x+-2) < c_b 
                          continue
                         else
                          if image(y+-1,x+-3) > cb 
                           if image(y+-4,x+-1) > cb 
                            if image(y+-2,x+-2) > cb 
                            elseif image(y+-2,x+-2) < c_b 
                             continue
                            else
                             if image(y+2,x+-1) > cb | image(y+2,x+-1) < c_b 
                              continue
                             else
                             end
                            end
                           elseif image(y+-4,x+-1) < c_b 
                            continue
                           else
                           end
                          else
                           continue
                          end
                         end
                        elseif image(y+0,x+-2) < c_b 
                         continue
                        else
                         if image(y+2,x+-3) > cb 
                          if image(y+3,x+0) > cb 
                          elseif image(y+3,x+0) < c_b 
                           continue
                          else
                           if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+2,x+-3) < c_b 
                          continue
                         else
                          if image(y+2,x+-2) > cb | image(y+2,x+-2) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       elseif image(y+1,x+4) < c_b 
                        continue
                       else
                       end
                      elseif image(y+-3,x+2) < c_b 
                      else
                       if image(y+1,x+3) > cb 
                        if image(y+2,x+-1) > cb 
                         if image(y+2,x+-3) > cb 
                         elseif image(y+2,x+-3) < c_b 
                          continue
                         else
                          if image(y+-4,x+0) > cb 
                          elseif image(y+-4,x+0) < c_b 
                           continue
                          else
                           if image(y+-3,x+-1) > cb 
                           else
                            continue
                           end
                          end
                         end
                        elseif image(y+2,x+-1) < c_b 
                         continue
                        else
                         if image(y+3,x+1) > cb 
                          if image(y+-3,x+0) > cb 
                           if image(y+0,x+-3) > cb 
                            if image(y+0,x+2) > cb 
                            else
                             continue
                            end
                           elseif image(y+0,x+-3) < c_b 
                            continue
                           else
                           end
                          elseif image(y+-3,x+0) < c_b 
                           continue
                          else
                          end
                         else
                          continue
                         end
                        end
                       elseif image(y+1,x+3) < c_b 
                        continue
                       else
                        if image(y+-4,x+0) > cb 
                         if image(y+2,x+-1) > cb 
                         else
                          continue
                         end
                        elseif image(y+-4,x+0) < c_b 
                         continue
                        else
                         if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                          continue
                         else
                          if image(y+4,x+1) > cb 
                          else
                           continue
                          end
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+2,x+1) < c_b 
                     continue
                    else
                     if image(y+1,x+3) > cb 
                      if image(y+-2,x+1) > cb 
                      elseif image(y+-2,x+1) < c_b 
                       continue
                      else
                       if image(y+1,x+4) > cb 
                        if image(y+0,x+-4) > cb 
                         if image(y+3,x+1) > cb 
                          if image(y+0,x+-2) > cb 
                           if image(y+0,x+3) > cb | image(y+0,x+3) < c_b 
                            continue
                           else
                           end
                          elseif image(y+0,x+-2) < c_b 
                           continue
                          else
                           if image(y+-4,x+1) > cb 
                            if image(y+-4,x+-1) > cb 
                             if image(y+-3,x+1) > cb 
                             elseif image(y+-3,x+1) < c_b 
                              continue
                             else
                              if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                               continue
                              else
                              end
                             end
                            else
                             continue
                            end
                           elseif image(y+-4,x+1) < c_b 
                            continue
                           else
                           end
                          end
                         elseif image(y+3,x+1) < c_b 
                          continue
                         else
                          if image(y+-1,x+-2) > cb 
                          elseif image(y+-1,x+-2) < c_b 
                           continue
                          else
                           if image(y+0,x+-2) > cb | image(y+0,x+-2) < c_b 
                            continue
                           else
                            if image(y+1,x+-2) > cb 
                            elseif image(y+1,x+-2) < c_b 
                             continue
                            else
                             if image(y+3,x+0) > cb | image(y+3,x+0) < c_b 
                              continue
                             else
                              if image(y+3,x+2) > cb 
                              elseif image(y+3,x+2) < c_b 
                               continue
                              else
                               if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                                continue
                               else
                                if image(y+-4,x+-1) > cb 
                                elseif image(y+-4,x+-1) < c_b 
                                 continue
                                else
                                 if image(y+0,x+2) > cb 
                                 else
                                  continue
                                 end
                                end
                               end
                              end
                             end
                            end
                           end
                          end
                         end
                        else
                         continue
                        end
                       elseif image(y+1,x+4) < c_b 
                        continue
                       else
                       end
                      end
                     elseif image(y+1,x+3) < c_b 
                      continue
                     else
                      if image(y+1,x+-2) > cb 
                       if image(y+3,x+0) > cb | image(y+3,x+0) < c_b 
                        continue
                       else
                       end
                      else
                       continue
                      end
                     end
                    end
                   end
                  elseif image(y+-1,x+-4) < c_b 
                   if image(y+-3,x+2) > cb 
                    if image(y+1,x+4) > cb 
                     if image(y+4,x+1) < c_b
                      continue
                     else
                      if image(y+3,x+1) > cb 
                      else
                       continue
                      end
                     end
                    else
                    end
                   elseif image(y+-3,x+2) < c_b 
                   else
                    if image(y+-3,x+-1) > cb 
                    elseif image(y+-3,x+-1) < c_b 
                     continue
                    else
                     if image(y+-4,x+-1) > cb 
                      if image(y+-1,x+-2) > cb | image(y+-1,x+-2) < c_b 
                       continue
                      else
                      end
                     else
                      continue
                     end
                    end
                   end
                  else
                   if image(y+-1,x+3) > cb 
                    if image(y+2,x+-1) > cb 
                     if image(y+2,x+1) > cb 
                      if image(y+-3,x+2) > cb 
                       if image(y+-1,x+2) > cb 
                       elseif image(y+-1,x+2) < c_b 
                        continue
                       else
                        if image(y+-4,x+0) > cb 
                         if image(y+0,x+2) > cb 
                          if image(y+-2,x+2) > cb 
                          else
                           continue
                          end
                         elseif image(y+0,x+2) < c_b 
                          continue
                         else
                          if image(y+1,x+-2) > cb 
                          elseif image(y+1,x+-2) < c_b 
                           continue
                          else
                           if image(y+-2,x+0) > cb 
                           else
                            continue
                           end
                          end
                         end
                        elseif image(y+-4,x+0) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+-3,x+2) < c_b 
                       if image(y+0,x+-2) > cb 
                       elseif image(y+0,x+-2) < c_b 
                        continue
                       else
                        if image(y+-3,x+1) > cb 
                         continue
                        elseif image(y+-3,x+1) < c_b 
                         if image(y+-1,x+-3) > cb 
                         else
                          continue
                         end
                        else
                        end
                       end
                      else
                       if image(y+0,x+4) > cb 
                       elseif image(y+0,x+4) < c_b 
                        continue
                       else
                        if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     elseif image(y+2,x+1) < c_b 
                      continue
                     else
                      if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                      else
                       if image(y+0,x+-2) > cb 
                       elseif image(y+0,x+-2) < c_b 
                        continue
                       else
                        if image(y+-2,x+2) > cb 
                        else
                         continue
                        end
                       end
                      end
                     end
                    elseif image(y+2,x+-1) < c_b 
                     continue
                    else
                     if image(y+-2,x+1) > cb 
                     elseif image(y+-2,x+1) < c_b 
                      continue
                     else
                      if image(y+-3,x+1) > cb 
                       if image(y+-1,x+2) > cb 
                        if image(y+3,x+1) > cb 
                        elseif image(y+3,x+1) < c_b 
                         continue
                        else
                         if image(y+-4,x+0) > cb 
                          if image(y+0,x+-4) > cb 
                          else
                           continue
                          end
                         else
                          continue
                         end
                        end
                       else
                        continue
                       end
                      elseif image(y+-3,x+1) < c_b 
                       continue
                      else
                       if image(y+2,x+1) > cb 
                       elseif image(y+2,x+1) < c_b 
                        continue
                       else
                        if image(y+2,x+-2) > cb 
                         if image(y+-3,x+-1) > cb 
                          if image(y+0,x+2) > cb 
                          else
                           continue
                          end
                         else
                          continue
                         end
                        else
                         continue
                        end
                       end
                      end
                     end
                    end
                   elseif image(y+-1,x+3) < c_b 
                    if image(y+1,x+4) > cb 
                     if image(y+-3,x+1) > cb 
                      if image(y+-3,x+2) > cb 
                       if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                        continue
                       else
                        if image(y+-1,x+-2) > cb | image(y+-1,x+-2) < c_b 
                         continue
                        else
                        end
                       end
                      elseif image(y+-3,x+2) < c_b 
                       continue
                      else
                      end
                     elseif image(y+-3,x+1) < c_b 
                      continue
                     else
                      if image(y+-4,x+1) > cb 
                      elseif image(y+-4,x+1) < c_b 
                       continue
                      else
                       if image(y+-3,x+2) > cb 
                       elseif image(y+-3,x+2) < c_b 
                        continue
                       else
                        if image(y+-1,x+2) < c_b
                         if image(y+0,x+-3) > cb | image(y+0,x+-3) < c_b 
                          continue
                         else
                         end
                        else
                         continue
                        end
                       end
                      end
                     end
                    elseif image(y+1,x+4) < c_b 
                     continue
                    else
                     if image(y+-4,x+1) > cb 
                     else
                      continue
                     end
                    end
                   else
                    if image(y+1,x+4) > cb 
                     if image(y+-3,x+2) > cb 
                      if image(y+-3,x+-1) > cb 
                       if image(y+-2,x+1) > cb 
                        if image(y+2,x+2) > cb 
                        else
                         continue
                        end
                       elseif image(y+-2,x+1) < c_b 
                        continue
                       else
                        if image(y+-3,x+1) > cb 
                         if image(y+-1,x+4) > cb 
                          if image(y+1,x+-2) > cb 
                           if image(y+0,x+2) < c_b
                            continue
                           else
                            if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                             continue
                            else
                            end
                           end
                          elseif image(y+1,x+-2) < c_b 
                           continue
                          else
                           if image(y+-2,x+-2) > cb 
                           else
                            continue
                           end
                          end
                         elseif image(y+-1,x+4) < c_b 
                          if image(y+-2,x+-2) > cb 
                           if image(y+-4,x+-1) > cb 
                           else
                            continue
                           end
                          else
                           continue
                          end
                         else
                          if image(y+-2,x+-2) > cb 
                           if image(y+4,x+-1) > cb 
                           elseif image(y+4,x+-1) < c_b 
                            continue
                           else
                            if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                             continue
                            else
                             if image(y+2,x+1) > cb 
                             else
                              continue
                             end
                            end
                           end
                          elseif image(y+-2,x+-2) < c_b 
                           continue
                          else
                           if image(y+-2,x+2) > cb 
                            if image(y+4,x+0) > cb 
                            else
                             continue
                            end
                           elseif image(y+-2,x+2) < c_b 
                            continue
                           else
                            if image(y+0,x+-2) > cb 
                             if image(y+4,x+0) > cb | image(y+4,x+0) < c_b 
                              continue
                             else
                             end
                            elseif image(y+0,x+-2) < c_b 
                             continue
                            else
                             if image(y+-1,x+2) > cb 
                             elseif image(y+-1,x+2) < c_b 
                              continue
                             else
                              if image(y+2,x+2) > cb 
                               if image(y+2,x+-2) > cb | image(y+2,x+-2) < c_b 
                                continue
                               else
                                if image(y+1,x+-2) > cb 
                                else
                                 continue
                                end
                               end
                              elseif image(y+2,x+2) < c_b 
                               continue
                              else
                               if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                                continue
                               else
                               end
                              end
                             end
                            end
                           end
                          end
                         end
                        elseif image(y+-3,x+1) < c_b 
                         continue
                        else
                         if image(y+0,x+4) > cb 
                          if image(y+0,x+-4) > cb 
                          elseif image(y+0,x+-4) < c_b 
                           continue
                          else
                           if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                            continue
                           else
                            if image(y+-3,x+0) > cb 
                            else
                             continue
                            end
                           end
                          end
                         elseif image(y+0,x+4) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      elseif image(y+-3,x+-1) < c_b 
                       continue
                      else
                       if image(y+2,x+-2) > cb 
                        if image(y+2,x+2) > cb 
                         if image(y+0,x+-4) > cb 
                          if image(y+2,x+-1) > cb 
                           if image(y+0,x+-3) > cb 
                           elseif image(y+0,x+-3) < c_b 
                            continue
                           else
                            if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                             continue
                            else
                            end
                           end
                          else
                           continue
                          end
                         elseif image(y+0,x+-4) < c_b 
                          continue
                         else
                         end
                        else
                         continue
                        end
                       elseif image(y+2,x+-2) < c_b 
                        continue
                       else
                        if image(y+-1,x+-2) > cb | image(y+-1,x+-2) < c_b 
                        else
                         continue
                        end
                       end
                      end
                     elseif image(y+-3,x+2) < c_b 
                      if image(y+2,x+0) > cb 
                      else
                       continue
                      end
                     else
                      if image(y+-4,x+1) > cb 
                       if image(y+2,x+-1) > cb 
                        if image(y+-4,x+-1) > cb 
                        elseif image(y+-4,x+-1) < c_b 
                         continue
                        else
                         if image(y+0,x+3) > cb 
                          if image(y+-3,x+0) > cb 
                           if image(y+-2,x+-2) > cb 
                           elseif image(y+-2,x+-2) < c_b 
                            continue
                           else
                            if image(y+-1,x+2) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+-3,x+0) < c_b 
                           continue
                          else
                          end
                         elseif image(y+0,x+3) < c_b 
                          continue
                         else
                          if image(y+0,x+4) > cb 
                          else
                           continue
                          end
                         end
                        end
                       elseif image(y+2,x+-1) < c_b 
                        continue
                       else
                        if image(y+0,x+3) > cb 
                         if image(y+-3,x+0) > cb 
                          if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                           continue
                          else
                          end
                         elseif image(y+-3,x+0) < c_b 
                          continue
                         else
                          if image(y+2,x+-2) > cb 
                          elseif image(y+2,x+-2) < c_b 
                           continue
                          else
                           if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        else
                         continue
                        end
                       end
                      elseif image(y+-4,x+1) < c_b 
                       continue
                      else
                       if image(y+0,x+-2) > cb 
                        if image(y+2,x+0) > cb 
                        elseif image(y+2,x+0) < c_b 
                         continue
                        else
                         if image(y+-3,x+-1) > cb 
                          if image(y+-4,x+-1) > cb 
                          else
                           continue
                          end
                         elseif image(y+-3,x+-1) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+0,x+-2) < c_b 
                       else
                        if image(y+1,x+-2) > cb 
                         if image(y+0,x+4) > cb 
                          if image(y+4,x+0) > cb 
                           if image(y+2,x+0) > cb 
                            if image(y+-3,x+1) > cb 
                             if image(y+-4,x+-1) > cb 
                             else
                              continue
                             end
                            elseif image(y+-3,x+1) < c_b 
                             continue
                            else
                            end
                           elseif image(y+2,x+0) < c_b 
                            continue
                           else
                            if image(y+-1,x+-2) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+4,x+0) < c_b 
                           continue
                          else
                           if image(y+0,x+-3) > cb 
                           elseif image(y+0,x+-3) < c_b 
                            continue
                           else
                            if image(y+2,x+0) > cb 
                             if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                              continue
                             else
                              if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                               continue
                              else
                               if image(y+0,x+2) > cb 
                               else
                                continue
                               end
                              end
                             end
                            elseif image(y+2,x+0) < c_b 
                             continue
                            else
                             if image(y+-1,x+4) > cb 
                             else
                              continue
                             end
                            end
                           end
                          end
                         elseif image(y+0,x+4) < c_b 
                          continue
                         else
                          if image(y+-2,x+1) > cb | image(y+-2,x+1) < c_b 
                          else
                           if image(y+-1,x+4) > cb 
                           elseif image(y+-1,x+4) < c_b 
                            continue
                           else
                            if image(y+0,x+3) > cb 
                             if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                              continue
                             else
                             end
                            elseif image(y+0,x+3) < c_b 
                             continue
                            else
                             if image(y+0,x+2) < c_b
                              continue
                             else
                              if image(y+-2,x+2) > cb 
                              else
                               continue
                              end
                             end
                            end
                           end
                          end
                         end
                        elseif image(y+1,x+-2) < c_b 
                         continue
                        else
                         if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
                         else
                          if image(y+-1,x+2) > cb 
                          elseif image(y+-1,x+2) < c_b 
                           continue
                          else
                           if image(y+-1,x+-2) > cb 
                            if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                             continue
                            else
                            end
                           elseif image(y+-1,x+-2) < c_b 
                            continue
                           else
                            if image(y+-2,x+1) > cb 
                             if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                              continue
                             else
                             end
                            elseif image(y+-2,x+1) < c_b 
                             continue
                            else
                             if image(y+2,x+-1) > cb 
                              if image(y+-2,x+0) > cb 
                               if image(y+-4,x+-1) > cb 
                               else
                                continue
                               end
                              elseif image(y+-2,x+0) < c_b 
                               continue
                              else
                               if image(y+0,x+3) > cb 
                                if image(y+0,x+4) > cb 
                                 if image(y+2,x+2) > cb | image(y+2,x+2) < c_b 
                                  continue
                                 else
                                  if image(y+3,x+0) > cb | image(y+3,x+0) < c_b 
                                   continue
                                  else
                                  end
                                 end
                                elseif image(y+0,x+4) < c_b 
                                 continue
                                else
                                 if image(y+-4,x+-1) > cb 
                                 else
                                  continue
                                 end
                                end
                               else
                                continue
                               end
                              end
                             else
                              continue
                             end
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+1,x+4) < c_b 
                    else
                     if image(y+1,x+-2) > cb 
                      if image(y+-4,x+1) > cb 
                      elseif image(y+-4,x+1) < c_b 
                       if image(y+-4,x+-1) > cb 
                       else
                        continue
                       end
                      else
                       if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                       else
                        if image(y+0,x+-2) > cb 
                         if image(y+-3,x+1) > cb 
                          if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                           continue
                          else
                          end
                         else
                         end
                        elseif image(y+0,x+-2) < c_b 
                         continue
                        else
                         if image(y+0,x+2) > cb 
                         elseif image(y+0,x+2) < c_b 
                          continue
                         else
                          if image(y+0,x+4) > cb 
                           if image(y+0,x+-3) > cb | image(y+0,x+-3) < c_b 
                            continue
                           else
                           end
                          elseif image(y+0,x+4) < c_b 
                          else
                           if image(y+-2,x+0) > cb 
                           elseif image(y+-2,x+0) < c_b 
                            continue
                           else
                            if image(y+-1,x+-2) > cb 
                            elseif image(y+-1,x+-2) < c_b 
                             continue
                            else
                             if image(y+-2,x+1) > cb 
                             else
                              continue
                             end
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+1,x+-2) < c_b 
                      if image(y+-3,x+2) > cb 
                      else
                       continue
                      end
                     else
                      if image(y+-2,x+2) > cb 
                      elseif image(y+-2,x+2) < c_b 
                       continue
                      else
                       if image(y+-3,x+2) > cb 
                        if image(y+-3,x+1) > cb 
                         if image(y+-2,x+1) > cb 
                         elseif image(y+-2,x+1) < c_b 
                          continue
                         else
                          if image(y+0,x+2) > cb 
                           if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                            continue
                           else
                           end
                          else
                           continue
                          end
                         end
                        elseif image(y+-3,x+1) < c_b 
                         continue
                        else
                        end
                       elseif image(y+-3,x+2) < c_b 
                        if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                         continue
                        else
                        end
                       else
                        if image(y+-4,x+1) > cb 
                         if image(y+2,x+-1) > cb 
                         elseif image(y+2,x+-1) < c_b 
                          continue
                         else
                          if image(y+-1,x+-2) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+-4,x+1) < c_b 
                         continue
                        else
                         if image(y+0,x+3) > cb 
                          if image(y+0,x+-2) > cb | image(y+0,x+-2) < c_b 
                           continue
                          else
                          end
                         elseif image(y+0,x+3) < c_b 
                          continue
                         else
                          if image(y+-1,x+-2) > cb 
                          elseif image(y+-1,x+-2) < c_b 
                           continue
                          else
                           if image(y+2,x+-2) > cb | image(y+2,x+-2) < c_b 
                            continue
                           else
                            if image(y+-3,x+-1) > cb 
                             if image(y+0,x+4) > cb 
                             else
                              continue
                             end
                            elseif image(y+-3,x+-1) < c_b 
                             continue
                            else
                            end
                           end
                          end
                         end
                        end
                       end
                      end
                     end
                    end
                   end
                  end
                 end
                end
               elseif image(y+1,x+-4) < c_b 
                if image(y+-1,x+3) > cb 
                 if image(y+-3,x+2) > cb 
                  if image(y+-2,x+2) > cb 
                   if image(y+4,x+1) > cb 
                    if image(y+2,x+1) > cb 
                    elseif image(y+2,x+1) < c_b 
                     continue
                    else
                     if image(y+-2,x+-2) > cb 
                     else
                      continue
                     end
                    end
                   elseif image(y+4,x+1) < c_b 
                    continue
                   else
                    if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                     continue
                    else
                     if image(y+-1,x+-4) > cb 
                      continue
                     elseif image(y+-1,x+-4) < c_b 
                      if image(y+-2,x+-2) > cb 
                       if image(y+-3,x+1) > cb 
                       elseif image(y+-3,x+1) < c_b 
                        continue
                       else
                        if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                         continue
                        else
                         if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      elseif image(y+-2,x+-2) < c_b 
                       continue
                      else
                      end
                     else
                     end
                    end
                   end
                  elseif image(y+-2,x+2) < c_b 
                   continue
                  else
                   if image(y+2,x+-1) > cb 
                    if image(y+2,x+-3) > cb | image(y+2,x+-3) < c_b 
                     continue
                    else
                    end
                   else
                    continue
                   end
                  end
                 elseif image(y+-3,x+2) < c_b 
                 else
                  if image(y+3,x+0) > cb 
                  elseif image(y+3,x+0) < c_b 
                   continue
                  else
                   if image(y+0,x+-2) > cb | image(y+0,x+-2) < c_b 
                   else
                    if image(y+-3,x+-1) > cb 
                    else
                     continue
                    end
                   end
                  end
                 end
                elseif image(y+-1,x+3) < c_b 
                 if image(y+-2,x+0) > cb 
                  continue
                 else
                 end
                else
                 if image(y+2,x+-1) > cb 
                  if image(y+-2,x+-3) > cb 
                   if image(y+-4,x+0) > cb 
                   elseif image(y+-4,x+0) < c_b 
                    continue
                   else
                    if image(y+0,x+-2) < c_b
                     if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                     else
                      continue
                     end
                    else
                    end
                   end
                  elseif image(y+-2,x+-3) < c_b 
                   continue
                  else
                   if image(y+0,x+-4) > cb 
                    continue
                   elseif image(y+0,x+-4) < c_b 
                    if image(y+0,x+4) > cb | image(y+0,x+4) < c_b 
                    else
                     if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                     else
                      if image(y+1,x+-2) > cb 
                      elseif image(y+1,x+-2) < c_b 
                       continue
                      else
                       if image(y+-4,x+-1) > cb 
                        if image(y+2,x+-2) > cb 
                         if image(y+-2,x+1) > cb 
                         else
                          continue
                         end
                        elseif image(y+2,x+-2) < c_b 
                         continue
                        else
                        end
                       else
                        continue
                       end
                      end
                     end
                    end
                   else
                    if image(y+-3,x+2) > cb 
                     if image(y+-2,x+2) > cb 
                     else
                      continue
                     end
                    elseif image(y+-3,x+2) < c_b 
                     if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                      continue
                     else
                      if image(y+3,x+1) > cb 
                      else
                       continue
                      end
                     end
                    else
                     if image(y+2,x+1) > cb 
                      if image(y+0,x+-2) > cb 
                       continue
                      elseif image(y+0,x+-2) < c_b 
                       if image(y+-3,x+-1) > cb 
                       else
                        continue
                       end
                      else
                      end
                     else
                      continue
                     end
                    end
                   end
                  end
                 elseif image(y+2,x+-1) < c_b 
                  continue
                 else
                  if image(y+0,x+-2) > cb 
                   continue
                  elseif image(y+0,x+-2) < c_b 
                   if image(y+-2,x+2) > cb 
                    if image(y+-1,x+4) > cb 
                     continue
                    elseif image(y+-1,x+4) < c_b 
                    else
                     if image(y+-2,x+-3) > cb 
                     else
                      continue
                     end
                    end
                   elseif image(y+-2,x+2) < c_b 
                   else
                    if image(y+3,x+0) > cb 
                     if image(y+-2,x+3) < c_b
                     else
                      continue
                     end
                    elseif image(y+3,x+0) < c_b 
                     continue
                    else
                     if image(y+-4,x+-1) > cb 
                     else
                      continue
                     end
                    end
                   end
                  else
                   if image(y+-3,x+1) > cb 
                    if image(y+-2,x+-3) > cb 
                    else
                     continue
                    end
                   elseif image(y+-3,x+1) < c_b 
                    if image(y+-4,x+-1) > cb 
                     if image(y+-3,x+2) > cb | image(y+-3,x+2) < c_b 
                      continue
                     else
                     end
                    elseif image(y+-4,x+-1) < c_b 
                     continue
                    else
                    end
                   else
                    if image(y+2,x+1) > cb 
                    elseif image(y+2,x+1) < c_b 
                     continue
                    else
                     if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                      continue
                     else
                     end
                    end
                   end
                  end
                 end
                end
               else
                if image(y+1,x+4) > cb 
                 if image(y+1,x+-3) > cb 
                  if image(y+2,x+-2) > cb 
                   if image(y+-2,x+-2) > cb 
                   elseif image(y+-2,x+-2) < c_b 
                    continue
                   else
                    if image(y+-2,x+-3) > cb 
                     if image(y+4,x+1) > cb | image(y+4,x+1) < c_b 
                     else
                      if image(y+-3,x+2) > cb 
                       if image(y+0,x+3) > cb 
                       elseif image(y+0,x+3) < c_b 
                        continue
                       else
                        if image(y+2,x+2) > cb 
                        else
                         continue
                        end
                       end
                      elseif image(y+-3,x+2) < c_b 
                       continue
                      else
                       if image(y+3,x+2) > cb 
                        if image(y+-3,x+-1) > cb 
                        elseif image(y+-3,x+-1) < c_b 
                         continue
                        else
                         if image(y+0,x+-2) > cb 
                         elseif image(y+0,x+-2) < c_b 
                          continue
                         else
                          if image(y+0,x+2) > cb 
                           if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
                            continue
                           else
                           end
                          elseif image(y+0,x+2) < c_b 
                           continue
                          else
                           if image(y+2,x+1) > cb 
                            if image(y+-1,x+3) > cb 
                            else
                             continue
                            end
                           elseif image(y+2,x+1) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        end
                       elseif image(y+3,x+2) < c_b 
                        continue
                       else
                        if image(y+0,x+-3) > cb 
                        elseif image(y+0,x+-3) < c_b 
                         continue
                        else
                         if image(y+-1,x+3) > cb 
                          if image(y+2,x+2) > cb 
                           if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                            continue
                           else
                            if image(y+-1,x+-3) > cb | image(y+-1,x+-3) < c_b 
                             continue
                            else
                            end
                           end
                          elseif image(y+2,x+2) < c_b 
                           continue
                          else
                          end
                         else
                         end
                        end
                       end
                      end
                     end
                    elseif image(y+-2,x+-3) < c_b 
                     continue
                    else
                    end
                   end
                  elseif image(y+2,x+-2) < c_b 
                   continue
                  else
                   if image(y+-2,x+-3) > cb 
                    if image(y+-1,x+-2) > cb 
                     if image(y+-1,x+2) > cb 
                     elseif image(y+-1,x+2) < c_b 
                      continue
                     else
                      if image(y+2,x+0) > cb 
                      elseif image(y+2,x+0) < c_b 
                       continue
                      else
                       if image(y+3,x+-2) > cb 
                        if image(y+-2,x+-2) > cb 
                         if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                          continue
                         else
                          if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                           continue
                          else
                          end
                         end
                        elseif image(y+-2,x+-2) < c_b 
                         continue
                        else
                        end
                       elseif image(y+3,x+-2) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    elseif image(y+-1,x+-2) < c_b 
                     continue
                    else
                     if image(y+0,x+2) > cb 
                      if image(y+4,x+1) > cb 
                       if image(y+-3,x+1) > cb 
                       elseif image(y+-3,x+1) < c_b 
                        continue
                       else
                        if image(y+-4,x+-1) > cb 
                        elseif image(y+-4,x+-1) < c_b 
                         continue
                        else
                         if image(y+-4,x+1) > cb 
                          continue
                         elseif image(y+-4,x+1) < c_b 
                         else
                          if image(y+-3,x+2) > cb 
                          else
                           continue
                          end
                         end
                        end
                       end
                      elseif image(y+4,x+1) < c_b 
                       continue
                      else
                       if image(y+-3,x+1) > cb 
                        if image(y+-2,x+2) > cb 
                        else
                         continue
                        end
                       else
                        continue
                       end
                      end
                     elseif image(y+0,x+2) < c_b 
                      continue
                     else
                      if image(y+-4,x+1) > cb 
                       if image(y+0,x+-3) > cb 
                       else
                        continue
                       end
                      else
                       continue
                      end
                     end
                    end
                   elseif image(y+-2,x+-3) < c_b 
                    continue
                   else
                   end
                  end
                 elseif image(y+1,x+-3) < c_b 
                  if image(y+-1,x+3) > cb 
                   if image(y+-3,x+1) > cb 
                    if image(y+-2,x+1) > cb 
                    elseif image(y+-2,x+1) < c_b 
                     continue
                    else
                     if image(y+-2,x+-3) > cb 
                      if image(y+-2,x+2) > cb 
                       if image(y+-2,x+-2) > cb 
                       else
                        continue
                       end
                      else
                       continue
                      end
                     elseif image(y+-2,x+-3) < c_b 
                      continue
                     else
                     end
                    end
                   elseif image(y+-3,x+1) < c_b 
                   else
                    if image(y+2,x+1) > cb 
                    elseif image(y+2,x+1) < c_b 
                     continue
                    else
                     if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                      continue
                     else
                     end
                    end
                   end
                  elseif image(y+-1,x+3) < c_b 
                  else
                   if image(y+-2,x+-3) > cb 
                    if image(y+-4,x+1) > cb 
                     if image(y+2,x+-1) > cb 
                     elseif image(y+2,x+-1) < c_b 
                      continue
                     else
                      if image(y+-3,x+0) > cb 
                      else
                       continue
                      end
                     end
                    elseif image(y+-4,x+1) < c_b 
                    else
                     if image(y+-2,x+0) > cb 
                      continue
                     elseif image(y+-2,x+0) < c_b 
                     else
                      if image(y+-3,x+2) > cb 
                      else
                       continue
                      end
                     end
                    end
                   elseif image(y+-2,x+-3) < c_b 
                    continue
                   else
                   end
                  end
                 else
                  if image(y+4,x+1) > cb 
                  elseif image(y+4,x+1) < c_b 
                   if image(y+-4,x+-1) > cb 
                   elseif image(y+-4,x+-1) < c_b 
                    continue
                   else
                    if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                     continue
                    else
                    end
                   end
                  else
                   if image(y+-2,x+-3) > cb 
                    if image(y+-2,x+-2) > cb 
                    elseif image(y+-2,x+-2) < c_b 
                     continue
                    else
                     if image(y+2,x+-2) > cb 
                      if image(y+-4,x+1) > cb 
                       if image(y+2,x+2) > cb 
                        if image(y+-4,x+-1) > cb 
                        elseif image(y+-4,x+-1) < c_b 
                         continue
                        else
                         if image(y+-3,x+1) > cb 
                         elseif image(y+-3,x+1) < c_b 
                          continue
                         else
                          if image(y+-2,x+3) > cb 
                          elseif image(y+-2,x+3) < c_b 
                           continue
                          else
                           if image(y+-3,x+-1) > cb 
                           elseif image(y+-3,x+-1) < c_b 
                            continue
                           else
                            if image(y+-3,x+0) > cb 
                            else
                             continue
                            end
                           end
                          end
                         end
                        end
                       elseif image(y+2,x+2) < c_b 
                        continue
                       else
                        if image(y+0,x+2) > cb 
                         if image(y+3,x+-2) > cb 
                         else
                          continue
                         end
                        elseif image(y+0,x+2) < c_b 
                         continue
                        else
                         if image(y+-1,x+-4) > cb 
                          if image(y+-3,x+2) > cb 
                          else
                           continue
                          end
                         else
                          continue
                         end
                        end
                       end
                      elseif image(y+-4,x+1) < c_b 
                      else
                       if image(y+-1,x+3) > cb 
                        if image(y+-3,x+1) > cb 
                         continue
                        elseif image(y+-3,x+1) < c_b 
                        else
                         if image(y+4,x+0) > cb 
                          if image(y+3,x+2) > cb 
                           if image(y+-3,x+2) > cb 
                           elseif image(y+-3,x+2) < c_b 
                            continue
                           else
                            if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                             continue
                            else
                             if image(y+-1,x+-3) > cb 
                              if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
                               continue
                              else
                              end
                             elseif image(y+-1,x+-3) < c_b 
                              continue
                             else
                             end
                            end
                           end
                          elseif image(y+3,x+2) < c_b 
                           continue
                          else
                          end
                         elseif image(y+4,x+0) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+-1,x+3) < c_b 
                       else
                        if image(y+-3,x+-1) > cb 
                        elseif image(y+-3,x+-1) < c_b 
                         continue
                        else
                         if image(y+-2,x+2) > cb | image(y+-2,x+2) < c_b 
                         else
                          if image(y+2,x+-1) > cb 
                           if image(y+-2,x+0) > cb 
                           elseif image(y+-2,x+0) < c_b 
                            continue
                           else
                            if image(y+-2,x+3) > cb 
                            else
                             continue
                            end
                           end
                          elseif image(y+2,x+-1) < c_b 
                           continue
                          else
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+2,x+-2) < c_b 
                      continue
                     else
                     end
                    end
                   elseif image(y+-2,x+-3) < c_b 
                    continue
                   else
                   end
                  end
                 end
                elseif image(y+1,x+4) < c_b 
                else
                 if image(y+-2,x+-3) > cb 
                  if image(y+2,x+-2) > cb 
                   if image(y+-2,x+2) > cb 
                    if image(y+-4,x+-1) > cb 
                     if image(y+-4,x+1) > cb 
                      if image(y+-2,x+-2) > cb 
                      elseif image(y+-2,x+-2) < c_b 
                       continue
                      else
                       if image(y+4,x+0) > cb 
                       elseif image(y+4,x+0) < c_b 
                        continue
                       else
                        if image(y+4,x+1) > cb 
                         if image(y+-3,x+-1) > cb | image(y+-3,x+-1) < c_b 
                          continue
                         else
                         end
                        elseif image(y+4,x+1) < c_b 
                         continue
                        else
                        end
                       end
                      end
                     elseif image(y+-4,x+1) < c_b 
                      continue
                     else
                      if image(y+2,x+-3) > cb 
                       if image(y+-4,x+0) > cb 
                        if image(y+-2,x+1) > cb 
                        else
                         continue
                        end
                       elseif image(y+-4,x+0) < c_b 
                        continue
                       else
                       end
                      elseif image(y+2,x+-3) < c_b 
                       continue
                      else
                       if image(y+-1,x+-4) > cb 
                       else
                        continue
                       end
                      end
                     end
                    else
                    end
                   elseif image(y+-2,x+2) < c_b 
                   else
                    if image(y+4,x+1) > cb 
                     if image(y+-1,x+-2) > cb 
                      if image(y+2,x+-1) > cb 
                       if image(y+-4,x+1) > cb 
                       elseif image(y+-4,x+1) < c_b 
                        if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                         continue
                        else
                        end
                       else
                        if image(y+2,x+0) > cb 
                        elseif image(y+2,x+0) < c_b 
                         continue
                        else
                         if image(y+0,x+2) > cb 
                         elseif image(y+0,x+2) < c_b 
                          continue
                         else
                          if image(y+-1,x+-3) > cb 
                           if image(y+1,x+3) > cb | image(y+1,x+3) < c_b 
                            continue
                           else
                           end
                          else
                           continue
                          end
                         end
                        end
                       end
                      elseif image(y+2,x+-1) < c_b 
                       continue
                      else
                       if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                        continue
                       else
                        if image(y+-4,x+1) > cb 
                        elseif image(y+-4,x+1) < c_b 
                         continue
                        else
                         if image(y+1,x+-3) > cb 
                         elseif image(y+1,x+-3) < c_b 
                          continue
                         else
                          if image(y+2,x+0) > cb 
                          elseif image(y+2,x+0) < c_b 
                           continue
                          else
                           if image(y+-1,x+2) > cb 
                           else
                            continue
                           end
                          end
                         end
                        end
                       end
                      end
                     elseif image(y+-1,x+-2) < c_b 
                      continue
                     else
                      if image(y+-4,x+1) > cb 
                       if image(y+-3,x+2) > cb 
                        if image(y+1,x+-2) > cb 
                         if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                          continue
                         else
                         end
                        elseif image(y+1,x+-2) < c_b 
                         continue
                        else
                         if image(y+-1,x+3) > cb 
                         elseif image(y+-1,x+3) < c_b 
                          continue
                         else
                          if image(y+-2,x+1) > cb 
                          else
                           continue
                          end
                         end
                        end
                       elseif image(y+-3,x+2) < c_b 
                        continue
                       else
                        if image(y+-4,x+-1) > cb 
                         if image(y+2,x+-1) > cb 
                         elseif image(y+2,x+-1) < c_b 
                          continue
                         else
                          if image(y+-3,x+1) > cb 
                          else
                           continue
                          end
                         end
                        elseif image(y+-4,x+-1) < c_b 
                         continue
                        else
                         if image(y+-3,x+1) > cb 
                         else
                          continue
                         end
                        end
                       end
                      elseif image(y+-4,x+1) < c_b 
                       continue
                      else
                       if image(y+-1,x+3) > cb 
                        if image(y+-3,x+1) > cb | image(y+-3,x+1) < c_b 
                         continue
                        else
                         if image(y+0,x+-4) > cb | image(y+0,x+-4) < c_b 
                          continue
                         else
                         end
                        end
                       elseif image(y+-1,x+3) < c_b 
                        continue
                       else
                        if image(y+2,x+-3) > cb 
                         if image(y+-1,x+2) > cb 
                         elseif image(y+-1,x+2) < c_b 
                          continue
                         else
                          if image(y+0,x+-2) > cb 
                          elseif image(y+0,x+-2) < c_b 
                           continue
                          else
                           if image(y+-2,x+1) > cb 
                           elseif image(y+-2,x+1) < c_b 
                            continue
                           else
                            if image(y+-2,x+3) > cb 
                             if image(y+-4,x+-1) > cb | image(y+-4,x+-1) < c_b 
                              continue
                             else
                             end
                            elseif image(y+-2,x+3) < c_b 
                             continue
                            else
                             if image(y+-3,x+1) > cb 
                              if image(y+1,x+-2) > cb 
                              else
                               continue
                              end
                             else
                              continue
                             end
                            end
                           end
                          end
                         end
                        else
                         continue
                        end
                       end
                      end
                     end
                    elseif image(y+4,x+1) < c_b 
                    else
                     if image(y+-2,x+-2) > cb 
                     elseif image(y+-2,x+-2) < c_b 
                      continue
                     else
                      if image(y+-3,x+-1) > cb 
                      elseif image(y+-3,x+-1) < c_b 
                       continue
                      else
                       if image(y+2,x+-1) > cb 
                        if image(y+4,x+0) > cb 
                        elseif image(y+4,x+0) < c_b 
                         continue
                        else
                         if image(y+-4,x+0) > cb 
                          if image(y+-4,x+-1) > cb 
                          elseif image(y+-4,x+-1) < c_b 
                           continue
                          else
                           if image(y+-3,x+0) > cb 
                           elseif image(y+-3,x+0) < c_b 
                            continue
                           else
                            if image(y+1,x+-2) > cb 
                            else
                             continue
                            end
                           end
                          end
                         elseif image(y+-4,x+0) < c_b 
                          continue
                         else
                          if image(y+-1,x+2) > cb 
                          elseif image(y+-1,x+2) < c_b 
                           continue
                          else
                           if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                            continue
                           else
                           end
                          end
                         end
                        end
                       elseif image(y+2,x+-1) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    end
                   end
                  elseif image(y+2,x+-2) < c_b 
                  else
                   if image(y+1,x+-3) > cb 
                    if image(y+-2,x+3) > cb 
                    elseif image(y+-2,x+3) < c_b 
                     continue
                    else
                     if image(y+1,x+-2) > cb 
                      if image(y+-2,x+-2) > cb 
                      else
                       continue
                      end
                     else
                      continue
                     end
                    end
                   elseif image(y+1,x+-3) < c_b 
                    if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                    else
                     if image(y+1,x+-2) > cb 
                      continue
                     elseif image(y+1,x+-2) < c_b 
                     else
                      if image(y+2,x+-1) > cb 
                       if image(y+-4,x+-1) > cb 
                       elseif image(y+-4,x+-1) < c_b 
                        continue
                       else
                        if image(y+-4,x+0) > cb 
                        else
                         continue
                        end
                       end
                      elseif image(y+2,x+-1) < c_b 
                       continue
                      else
                       if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                        continue
                       else
                       end
                      end
                     end
                    end
                   else
                   end
                  end
                 elseif image(y+-2,x+-3) < c_b 
                  if image(y+2,x+-1) > cb 
                  else
                   continue
                  end
                 else
                 end
                end
               end
              elseif image(y+3,x+-1) < c_b 
               if image(y+-3,x+2) > cb 
                if image(y+1,x+-4) > cb 
                 if image(y+-1,x+-4) > cb 
                  if image(y+3,x+1) > cb 
                   if image(y+-2,x+-2) > cb 
                   elseif image(y+-2,x+-2) < c_b 
                    continue
                   else
                    if image(y+-1,x+2) > cb 
                     if image(y+-2,x+1) > cb 
                     elseif image(y+-2,x+1) < c_b 
                      continue
                     else
                      if image(y+2,x+-3) > cb 
                       if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                        continue
                       else
                       end
                      elseif image(y+2,x+-3) < c_b 
                       continue
                      else
                      end
                     end
                    else
                     continue
                    end
                   end
                  elseif image(y+3,x+1) < c_b 
                   if image(y+-4,x+0) > cb 
                    if image(y+0,x+-2) > cb | image(y+0,x+-2) < c_b 
                    else
                     if image(y+-2,x+-2) > cb | image(y+-2,x+-2) < c_b 
                      continue
                     else
                      if image(y+-2,x+0) > cb 
                      else
                       continue
                      end
                     end
                    end
                   elseif image(y+-4,x+0) < c_b 
                    continue
                   else
                   end
                  else
                  end
                 elseif image(y+-1,x+-4) < c_b 
                  continue
                 else
                  if image(y+4,x+1) > cb 
                  elseif image(y+4,x+1) < c_b 
                   if image(y+-4,x+-1) > cb 
                   else
                    continue
                   end
                  else
                   if image(y+2,x+-3) > cb 
                   elseif image(y+2,x+-3) < c_b 
                    continue
                   else
                    if image(y+0,x+-4) > cb 
                     if image(y+-2,x+0) > cb | image(y+-2,x+0) < c_b 
                      continue
                     else
                      if image(y+-2,x+1) > cb 
                      else
                       continue
                      end
                     end
                    else
                     continue
                    end
                   end
                  end
                 end
                elseif image(y+1,x+-4) < c_b 
                 if image(y+-2,x+-3) > cb 
                 elseif image(y+-2,x+-3) < c_b 
                  if image(y+4,x+1) > cb 
                   if image(y+2,x+1) > cb 
                   else
                    continue
                   end
                  else
                   continue
                  end
                 else
                  if image(y+2,x+1) > cb 
                   if image(y+4,x+1) > cb 
                    if image(y+1,x+4) > cb 
                    elseif image(y+1,x+4) < c_b 
                     continue
                    else
                     if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                      continue
                     else
                      if image(y+0,x+-4) < c_b
                      else
                       continue
                      end
                     end
                    end
                   elseif image(y+4,x+1) < c_b 
                   else
                    if image(y+4,x+-1) > cb 
                     continue
                    elseif image(y+4,x+-1) < c_b 
                     if image(y+-2,x+3) > cb | image(y+-2,x+3) < c_b 
                      continue
                     else
                      if image(y+-2,x+0) > cb 
                      else
                       continue
                      end
                     end
                    else
                    end
                   end
                  elseif image(y+2,x+1) < c_b 
                   continue
                  else
                   if image(y+-1,x+-3) > cb 
                   elseif image(y+-1,x+-3) < c_b 
                    continue
                   else
                    if image(y+3,x+-2) > cb 
                     continue
                    elseif image(y+3,x+-2) < c_b 
                     if image(y+2,x+-3) > cb | image(y+2,x+-3) < c_b 
                      continue
                     else
                      if image(y+1,x+4) > cb | image(y+1,x+4) < c_b 
                       continue
                      else
                      end
                     end
                    else
                     if image(y+3,x+0) < c_b
                      if image(y+2,x+-3) < c_b
                      else
                       continue
                      end
                     else
                      continue
                     end
                    end
                   end
                  end
                 end
                else
                 if image(y+-2,x+-3) > cb 
                  if image(y+2,x+-2) > cb | image(y+2,x+-2) < c_b 
                  else
                   if image(y+-1,x+-2) > cb 
                   elseif image(y+-1,x+-2) < c_b 
                    continue
                   else
                    if image(y+2,x+1) > cb 
                     if image(y+4,x+1) > cb 
                     elseif image(y+4,x+1) < c_b 
                      continue
                     else
                      if image(y+1,x+-3) > cb 
                      else
                       continue
                      end
                     end
                    elseif image(y+2,x+1) < c_b 
                     continue
                    else
                     if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                     else
                      if image(y+-2,x+1) > cb 
                       if image(y+-2,x+-2) > cb 
                        if image(y+3,x+-2) > cb | image(y+3,x+-2) < c_b 
                         continue
                        else
                         if image(y+3,x+1) > cb | image(y+3,x+1) < c_b 
                          continue
                         else
                          if image(y+2,x+-1) > cb 
                           continue
                          elseif image(y+2,x+-1) < c_b 
                           if image(y+2,x+2) > cb 
                            if image(y+-1,x+-4) > cb 
                            elseif image(y+-1,x+-4) < c_b 
                             continue
                            else
                             if image(y+-1,x+4) > cb | image(y+-1,x+4) < c_b 
                              continue
                             else
                             end
                            end
                           else
                            continue
                           end
                          else
                          end
                         end
                        end
                       elseif image(y+-2,x+-2) < c_b 
                        continue
                       else
                        if image(y+3,x+1) < c_b
                         if image(y+1,x+-2) > cb | image(y+1,x+-2) < c_b 
                          continue
                         else
                         end
                        else
                         continue
                        end
                       end
                      else
                       continue
                      end
                     end
                    end
                   end
                  end
                 elseif image(y+-2,x+-3) < c_b 
                  continue
                 else
                 end
                end
               elseif image(y+-3,x+2) < c_b 
                if image(y+-2,x+2) > cb 
                elseif image(y+-2,x+2) < c_b 
                 if image(y+3,x+2) > cb 
                 elseif image(y+3,x+2) < c_b 
                  continue
                 else
                  if image(y+2,x+-2) > cb 
                  elseif image(y+2,x+-2) < c_b 
                   if image(y+-4,x+-1) > cb 
                    if image(y+2,x+2) > cb 
                    elseif image(y+2,x+2) < c_b 
                     continue
                    else
                     if image(y+1,x+4) > cb 
                     else
                      continue
                     end
                    end
                   else
                   end
                  else
                   if image(y+-1,x+-2) > cb 
                   elseif image(y+-1,x+-2) < c_b 
                    continue
                   else
                    if image(y+4,x+0) < c_b
                    else
                     continue
                    end
                   end
                  end
                 end
                else
                 if image(y+2,x+-2) > cb 
                  continue
                 elseif image(y+2,x+-2) < c_b 
                  if image(y+-2,x+-3) > cb | image(y+-2,x+-3) < c_b 
                  else
                   if image(y+4,x+1) > cb 
                   elseif image(y+4,x+1) < c_b 
                    continue
                   else
                    if image(y+-1,x+-4) > cb 
                     continue
                    elseif image(y+-1,x+-4) < c_b 
                    else
                     if image(y+1,x+-4) > cb 
                      continue
                     elseif image(y+1,x+-4) < c_b 
                      if image(y+2,x+1) > cb 
                       if image(y+-4,x+0) > cb 
                        if image(y+-3,x+0) > cb 
                        else
                         continue
                        end
                       elseif image(y+-4,x+0) < c_b 
                        if image(y+0,x+-4) < c_b
                        else
                         continue
                        end
                       else
                        if image(y+3,x+0) > cb 
                         continue
                        elseif image(y+3,x+0) < c_b 
                         if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                          continue
                         else
                         end
                        else
                        end
                       end
                      elseif image(y+2,x+1) < c_b 
                       continue
                      else
                       if image(y+-3,x+-1) > cb 
                        if image(y+0,x+2) > cb 
                        elseif image(y+0,x+2) < c_b 
                         continue
                        else
                         if image(y+-3,x+1) < c_b
                         else
                          continue
                         end
                        end
                       elseif image(y+-3,x+-1) < c_b 
                        continue
                       else
                        if image(y+-2,x+3) > cb 
                         continue
                        elseif image(y+-2,x+3) < c_b 
                        else
                         if image(y+1,x+4) > cb 
                          if image(y+-4,x+0) < c_b
                          else
                           continue
                          end
                         elseif image(y+1,x+4) < c_b 
                          continue
                         else
                         end
                        end
                       end
                      end
                     else
                     end
                    end
                   end
                  end
                 else
                  if image(y+2,x+-1) > cb 
                   continue
                  elseif image(y+2,x+-1) < c_b 
                   if image(y+1,x+-4) < c_b
                    if image(y+-1,x+-4) < c_b
                    else
                     continue
                    end
                   else
                   end
                  else
                   if image(y+-4,x+-1) > cb 
                    if image(y+-1,x+-4) > cb | image(y+-1,x+-4) < c_b 
                     continue
                    else
                    end
                   elseif image(y+-4,x+-1) < c_b 
                   else
                    if image(y+-2,x+0) > cb 
                     continue
                    elseif image(y+-2,x+0) < c_b 
                    else
                     if image(y+2,x+-3) > cb 
                      continue
                     elseif image(y+2,x+-3) < c_b 
                     else
                      if image(y+2,x+0) < c_b
                       if image(y+-1,x+3) > cb 
                       else
                        continue
                       end
                      else
                       continue
                      end
                     end
                    end
                   end
                  end
                 end
                end
               else
                if image(y+1,x+-4) > cb 
                 if image(y+-1,x+2) > cb 
                  if image(y+-1,x+-4) > cb 
                   if image(y+0,x+-3) > cb | image(y+0,x+-3) < c_b 
                   else
                    if image(y+3,x+1) < c_b
                     continue
                    else
                    end
                   end
                  elseif image(y+-1,x+-4) < c_b 
                   continue
                  else
                   if image(y+0,x+2) > cb 
                    if image(y+0,x+-3) > cb 
                     if image(y+-4,x+-1) > cb 
                     else
                      continue
                     end
                    elseif image(y+0,x+-3) < c_b 
                     continue
                    else
                    end
                   else
                    continue
                   end
                  end
                 elseif image(y+-1,x+2) < c_b 
                 else
                  if image(y+-1,x+-2) > cb 
                   if image(y+3,x+1) > cb 
                   elseif image(y+3,x+1) < c_b 
                    if image(y+-4,x+-1) > cb 
                     if image(y+-3,x+0) > cb | image(y+-3,x+0) < c_b 
                      continue
                     else
                     end
                    else
                     continue
                    end
                   else
                    if image(y+4,x+-1) > cb 
                     continue
                    elseif image(y+4,x+-1) < c_b 
                     if image(y+-4,x+0) < c_b
                      if image(y+-4,x+1) > cb | image(y+-4,x+1) < c_b 
                       continue
                      else
                      end
                     else
                     end
                    else
                     if image(y+1,x+-3) > cb | image(y+1,x+-3) < c_b 
                      continue
                     else
                      if image(y+3,x+-2) < c_b
                      else
                       continue
                      end
                     end
                    end
                   end
                  elseif image(y+-1,x+-2) < c_b 
                   continue
                  else
                   if image(y+0,x+2) > cb 
                    if image(y+-2,x+0) > cb 
                     if image(y+-4,x+0) > cb | image(y+-4,x+0) < c_b 
                      continue
                     else
                     end
                    elseif image(y+-2,x+0) < c_b 
                    else
                     if image(y+3,x+2) > cb 
         